/*
 * Decompiled with CFR 0.152.
 */
package com.google.template.soy.soytree;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.template.soy.base.SourceLocation;
import com.google.template.soy.soyparse.ErrorReporter;
import com.google.template.soy.soyparse.SoyError;
import com.google.template.soy.soyparse.TransitionalThrowingErrorReporter;
import com.google.template.soy.soytree.CallParamNode;
import com.google.template.soy.soytree.ExprUnion;
import com.google.template.soy.soytree.SoyNode;
import java.util.List;

public final class CallParamValueNode
extends CallParamNode
implements SoyNode.ExprHolderNode {
    private static final SoyError SELF_ENDING_TAG_WITHOUT_VALUE = SoyError.of("A ''param'' tag should be self-ending (with a trailing ''/'') if and only if it also contains a value (invalid tag is '{'param {0} /'}').");
    private static final SoyError SELF_ENDING_TAG_WITH_KIND_ATTRIBUTE = SoyError.of("The ''kind'' attribute is not allowed on self-ending ''param'' tags (invalid tag is '{'param {0} /'}').");
    private final String key;
    private final ExprUnion valueExprUnion;

    private CallParamValueNode(int id, String key, ExprUnion valueExprUnion, String commandText) {
        super(id, commandText);
        this.key = (String)Preconditions.checkNotNull((Object)key);
        this.valueExprUnion = (ExprUnion)Preconditions.checkNotNull((Object)valueExprUnion);
    }

    private CallParamValueNode(CallParamValueNode orig) {
        super(orig);
        this.key = orig.key;
        this.valueExprUnion = orig.valueExprUnion != null ? orig.valueExprUnion.clone() : null;
    }

    @Override
    public SoyNode.Kind getKind() {
        return SoyNode.Kind.CALL_PARAM_VALUE_NODE;
    }

    @Override
    public String getKey() {
        return this.key;
    }

    public String getValueExprText() {
        return this.valueExprUnion.getExprText();
    }

    public ExprUnion getValueExprUnion() {
        return this.valueExprUnion;
    }

    @Override
    public String getTagString() {
        return this.buildTagStringHelper(true);
    }

    @Override
    public List<ExprUnion> getAllExprUnions() {
        return ImmutableList.of((Object)this.valueExprUnion);
    }

    @Override
    public CallParamValueNode clone() {
        return new CallParamValueNode(this);
    }

    public static final class Builder
    extends CallParamNode.Builder {
        public static final CallParamValueNode ERROR = new Builder(-1, "error: error", SourceLocation.UNKNOWN).buildAndThrowIfInvalid();

        public Builder(int id, String commandText, SourceLocation sourceLocation) {
            super(id, commandText, sourceLocation);
        }

        public CallParamValueNode build(ErrorReporter errorReporter) {
            ErrorReporter.Checkpoint checkpoint = errorReporter.checkpoint();
            CallParamNode.CommandTextParseResult parseResult = this.parseCommandTextHelper(errorReporter);
            if (parseResult.valueExprUnion == null) {
                errorReporter.report(this.sourceLocation, SELF_ENDING_TAG_WITHOUT_VALUE, this.commandText);
            }
            if (parseResult.contentKind != null) {
                errorReporter.report(this.sourceLocation, SELF_ENDING_TAG_WITH_KIND_ATTRIBUTE, this.commandText);
            }
            if (errorReporter.errorsSince(checkpoint)) {
                return ERROR;
            }
            CallParamValueNode node = new CallParamValueNode(this.id, parseResult.key, parseResult.valueExprUnion, this.commandText);
            node.setSourceLocation(this.sourceLocation);
            return node;
        }

        private CallParamValueNode buildAndThrowIfInvalid() {
            TransitionalThrowingErrorReporter errorManager = new TransitionalThrowingErrorReporter();
            CallParamValueNode node = this.build(errorManager);
            errorManager.throwIfErrorsPresent();
            return node;
        }
    }
}

