/*
 * Decompiled with CFR 0.152.
 */
package com.google.template.soy.soyparse;

import com.google.common.collect.ImmutableCollection;
import com.google.common.collect.ImmutableList;
import com.google.template.soy.base.SourceLocation;
import com.google.template.soy.base.SoySyntaxException;
import com.google.template.soy.soyparse.ErrorReporter;
import com.google.template.soy.soyparse.SoyError;
import java.util.ArrayList;
import java.util.List;

public class ErrorReporterImpl
implements ErrorReporter {
    protected final List<SoySyntaxException> errors = new ArrayList<SoySyntaxException>();

    @Override
    public void report(SourceLocation sourceLocation, SoyError error, String ... args) {
        this.errors.add(SoySyntaxException.createWithMetaInfo(error.format(args), sourceLocation));
    }

    @Override
    public ErrorReporter.Checkpoint checkpoint() {
        return new ErrorReporter.Checkpoint(this.errors.size());
    }

    @Override
    public boolean errorsSince(ErrorReporter.Checkpoint checkpoint) {
        return this.errors.size() > checkpoint.numErrors;
    }

    ImmutableCollection<? extends SoySyntaxException> getErrors() {
        return ImmutableList.copyOf(this.errors);
    }
}

