/*
 * Decompiled with CFR 0.152.
 */
package com.google.template.soy.sharedpasses;

import com.google.template.soy.base.SoySyntaxException;
import com.google.template.soy.soytree.AbstractSoyNodeVisitor;
import com.google.template.soy.soytree.CallBasicNode;
import com.google.template.soy.soytree.CallNode;
import com.google.template.soy.soytree.SoyFileNode;
import com.google.template.soy.soytree.SoyFileSetNode;
import com.google.template.soy.soytree.SoyNode;
import com.google.template.soy.soytree.TemplateBasicNode;
import com.google.template.soy.soytree.TemplateNode;
import com.google.template.soy.soytree.TemplateRegistry;
import com.google.template.soy.soytree.Visibility;

public class CheckTemplateVisibility
extends AbstractSoyNodeVisitor<Void> {
    private TemplateRegistry templateRegistry;
    private String currentFileName;
    private String currentTemplateName;

    @Override
    protected void visitSoyFileSetNode(SoyFileSetNode node) {
        this.templateRegistry = new TemplateRegistry(node);
        this.visitChildren(node);
        this.templateRegistry = null;
    }

    @Override
    protected void visitSoyFileNode(SoyFileNode node) {
        this.currentFileName = node.getSourceLocation().getFileName();
        this.visitChildren(node);
        this.currentFileName = null;
    }

    @Override
    protected void visitTemplateNode(TemplateNode node) {
        this.currentTemplateName = node.getTemplateName();
        this.visitChildren(node);
        this.currentTemplateName = null;
    }

    @Override
    protected void visitCallNode(CallNode node) {
        if (node instanceof CallBasicNode) {
            this.handleBasicNode((CallBasicNode)node);
        }
        this.visitChildren(node);
    }

    @Override
    protected void visitSoyNode(SoyNode node) {
        if (node instanceof SoyNode.ParentSoyNode) {
            this.visitChildren((SoyNode.ParentSoyNode)node);
        }
    }

    private void handleBasicNode(CallBasicNode node) {
        String calleeName = node.getCalleeName();
        TemplateBasicNode definition = this.templateRegistry.getBasicTemplate(calleeName);
        if (definition != null && !this.isVisible(definition)) {
            throw SoySyntaxException.createWithMetaInfo(calleeName + " [visibility=\"" + definition.getVisibility().getAttributeValue() + "\"] not visible from here", node.getSourceLocation(), null, this.currentTemplateName);
        }
    }

    private boolean isVisible(TemplateNode definition) {
        if (definition.getVisibility() != Visibility.PRIVATE) {
            return true;
        }
        return this.currentFileName.equals(definition.getSourceLocation().getFileName());
    }
}

