/*
 * Decompiled with CFR 0.152.
 */
package com.google.template.soy.sharedpasses;

import com.google.common.base.Preconditions;
import com.google.template.soy.soyparse.SoyError;
import com.google.template.soy.soyparse.TransitionalThrowingErrorReporter;
import com.google.template.soy.soytree.AbstractSoyNodeVisitor;
import com.google.template.soy.soytree.AutoescapeMode;
import com.google.template.soy.soytree.SoyFileNode;
import com.google.template.soy.soytree.SoyFileSetNode;
import com.google.template.soy.soytree.SoyNode;
import com.google.template.soy.soytree.TemplateNode;

public class AssertStrictAutoescapingVisitor
extends AbstractSoyNodeVisitor<Void> {
    private static final SoyError INVALID_AUTOESCAPING = SoyError.of("Invalid use of non-strict when strict autoescaping is required.");
    private TransitionalThrowingErrorReporter errorReporter;

    @Override
    public Void exec(SoyNode soyNode) {
        Preconditions.checkArgument((soyNode instanceof SoyFileSetNode || soyNode instanceof SoyFileNode ? 1 : 0) != 0);
        this.errorReporter = new TransitionalThrowingErrorReporter();
        super.exec(soyNode);
        this.errorReporter.throwIfErrorsPresent();
        return null;
    }

    @Override
    protected void visitSoyFileNode(SoyFileNode node) {
        if (node.getDefaultAutoescapeMode() != AutoescapeMode.STRICT) {
            this.errorReporter.report(node.getSourceLocation(), INVALID_AUTOESCAPING, new String[0]);
            return;
        }
        this.visitChildren(node);
    }

    @Override
    protected void visitTemplateNode(TemplateNode node) {
        if (node.getAutoescapeMode() != AutoescapeMode.STRICT) {
            this.errorReporter.report(node.getSourceLocation(), INVALID_AUTOESCAPING, new String[0]);
        }
    }

    @Override
    protected void visitSoyNode(SoyNode node) {
        if (node instanceof SoyNode.ParentSoyNode) {
            this.visitChildren((SoyNode.ParentSoyNode)node);
        }
    }
}

