/*
 * Decompiled with CFR 0.152.
 */
package com.google.template.soy.pysrc.restricted;

import com.google.common.base.Joiner;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.template.soy.data.SanitizedContent;
import com.google.template.soy.data.internalutils.NodeContentKinds;
import com.google.template.soy.exprtree.Operator;
import com.google.template.soy.internal.targetexpr.ExprUtils;
import com.google.template.soy.internal.targetexpr.TargetExpr;
import com.google.template.soy.pysrc.restricted.PyExpr;
import com.google.template.soy.pysrc.restricted.PyListExpr;
import com.google.template.soy.pysrc.restricted.PyStringExpr;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;

public final class PyExprUtils {
    private static final PyExpr EMPTY_STRING = new PyStringExpr("''");
    private static final ImmutableMap<Operator, Integer> PYTHON_PRECEDENCES = new ImmutableMap.Builder().put((Object)Operator.NEGATIVE, (Object)8).put((Object)Operator.TIMES, (Object)7).put((Object)Operator.DIVIDE_BY, (Object)7).put((Object)Operator.MOD, (Object)7).put((Object)Operator.PLUS, (Object)6).put((Object)Operator.MINUS, (Object)6).put((Object)Operator.LESS_THAN, (Object)5).put((Object)Operator.GREATER_THAN, (Object)5).put((Object)Operator.LESS_THAN_OR_EQUAL, (Object)5).put((Object)Operator.GREATER_THAN_OR_EQUAL, (Object)5).put((Object)Operator.EQUAL, (Object)5).put((Object)Operator.NOT_EQUAL, (Object)5).put((Object)Operator.NOT, (Object)4).put((Object)Operator.AND, (Object)3).put((Object)Operator.OR, (Object)2).put((Object)Operator.NULL_COALESCING, (Object)1).put((Object)Operator.CONDITIONAL, (Object)1).build();

    private PyExprUtils() {
    }

    public static PyExpr concatPyExprs(List<? extends PyExpr> pyExprs) {
        if (pyExprs.isEmpty()) {
            return EMPTY_STRING;
        }
        if (pyExprs.size() == 1) {
            return pyExprs.get(0).toPyString();
        }
        StringBuilder resultSb = new StringBuilder();
        resultSb.append("[");
        boolean isFirst = true;
        for (PyExpr pyExpr : pyExprs) {
            if (isFirst) {
                isFirst = false;
            } else {
                resultSb.append(',');
            }
            resultSb.append(pyExpr.toPyString().getText());
        }
        resultSb.append("]");
        return new PyListExpr(resultSb.toString(), Integer.MAX_VALUE);
    }

    public static PyExpr genPyNotNullCheck(PyExpr pyExpr) {
        ImmutableList exprs = ImmutableList.of((Object)pyExpr, (Object)new PyExpr("None", Integer.MAX_VALUE));
        String conditionalExpr = ExprUtils.genExprWithNewToken(Operator.NOT_EQUAL, (List<? extends TargetExpr>)exprs, "is not");
        return new PyExpr(conditionalExpr, PyExprUtils.pyPrecedenceForOperator(Operator.NOT_EQUAL));
    }

    public static PyExpr maybeProtect(PyExpr expr, int minSafePrecedence) {
        if (expr.getPrecedence() > minSafePrecedence) {
            return expr;
        }
        return new PyExpr("(" + expr.getText() + ")", Integer.MAX_VALUE);
    }

    public static PyExpr wrapAsSanitizedContent(SanitizedContent.ContentKind contentKind, PyExpr pyExpr) {
        String sanitizer = NodeContentKinds.toPySanitizedContentOrdainer(contentKind);
        return new PyExpr(sanitizer + "(" + pyExpr.getText() + ")", Integer.MAX_VALUE);
    }

    public static int pyPrecedenceForOperator(Operator op) {
        return (Integer)PYTHON_PRECEDENCES.get((Object)op);
    }

    public static PyExpr convertIterableToPyListExpr(Iterable<?> iterable) {
        return PyExprUtils.convertIterableToPyExpr(iterable, true);
    }

    public static PyExpr convertIterableToPyTupleExpr(Iterable<?> iterable) {
        return PyExprUtils.convertIterableToPyExpr(iterable, false);
    }

    public static PyExpr convertMapToPyExpr(Map<PyExpr, PyExpr> dict) {
        ArrayList<String> values = new ArrayList<String>();
        for (Map.Entry<PyExpr, PyExpr> entry : dict.entrySet()) {
            values.add(entry.getKey().getText() + ": " + entry.getValue().getText());
        }
        Joiner joiner = Joiner.on((String)", ");
        return new PyExpr("{" + joiner.join(values) + "}", Integer.MAX_VALUE);
    }

    private static PyExpr convertIterableToPyExpr(Iterable<?> iterable, boolean asArray) {
        ArrayList<String> values = new ArrayList<String>();
        String leftDelimiter = "[";
        String rightDelimiter = "]";
        if (!asArray) {
            leftDelimiter = "(";
            rightDelimiter = ")";
        }
        for (Object elem : iterable) {
            if (!(elem instanceof Number || elem instanceof String || elem instanceof PyExpr)) {
                throw new UnsupportedOperationException("Only Number, String and PyExpr is allowed");
            }
            if (elem instanceof Number) {
                values.add(String.valueOf(elem));
                continue;
            }
            if (elem instanceof PyExpr) {
                values.add(((PyExpr)elem).getText());
                continue;
            }
            if (!(elem instanceof String)) continue;
            values.add("'" + elem + "'");
        }
        String contents = Joiner.on((String)", ").join(values);
        if (values.size() == 1 && !asArray) {
            contents = contents + ",";
        }
        return new PyListExpr(leftDelimiter + contents + rightDelimiter, Integer.MAX_VALUE);
    }
}

