/*
 * Decompiled with CFR 0.152.
 */
package com.google.template.soy.pysrc.internal;

import com.google.common.base.Function;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Iterables;
import com.google.inject.assistedinject.Assisted;
import com.google.inject.assistedinject.AssistedInject;
import com.google.template.soy.base.SoyBackendKind;
import com.google.template.soy.base.SoySyntaxException;
import com.google.template.soy.exprtree.AbstractReturningExprNodeVisitor;
import com.google.template.soy.exprtree.BooleanNode;
import com.google.template.soy.exprtree.DataAccessNode;
import com.google.template.soy.exprtree.ExprNode;
import com.google.template.soy.exprtree.ExprRootNode;
import com.google.template.soy.exprtree.FieldAccessNode;
import com.google.template.soy.exprtree.FunctionNode;
import com.google.template.soy.exprtree.ItemAccessNode;
import com.google.template.soy.exprtree.ListLiteralNode;
import com.google.template.soy.exprtree.MapLiteralNode;
import com.google.template.soy.exprtree.NullNode;
import com.google.template.soy.exprtree.Operator;
import com.google.template.soy.exprtree.OperatorNodes;
import com.google.template.soy.exprtree.StringNode;
import com.google.template.soy.exprtree.VarRefNode;
import com.google.template.soy.internal.targetexpr.ExprUtils;
import com.google.template.soy.pysrc.internal.LocalVariableStack;
import com.google.template.soy.pysrc.restricted.PyExpr;
import com.google.template.soy.pysrc.restricted.PyExprUtils;
import com.google.template.soy.pysrc.restricted.PyStringExpr;
import com.google.template.soy.pysrc.restricted.SoyPySrcFunction;
import com.google.template.soy.shared.internal.NonpluginFunction;
import com.google.template.soy.types.SoyObjectType;
import com.google.template.soy.types.SoyType;
import java.util.LinkedHashMap;
import java.util.List;

final class TranslateToPyExprVisitor
extends AbstractReturningExprNodeVisitor<PyExpr> {
    private final LocalVariableStack localVarExprs;
    private final ImmutableMap<String, SoyPySrcFunction> soyPySrcFunctionsMap;
    private final Function<ExprNode, PyExpr> VISIT_MAPPER = new Function<ExprNode, PyExpr>(){

        public PyExpr apply(ExprNode node) {
            return (PyExpr)TranslateToPyExprVisitor.this.visit(node);
        }
    };

    @AssistedInject
    TranslateToPyExprVisitor(ImmutableMap<String, SoyPySrcFunction> soyPySrcFunctionsMap, @Assisted LocalVariableStack localVarExprs) {
        this.localVarExprs = localVarExprs;
        this.soyPySrcFunctionsMap = soyPySrcFunctionsMap;
    }

    @Override
    protected PyExpr visitExprRootNode(ExprRootNode<?> node) {
        return (PyExpr)this.visit((ExprNode)node.getChild(0));
    }

    @Override
    protected PyExpr visitPrimitiveNode(ExprNode.PrimitiveNode node) {
        return new PyExpr(node.toSourceString(), Integer.MAX_VALUE);
    }

    @Override
    protected PyExpr visitStringNode(StringNode node) {
        return new PyStringExpr(node.toSourceString());
    }

    @Override
    protected PyExpr visitNullNode(NullNode node) {
        return new PyExpr("None", Integer.MAX_VALUE);
    }

    @Override
    protected PyExpr visitBooleanNode(BooleanNode node) {
        return new PyExpr(node.getValue() ? "True" : "False", Integer.MAX_VALUE);
    }

    @Override
    protected PyExpr visitListLiteralNode(ListLiteralNode node) {
        return PyExprUtils.convertIterableToPyListExpr(Iterables.transform(node.getChildren(), this.VISIT_MAPPER));
    }

    @Override
    protected PyExpr visitMapLiteralNode(MapLiteralNode node) {
        Preconditions.checkArgument((node.numChildren() % 2 == 0 ? 1 : 0) != 0);
        LinkedHashMap<PyExpr, PyExpr> dict = new LinkedHashMap<PyExpr, PyExpr>();
        int n = node.numChildren();
        for (int i = 0; i < n; i += 2) {
            ExprNode keyNode = node.getChild(i);
            ExprNode valueNode = node.getChild(i + 1);
            dict.put((PyExpr)this.visit(keyNode), (PyExpr)this.visit(valueNode));
        }
        return PyExprUtils.convertMapToPyExpr(dict);
    }

    @Override
    protected PyExpr visitVarRefNode(VarRefNode node) {
        return this.visitNullSafeNode(node);
    }

    @Override
    protected PyExpr visitDataAccessNode(DataAccessNode node) {
        return this.visitNullSafeNode(node);
    }

    private PyExpr visitNullSafeNode(ExprNode node) {
        StringBuilder nullSafetyPrefix = new StringBuilder();
        String refText = this.visitNullSafeNodeRecurse(node, nullSafetyPrefix);
        if (nullSafetyPrefix.length() == 0) {
            return new PyExpr(refText, Integer.MAX_VALUE);
        }
        return new PyExpr(nullSafetyPrefix + refText, PyExprUtils.pyPrecedenceForOperator(Operator.CONDITIONAL));
    }

    private String visitNullSafeNodeRecurse(ExprNode node, StringBuilder nullSafetyPrefix) {
        switch (node.getKind()) {
            case VAR_REF_NODE: {
                VarRefNode varRef = (VarRefNode)node;
                if (varRef.isInjected()) {
                    if (varRef.isNullSafeInjected()) {
                        nullSafetyPrefix.append("None if opt_ijData is None else ");
                    }
                    return "opt_ijData" + TranslateToPyExprVisitor.genCodeForLiteralKeyAccess(varRef.getName());
                }
                PyExpr translation = this.localVarExprs.getVariableExpression(varRef.getName());
                if (translation != null) {
                    return translation.getText();
                }
                return "opt_data" + TranslateToPyExprVisitor.genCodeForLiteralKeyAccess(varRef.getName());
            }
            case FIELD_ACCESS_NODE: 
            case ITEM_ACCESS_NODE: {
                DataAccessNode dataAccess = (DataAccessNode)node;
                String refText = this.visitNullSafeNodeRecurse(dataAccess.getBaseExprChild(), nullSafetyPrefix);
                if (dataAccess.isNullSafe()) {
                    nullSafetyPrefix.append("None if " + refText + " is None else ");
                }
                if (node.getKind() == ExprNode.Kind.FIELD_ACCESS_NODE) {
                    FieldAccessNode fieldAccess = (FieldAccessNode)node;
                    return refText + TranslateToPyExprVisitor.genCodeForFieldAccess(fieldAccess.getBaseExprChild().getType(), fieldAccess.getFieldName());
                }
                ItemAccessNode itemAccess = (ItemAccessNode)node;
                return refText + "[" + ((PyExpr)this.visit(itemAccess.getKeyExprChild())).getText() + "]";
            }
        }
        PyExpr value = (PyExpr)this.visit(node);
        return PyExprUtils.maybeProtect(value, Integer.MAX_VALUE).getText();
    }

    @Override
    protected PyExpr visitOperatorNode(ExprNode.OperatorNode node) {
        return this.genPyExprUsingSoySyntax(node);
    }

    @Override
    protected PyExpr visitEqualOpNode(OperatorNodes.EqualOpNode node) {
        List operandPyExprs = this.visitChildren(node);
        return new PyExpr("runtime.type_safe_eq(" + ((PyExpr)operandPyExprs.get(0)).getText() + ", " + ((PyExpr)operandPyExprs.get(1)).getText() + ")", Integer.MAX_VALUE);
    }

    @Override
    protected PyExpr visitNotEqualOpNode(OperatorNodes.NotEqualOpNode node) {
        List operandPyExprs = this.visitChildren(node);
        return new PyExpr("not runtime.type_safe_eq(" + ((PyExpr)operandPyExprs.get(0)).getText() + ", " + ((PyExpr)operandPyExprs.get(1)).getText() + ")", PyExprUtils.pyPrecedenceForOperator(Operator.NOT));
    }

    @Override
    protected PyExpr visitPlusOpNode(OperatorNodes.PlusOpNode node) {
        List operandPyExprs = this.visitChildren(node);
        return new PyExpr("runtime.type_safe_add(" + ((PyExpr)operandPyExprs.get(0)).getText() + ", " + ((PyExpr)operandPyExprs.get(1)).getText() + ")", Integer.MAX_VALUE);
    }

    @Override
    protected PyExpr visitConditionalOpNode(OperatorNodes.ConditionalOpNode node) {
        Operator op = Operator.CONDITIONAL;
        int conditionalPrecedence = PyExprUtils.pyPrecedenceForOperator(op);
        List<Operator.SyntaxElement> syntax = op.getSyntax();
        List operandExprs = this.visitChildren(node);
        Operator.Operand conditionalOperand = (Operator.Operand)syntax.get(0);
        PyExpr conditionalExpr = (PyExpr)operandExprs.get(conditionalOperand.getIndex());
        Operator.Operand trueOperand = (Operator.Operand)syntax.get(4);
        PyExpr trueExpr = (PyExpr)operandExprs.get(trueOperand.getIndex());
        Operator.Operand falseOperand = (Operator.Operand)syntax.get(8);
        PyExpr falseExpr = (PyExpr)operandExprs.get(falseOperand.getIndex());
        StringBuilder exprSb = new StringBuilder();
        exprSb.append(PyExprUtils.maybeProtect(trueExpr, conditionalPrecedence).getText());
        exprSb.append(" if ");
        exprSb.append(PyExprUtils.maybeProtect(conditionalExpr, conditionalPrecedence).getText());
        exprSb.append(" else ");
        exprSb.append(PyExprUtils.maybeProtect(falseExpr, conditionalPrecedence).getText());
        return new PyExpr(exprSb.toString(), conditionalPrecedence);
    }

    @Override
    protected PyExpr visitFunctionNode(FunctionNode node) {
        String fnName = node.getFunctionName();
        int numArgs = node.numChildren();
        NonpluginFunction nonpluginFn = NonpluginFunction.forFunctionName(fnName);
        if (nonpluginFn != null) {
            if (numArgs != nonpluginFn.getNumArgs()) {
                throw SoySyntaxException.createWithoutMetaInfo("Function '" + fnName + "' called with the wrong number of arguments" + " (function call \"" + node.toSourceString() + "\").");
            }
            switch (nonpluginFn) {
                case IS_FIRST: {
                    return this.visitForEachFunction(node, "__isFirst");
                }
                case IS_LAST: {
                    return this.visitForEachFunction(node, "__isLast");
                }
                case INDEX: {
                    return this.visitForEachFunction(node, "__index");
                }
                case QUOTE_KEYS_IF_JS: {
                    return this.visitMapLiteralNode((MapLiteralNode)node.getChild(0));
                }
            }
            throw new AssertionError();
        }
        SoyPySrcFunction fn = (SoyPySrcFunction)this.soyPySrcFunctionsMap.get((Object)fnName);
        if (fn != null) {
            if (!fn.getValidArgsSizes().contains(numArgs)) {
                throw SoySyntaxException.createWithoutMetaInfo("Function '" + fnName + "' called with the wrong number of arguments" + " (function call \"" + node.toSourceString() + "\").");
            }
            List<PyExpr> args = this.visitChildren(node);
            try {
                return fn.computeForPySrc(args);
            }
            catch (Exception e) {
                throw SoySyntaxException.createCausedWithoutMetaInfo("Error in function call \"" + node.toSourceString() + "\": " + e.getMessage(), e);
            }
        }
        throw SoySyntaxException.createWithoutMetaInfo("Failed to find function with name '" + fnName + "'" + " (function call \"" + node.toSourceString() + "\").");
    }

    private PyExpr visitForEachFunction(FunctionNode node, String suffix) {
        String varName = ((VarRefNode)node.getChild(0)).getName();
        return this.localVarExprs.getVariableExpression(varName + suffix);
    }

    private static String genCodeForLiteralKeyAccess(String key) {
        return TranslateToPyExprVisitor.genCodeForKeyAccess("'" + key + "'");
    }

    private static String genCodeForKeyAccess(String keyName) {
        return ".get(" + keyName + ")";
    }

    private static String genCodeForFieldAccess(SoyType baseType, String fieldName) {
        SoyObjectType objType;
        String accessExpr;
        if (baseType != null && baseType.getKind() == SoyType.Kind.OBJECT && (accessExpr = (objType = (SoyObjectType)baseType).getFieldAccessor(fieldName, SoyBackendKind.PYTHON_SRC)) != null) {
            return accessExpr;
        }
        return TranslateToPyExprVisitor.genCodeForLiteralKeyAccess(fieldName);
    }

    private PyExpr genPyExprUsingSoySyntax(ExprNode.OperatorNode opNode) {
        List operandPyExprs = this.visitChildren(opNode);
        String newExpr = ExprUtils.genExprWithNewToken(opNode.getOperator(), operandPyExprs, null);
        return new PyExpr(newExpr, PyExprUtils.pyPrecedenceForOperator(opNode.getOperator()));
    }

    static interface TranslateToPyExprVisitorFactory {
        public TranslateToPyExprVisitor create(LocalVariableStack var1);
    }
}

