/*
 * Decompiled with CFR 0.152.
 */
package com.google.template.soy.jbcsrc.api;

import com.google.common.base.Preconditions;
import java.util.concurrent.Future;
import javax.annotation.Nullable;

public final class RenderResult {
    private static final RenderResult DONE_RESULT = new RenderResult(Type.DONE);
    private static final RenderResult LIMITED_RESULT = new RenderResult(Type.LIMITED);
    private final Type type;
    @Nullable
    private final Future<?> future;

    public static RenderResult done() {
        return DONE_RESULT;
    }

    public static RenderResult limited() {
        return LIMITED_RESULT;
    }

    public static RenderResult continueAfter(Future<?> future) {
        return new RenderResult(future);
    }

    private RenderResult(Type type) {
        this.type = type;
        this.future = null;
    }

    private RenderResult(Future<?> future) {
        this.type = Type.DETACH;
        this.future = (Future)Preconditions.checkNotNull(future);
    }

    public Type type() {
        return this.type;
    }

    public Future<?> future() {
        Future<?> f = this.future;
        if (f == null) {
            throw new IllegalStateException("Result.future() can only be called if type() is DETACH, type was: " + (Object)((Object)this.type));
        }
        return f;
    }

    public static enum Type {
        LIMITED,
        DETACH,
        DONE;

    }
}

