/*
 * Decompiled with CFR 0.152.
 */
package com.google.template.soy.jbcsrc;

import com.google.template.soy.data.SoyRecord;
import com.google.template.soy.exprtree.FieldAccessNode;
import com.google.template.soy.exprtree.FunctionNode;
import com.google.template.soy.exprtree.ItemAccessNode;
import com.google.template.soy.exprtree.VarRefNode;
import com.google.template.soy.jbcsrc.BytecodeUtils;
import com.google.template.soy.jbcsrc.ClassData;
import com.google.template.soy.jbcsrc.CompiledTemplateMetadata;
import com.google.template.soy.jbcsrc.Expression;
import com.google.template.soy.jbcsrc.ExpressionCompiler;
import com.google.template.soy.jbcsrc.FieldRef;
import com.google.template.soy.jbcsrc.LocalVariable;
import com.google.template.soy.jbcsrc.MethodRef;
import com.google.template.soy.jbcsrc.SoyExpression;
import com.google.template.soy.jbcsrc.SoyNodeCompiler;
import com.google.template.soy.jbcsrc.Statement;
import com.google.template.soy.jbcsrc.TemplateFactoryCompiler;
import com.google.template.soy.jbcsrc.api.AdvisingAppendable;
import com.google.template.soy.jbcsrc.api.CompiledTemplate;
import com.google.template.soy.jbcsrc.api.RenderContext;
import com.google.template.soy.soytree.defn.TemplateParam;
import java.io.IOException;
import java.util.ArrayList;
import org.objectweb.asm.ClassVisitor;
import org.objectweb.asm.ClassWriter;
import org.objectweb.asm.Label;
import org.objectweb.asm.Type;
import org.objectweb.asm.commons.GeneratorAdapter;

final class TemplateCompiler {
    private static final String[] INTERFACES = new String[]{Type.getInternalName(CompiledTemplate.class)};
    private final FieldRef paramsField;
    private final CompiledTemplateMetadata template;
    private ClassWriter writer;

    TemplateCompiler(CompiledTemplateMetadata template) {
        this.template = template;
        this.paramsField = FieldRef.createFinalField(template.typeInfo(), "params", SoyRecord.class);
    }

    Iterable<ClassData> compile() {
        ArrayList<ClassData> classes = new ArrayList<ClassData>();
        classes.add(new TemplateFactoryCompiler(this.template).compile());
        this.writer = new ClassWriter(3);
        this.writer.visit(51, 49, this.template.typeInfo().type().getInternalName(), null, "java/lang/Object", INTERFACES);
        this.writer.visitSource(this.template.node().getSourceLocation().getFileName(), null);
        this.paramsField.defineField((ClassVisitor)this.writer);
        this.generateConstructor();
        this.generateRenderMethod();
        this.writer.visitEnd();
        classes.add(ClassData.create(this.template.typeInfo(), this.writer.toByteArray()));
        return classes;
    }

    private void generateRenderMethod() {
        Label start = new Label();
        Label end = new Label();
        LocalVariable thisVar = LocalVariable.createThisVar(this.template.factory(), start, end);
        LocalVariable appendableVar = LocalVariable.createLocal("appendable", 1, Type.getType(AdvisingAppendable.class), start, end);
        LocalVariable contextVar = LocalVariable.createLocal("context", 2, Type.getType(RenderContext.class), start, end);
        GeneratorAdapter ga = new GeneratorAdapter(1, CompiledTemplateMetadata.RENDER_METHOD, null, new Type[]{Type.getType(IOException.class)}, (ClassVisitor)this.writer);
        ga.mark(start);
        SoyNodeCompiler nodeCompiler = new SoyNodeCompiler(appendableVar, contextVar, new ExprCompiler());
        Statement statement = nodeCompiler.compile(this.template.node());
        statement.gen(ga);
        MethodRef.RENDER_RESULT_DONE.invoke(new Expression[0]).gen(ga);
        ga.mark(end);
        ga.returnValue();
        thisVar.tableEntry(ga);
        appendableVar.tableEntry(ga);
        contextVar.tableEntry(ga);
        ga.endMethod();
    }

    private void generateConstructor() {
        Label start = new Label();
        Label end = new Label();
        LocalVariable thisVar = LocalVariable.createThisVar(this.template.typeInfo(), start, end);
        LocalVariable paramsVar = LocalVariable.createLocal("params", 1, Type.getType(SoyRecord.class), start, end);
        GeneratorAdapter ga = new GeneratorAdapter(1, CompiledTemplateMetadata.GENERATED_CONSTRUCTOR, null, null, (ClassVisitor)this.writer);
        ga.mark(start);
        thisVar.gen(ga);
        ga.invokeConstructor(Type.getType(Object.class), BytecodeUtils.NULLARY_INIT);
        for (TemplateParam param : this.template.node().getAllParams()) {
            if (param.isInjected() || !param.isRequired()) continue;
            MethodRef.RUNTIME_CHECK_REQUIRED_PARAM.invoke(paramsVar, BytecodeUtils.constant(param.name())).gen(ga);
        }
        this.paramsField.putInstanceField(thisVar, paramsVar).gen(ga);
        ga.visitInsn(177);
        ga.visitLabel(end);
        thisVar.tableEntry(ga);
        paramsVar.tableEntry(ga);
        ga.endMethod();
    }

    private static final class ExprCompiler
    extends ExpressionCompiler {
        private ExprCompiler() {
        }

        @Override
        protected SoyExpression visitVarRefNode(VarRefNode node) {
            throw new UnsupportedOperationException();
        }

        @Override
        protected SoyExpression visitFieldAccessNode(FieldAccessNode node) {
            throw new UnsupportedOperationException();
        }

        @Override
        protected SoyExpression visitItemAccessNode(ItemAccessNode node) {
            throw new UnsupportedOperationException();
        }

        @Override
        protected SoyExpression visitFunctionNode(FunctionNode node) {
            throw new UnsupportedOperationException();
        }
    }
}

