/*
 * Decompiled with CFR 0.152.
 */
package com.google.template.soy.jbcsrc;

import com.google.common.base.Preconditions;
import com.google.template.soy.jbcsrc.BytecodeUtils;
import com.google.template.soy.jbcsrc.Expression;
import com.google.template.soy.jbcsrc.ExpressionCompiler;
import com.google.template.soy.jbcsrc.MethodRef;
import com.google.template.soy.jbcsrc.SoyExpression;
import com.google.template.soy.jbcsrc.Statement;
import com.google.template.soy.jbcsrc.api.AdvisingAppendable;
import com.google.template.soy.jbcsrc.api.RenderContext;
import com.google.template.soy.soytree.AbstractReturningSoyNodeVisitor;
import com.google.template.soy.soytree.CssNode;
import com.google.template.soy.soytree.DebuggerNode;
import com.google.template.soy.soytree.LogNode;
import com.google.template.soy.soytree.PrintNode;
import com.google.template.soy.soytree.RawTextNode;
import com.google.template.soy.soytree.SoyNode;
import com.google.template.soy.soytree.TemplateBasicNode;
import com.google.template.soy.soytree.TemplateNode;
import com.google.template.soy.soytree.XidNode;
import org.objectweb.asm.Type;

final class SoyNodeCompiler
extends AbstractReturningSoyNodeVisitor<Statement> {
    private final Expression appendableExpression;
    private final Expression contextExpression;
    private final ExpressionCompiler exprCompiler;

    SoyNodeCompiler(Expression appendableExpression, Expression contextExpression, ExpressionCompiler exprCompiler) {
        appendableExpression.checkType(Type.getType(AdvisingAppendable.class));
        contextExpression.checkType(Type.getType(RenderContext.class));
        this.appendableExpression = appendableExpression;
        this.contextExpression = contextExpression;
        this.exprCompiler = (ExpressionCompiler)Preconditions.checkNotNull((Object)exprCompiler);
    }

    Statement compile(TemplateBasicNode node) {
        return (Statement)this.visit(node);
    }

    @Override
    protected Statement visitTemplateBasicNode(TemplateNode node) {
        return Statement.concat(this.visitChildren(node));
    }

    @Override
    protected Statement visitPrintNode(PrintNode node) {
        if (!node.getChildren().isEmpty()) {
            throw new UnsupportedOperationException("The jbcsrc implementation does not support print directives (yet!): " + node.toSourceString());
        }
        SoyExpression printExpr = this.exprCompiler.compile(node.getExprUnion().getExpr());
        return MethodRef.SOY_VALUE_RENDER.invokeVoid(printExpr.box(), this.appendableExpression).withSourceLocation(node.getSourceLocation());
    }

    @Override
    protected Statement visitRawTextNode(RawTextNode node) {
        return MethodRef.ADVISING_APPENDABLE_APPEND.invoke(this.appendableExpression, BytecodeUtils.constant(node.getRawText())).toStatement().withSourceLocation(node.getSourceLocation());
    }

    @Override
    protected Statement visitDebuggerNode(DebuggerNode node) {
        return Statement.NULL_STATEMENT.withSourceLocation(node.getSourceLocation());
    }

    @Override
    protected Statement visitXidNode(XidNode node) {
        Expression rename = MethodRef.RENDER_CONTEXT_RENAME_XID.invoke(this.contextExpression, BytecodeUtils.constant(node.getText()));
        return MethodRef.ADVISING_APPENDABLE_APPEND.invoke(this.appendableExpression, rename).toStatement().withSourceLocation(node.getSourceLocation());
    }

    @Override
    protected Statement visitCssNode(CssNode node) {
        Expression renameSelector = MethodRef.RENDER_CONTEXT_RENAME_CSS_SELECTOR.invoke(this.contextExpression, BytecodeUtils.constant(node.getSelectorText()));
        Statement selectorStatement = MethodRef.ADVISING_APPENDABLE_APPEND.invoke(this.appendableExpression, renameSelector).toStatement();
        if (node.getComponentNameExpr() != null) {
            return Statement.concat(MethodRef.SOY_VALUE_RENDER.invokeVoid(this.exprCompiler.compile(node.getComponentNameExpr()).box(), this.appendableExpression), MethodRef.ADVISING_APPENDABLE_APPEND_CHAR.invoke(this.appendableExpression, BytecodeUtils.constant('-')).toStatement(), selectorStatement);
        }
        return selectorStatement;
    }

    @Override
    protected Statement visitLogNode(LogNode node) {
        SoyNodeCompiler loggerCompiler = new SoyNodeCompiler(MethodRef.RUNTIME_LOGGER.invoke(new Expression[0]), this.contextExpression, this.exprCompiler);
        return Statement.concat(loggerCompiler.visitChildren(node)).withSourceLocation(node.getSourceLocation());
    }

    @Override
    protected Statement visitSoyNode(SoyNode node) {
        throw new UnsupportedOperationException("The jbcsrc backend doesn't support: " + (Object)((Object)node.getKind()) + " nodes yet.");
    }
}

