/*
 * Decompiled with CFR 0.152.
 */
package com.google.template.soy.jbcsrc;

import com.google.common.base.Preconditions;
import com.google.template.soy.data.restricted.BooleanData;
import com.google.template.soy.data.restricted.IntegerData;
import com.google.template.soy.data.restricted.NullData;
import com.google.template.soy.data.restricted.StringData;
import com.google.template.soy.data.restricted.UndefinedData;
import com.google.template.soy.jbcsrc.AutoValue_FieldRef;
import com.google.template.soy.jbcsrc.Expression;
import com.google.template.soy.jbcsrc.Statement;
import com.google.template.soy.jbcsrc.TypeInfo;
import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import org.objectweb.asm.ClassVisitor;
import org.objectweb.asm.Type;
import org.objectweb.asm.commons.GeneratorAdapter;

abstract class FieldRef {
    static final FieldRef BOOLEAN_DATA_FALSE = FieldRef.staticFieldReference(BooleanData.class, "FALSE");
    static final FieldRef BOOLEAN_DATA_TRUE = FieldRef.staticFieldReference(BooleanData.class, "TRUE");
    static final FieldRef INTEGER_DATA_ZERO = FieldRef.staticFieldReference(IntegerData.class, "ZERO");
    static final FieldRef INTEGER_DATA_ONE = FieldRef.staticFieldReference(IntegerData.class, "ONE");
    static final FieldRef INTEGER_DATA_MINUS_ONE = FieldRef.staticFieldReference(IntegerData.class, "MINUS_ONE");
    static final FieldRef NULL_DATA_INSTANCE = FieldRef.staticFieldReference(NullData.class, "INSTANCE");
    static final FieldRef UNDEFINED_DATA_INSTANCE = FieldRef.staticFieldReference(UndefinedData.class, "INSTANCE");
    static final FieldRef STRING_DATA_EMPTY = FieldRef.staticFieldReference(StringData.class, "EMPTY_STRING");
    static final FieldRef SYSTEM_OUT = FieldRef.staticFieldReference(System.class, "out");

    FieldRef() {
    }

    static FieldRef createFinalField(TypeInfo owner, String name, Class<?> type) {
        return new AutoValue_FieldRef(owner, name, Type.getType(type), 18);
    }

    static FieldRef staticFieldReference(Class<?> owner, String name) {
        Class<?> fieldType;
        try {
            Field declaredField = owner.getDeclaredField(name);
            if (!Modifier.isStatic(declaredField.getModifiers())) {
                throw new IllegalStateException("Field: " + declaredField + " is not static");
            }
            fieldType = declaredField.getType();
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        return new AutoValue_FieldRef(TypeInfo.create(owner), name, Type.getType(fieldType), 8);
    }

    static FieldRef createField(TypeInfo owner, String name, Class<?> type) {
        return FieldRef.createField(owner, name, Type.getType(type));
    }

    static FieldRef createField(TypeInfo owner, String name, Type type) {
        return new AutoValue_FieldRef(owner, name, type, 2);
    }

    static FieldRef createPackagePrivateField(TypeInfo owner, String name, Type type) {
        return new AutoValue_FieldRef(owner, name, type, 0);
    }

    abstract TypeInfo owner();

    abstract String name();

    abstract Type type();

    abstract int accessFlags();

    final boolean isStatic() {
        return (this.accessFlags() & 8) != 0;
    }

    void defineField(ClassVisitor cv) {
        cv.visitField(this.accessFlags(), this.name(), this.type().getDescriptor(), null, null);
    }

    Expression accessor(final Expression owner) {
        Preconditions.checkState((!this.isStatic() ? 1 : 0) != 0);
        Preconditions.checkArgument((boolean)owner.resultType().equals((Object)this.owner().type()));
        return new Expression(){

            @Override
            public void gen(GeneratorAdapter mv) {
                owner.gen(mv);
                mv.getField(FieldRef.this.owner().type(), FieldRef.this.name(), this.resultType());
            }

            @Override
            public Type resultType() {
                return FieldRef.this.type();
            }
        };
    }

    Expression accessor() {
        Preconditions.checkState((boolean)this.isStatic());
        return new Expression(){

            @Override
            public void gen(GeneratorAdapter mv) {
                mv.getStatic(FieldRef.this.owner().type(), FieldRef.this.name(), this.resultType());
            }

            @Override
            public Type resultType() {
                return FieldRef.this.type();
            }
        };
    }

    Statement putInstanceField(final Expression instance, final Expression value) {
        Preconditions.checkState((!this.isStatic() ? 1 : 0) != 0, (Object)"This field is static!");
        instance.checkType(this.owner().type());
        value.checkType(this.type());
        return new Statement(){

            @Override
            void doGen(GeneratorAdapter adapter) {
                instance.gen(adapter);
                value.gen(adapter);
                adapter.putField(FieldRef.this.owner().type(), FieldRef.this.name(), FieldRef.this.type());
            }
        };
    }
}

