/*
 * Decompiled with CFR 0.152.
 */
package com.google.template.soy.jbcsrc;

import com.google.common.base.Preconditions;
import com.google.template.soy.exprtree.AbstractReturningExprNodeVisitor;
import com.google.template.soy.exprtree.BooleanNode;
import com.google.template.soy.exprtree.ExprNode;
import com.google.template.soy.exprtree.ExprRootNode;
import com.google.template.soy.exprtree.FieldAccessNode;
import com.google.template.soy.exprtree.FloatNode;
import com.google.template.soy.exprtree.FunctionNode;
import com.google.template.soy.exprtree.IntegerNode;
import com.google.template.soy.exprtree.ItemAccessNode;
import com.google.template.soy.exprtree.ListLiteralNode;
import com.google.template.soy.exprtree.MapLiteralNode;
import com.google.template.soy.exprtree.NullNode;
import com.google.template.soy.exprtree.OperatorNodes;
import com.google.template.soy.exprtree.StringNode;
import com.google.template.soy.exprtree.VarRefNode;
import com.google.template.soy.jbcsrc.BytecodeUtils;
import com.google.template.soy.jbcsrc.ConstructorRef;
import com.google.template.soy.jbcsrc.Expression;
import com.google.template.soy.jbcsrc.MethodRef;
import com.google.template.soy.jbcsrc.SoyExpression;
import com.google.template.soy.jbcsrc.Statement;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import org.objectweb.asm.Label;
import org.objectweb.asm.Type;
import org.objectweb.asm.commons.GeneratorAdapter;

abstract class ExpressionCompiler
extends AbstractReturningExprNodeVisitor<SoyExpression> {
    ExpressionCompiler() {
    }

    SoyExpression compile(ExprNode node) {
        return (SoyExpression)this.visit((ExprNode)Preconditions.checkNotNull((Object)node));
    }

    @Override
    protected final SoyExpression visitExprRootNode(ExprRootNode<?> node) {
        return (SoyExpression)this.visit((ExprNode)node.getChild(0));
    }

    @Override
    protected final SoyExpression visitNullNode(NullNode node) {
        return SoyExpression.NULL;
    }

    @Override
    protected final SoyExpression visitFloatNode(FloatNode node) {
        return BytecodeUtils.constant(node.getValue());
    }

    @Override
    protected final SoyExpression visitStringNode(StringNode node) {
        return BytecodeUtils.constant(node.getValue());
    }

    @Override
    protected final SoyExpression visitBooleanNode(BooleanNode node) {
        return node.getValue() ? SoyExpression.BoolExpression.TRUE : SoyExpression.BoolExpression.FALSE;
    }

    @Override
    protected final SoyExpression visitIntegerNode(IntegerNode node) {
        return BytecodeUtils.constant((long)node.getValue());
    }

    @Override
    protected final SoyExpression visitListLiteralNode(ListLiteralNode node) {
        int numChildren = node.getChildren().size();
        if (numChildren == 0) {
            return new SoyExpression.ListExpression(){

                @Override
                void gen(GeneratorAdapter adapter) {
                    MethodRef.IMMUTABLE_LIST_OF.invoke(new Expression[0]).gen(adapter);
                }

                @Override
                boolean isConstant() {
                    return true;
                }
            };
        }
        ArrayList<Statement> adds = new ArrayList<Statement>(numChildren);
        Expression dupExpr = BytecodeUtils.dupExpr(Type.getType(ArrayList.class));
        boolean localIsConstant = true;
        for (ExprNode child : node.getChildren()) {
            SoyExpression childExpr = ((SoyExpression)this.visit(child)).box();
            localIsConstant = localIsConstant && childExpr.isConstant();
            adds.add(MethodRef.ARRAY_LIST_ADD.invoke(dupExpr, childExpr).toStatement());
        }
        final boolean isConstant = localIsConstant;
        final Expression construct = ConstructorRef.ARRAY_LIST_SIZE.construct(BytecodeUtils.constant(numChildren));
        final Statement addAll = Statement.concat(adds);
        return new SoyExpression.ListExpression(){

            @Override
            public void gen(GeneratorAdapter mv) {
                construct.gen(mv);
                addAll.gen(mv);
            }

            @Override
            boolean isConstant() {
                return isConstant;
            }
        };
    }

    @Override
    protected final SoyExpression visitMapLiteralNode(MapLiteralNode node) {
        int numItems = node.numChildren() / 2;
        if (numItems == 0) {
            return new SoyExpression.MapExpression(){

                @Override
                void gen(GeneratorAdapter adapter) {
                    MethodRef.IMMUTABLE_MAP_OF.invoke(new Expression[0]).gen(adapter);
                }

                @Override
                boolean isConstant() {
                    return true;
                }
            };
        }
        int hashMapCapacity = this.hashMapCapacity(numItems);
        Expression dupExpr = BytecodeUtils.dupExpr(Type.getType(LinkedHashMap.class));
        ArrayList<Statement> puts = new ArrayList<Statement>(numItems);
        boolean localIsConstant = true;
        for (int i = 0; i < numItems; ++i) {
            SoyExpression key = ((SoyExpression)this.visit(node.getChild(2 * i))).convert(String.class);
            SoyExpression value = ((SoyExpression)this.visit(node.getChild(2 * i + 1))).box();
            localIsConstant = localIsConstant && key.isConstant() && value.isConstant();
            puts.add(MethodRef.LINKED_HASH_MAP_PUT.invoke(dupExpr, key, value).toStatement());
        }
        final boolean isConstant = localIsConstant;
        final Expression construct = ConstructorRef.LINKED_HASH_MAP_SIZE.construct(BytecodeUtils.constant(hashMapCapacity));
        final Statement putAll = Statement.concat(puts);
        return new SoyExpression.MapExpression(){

            @Override
            public void gen(GeneratorAdapter mv) {
                construct.gen(mv);
                putAll.gen(mv);
            }

            @Override
            boolean isConstant() {
                return isConstant;
            }
        };
    }

    @Override
    protected final SoyExpression visitEqualOpNode(OperatorNodes.EqualOpNode node) {
        return this.doEquals((SoyExpression)this.visit(node.getChild(0)), (SoyExpression)this.visit(node.getChild(1)));
    }

    @Override
    protected final SoyExpression visitNotEqualOpNode(OperatorNodes.NotEqualOpNode node) {
        return BytecodeUtils.logicalNot(this.doEquals((SoyExpression)this.visit(node.getChild(0)), (SoyExpression)this.visit(node.getChild(1))));
    }

    private SoyExpression.BoolExpression doEquals(SoyExpression left, SoyExpression right) {
        if (left.isKnownString()) {
            return this.doEqualsString((SoyExpression.StringExpression)left.convert(String.class), right);
        }
        if (right.isKnownString()) {
            return this.doEqualsString((SoyExpression.StringExpression)right.convert(String.class), left);
        }
        if (left.isKnownInt() && right.isKnownInt()) {
            return BytecodeUtils.compare(153, left.convert(Long.TYPE), right.convert(Long.TYPE));
        }
        if (left.isKnownNumber() && right.isKnownNumber()) {
            return BytecodeUtils.compare(153, left.convert(Double.TYPE), right.convert(Double.TYPE));
        }
        return (SoyExpression.BoolExpression)MethodRef.RUNTIME_EQUAL.invokeAsBoxedSoyExpression(left, right);
    }

    private SoyExpression.BoolExpression doEqualsString(SoyExpression.StringExpression stringExpr, SoyExpression other) {
        if (other.isKnownString()) {
            SoyExpression strOther = other.convert(String.class);
            return (SoyExpression.BoolExpression)MethodRef.EQUALS.invoke(stringExpr, strOther);
        }
        if (other.isKnownNumber()) {
            return (SoyExpression.BoolExpression)MethodRef.RUNTIME_STRING_EQUALS_AS_NUMBER.invoke(stringExpr, other.convert(Double.TYPE));
        }
        return (SoyExpression.BoolExpression)MethodRef.RUNTIME_EQUAL.invokeAsBoxedSoyExpression(stringExpr, other);
    }

    @Override
    protected final SoyExpression visitLessThanOpNode(OperatorNodes.LessThanOpNode node) {
        SoyExpression left = (SoyExpression)this.visit(node.getChild(0));
        SoyExpression right = (SoyExpression)this.visit(node.getChild(1));
        if (left.isKnownInt() && right.isKnownInt()) {
            return BytecodeUtils.compare(155, left.convert(Long.TYPE), right.convert(Long.TYPE));
        }
        if (left.isKnownNumber() && right.isKnownNumber()) {
            return BytecodeUtils.compare(155, left.convert(Double.TYPE), right.convert(Double.TYPE));
        }
        return MethodRef.RUNTIME_LESS_THAN.invokeAsBoxedSoyExpression(left, right);
    }

    @Override
    protected final SoyExpression visitGreaterThanOpNode(OperatorNodes.GreaterThanOpNode node) {
        SoyExpression left = (SoyExpression)this.visit(node.getChild(0));
        SoyExpression right = (SoyExpression)this.visit(node.getChild(1));
        if (left.isKnownInt() && right.isKnownInt()) {
            return BytecodeUtils.compare(157, left.convert(Long.TYPE), right.convert(Long.TYPE));
        }
        if (left.isKnownNumber() && right.isKnownNumber()) {
            return BytecodeUtils.compare(157, left.convert(Double.TYPE), right.convert(Double.TYPE));
        }
        return MethodRef.RUNTIME_LESS_THAN.invokeAsBoxedSoyExpression(right, left);
    }

    @Override
    protected final SoyExpression visitLessThanOrEqualOpNode(OperatorNodes.LessThanOrEqualOpNode node) {
        SoyExpression left = (SoyExpression)this.visit(node.getChild(0));
        SoyExpression right = (SoyExpression)this.visit(node.getChild(1));
        if (left.isKnownInt() && right.isKnownInt()) {
            return BytecodeUtils.compare(158, left.convert(Long.TYPE), right.convert(Long.TYPE));
        }
        if (left.isKnownNumber() && right.isKnownNumber()) {
            return BytecodeUtils.compare(158, left.convert(Double.TYPE), right.convert(Double.TYPE));
        }
        return MethodRef.RUNTIME_LESS_THAN_OR_EQUAL.invokeAsBoxedSoyExpression(left, right);
    }

    @Override
    protected final SoyExpression visitGreaterThanOrEqualOpNode(OperatorNodes.GreaterThanOrEqualOpNode node) {
        SoyExpression left = (SoyExpression)this.visit(node.getChild(0));
        SoyExpression right = (SoyExpression)this.visit(node.getChild(1));
        if (left.isKnownInt() && right.isKnownInt()) {
            return BytecodeUtils.compare(156, left.convert(Long.TYPE), right.convert(Long.TYPE));
        }
        if (left.isKnownNumber() && right.isKnownNumber()) {
            return BytecodeUtils.compare(156, left.convert(Double.TYPE), right.convert(Double.TYPE));
        }
        return MethodRef.RUNTIME_LESS_THAN_OR_EQUAL.invokeAsBoxedSoyExpression(right, left);
    }

    @Override
    protected final SoyExpression visitPlusOpNode(OperatorNodes.PlusOpNode node) {
        SoyExpression left = (SoyExpression)this.visit(node.getChild(0));
        SoyExpression right = (SoyExpression)this.visit(node.getChild(1));
        if (left.isKnownInt() && right.isKnownInt()) {
            return this.applyBinaryIntOperator(97, left, right);
        }
        if (left.isKnownNumber() && right.isKnownNumber()) {
            return this.applyBinaryFloatOperator(99, left, right);
        }
        if (left.isKnownString() || right.isKnownString()) {
            SoyExpression leftString = left.convert(String.class);
            SoyExpression rightString = right.convert(String.class);
            return (SoyExpression)MethodRef.STRING_CONCAT.invoke(leftString, rightString);
        }
        return MethodRef.RUNTIME_PLUS.invokeAsBoxedSoyExpression(left, right);
    }

    @Override
    protected final SoyExpression visitMinusOpNode(OperatorNodes.MinusOpNode node) {
        SoyExpression left = (SoyExpression)this.visit(node.getChild(0));
        SoyExpression right = (SoyExpression)this.visit(node.getChild(1));
        if (left.isKnownInt() && right.isKnownInt()) {
            return this.applyBinaryIntOperator(101, left, right);
        }
        if (left.isKnownNumber() && right.isKnownNumber()) {
            return this.applyBinaryFloatOperator(103, left, right);
        }
        return MethodRef.RUNTIME_MINUS.invokeAsBoxedSoyExpression(left, right);
    }

    @Override
    protected final SoyExpression visitTimesOpNode(OperatorNodes.TimesOpNode node) {
        SoyExpression left = (SoyExpression)this.visit(node.getChild(0));
        SoyExpression right = (SoyExpression)this.visit(node.getChild(1));
        if (left.isKnownInt() && right.isKnownInt()) {
            return this.applyBinaryIntOperator(105, left, right);
        }
        if (left.isKnownNumber() && right.isKnownNumber()) {
            return this.applyBinaryFloatOperator(107, left, right);
        }
        return MethodRef.RUNTIME_TIMES.invokeAsBoxedSoyExpression(left, right);
    }

    @Override
    protected final SoyExpression visitDivideByOpNode(OperatorNodes.DivideByOpNode node) {
        return this.applyBinaryFloatOperator(111, (SoyExpression)this.visit(node.getChild(0)), (SoyExpression)this.visit(node.getChild(1)));
    }

    @Override
    protected final SoyExpression visitModOpNode(OperatorNodes.ModOpNode node) {
        return this.applyBinaryIntOperator(113, (SoyExpression)this.visit(node.getChild(0)), (SoyExpression)this.visit(node.getChild(1)));
    }

    private SoyExpression.IntExpression applyBinaryIntOperator(final int operator, SoyExpression left, SoyExpression right) {
        final SoyExpression leftInt = left.convert(Long.TYPE);
        final SoyExpression rightInt = right.convert(Long.TYPE);
        return new SoyExpression.IntExpression(){

            @Override
            public void gen(GeneratorAdapter mv) {
                leftInt.gen(mv);
                rightInt.gen(mv);
                mv.visitInsn(operator);
            }

            @Override
            boolean isConstant() {
                return leftInt.isConstant() && rightInt.isConstant();
            }
        };
    }

    private SoyExpression.FloatExpression applyBinaryFloatOperator(final int operator, SoyExpression left, SoyExpression right) {
        final SoyExpression leftInt = left.convert(Double.TYPE);
        final SoyExpression rightInt = right.convert(Double.TYPE);
        return new SoyExpression.FloatExpression(){

            @Override
            public void gen(GeneratorAdapter mv) {
                leftInt.gen(mv);
                rightInt.gen(mv);
                mv.visitInsn(operator);
            }

            @Override
            boolean isConstant() {
                return leftInt.isConstant() && rightInt.isConstant();
            }
        };
    }

    @Override
    protected final SoyExpression visitNegativeOpNode(OperatorNodes.NegativeOpNode node) {
        SoyExpression child = (SoyExpression)this.visit(node.getChild(0));
        if (child.isKnownInt()) {
            final SoyExpression intExpr = child.convert(Long.TYPE);
            return new SoyExpression.IntExpression(){

                @Override
                public void gen(GeneratorAdapter mv) {
                    intExpr.gen(mv);
                    mv.visitInsn(117);
                }
            };
        }
        if (child.isKnownNumber()) {
            final SoyExpression floatExpr = child.convert(Double.TYPE);
            return new SoyExpression.FloatExpression(){

                @Override
                public void gen(GeneratorAdapter mv) {
                    floatExpr.gen(mv);
                    mv.visitInsn(119);
                }
            };
        }
        return MethodRef.RUNTIME_NEGATIVE.invokeAsBoxedSoyExpression(child);
    }

    @Override
    protected final SoyExpression visitNotOpNode(OperatorNodes.NotOpNode node) {
        return BytecodeUtils.logicalNot(((SoyExpression)this.visit(node.getChild(0))).convert(Boolean.TYPE));
    }

    @Override
    protected final SoyExpression visitAndOpNode(OperatorNodes.AndOpNode node) {
        final SoyExpression left = ((SoyExpression)this.visit(node.getChild(0))).convert(Boolean.TYPE);
        final SoyExpression right = ((SoyExpression)this.visit(node.getChild(1))).convert(Boolean.TYPE);
        return new SoyExpression.BoolExpression(){

            @Override
            public void gen(GeneratorAdapter mv) {
                left.gen(mv);
                Label ifFalsy = new Label();
                Label end = new Label();
                mv.ifZCmp(153, ifFalsy);
                right.gen(mv);
                mv.goTo(end);
                mv.mark(ifFalsy);
                mv.push(false);
                mv.mark(end);
            }

            @Override
            boolean isConstant() {
                return left.isConstant() && right.isConstant();
            }
        };
    }

    @Override
    protected final SoyExpression visitOrOpNode(OperatorNodes.OrOpNode node) {
        final SoyExpression left = ((SoyExpression)this.visit(node.getChild(0))).convert(Boolean.TYPE);
        final SoyExpression right = ((SoyExpression)this.visit(node.getChild(1))).convert(Boolean.TYPE);
        return new SoyExpression.BoolExpression(){

            @Override
            public void gen(GeneratorAdapter mv) {
                left.gen(mv);
                Label ifTruthy = new Label();
                Label end = new Label();
                mv.ifZCmp(154, ifTruthy);
                right.gen(mv);
                mv.goTo(end);
                mv.mark(ifTruthy);
                mv.push(true);
                mv.mark(end);
            }

            @Override
            boolean isConstant() {
                return left.isConstant() && right.isConstant();
            }
        };
    }

    @Override
    protected final SoyExpression visitConditionalOpNode(OperatorNodes.ConditionalOpNode node) {
        boolean constant;
        final SoyExpression.BoolExpression condition = (SoyExpression.BoolExpression)((SoyExpression)this.visit(node.getChild(0))).convert(Boolean.TYPE);
        final SoyExpression trueBranch = (SoyExpression)this.visit(node.getChild(1));
        final SoyExpression falseBranch = (SoyExpression)this.visit(node.getChild(2));
        boolean bl = constant = condition.isConstant() && trueBranch.isConstant() && falseBranch.isConstant();
        if (trueBranch.isKnownInt() && falseBranch.isKnownInt()) {
            return new SoyExpression.IntExpression(){

                @Override
                void gen(GeneratorAdapter adapter) {
                    ExpressionCompiler.doCondition(adapter, condition, trueBranch.convert(Long.TYPE), falseBranch.convert(Long.TYPE));
                }

                @Override
                boolean isConstant() {
                    return constant;
                }
            };
        }
        if (trueBranch.isKnownNumber() && falseBranch.isKnownNumber()) {
            return new SoyExpression.FloatExpression(){

                @Override
                void gen(GeneratorAdapter adapter) {
                    ExpressionCompiler.doCondition(adapter, condition, trueBranch.convert(Double.TYPE), falseBranch.convert(Double.TYPE));
                }

                @Override
                boolean isConstant() {
                    return constant;
                }
            };
        }
        if (trueBranch.isKnownString() && falseBranch.isKnownString()) {
            return new SoyExpression.StringExpression(){

                @Override
                void gen(GeneratorAdapter adapter) {
                    ExpressionCompiler.doCondition(adapter, condition, trueBranch.convert(String.class), falseBranch.convert(String.class));
                }

                @Override
                boolean isConstant() {
                    return constant;
                }
            };
        }
        final SoyExpression trueBoxed = trueBranch.box();
        final SoyExpression falseBoxed = falseBranch.box();
        return new SoyExpression.BoxedExpression(node.getType().javaType()){

            @Override
            public void gen(GeneratorAdapter mv) {
                ExpressionCompiler.doCondition(mv, condition, trueBoxed, falseBoxed);
            }

            @Override
            boolean isConstant() {
                return condition.isConstant() && trueBranch.isConstant() && falseBranch.isConstant();
            }
        };
    }

    private static void doCondition(GeneratorAdapter mv, SoyExpression.BoolExpression condition, SoyExpression trueBranch, SoyExpression falseBranch) {
        condition.gen(mv);
        Label ifFalse = new Label();
        Label end = new Label();
        mv.visitJumpInsn(153, ifFalse);
        trueBranch.gen(mv);
        mv.visitJumpInsn(167, end);
        mv.visitLabel(ifFalse);
        falseBranch.gen(mv);
        mv.visitLabel(end);
    }

    @Override
    protected abstract SoyExpression visitVarRefNode(VarRefNode var1);

    @Override
    protected abstract SoyExpression visitFieldAccessNode(FieldAccessNode var1);

    @Override
    protected abstract SoyExpression visitItemAccessNode(ItemAccessNode var1);

    @Override
    protected abstract SoyExpression visitFunctionNode(FunctionNode var1);

    @Override
    protected final SoyExpression visitExprNode(ExprNode node) {
        throw new UnsupportedOperationException("Support for " + (Object)((Object)node.getKind()) + " has node been added yet");
    }

    private int hashMapCapacity(int expectedSize) {
        if (expectedSize < 3) {
            return expectedSize + 1;
        }
        if (expectedSize < 0x40000000) {
            return (int)((float)expectedSize / 0.75f + 1.0f);
        }
        return Integer.MAX_VALUE;
    }
}

