/*
 * Decompiled with CFR 0.152.
 */
package com.google.template.soy.jbcsrc;

import com.google.common.collect.ImmutableBiMap;
import com.google.template.soy.jbcsrc.CompiledTemplateMetadata;
import com.google.template.soy.soytree.TemplateBasicNode;
import com.google.template.soy.soytree.TemplateRegistry;
import java.util.Map;

final class CompiledTemplateRegistry {
    private final ImmutableBiMap<String, CompiledTemplateMetadata> templateNameToGeneratedClassName;

    CompiledTemplateRegistry(TemplateRegistry registry) {
        ImmutableBiMap.Builder builder = ImmutableBiMap.builder();
        for (Map.Entry<String, TemplateBasicNode> entry : registry.getBasicTemplatesMap().entrySet()) {
            builder.put((Object)entry.getKey(), (Object)CompiledTemplateMetadata.create(entry.getKey(), entry.getValue()));
        }
        this.templateNameToGeneratedClassName = builder.build();
    }

    CompiledTemplateMetadata getTemplateInfo(String templateName) {
        return (CompiledTemplateMetadata)this.templateNameToGeneratedClassName.get((Object)templateName);
    }
}

