/*
 * Decompiled with CFR 0.152.
 */
package com.google.template.soy.exprtree;

import com.google.common.base.Preconditions;
import com.google.template.soy.exprtree.AbstractExprNode;
import com.google.template.soy.exprtree.ExprNode;
import com.google.template.soy.exprtree.VarDefn;
import com.google.template.soy.types.SoyType;
import java.util.Objects;
import javax.annotation.Nullable;

public final class VarRefNode
extends AbstractExprNode {
    public static final VarRefNode ERROR = new VarRefNode("error", false, false, null);
    private final String name;
    private final boolean isInjected;
    private final boolean isNullSafeInjected;
    private VarDefn defn;
    private SoyType subtituteType;

    public VarRefNode(String name, boolean injected, boolean nullSafeInjected, @Nullable VarDefn defn) {
        Preconditions.checkArgument((name != null ? 1 : 0) != 0);
        this.name = name;
        this.isInjected = injected;
        this.isNullSafeInjected = nullSafeInjected;
        this.defn = defn;
    }

    private VarRefNode(VarRefNode orig) {
        super(orig);
        this.name = orig.name;
        this.isInjected = orig.isInjected;
        this.isNullSafeInjected = orig.isNullSafeInjected;
        this.defn = orig.defn;
    }

    @Override
    public ExprNode.Kind getKind() {
        return ExprNode.Kind.VAR_REF_NODE;
    }

    @Override
    public SoyType getType() {
        Preconditions.checkState((this.defn != null ? 1 : 0) != 0);
        return this.subtituteType != null ? this.subtituteType : this.defn.type();
    }

    public String getName() {
        return this.name;
    }

    public boolean isInjected() {
        return this.isInjected;
    }

    public boolean isNullSafeInjected() {
        return this.isNullSafeInjected;
    }

    public void setDefn(VarDefn defn) {
        this.defn = defn;
    }

    public VarDefn getDefnDecl() {
        return this.defn;
    }

    public Boolean isLocalVar() {
        return this.defn == null ? null : Boolean.valueOf(this.defn.kind() == VarDefn.Kind.LOCAL_VAR);
    }

    public Boolean isPossibleParam() {
        return this.defn == null || this.defn.kind() == VarDefn.Kind.PARAM || this.defn.kind() == VarDefn.Kind.UNDECLARED;
    }

    public void setSubstituteType(SoyType type) {
        this.subtituteType = type;
    }

    @Override
    public String toSourceString() {
        return "$" + (this.isInjected ? (this.isNullSafeInjected ? "ij?." : "ij.") : "") + this.name;
    }

    @Override
    public VarRefNode clone() {
        return new VarRefNode(this);
    }

    public boolean equals(Object other) {
        if (other == null || other.getClass() != this.getClass()) {
            return false;
        }
        VarRefNode otherVar = (VarRefNode)other;
        return this.name.equals(otherVar.name) && this.isInjected == otherVar.isInjected && this.isNullSafeInjected == otherVar.isNullSafeInjected;
    }

    public int hashCode() {
        return Objects.hash(this.getClass(), this.name, this.isInjected, this.isNullSafeInjected);
    }
}

