/* Generated By:JavaCC: Do not edit this line. TemplateParser.java */
package com.google.template.soy.soyparse;

import com.google.common.base.CharMatcher;
import com.google.common.base.Joiner;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Lists;
import com.google.template.soy.soyparse.ErrorReporter;
import com.google.template.soy.base.SourceLocation;
import com.google.template.soy.base.internal.IdGenerator;
import com.google.template.soy.soytree.CallBasicNode;
import com.google.template.soy.soytree.CallDelegateNode;
import com.google.template.soy.soytree.CallNode;
import com.google.template.soy.soytree.CallParamContentNode;
import com.google.template.soy.soytree.CallParamNode;
import com.google.template.soy.soytree.CallParamValueNode;
import com.google.template.soy.soytree.CssNode;
import com.google.template.soy.soytree.DebuggerNode;
import com.google.template.soy.soytree.ForNode;
import com.google.template.soy.soytree.ForeachNode;
import com.google.template.soy.soytree.IfCondNode;
import com.google.template.soy.soytree.IfElseNode;
import com.google.template.soy.soytree.IfNode;
import com.google.template.soy.soytree.LetContentNode;
import com.google.template.soy.soytree.LetNode;
import com.google.template.soy.soytree.LetValueNode;
import com.google.template.soy.soytree.LogNode;
import com.google.template.soy.soytree.MsgFallbackGroupNode;
import com.google.template.soy.soytree.MsgHtmlTagNode;
import com.google.template.soy.soytree.MsgNode;
import com.google.template.soy.soytree.MsgPlaceholderNode;
import com.google.template.soy.soytree.MsgPluralCaseNode;
import com.google.template.soy.soytree.MsgPluralDefaultNode;
import com.google.template.soy.soytree.MsgPluralNode;
import com.google.template.soy.soytree.MsgSelectCaseNode;
import com.google.template.soy.soytree.MsgSelectDefaultNode;
import com.google.template.soy.soytree.MsgSelectNode;
import com.google.template.soy.soytree.PrintDirectiveNode;
import com.google.template.soy.soytree.PrintNode;
import com.google.template.soy.soytree.RawTextNode;
import com.google.template.soy.soytree.SoyNode;
import com.google.template.soy.soytree.SoyNode.CommandNode;
import com.google.template.soy.soytree.SoyNode.MsgPlaceholderInitialNode;
import com.google.template.soy.soytree.SoyNode.StandaloneNode;
import com.google.template.soy.soytree.SoyNode.StatementNode;
import com.google.template.soy.soytree.SwitchCaseNode;
import com.google.template.soy.soytree.SwitchDefaultNode;
import com.google.template.soy.soytree.SwitchNode;
import com.google.template.soy.soytree.TemplateNodeBuilder.DeclInfo;
import com.google.template.soy.soytree.XidNode;

import java.io.*;
import java.util.*;
import java.util.regex.*;


/**
 * This parser's specification is in TemplateParser.jj, which is read by JavaCC and transformed
 * into TemplateParser.java. To modify this parser, please edit TemplateParser.jj. Do not edit
 * TemplateParser.java directly.
 *
 * <p> Important: Do not use outside of Soy code (treat as superpackage-private).
 *
 * <pre>
 * This parser parses the content (header and body) of a Soy template.
 *
 * Header:
 *
 * 1. Comments:
 *    + Comments are only allowed outside of Soy tags.
 *    + Standard "//" for a rest-of-line comment. Must appear at start of line or after a space.
 *    + Standard slash-star (/*) ... star-slash (*&#47;) for a block comment.
 *    + Doc comments are not allowed, except when attached to a valid declaration.
 *
 * 2. Param declaration:
 *    + Soy tag with command name "@param" and command text "key: type".
 *    + Optional desc string is written as a block doc comment, which either must
 *      precede the param tag, or must start on the same line as the end of the '@param' tag.
 *    + Examples:
 *    {@param foo: bool}
 *    {@param foo: list<int>}  /** A list of numbers. *&#47;
 *    {@param? foo:
 *        list<int>}  /**
 *        A list of numbers. *&#47;
 *
 * 3. Injected param declaration:
 *    + Works exactly like @param except that parameter values are taken from the
 *      implicit $ij scope.
 *    + Soy tag with command name "@inject" and command text "key: type".
 *    + Optional desc string is written as a block doc comment, which either must
 *      precede the param tag, or must start on the same line as the end of the '@inject' tag.
 *    + Examples:
 *    {@inject foo: bool}
 *    {@inject foo: list<int>}  /** A list of numbers. *&#47;
 *    {@inject? foo:
 *        list<int>}  /**
 *        A list of numbers. *&#47;
 *
 * Body:
 *
 * 1. Comments:
 *    + Comments are only allowed outside of Soy tags.
 *    + Standard "//" for a rest-of-line comment. Must appear at start of line or after a space.
 *    + Standard slash-star (/*) ... star-slash (*&#47;) for a block comment.
 *
 * 2. Soy tag format:
 *    + Can be delimited by single braces "{...}" or double braces "{{...}}".
 *    + Soy tags delimited by double braces are allowed to contain single braces within.
 *    + Some Soy tags are allowed to end in "/}" or "/}}" to denote immediate ending of a block.
 *    + It is an error to use "/}" or "/}}" when it's not applicable to the command.
 *    + If there is a command name, it must come immediately after the opening delimiter.
 *    + The command name must be followed by either the closing delimiter (if the command does not
 *      take any command text) or a whitespace (if the command takes command text).
 *    + It is an error to provide command text when it's not applicable, and vice versa.
 *    + This parser does not parse command text (that will be separate).
 *    Examples:
 *    {print $boo}   // explicit 'print' command
 *    {$boo.foo}   // implicit 'print' command
 *    {printer}   // implicit 'print' command (the prefix 'print' here is not a command name)
 *    {\n}   // a command that doesn't take any command text
 *    {call .gooMoo data="all" /}   // self-ending block
 *    {call .gooMoo data="all"}...{/call}   // block with separate start and end tags
 *
 * 3. Raw text:
 *    + Raw text is fixed text that will be part of the template output. There are 3 types.
 *    + Any text outside of Soy tags is raw text.
 *    + There are 7 special character commands that produce raw text strings:
 *      {sp} = space   {nil} = empty string   {\n} = newline (line feed)   {\r} = carriage return
 *      {\t} = tab   {lb} = left brace   {rb} = right brace
 *    + A section of raw text (may contain braces) can be enclosed within a 'literal' block:
 *      {literal}...{/literal}
 *
 * 4. Msg blocks:
 *    + A block between 'msg' and '/msg' tags represents a message for translation.
 *    + It is an error to nest 'msg' blocks.
 *    + Within a 'msg' block, the parsing of Soy tags is the same. The only difference is that we
 *      also recognize "&lt;" and "&gt;" as opening and closing an HTML tag. This is because each
 *      HTML tag as a whole needs to be turned into a single placeholder in the message.
 *    + A 'msg' block may have a 'plural' or 'select' block as its only content.
 *    + A 'msg' block may be followed by optional additional 'fallbackmsg' blocks.
 *    Example:
 *    {msg desc="Event title."}
 *      Join event &lt;a href="{$event.url}"&gt;{$event.title}&lt;/a&gt;.
 *    {fallbackmsg desc="Event title."}
 *      Join event {$event.title}.
 *    {/msg}
 *
 * 5. Other Soy commands:
 *    {print ...}
 *    {...}    // implied 'print' command
 *    {xid ...}
 *    {css ...}
 *    {let ... /}
 *    {let ...}...{/let}
 *    {if ...}...{elseif ...}...{else ...}...{/if}
 *    {switch ...}{case ...}...{default}...{/switch}
 *    {foreach ...}...{ifempty}...{/foreach}
 *    {for ...}...{/for}
 *    {call ... /}
 *    {delcall ... /}
 *    {call ...}{param ... /}{param ...}...{/param}{/call}
 *    {delcall ...}{param ... /}{param ...}...{/param}{/delcall}
 *    {log}...{/log}
 *    {debugger}
 *
 * 6. Misc:
 *    + The following commands are not allowed to appear in a template:
 *      {namespace ...}   {template ...}   {/template}
 * </pre>
 *
 */
public class TemplateParser implements TemplateParserConstants {

  /** Regex string used in patterns below. Note the first set of spaces is reluctant. */
  private static final String LINE_BOUNDARY_REGEX = "\u005c\u005cs*?(\u005c\u005cn|\u005c\u005cr)\u005c\u005cs*";

  /** Pattern for a line boundary. */
  private static final Pattern LINE_BOUNDARY_PATTERN = Pattern.compile(LINE_BOUNDARY_REGEX);

  /** Pattern for a line boundary appearing at the start edge of the string being matched. */
  private static final Pattern START_EDGE_LINE_BOUNDARY_PATTERN =
      Pattern.compile("^" + LINE_BOUNDARY_REGEX);

  /** Pattern for a line boundary appearing at the end edge of the string being matched. */
  private static final Pattern END_EDGE_LINE_BOUNDARY_PATTERN =
      Pattern.compile(LINE_BOUNDARY_REGEX + "$");

  /** Pattern for a line boundary not appearing at either edge of the string being matched. */
  private static final Pattern NONEDGE_LINE_BOUNDARY_PATTERN =
      Pattern.compile("(?<=\u005c\u005cS)" + LINE_BOUNDARY_REGEX + "(?=\u005c\u005cS)");

  private static final SoyError MULTIPLE_FALLBACK_MSGS =
      SoyError.of("Multiple ''fallbackmsg''s is not allowed.");

  private static final SoyError COMMAND_NOT_ALLOWED_WITHIN_MSG_BLOCK =
      SoyError.of("Command ''{0}'' not allowed within a ''msg'' block.");

  private static final SoyError PLURAL_AND_SELECT_NOT_ALLOWED_INSIDE_PLURAL_BLOCK =
      SoyError.of("Tags ''plural'' and ''select'' are not allowed inside ''plural'' blocks.");

  private static final SoyError MULTIPLE_PHNAME_ATTRIBUTES_IN_COMMAND = SoyError.of(
      "Found multiple ''phname'' attributes in ''{0}'' command text \u005c"{1}\u005c".");

  private static final SoyError PRINT_COMMAND_WITH_EMPTY_TEXT =
      SoyError.of("Found ''print'' command with empty command text.");

  private static final SoyError INVALID_PRINT_COMMAND_TEXT =
      SoyError.of("Invalid ''print'' command text \u005c"{0}\u005c" (check the directives).");

  /** Node id generator for the tree being built. */
  private IdGenerator nodeIdGen;

  /** Path of source file being parsed. This is descriptive, not a means to refetch the source. */
  // Should be marked 'final' (except JavaCC-generated constructors do not init it).
  private String filePath;

  /** The number of lines that precede the start of the template being parsed. */
  // Should be marked 'final' (except JavaCC-generated constructors do not init it).
  private int lineNumOffset;

  /** For reporting syntax errors. */
  private ErrorReporter errorReporter;

  /**
   * Constructor that takes a reader object providing the input.
   * Important: The input should end with a newline sequence (one of "\n", "\r", or "\r\n").
   *
   * @param nodeIdGen The node id generator for the tree being built.
   * @param input The input to parse. This reader will not be closed by this parser.
   * @param filePath File path or uri describing where the input is from. Used for reporting.
   * @param templateContentStartLine The start line for input, 1-indexed.
   * @param errorReporter For reporting errors.
   */
  public TemplateParser(
      IdGenerator nodeIdGen,
      Reader input,
      String filePath,
      int templateContentStartLine,
      ErrorReporter errorReporter) {
    this(input);
    Preconditions.checkNotNull(nodeIdGen);
    this.nodeIdGen = nodeIdGen;
    this.filePath = filePath;
    // Line numbers are 1-indexed but offsets are not.
    this.lineNumOffset = templateContentStartLine - 1;
    this.errorReporter = errorReporter;
  }


  /**
   * Constructor that takes a string input.
   * Important: The input should end with a newline sequence (one of "\n", "\r", or "\r\n").
   *
   * @param nodeIdGen The node id generator for the tree being built.
   * @param input The input to parse.
   * @param filePath File path or uri describing where the input is from. Used for reporting.
   * @param templateContentStartLine The start line for input, 1-indexed.
   * @param errorReporter For reporting errors.
   */
  public TemplateParser(
      IdGenerator nodeIdGen,
      String input,
      String filePath,
      int templateContentStartLine,
      ErrorReporter errorReporter) {
    this(nodeIdGen, new StringReader(input), filePath, templateContentStartLine, errorReporter);
  }

  /**
   * Constructor that takes a string input.
   * Important: The input should end with a newline sequence (one of "\n", "\r", or "\r\n").
   *
   * @param nodeIdGen The node id generator for the tree being built.
   * @param input The input to parse.
   * @param filePath File path or uri describing where the input is from. Used for reporting.
   * @param templateContentStartLine The start line for input, 1-indexed.
   */
  public TemplateParser(
      IdGenerator nodeIdGen,
      String input,
      String filePath,
      int templateContentStartLine) {
    this(nodeIdGen, input, filePath, templateContentStartLine, new ErrorReporterImpl());
  }


  /**
   * Attempts to parse the input as the content of a Soy template (header and body).
   * @throws TokenMgrError When the input has a token error.
   * @throws ParseException When the input has a parse error.
   */
  public TemplateParseResult parseTemplateContent() throws TokenMgrError, ParseException {
    Preconditions.checkNotNull(nodeIdGen);
    return TemplateContentInput();
  }


  /** Map from special character command names to their respective raw text strings. */
  private static final Map<String, String> SPECIAL_CHAR_CMD_NAME_TO_RAW_TEXT =
      ImmutableMap.<String, String>builder()
          .put("sp", " ").put("nil", "").put("\u005c\u005cn", "\u005cn").put("\u005c\u005cr", "\u005cr").put("\u005c\u005ct", "\u005ct")
          .put("lb", "{").put("rb", "}")
          .build();

  private <T> SourceItemInfo<T> newSourceItemInfo(T parsed, Token token) {
    return new SourceItemInfo<T>(filePath, lineNumOffset, parsed, token);
  }

  private <T> SourceItemInfo<T> newSourceItemInfo(T parsed, SourceItemInfo<?> begin,
      SourceItemInfo<?> end) {
    return new SourceItemInfo<T>(parsed, begin, end);
  }

  private <T> SourceItemInfo<T> newSourceItemInfo(
      T parsed, int lineNum, int columnNum, int lineNumEnd, int columnNumEnd) {
    return new SourceItemInfo<T>(filePath, parsed, lineNumOffset + lineNum, columnNum,
        lineNumOffset + lineNumEnd, columnNumEnd);
  }

  private SourceLocation createSrcLoc(Token token) {
    return newSourceItemInfo(null, token).srcLocation();
  }

  private <T extends SoyNode> T setSrcLoc(T node, SourceItemInfo info) {
    node.setSourceLocation(info.srcLocation());
    return node;
  }

  private <T extends SoyNode> T setSrcLoc(T node, Token token) {
    node.setSourceLocation(createSrcLoc(token));
    return node;
  }

  final private SourceItemInfo<Void> SoyTagOpen() throws ParseException {
  Token tagOpen;
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case SOY_TAG_OPEN_1:
      tagOpen = jj_consume_token(SOY_TAG_OPEN_1);
      break;
    case SOY_TAG_OPEN_2:
      tagOpen = jj_consume_token(SOY_TAG_OPEN_2);
      break;
    default:
      jj_la1[0] = jj_gen;
      jj_consume_token(-1);
      throw new ParseException();
    }
    {if (true) return newSourceItemInfo(null, tagOpen);}
    throw new Error("Missing return statement in function");
  }

  final private SourceItemInfo<Void> RegSoyTagClose() throws ParseException {
  Token tagClose;
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case REG_SOY_TAG_CLOSE_AFTER_CMD_NAME_1:
      tagClose = jj_consume_token(REG_SOY_TAG_CLOSE_AFTER_CMD_NAME_1);
      break;
    case REG_SOY_TAG_CLOSE_AFTER_CMD_NAME_2:
      tagClose = jj_consume_token(REG_SOY_TAG_CLOSE_AFTER_CMD_NAME_2);
      break;
    case REG_SOY_TAG_CLOSE_AFTER_CMD_TEXT_1:
      tagClose = jj_consume_token(REG_SOY_TAG_CLOSE_AFTER_CMD_TEXT_1);
      break;
    case REG_SOY_TAG_CLOSE_AFTER_CMD_TEXT_2:
      tagClose = jj_consume_token(REG_SOY_TAG_CLOSE_AFTER_CMD_TEXT_2);
      break;
    default:
      jj_la1[1] = jj_gen;
      jj_consume_token(-1);
      throw new ParseException();
    }
    {if (true) return newSourceItemInfo(null, tagClose);}
    throw new Error("Missing return statement in function");
  }

  final private SourceItemInfo<Void> SelfEndingSoyTagClose() throws ParseException {
  Token tagClose;
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case SELF_ENDING_SOY_TAG_CLOSE_AFTER_CMD_NAME_1:
      tagClose = jj_consume_token(SELF_ENDING_SOY_TAG_CLOSE_AFTER_CMD_NAME_1);
      break;
    case SELF_ENDING_SOY_TAG_CLOSE_AFTER_CMD_NAME_2:
      tagClose = jj_consume_token(SELF_ENDING_SOY_TAG_CLOSE_AFTER_CMD_NAME_2);
      break;
    case SELF_ENDING_SOY_TAG_CLOSE_AFTER_CMD_TEXT_1:
      tagClose = jj_consume_token(SELF_ENDING_SOY_TAG_CLOSE_AFTER_CMD_TEXT_1);
      break;
    case SELF_ENDING_SOY_TAG_CLOSE_AFTER_CMD_TEXT_2:
      tagClose = jj_consume_token(SELF_ENDING_SOY_TAG_CLOSE_AFTER_CMD_TEXT_2);
      break;
    default:
      jj_la1[2] = jj_gen;
      jj_consume_token(-1);
      throw new ParseException();
    }
    {if (true) return newSourceItemInfo(null, tagClose);}
    throw new Error("Missing return statement in function");
  }

  final private String CmdText() throws ParseException {
  List<String> cmdTextParts;
    cmdTextParts = CmdTextParts();
    {if (true) return Joiner.on("").join(cmdTextParts);}
    throw new Error("Missing return statement in function");
  }

  final private List<String> CmdTextParts() throws ParseException {
  String freakCmdName;
  Token cmdTextChar;
  Token cmdTextSpecialPart;
    List<String> cmdTextParts = Lists.newArrayList();
    StringBuilder currCmdTextPartSb = new StringBuilder();
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case CMD_NAME_SP:
    case CMD_NAME_NIL:
    case CMD_NAME_LF:
    case CMD_NAME_CR:
    case CMD_NAME_TAB:
    case CMD_NAME_LB:
    case CMD_NAME_RB:
    case CMD_NAME_LITERAL:
    case CMD_NAME_END_LITERAL:
    case CMD_NAME_MSG:
    case CMD_NAME_END_MSG:
    case CMD_NAME_PRINT:
    case CMD_NAME_XID:
    case CMD_NAME_CSS:
    case CMD_NAME_LET:
    case CMD_NAME_END_LET:
    case CMD_NAME_IF:
    case CMD_NAME_ELSEIF:
    case CMD_NAME_ELSE:
    case CMD_NAME_END_IF:
    case CMD_NAME_SWITCH:
    case CMD_NAME_END_SWITCH:
    case CMD_NAME_FOREACH:
    case CMD_NAME_IFEMPTY:
    case CMD_NAME_END_FOREACH:
    case CMD_NAME_FOR:
    case CMD_NAME_END_FOR:
    case CMD_NAME_ANY_CALL:
    case CMD_NAME_END_ANY_CALL:
    case CMD_NAME_PARAM:
    case CMD_NAME_END_PARAM:
    case CMD_NAME_LOG:
    case CMD_NAME_END_LOG:
    case CMD_NAME_DEBUGGER:
    case CMD_NAME_CASE:
    case CMD_NAME_DEFAULT:
    case CMD_NAME_NAMESPACE:
    case CMD_NAME_TEMPLATE:
    case CMD_NAME_END_TEMPLATE:
      freakCmdName = AnyCmdName();
      currCmdTextPartSb.append(freakCmdName);
      jj_consume_token(NOT_CMD_NAME_BOUNDARY_AFTER_CMD_NAME);
      break;
    default:
      jj_la1[3] = jj_gen;
      ;
    }
    label_1:
    while (true) {
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case CMD_TEXT_DIRECTIVE_NAME:
      case CMD_TEXT_PHNAME_ATTR:
      case CMD_TEXT_CHAR_1:
      case CMD_TEXT_CHAR_2:
        ;
        break;
      default:
        jj_la1[4] = jj_gen;
        break label_1;
      }
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case CMD_TEXT_CHAR_1:
        cmdTextChar = jj_consume_token(CMD_TEXT_CHAR_1);
        currCmdTextPartSb.append(cmdTextChar.image);
        break;
      case CMD_TEXT_CHAR_2:
        cmdTextChar = jj_consume_token(CMD_TEXT_CHAR_2);
        currCmdTextPartSb.append(cmdTextChar.image);
        break;
      case CMD_TEXT_DIRECTIVE_NAME:
      case CMD_TEXT_PHNAME_ATTR:
        switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
        case CMD_TEXT_DIRECTIVE_NAME:
          cmdTextSpecialPart = jj_consume_token(CMD_TEXT_DIRECTIVE_NAME);
          break;
        case CMD_TEXT_PHNAME_ATTR:
          cmdTextSpecialPart = jj_consume_token(CMD_TEXT_PHNAME_ATTR);
          break;
        default:
          jj_la1[5] = jj_gen;
          jj_consume_token(-1);
          throw new ParseException();
        }
        // Add the preceding part if nonempty.
        if (currCmdTextPartSb.length() > 0) {
          cmdTextParts.add(currCmdTextPartSb.toString());
          currCmdTextPartSb = new StringBuilder();
        }
        // Add the special part.
        cmdTextParts.add(cmdTextSpecialPart.image);
        break;
      default:
        jj_la1[6] = jj_gen;
        jj_consume_token(-1);
        throw new ParseException();
      }
    }
    // Add the last part if nonempty.
    if (currCmdTextPartSb.length() > 0) {
      cmdTextParts.add(currCmdTextPartSb.toString());
      currCmdTextPartSb = new StringBuilder();
    }

    // Process whitespace.
    // TODO(user): this is the beginning of a code path that should be eliminated.
    // These trimmed command strings are typically passed into Node constructors and then
    // re-passed into the expression parser for further parsing. The trimming and re-parsing
    // makes it hard to reconstruct accurate source location information for expression trees.
    // This file should be the source of truth for all source location information in Soy.
    for (int i = 0, n = cmdTextParts.size(); i < n; i++) {
      String cmdTextPart = cmdTextParts.get(i);
      if (i == 0) {
        cmdTextPart = CharMatcher.WHITESPACE.trimLeadingFrom(cmdTextPart);
      }
      if (i == n - 1) {
        cmdTextPart = CharMatcher.WHITESPACE.trimTrailingFrom(cmdTextPart);
      }
      cmdTextPart = LINE_BOUNDARY_PATTERN.matcher(cmdTextPart).replaceAll(" ");
      cmdTextParts.set(i, cmdTextPart);
    }

    {if (true) return cmdTextParts;}
    throw new Error("Missing return statement in function");
  }

  final private String AnyCmdName() throws ParseException {
  Token cmdName;
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case CMD_NAME_SP:
      cmdName = jj_consume_token(CMD_NAME_SP);
      break;
    case CMD_NAME_NIL:
      cmdName = jj_consume_token(CMD_NAME_NIL);
      break;
    case CMD_NAME_LF:
      cmdName = jj_consume_token(CMD_NAME_LF);
      break;
    case CMD_NAME_CR:
      cmdName = jj_consume_token(CMD_NAME_CR);
      break;
    case CMD_NAME_TAB:
      cmdName = jj_consume_token(CMD_NAME_TAB);
      break;
    case CMD_NAME_LB:
      cmdName = jj_consume_token(CMD_NAME_LB);
      break;
    case CMD_NAME_RB:
      cmdName = jj_consume_token(CMD_NAME_RB);
      break;
    case CMD_NAME_LITERAL:
      cmdName = jj_consume_token(CMD_NAME_LITERAL);
      break;
    case CMD_NAME_END_LITERAL:
      cmdName = jj_consume_token(CMD_NAME_END_LITERAL);
      break;
    case CMD_NAME_MSG:
      cmdName = jj_consume_token(CMD_NAME_MSG);
      break;
    case CMD_NAME_END_MSG:
      cmdName = jj_consume_token(CMD_NAME_END_MSG);
      break;
    case CMD_NAME_PRINT:
      cmdName = jj_consume_token(CMD_NAME_PRINT);
      break;
    case CMD_NAME_XID:
      cmdName = jj_consume_token(CMD_NAME_XID);
      break;
    case CMD_NAME_CSS:
      cmdName = jj_consume_token(CMD_NAME_CSS);
      break;
    case CMD_NAME_LET:
      cmdName = jj_consume_token(CMD_NAME_LET);
      break;
    case CMD_NAME_END_LET:
      cmdName = jj_consume_token(CMD_NAME_END_LET);
      break;
    case CMD_NAME_IF:
      cmdName = jj_consume_token(CMD_NAME_IF);
      break;
    case CMD_NAME_ELSEIF:
      cmdName = jj_consume_token(CMD_NAME_ELSEIF);
      break;
    case CMD_NAME_ELSE:
      cmdName = jj_consume_token(CMD_NAME_ELSE);
      break;
    case CMD_NAME_END_IF:
      cmdName = jj_consume_token(CMD_NAME_END_IF);
      break;
    case CMD_NAME_SWITCH:
      cmdName = jj_consume_token(CMD_NAME_SWITCH);
      break;
    case CMD_NAME_END_SWITCH:
      cmdName = jj_consume_token(CMD_NAME_END_SWITCH);
      break;
    case CMD_NAME_FOREACH:
      cmdName = jj_consume_token(CMD_NAME_FOREACH);
      break;
    case CMD_NAME_IFEMPTY:
      cmdName = jj_consume_token(CMD_NAME_IFEMPTY);
      break;
    case CMD_NAME_END_FOREACH:
      cmdName = jj_consume_token(CMD_NAME_END_FOREACH);
      break;
    case CMD_NAME_FOR:
      cmdName = jj_consume_token(CMD_NAME_FOR);
      break;
    case CMD_NAME_END_FOR:
      cmdName = jj_consume_token(CMD_NAME_END_FOR);
      break;
    case CMD_NAME_ANY_CALL:
      cmdName = jj_consume_token(CMD_NAME_ANY_CALL);
      break;
    case CMD_NAME_END_ANY_CALL:
      cmdName = jj_consume_token(CMD_NAME_END_ANY_CALL);
      break;
    case CMD_NAME_PARAM:
      cmdName = jj_consume_token(CMD_NAME_PARAM);
      break;
    case CMD_NAME_END_PARAM:
      cmdName = jj_consume_token(CMD_NAME_END_PARAM);
      break;
    case CMD_NAME_LOG:
      cmdName = jj_consume_token(CMD_NAME_LOG);
      break;
    case CMD_NAME_END_LOG:
      cmdName = jj_consume_token(CMD_NAME_END_LOG);
      break;
    case CMD_NAME_DEBUGGER:
      cmdName = jj_consume_token(CMD_NAME_DEBUGGER);
      break;
    case CMD_NAME_CASE:
      cmdName = jj_consume_token(CMD_NAME_CASE);
      break;
    case CMD_NAME_DEFAULT:
      cmdName = jj_consume_token(CMD_NAME_DEFAULT);
      break;
    case CMD_NAME_NAMESPACE:
      cmdName = jj_consume_token(CMD_NAME_NAMESPACE);
      break;
    case CMD_NAME_TEMPLATE:
      cmdName = jj_consume_token(CMD_NAME_TEMPLATE);
      break;
    case CMD_NAME_END_TEMPLATE:
      cmdName = jj_consume_token(CMD_NAME_END_TEMPLATE);
      break;
    default:
      jj_la1[7] = jj_gen;
      jj_consume_token(-1);
      throw new ParseException();
    }
    {if (true) return cmdName.image;}
    throw new Error("Missing return statement in function");
  }

  final private SourceItemInfo<String> ConsecWsNoNl() throws ParseException {
  Token token;
  Token first = null;
  Token last = null;
    StringBuilder sb = new StringBuilder();
    label_2:
    while (true) {
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case TOKEN_WS_NOT_NL:
        token = jj_consume_token(TOKEN_WS_NOT_NL);
        sb.append(token.image);
        break;
      case BLOCK_NONDOC_COMMENT:
        // Skip block nondoc comments (but not block doc comments).
              token = jj_consume_token(BLOCK_NONDOC_COMMENT);
        break;
      default:
        jj_la1[8] = jj_gen;
        jj_consume_token(-1);
        throw new ParseException();
      }
      if (first == null) {
        first = token;
      }
      last = token;
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case BLOCK_NONDOC_COMMENT:
      case TOKEN_WS_NOT_NL:
        ;
        break;
      default:
        jj_la1[9] = jj_gen;
        break label_2;
      }
    }
    {if (true) return newSourceItemInfo(
      sb.toString(), first.beginLine, first.beginColumn, last.endLine, last.endColumn);}
    throw new Error("Missing return statement in function");
  }

  final private SourceItemInfo<String> ConsecWsWithNl() throws ParseException {
  SourceItemInfo<String> consecWsNoNl;
  SourceItemInfo<String> first = null;
  SourceItemInfo<String> last = null;
  Token token;
    StringBuilder sb = new StringBuilder();
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case BLOCK_NONDOC_COMMENT:
    case TOKEN_WS_NOT_NL:
      consecWsNoNl = ConsecWsNoNl();
      sb.append(consecWsNoNl.parsedContent());
      first = consecWsNoNl;
      break;
    default:
      jj_la1[10] = jj_gen;
      ;
    }
    token = jj_consume_token(TOKEN_NL);
    sb.append(token.image);
    if (first == null) {
      first = newSourceItemInfo(token.image, token);
    }
    last = newSourceItemInfo(token.image, token);
    label_3:
    while (true) {
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case BLOCK_NONDOC_COMMENT:
      case TOKEN_NL:
      case TOKEN_WS_NOT_NL:
        ;
        break;
      default:
        jj_la1[11] = jj_gen;
        break label_3;
      }
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case TOKEN_NL:
        token = jj_consume_token(TOKEN_NL);
      sb.append(token.image);
      last = newSourceItemInfo(token.image, token);
        break;
      case BLOCK_NONDOC_COMMENT:
      case TOKEN_WS_NOT_NL:
        consecWsNoNl = ConsecWsNoNl();
      sb.append(consecWsNoNl.parsedContent());
      last = consecWsNoNl;
        break;
      default:
        jj_la1[12] = jj_gen;
        jj_consume_token(-1);
        throw new ParseException();
      }
    }
    {if (true) return newSourceItemInfo(sb.toString(), first, last);}
    throw new Error("Missing return statement in function");
  }

  final private void ConsecWsWithNlLookaheadHelper() throws ParseException {
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case BLOCK_NONDOC_COMMENT:
    case TOKEN_WS_NOT_NL:
      ConsecWsNoNl();
      break;
    default:
      jj_la1[13] = jj_gen;
      ;
    }
    jj_consume_token(TOKEN_NL);
  }

  final private SourceItemInfo<String> ConsecWs() throws ParseException {
  SourceItemInfo<String> consecWs;
    if (jj_2_1(2147483647)) {
      consecWs = ConsecWsWithNl();
    } else {
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case BLOCK_NONDOC_COMMENT:
      case TOKEN_WS_NOT_NL:
        consecWs = ConsecWsNoNl();
        break;
      default:
        jj_la1[14] = jj_gen;
        jj_consume_token(-1);
        throw new ParseException();
      }
    }
    {if (true) return consecWs;}
    throw new Error("Missing return statement in function");
  }

  final private Token BlockCommentToken() throws ParseException {
  Token token;
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case BLOCK_DOC_COMMENT:
      token = jj_consume_token(BLOCK_DOC_COMMENT);
      break;
    case BLOCK_NONDOC_COMMENT:
      token = jj_consume_token(BLOCK_NONDOC_COMMENT);
      break;
    default:
      jj_la1[15] = jj_gen;
      jj_consume_token(-1);
      throw new ParseException();
    }
    {if (true) return token;}
    throw new Error("Missing return statement in function");
  }

  final private SourceItemInfo<String> WsBasicRawTextNoNl() throws ParseException {
  Token token;
  Token first = null;
  Token last = null;
    StringBuilder sb = new StringBuilder();
    label_4:
    while (true) {
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case TOKEN_WS_NOT_NL:
        token = jj_consume_token(TOKEN_WS_NOT_NL);
        sb.append(token.image);
        break;
      case BLOCK_DOC_COMMENT:
      case BLOCK_NONDOC_COMMENT:
        // Skip block comments (doc and nondoc).
              token = BlockCommentToken();
        break;
      default:
        jj_la1[16] = jj_gen;
        jj_consume_token(-1);
        throw new ParseException();
      }
      if (first == null) {
        first = token;
      }
      last = token;
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case BLOCK_DOC_COMMENT:
      case BLOCK_NONDOC_COMMENT:
      case TOKEN_WS_NOT_NL:
        ;
        break;
      default:
        jj_la1[17] = jj_gen;
        break label_4;
      }
    }
    {if (true) return newSourceItemInfo(
      sb.toString(), first.beginLine, first.beginColumn, last.endLine, last.endColumn);}
    throw new Error("Missing return statement in function");
  }

  final private Token BasicRawTextToken() throws ParseException {
  Token token;
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case TOKEN_NL:
      token = jj_consume_token(TOKEN_NL);
      break;
    case TOKEN_WS_NOT_NL:
      token = jj_consume_token(TOKEN_WS_NOT_NL);
      break;
    case TOKEN_NOT_WS:
      token = jj_consume_token(TOKEN_NOT_WS);
      break;
    default:
      jj_la1[18] = jj_gen;
      jj_consume_token(-1);
      throw new ParseException();
    }
    {if (true) return token;}
    throw new Error("Missing return statement in function");
  }

  final private SourceItemInfo<String> BasicRawText() throws ParseException {
  Token token;
    StringBuilder basicRawTextSb = new StringBuilder();
    int lineNum = -1;
    int columnNum = -1;
    label_5:
    while (true) {
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case TOKEN_NL:
      case TOKEN_WS_NOT_NL:
      case TOKEN_NOT_WS:
        token = BasicRawTextToken();
        basicRawTextSb.append(token.image);
        break;
      case BLOCK_DOC_COMMENT:
      case BLOCK_NONDOC_COMMENT:
        // Skip block comments (doc and nondoc).
              token = BlockCommentToken();
        break;
      default:
        jj_la1[19] = jj_gen;
        jj_consume_token(-1);
        throw new ParseException();
      }
      if (lineNum == -1) {
        lineNum = token.beginLine;
        columnNum = token.beginColumn;
      }
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case BLOCK_DOC_COMMENT:
      case BLOCK_NONDOC_COMMENT:
      case TOKEN_NL:
      case TOKEN_WS_NOT_NL:
      case TOKEN_NOT_WS:
        ;
        break;
      default:
        jj_la1[20] = jj_gen;
        break label_5;
      }
    }
    String basicRawText = basicRawTextSb.toString();

    // Handle line boundaries after Soy tags (includes stripping end-of-template space since input
    // ends with a newline).
    basicRawText = START_EDGE_LINE_BOUNDARY_PATTERN.matcher(basicRawText).replaceFirst("");

    // Adjust line by counting forward for each newline removed.
    // So far, we have only removed content from the beginning of the string.
    int numSpaceCharsRemovedFromFront = basicRawTextSb.length() - basicRawText.length();
    for (int i = 0; i < numSpaceCharsRemovedFromFront; ++i) {
      char ch = basicRawTextSb.charAt(i);
       if (ch == '\u005cr') {
        if (i + 1 == numSpaceCharsRemovedFromFront || basicRawTextSb.charAt(i + 1) != '\u005cn') {
          ++lineNum;  // Only count this CR if it is not part of a CRLF.
          columnNum = 1;
        }
      } else if (ch == '\u005cn') {
        ++lineNum;
        columnNum = 1;
      }
    }

    // Handle line boundaries before Soy tags (includes stripping end-of-template space since input
    // ends with a newline).
    basicRawText = END_EDGE_LINE_BOUNDARY_PATTERN.matcher(basicRawText).replaceFirst("");

    // Handle line boundaries in the middle of the raw text. Note we have to check the characters
    // before and after because the line boundaries may be adjacent to HTML tags.
    Matcher matcher = NONEDGE_LINE_BOUNDARY_PATTERN.matcher(basicRawText);
    StringBuffer basicRawTextWithoutNewlinesSb = new StringBuffer(basicRawText.length());
    while (matcher.find()) {
      char charBefore = basicRawText.charAt(matcher.start() - 1);
      char charAfter = basicRawText.charAt(matcher.end());
      matcher.appendReplacement(
          basicRawTextWithoutNewlinesSb, (charBefore == '>' || charAfter == '<') ? "" : " ");
    }
    matcher.appendTail(basicRawTextWithoutNewlinesSb);

    {if (true) return newSourceItemInfo(
      basicRawTextWithoutNewlinesSb.toString(),
      lineNum,
      columnNum,
      lineNum, // TODO(brndn): compute lineNumEnd correctly
      columnNum // TODO(brndn): compute columnNumEnd correctly
    );}
    throw new Error("Missing return statement in function");
  }

/**
 * Matches empty string or BasicRawText, and if the latter, then ensures it's all whitespace.
 * Used for areas that should not have any content (e.g. between 'call' and 'param' tags).
 *
 * MaybeWhitespace -> [ BasicRawText ]
 *
 * Package visible for testing.
 */
  final public void MaybeWhitespace(String errorMessage) throws ParseException {
  SourceItemInfo<String> basicRawText;
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case BLOCK_DOC_COMMENT:
    case BLOCK_NONDOC_COMMENT:
    case TOKEN_NL:
    case TOKEN_WS_NOT_NL:
    case TOKEN_NOT_WS:
      basicRawText = BasicRawText();
      if (basicRawText.parsedContent().trim().length() != 0) {
        {if (true) throw new ParseException(
            errorMessage + " Found at: " + basicRawText.srcLocation());}
      }
      break;
    default:
      jj_la1[21] = jj_gen;
      ;
    }
  }

  final private SourceItemInfo<String> LiteralRawText() throws ParseException {
  SourceItemInfo<Void> tagOpen, tagClose;
  Token literalRawTextContent;
    tagOpen = SoyTagOpen();
    jj_consume_token(CMD_NAME_LITERAL);
    tagClose = RegSoyTagClose();
    literalRawTextContent = jj_consume_token(LITERAL_RAW_TEXT_CONTENT);
    {if (true) return newSourceItemInfo(literalRawTextContent.image, tagOpen, tagClose);}
    throw new Error("Missing return statement in function");
  }

  final private SourceItemInfo<String> SpecialCharRawText() throws ParseException {
  Token specialCharCmdName;
  SourceItemInfo<Void> tagOpen, tagClose;
    tagOpen = SoyTagOpen();
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case CMD_NAME_SP:
      specialCharCmdName = jj_consume_token(CMD_NAME_SP);
      break;
    case CMD_NAME_NIL:
      specialCharCmdName = jj_consume_token(CMD_NAME_NIL);
      break;
    case CMD_NAME_LF:
      specialCharCmdName = jj_consume_token(CMD_NAME_LF);
      break;
    case CMD_NAME_CR:
      specialCharCmdName = jj_consume_token(CMD_NAME_CR);
      break;
    case CMD_NAME_TAB:
      specialCharCmdName = jj_consume_token(CMD_NAME_TAB);
      break;
    case CMD_NAME_LB:
      specialCharCmdName = jj_consume_token(CMD_NAME_LB);
      break;
    case CMD_NAME_RB:
      specialCharCmdName = jj_consume_token(CMD_NAME_RB);
      break;
    default:
      jj_la1[22] = jj_gen;
      jj_consume_token(-1);
      throw new ParseException();
    }
    tagClose = RegSoyTagClose();
    {if (true) return newSourceItemInfo(
        SPECIAL_CHAR_CMD_NAME_TO_RAW_TEXT.get(specialCharCmdName.image), tagOpen, tagClose);}
    throw new Error("Missing return statement in function");
  }

  final private SourceItemInfo<String> ContiguousRawText() throws ParseException {
  SourceItemInfo<String> basicRawText, literalRawText, specialCharRawText;
    StringBuilder sb = new StringBuilder();
    SourceItemInfo<String> first = null;
    SourceItemInfo<String> last = null;
    label_6:
    while (true) {
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case BLOCK_DOC_COMMENT:
      case BLOCK_NONDOC_COMMENT:
      case TOKEN_NL:
      case TOKEN_WS_NOT_NL:
      case TOKEN_NOT_WS:
        basicRawText = BasicRawText();
        if (first == null) {
          first = basicRawText;
        }
        last = basicRawText;
        sb.append(basicRawText.parsedContent());
        break;
      default:
        jj_la1[23] = jj_gen;
        if (jj_2_2(2147483647)) {
          literalRawText = LiteralRawText();
        if (first == null) {
          first = literalRawText;
        }
        last = literalRawText;
        sb.append(literalRawText.parsedContent());
        } else {
          switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
          case SOY_TAG_OPEN_1:
          case SOY_TAG_OPEN_2:
            specialCharRawText = SpecialCharRawText();
        if (first == null) {
          first = specialCharRawText;
        }
        last = specialCharRawText;
        sb.append(specialCharRawText.parsedContent());
            break;
          default:
            jj_la1[24] = jj_gen;
            jj_consume_token(-1);
            throw new ParseException();
          }
        }
      }
      if (jj_2_3(2147483647)) {
        ;
      } else {
        break label_6;
      }
    }
    {if (true) return newSourceItemInfo(sb.toString(), first, last);}
    throw new Error("Missing return statement in function");
  }

  final private void ContiguousRawTextLookaheadHelper() throws ParseException {
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case TOKEN_NL:
    case TOKEN_WS_NOT_NL:
    case TOKEN_NOT_WS:
      BasicRawTextToken();
      break;
    case BLOCK_DOC_COMMENT:
    case BLOCK_NONDOC_COMMENT:
      BlockCommentToken();
      break;
    default:
      jj_la1[25] = jj_gen;
      if (jj_2_4(2147483647)) {
        SoyTagOpen();
        jj_consume_token(CMD_NAME_LITERAL);
        RegSoyTagClose();
      } else {
        switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
        case SOY_TAG_OPEN_1:
        case SOY_TAG_OPEN_2:
          SpecialCharRawText();
          break;
        default:
          jj_la1[26] = jj_gen;
          jj_consume_token(-1);
          throw new ParseException();
        }
      }
    }
  }

  final private SourceItemInfo<String> MsgTag() throws ParseException {
  SourceItemInfo<Void> tagOpen, tagClose;
  String cmdText;
    tagOpen = SoyTagOpen();
    jj_consume_token(CMD_NAME_MSG);
    jj_consume_token(WS_AFTER_CMD_NAME);
    cmdText = CmdText();
    tagClose = RegSoyTagClose();
    {if (true) return newSourceItemInfo(cmdText, tagOpen, tagClose);}
    throw new Error("Missing return statement in function");
  }

  final private SourceItemInfo<String> FallbackmsgTag() throws ParseException {
  SourceItemInfo<Void> tagOpen, tagClose;
  String cmdText;
    tagOpen = SoyTagOpen();
    jj_consume_token(CMD_NAME_FALLBACKMSG);
    jj_consume_token(WS_AFTER_CMD_NAME);
    cmdText = CmdText();
    tagClose = RegSoyTagClose();
    {if (true) return newSourceItemInfo(cmdText, tagOpen, tagClose);}
    throw new Error("Missing return statement in function");
  }

  final private void EndMsgTag() throws ParseException {
    SoyTagOpen();
    jj_consume_token(CMD_NAME_END_MSG);
    RegSoyTagClose();
  }

  final private SourceItemInfo<String> PluralTag() throws ParseException {
  SourceItemInfo<Void> tagOpen, tagClose;
  String cmdText;
    tagOpen = SoyTagOpen();
    jj_consume_token(CMD_NAME_PLURAL);
    jj_consume_token(WS_AFTER_CMD_NAME);
    cmdText = CmdText();
    tagClose = RegSoyTagClose();
    {if (true) return newSourceItemInfo(cmdText, tagOpen, tagClose);}
    throw new Error("Missing return statement in function");
  }

  final private void EndPluralTag() throws ParseException {
    SoyTagOpen();
    jj_consume_token(CMD_NAME_END_PLURAL);
    RegSoyTagClose();
  }

  final private SourceItemInfo<String> SelectTag() throws ParseException {
  SourceItemInfo<Void> tagOpen, tagClose;
  String cmdText;
    tagOpen = SoyTagOpen();
    jj_consume_token(CMD_NAME_SELECT);
    jj_consume_token(WS_AFTER_CMD_NAME);
    cmdText = CmdText();
    tagClose = RegSoyTagClose();
    {if (true) return newSourceItemInfo(cmdText, tagOpen, tagClose);}
    throw new Error("Missing return statement in function");
  }

  final private void EndSelectTag() throws ParseException {
    SoyTagOpen();
    jj_consume_token(CMD_NAME_END_SELECT);
    RegSoyTagClose();
  }

  final private SourceItemInfo<List<String>> PrintTag() throws ParseException {
  SourceItemInfo<Void> tagOpen, tagClose;
  List<String> cmdTextParts;
    List<String> printTagParts = Lists.newArrayList();
    tagOpen = SoyTagOpen();
    if (jj_2_5(2147483647)) {
      jj_consume_token(CMD_NAME_PRINT);
      jj_consume_token(WS_AFTER_CMD_NAME);
      printTagParts.add("print");
    } else {
      ;
    }
    cmdTextParts = CmdTextParts();
    printTagParts.addAll(cmdTextParts);
    tagClose = RegSoyTagClose();
    {if (true) return newSourceItemInfo(printTagParts, tagOpen, tagClose);}
    throw new Error("Missing return statement in function");
  }

  final private SourceItemInfo<String> XidTag() throws ParseException {
  SourceItemInfo<Void> tagOpen, tagClose;
  String cmdText;
    tagOpen = SoyTagOpen();
    jj_consume_token(CMD_NAME_XID);
    jj_consume_token(WS_AFTER_CMD_NAME);
    cmdText = CmdText();
    tagClose = RegSoyTagClose();
    {if (true) return newSourceItemInfo(cmdText, tagOpen, tagClose);}
    throw new Error("Missing return statement in function");
  }

  final private SourceItemInfo<String> CssTag() throws ParseException {
  SourceItemInfo<Void> tagOpen, tagClose;
  String cmdText;
    tagOpen = SoyTagOpen();
    jj_consume_token(CMD_NAME_CSS);
    jj_consume_token(WS_AFTER_CMD_NAME);
    cmdText = CmdText();
    tagClose = RegSoyTagClose();
    {if (true) return newSourceItemInfo(cmdText, tagOpen, tagClose);}
    throw new Error("Missing return statement in function");
  }

  final private SourceItemInfo<String> LetTagSelfEnding() throws ParseException {
  SourceItemInfo<Void> tagOpen, tagClose;
  String cmdText;
    tagOpen = SoyTagOpen();
    jj_consume_token(CMD_NAME_LET);
    jj_consume_token(WS_AFTER_CMD_NAME);
    cmdText = CmdText();
    tagClose = SelfEndingSoyTagClose();
    {if (true) return newSourceItemInfo(cmdText, tagOpen, tagClose);}
    throw new Error("Missing return statement in function");
  }

  final private SourceItemInfo<String> LetTagNotSelfEnding() throws ParseException {
  SourceItemInfo<Void> tagOpen, tagClose;
  String cmdText;
    tagOpen = SoyTagOpen();
    jj_consume_token(CMD_NAME_LET);
    jj_consume_token(WS_AFTER_CMD_NAME);
    cmdText = CmdText();
    tagClose = RegSoyTagClose();
    {if (true) return newSourceItemInfo(cmdText, tagOpen, tagClose);}
    throw new Error("Missing return statement in function");
  }

  final private void EndLetTag() throws ParseException {
    SoyTagOpen();
    jj_consume_token(CMD_NAME_END_LET);
    RegSoyTagClose();
  }

  final private SourceItemInfo<String> IfTag() throws ParseException {
  SourceItemInfo<Void> tagOpen, tagClose;
  String cmdText;
    tagOpen = SoyTagOpen();
    jj_consume_token(CMD_NAME_IF);
    jj_consume_token(WS_AFTER_CMD_NAME);
    cmdText = CmdText();
    tagClose = RegSoyTagClose();
    {if (true) return newSourceItemInfo(cmdText, tagOpen, tagClose);}
    throw new Error("Missing return statement in function");
  }

  final private SourceItemInfo<String> ElseifTag() throws ParseException {
  SourceItemInfo<Void> tagOpen, tagClose;
  String cmdText;
    tagOpen = SoyTagOpen();
    jj_consume_token(CMD_NAME_ELSEIF);
    jj_consume_token(WS_AFTER_CMD_NAME);
    cmdText = CmdText();
    tagClose = RegSoyTagClose();
    {if (true) return newSourceItemInfo(cmdText, tagOpen, tagClose);}
    throw new Error("Missing return statement in function");
  }

  final private SourceItemInfo<Void> ElseTag() throws ParseException {
  SourceItemInfo<Void> tagOpen;
    tagOpen = SoyTagOpen();
    jj_consume_token(CMD_NAME_ELSE);
    RegSoyTagClose();
    {if (true) return tagOpen;}
    throw new Error("Missing return statement in function");
  }

  final private void EndIfTag() throws ParseException {
    SoyTagOpen();
    jj_consume_token(CMD_NAME_END_IF);
    RegSoyTagClose();
  }

  final private SourceItemInfo<String> SwitchTag() throws ParseException {
  SourceItemInfo<Void> tagOpen, tagClose;
  String cmdText;
    tagOpen = SoyTagOpen();
    jj_consume_token(CMD_NAME_SWITCH);
    jj_consume_token(WS_AFTER_CMD_NAME);
    cmdText = CmdText();
    tagClose = RegSoyTagClose();
    {if (true) return newSourceItemInfo(cmdText, tagOpen, tagClose);}
    throw new Error("Missing return statement in function");
  }

  final private void EndSwitchTag() throws ParseException {
    SoyTagOpen();
    jj_consume_token(CMD_NAME_END_SWITCH);
    RegSoyTagClose();
  }

  final private SourceItemInfo<String> ForeachTag() throws ParseException {
  SourceItemInfo<Void> tagOpen, tagClose;
  String cmdText;
    tagOpen = SoyTagOpen();
    jj_consume_token(CMD_NAME_FOREACH);
    jj_consume_token(WS_AFTER_CMD_NAME);
    cmdText = CmdText();
    tagClose = RegSoyTagClose();
    {if (true) return newSourceItemInfo(cmdText, tagOpen, tagClose);}
    throw new Error("Missing return statement in function");
  }

  final private SourceItemInfo<Void> IfemptyTag() throws ParseException {
  SourceItemInfo<Void> tagOpen;
    tagOpen = SoyTagOpen();
    jj_consume_token(CMD_NAME_IFEMPTY);
    RegSoyTagClose();
    {if (true) return tagOpen;}
    throw new Error("Missing return statement in function");
  }

  final private void EndForeachTag() throws ParseException {
    SoyTagOpen();
    jj_consume_token(CMD_NAME_END_FOREACH);
    RegSoyTagClose();
  }

  final private SourceItemInfo<String> ForTag() throws ParseException {
  SourceItemInfo<Void> tagOpen, tagClose;
  String cmdText;
    tagOpen = SoyTagOpen();
    jj_consume_token(CMD_NAME_FOR);
    jj_consume_token(WS_AFTER_CMD_NAME);
    cmdText = CmdText();
    tagClose = RegSoyTagClose();
    {if (true) return newSourceItemInfo(cmdText, tagOpen, tagClose);}
    throw new Error("Missing return statement in function");
  }

  final private void EndForTag() throws ParseException {
    SoyTagOpen();
    jj_consume_token(CMD_NAME_END_FOR);
    RegSoyTagClose();
  }

  final private SourceItemInfo<List<String>> AnyCallTagSelfEnding() throws ParseException {
  SourceItemInfo<Void> tagOpen, tagClose;
  Token cmdName;
  List<String> cmdTextParts;
    List<String> callTagParts = Lists.newArrayList();
    tagOpen = SoyTagOpen();
    cmdName = jj_consume_token(CMD_NAME_ANY_CALL);
    callTagParts.add(cmdName.image);
    jj_consume_token(WS_AFTER_CMD_NAME);
    cmdTextParts = CmdTextParts();
    callTagParts.addAll(cmdTextParts);
    tagClose = SelfEndingSoyTagClose();
    {if (true) return newSourceItemInfo(callTagParts, tagOpen, tagClose);}
    throw new Error("Missing return statement in function");
  }

  final private SourceItemInfo<List<String>> AnyCallTagNotSelfEnding() throws ParseException {
  SourceItemInfo<Void> tagOpen, tagClose;
  Token cmdName;
  List<String> cmdTextParts;
    List<String> callTagParts = Lists.newArrayList();
    tagOpen = SoyTagOpen();
    cmdName = jj_consume_token(CMD_NAME_ANY_CALL);
    callTagParts.add(cmdName.image);
    jj_consume_token(WS_AFTER_CMD_NAME);
    cmdTextParts = CmdTextParts();
    callTagParts.addAll(cmdTextParts);
    tagClose = RegSoyTagClose();
    {if (true) return newSourceItemInfo(callTagParts, tagOpen, tagClose);}
    throw new Error("Missing return statement in function");
  }

  final private boolean EndAnyCallTag() throws ParseException {
  Token cmdName;
    SoyTagOpen();
    cmdName = jj_consume_token(CMD_NAME_END_ANY_CALL);
    RegSoyTagClose();
    {if (true) return cmdName.image.equals("/call");}
    throw new Error("Missing return statement in function");
  }

  final private SourceItemInfo<String> ParamTagSelfEnding() throws ParseException {
  SourceItemInfo<Void> tagOpen, tagClose;
  String cmdText;
    tagOpen = SoyTagOpen();
    jj_consume_token(CMD_NAME_PARAM);
    jj_consume_token(WS_AFTER_CMD_NAME);
    cmdText = CmdText();
    tagClose = SelfEndingSoyTagClose();
    {if (true) return newSourceItemInfo(cmdText, tagOpen, tagClose);}
    throw new Error("Missing return statement in function");
  }

  final private SourceItemInfo<String> ParamTagNotSelfEnding() throws ParseException {
  SourceItemInfo<Void> tagOpen, tagClose;
  String cmdText;
    tagOpen = SoyTagOpen();
    jj_consume_token(CMD_NAME_PARAM);
    jj_consume_token(WS_AFTER_CMD_NAME);
    cmdText = CmdText();
    tagClose = RegSoyTagClose();
    {if (true) return newSourceItemInfo(cmdText, tagOpen, tagClose);}
    throw new Error("Missing return statement in function");
  }

  final private void EndParamTag() throws ParseException {
    SoyTagOpen();
    jj_consume_token(CMD_NAME_END_PARAM);
    RegSoyTagClose();
  }

  final private SourceItemInfo<Void> LogTag() throws ParseException {
  SourceItemInfo<Void> tagOpen;
    tagOpen = SoyTagOpen();
    jj_consume_token(CMD_NAME_LOG);
    RegSoyTagClose();
    {if (true) return tagOpen;}
    throw new Error("Missing return statement in function");
  }

  final private void EndLogTag() throws ParseException {
    SoyTagOpen();
    jj_consume_token(CMD_NAME_END_LOG);
    RegSoyTagClose();
  }

  final private SourceItemInfo<Void> DebuggerTag() throws ParseException {
  SourceItemInfo<Void> tagOpen;
    tagOpen = SoyTagOpen();
    jj_consume_token(CMD_NAME_DEBUGGER);
    RegSoyTagClose();
    {if (true) return tagOpen;}
    throw new Error("Missing return statement in function");
  }

  final private SourceItemInfo<String> CaseTag() throws ParseException {
  SourceItemInfo<Void> tagOpen, tagClose;
  String cmdText;
    tagOpen = SoyTagOpen();
    jj_consume_token(CMD_NAME_CASE);
    jj_consume_token(WS_AFTER_CMD_NAME);
    cmdText = CmdText();
    tagClose = RegSoyTagClose();
    {if (true) return newSourceItemInfo(cmdText, tagOpen, tagClose);}
    throw new Error("Missing return statement in function");
  }

  final private SourceItemInfo<Void> DefaultTag() throws ParseException {
  SourceItemInfo<Void> tagOpen;
    tagOpen = SoyTagOpen();
    jj_consume_token(CMD_NAME_DEFAULT);
    RegSoyTagClose();
    {if (true) return tagOpen;}
    throw new Error("Missing return statement in function");
  }

  final private TemplateParseResult TemplateContentInput() throws ParseException {
  List<DeclInfo> headerDecls;
  List<StandaloneNode> bodyNodes;
    if (jj_2_6(2147483647)) {
      headerDecls = TemplateHeader();
    } else {
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case BLOCK_DOC_COMMENT:
      case BLOCK_NONDOC_COMMENT:
      case TOKEN_WS_NOT_NL:
        WsBasicRawTextNoNl();
        break;
      default:
        jj_la1[27] = jj_gen;
        ;
      }
      headerDecls = null;
    }
    bodyNodes = TemplateBlock();
    jj_consume_token(0);
    // Note: We're using an undocumented API to check the token manager's state. If this ever
    // breaks due to changes in JavaCC (extremely unlikely since many users around the world are
    // depending on it), then we'll have to use a different method to detect whether we're within
    // a comment block.
    if (token_source.curLexState == IN_BLOCK_DOC_COMMENT ||
        token_source.curLexState == IN_BLOCK_NONDOC_COMMENT) {
      {if (true) throw new ParseException("At end of template, found comment block that is never closed.");}
    }
    {if (true) return new TemplateParseResult(headerDecls, bodyNodes);}
    throw new Error("Missing return statement in function");
  }

  final private List<DeclInfo> TemplateHeader() throws ParseException {
  DeclInfo declInfo;
    List<DeclInfo> declInfos = Lists.newArrayList();
    label_7:
    while (true) {
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case BLOCK_NONDOC_COMMENT:
      case TOKEN_NL:
      case TOKEN_WS_NOT_NL:
        ConsecWs();
        break;
      default:
        jj_la1[28] = jj_gen;
        ;
      }
      declInfo = Decl();
      declInfos.add(declInfo);
      if (jj_2_7(2147483647)) {
        ;
      } else {
        break label_7;
      }
    }
    ConsecWsWithNl();
    {if (true) return declInfos;}
    throw new Error("Missing return statement in function");
  }

  final private void TemplateHeaderLookaheadHelper() throws ParseException {
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case BLOCK_NONDOC_COMMENT:
    case TOKEN_NL:
    case TOKEN_WS_NOT_NL:
      ConsecWs();
      break;
    default:
      jj_la1[29] = jj_gen;
      ;
    }
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case BLOCK_DOC_COMMENT:
      jj_consume_token(BLOCK_DOC_COMMENT);
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case BLOCK_NONDOC_COMMENT:
      case TOKEN_NL:
      case TOKEN_WS_NOT_NL:
        ConsecWs();
        break;
      default:
        jj_la1[30] = jj_gen;
        ;
      }
      break;
    default:
      jj_la1[31] = jj_gen;
      ;
    }
    SoyTagOpen();
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case CMD_NAME_PARAM_DECL:
      jj_consume_token(CMD_NAME_PARAM_DECL);
      break;
    case CMD_NAME_INJECTED_PARAM_DECL:
      jj_consume_token(CMD_NAME_INJECTED_PARAM_DECL);
      break;
    default:
      jj_la1[32] = jj_gen;
      jj_consume_token(-1);
      throw new ParseException();
    }
  }

  final private DeclInfo Decl() throws ParseException {
  DeclInfo declInfo;
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case SOY_TAG_OPEN_1:
    case SOY_TAG_OPEN_2:
      declInfo = ParamDecl();
      {if (true) return declInfo;}
      break;
    case BLOCK_DOC_COMMENT:
      declInfo = ParamDeclWithDocPrefix();
      {if (true) return declInfo;}
      break;
    default:
      jj_la1[33] = jj_gen;
      jj_consume_token(-1);
      throw new ParseException();
    }
    throw new Error("Missing return statement in function");
  }

  final private DeclInfo ParamDecl() throws ParseException {
  String cmdText;
  Token blockDocComment;
  String tag;
  boolean optional = false;
  boolean injected = false;
    SoyTagOpen();
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case CMD_NAME_PARAM_DECL:
      jj_consume_token(CMD_NAME_PARAM_DECL);
      tag = "@param";
      break;
    case CMD_NAME_INJECTED_PARAM_DECL:
      jj_consume_token(CMD_NAME_INJECTED_PARAM_DECL);
      tag = "@inject"; injected = true;
      break;
    default:
      jj_la1[34] = jj_gen;
      jj_consume_token(-1);
      throw new ParseException();
    }
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case QMARK:
      jj_consume_token(QMARK);
              optional = true;
      break;
    default:
      jj_la1[35] = jj_gen;
      ;
    }
    jj_consume_token(WS_AFTER_CMD_NAME);
    cmdText = CmdText();
    RegSoyTagClose();
    String desc;
    if (jj_2_8(2147483647)) {
      label_8:
      while (true) {
        switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
        case TOKEN_WS_NOT_NL:
          ;
          break;
        default:
          jj_la1[36] = jj_gen;
          break label_8;
        }
        jj_consume_token(TOKEN_WS_NOT_NL);
      }
      blockDocComment = jj_consume_token(BLOCK_DOC_COMMENT);
      desc = blockDocComment.image;
    } else {
      desc = null;
    }
    {if (true) return new DeclInfo(tag, cmdText, desc, optional);}
    throw new Error("Missing return statement in function");
  }

  final private DeclInfo ParamDeclWithDocPrefix() throws ParseException {
  String cmdText;
  Token blockDocComment;
  String tag;
  boolean optional = false;
  boolean injected = false;
    blockDocComment = jj_consume_token(BLOCK_DOC_COMMENT);
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case BLOCK_NONDOC_COMMENT:
    case TOKEN_NL:
    case TOKEN_WS_NOT_NL:
      ConsecWs();
      break;
    default:
      jj_la1[37] = jj_gen;
      ;
    }
    SoyTagOpen();
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case CMD_NAME_PARAM_DECL:
      jj_consume_token(CMD_NAME_PARAM_DECL);
      tag = "@param";
      break;
    case CMD_NAME_INJECTED_PARAM_DECL:
      jj_consume_token(CMD_NAME_INJECTED_PARAM_DECL);
      tag = "@inject"; injected = true;
      break;
    default:
      jj_la1[38] = jj_gen;
      jj_consume_token(-1);
      throw new ParseException();
    }
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case QMARK:
      jj_consume_token(QMARK);
              optional = true;
      break;
    default:
      jj_la1[39] = jj_gen;
      ;
    }
    jj_consume_token(WS_AFTER_CMD_NAME);
    cmdText = CmdText();
    RegSoyTagClose();
    {if (true) return new DeclInfo(tag, cmdText, blockDocComment.image, optional);}
    throw new Error("Missing return statement in function");
  }

  final private List<StandaloneNode> TemplateBlock() throws ParseException {
  RawTextNode contiguousRawTextAsNode;
  StatementNode stmt;
    List<StandaloneNode> templateBlock = Lists.newArrayList();
    label_9:
    while (true) {
      if (jj_2_9(2147483647)) {
        ;
      } else {
        break label_9;
      }
      if (jj_2_10(2147483647)) {
        contiguousRawTextAsNode = ContiguousRawTextAsNode();
        if (contiguousRawTextAsNode != null) templateBlock.add(contiguousRawTextAsNode);
      } else {
        switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
        case SOY_TAG_OPEN_1:
        case SOY_TAG_OPEN_2:
          stmt = Stmt();
        templateBlock.add(stmt);
          break;
        default:
          jj_la1[40] = jj_gen;
          jj_consume_token(-1);
          throw new ParseException();
        }
      }
    }
    {if (true) return templateBlock;}
    throw new Error("Missing return statement in function");
  }

  final private RawTextNode ContiguousRawTextAsNode() throws ParseException {
  SourceItemInfo<String> contiguousRawText;
    contiguousRawText = ContiguousRawText();
    {if (true) return (contiguousRawText.parsedContent().length() > 0

  ) ?
        setSrcLoc(
            new RawTextNode(nodeIdGen.genId(), contiguousRawText.parsedContent()),
            contiguousRawText) :
        null;}
    throw new Error("Missing return statement in function");
  }

  final private StatementNode Stmt() throws ParseException {
  StatementNode stmt;
    if (jj_2_11(2147483647)) {
      stmt = MsgStmt();
    } else if (jj_2_12(2147483647)) {
      stmt = PrintStmt();
    } else if (jj_2_13(2147483647)) {
      stmt = XidStmt();
    } else if (jj_2_14(2147483647)) {
      stmt = CssStmt();
    } else if (jj_2_15(2147483647)) {
      stmt = LetStmt();
    } else if (jj_2_16(2147483647)) {
      stmt = IfStmt();
    } else if (jj_2_17(2147483647)) {
      stmt = SwitchStmt();
    } else if (jj_2_18(2147483647)) {
      stmt = ForeachStmt();
    } else if (jj_2_19(2147483647)) {
      stmt = ForStmt();
    } else if (jj_2_20(2147483647)) {
      stmt = CallStmt();
    } else if (jj_2_21(2147483647)) {
      stmt = LogStmt();
    } else if (jj_2_22(2147483647)) {
      stmt = DebuggerStmt();
    } else {
      jj_consume_token(-1);
      throw new ParseException();
    }
    {if (true) return stmt;}
    throw new Error("Missing return statement in function");
  }

  final private void StmtLookaheadHelper() throws ParseException {
    if (jj_2_23(2147483647)) {
      PrintStmtLookaheadHelper();
    } else {
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case SOY_TAG_OPEN_1:
      case SOY_TAG_OPEN_2:
        SoyTagOpen();
        switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
        case CMD_NAME_MSG:
          jj_consume_token(CMD_NAME_MSG);
          break;
        case CMD_NAME_XID:
          jj_consume_token(CMD_NAME_XID);
          break;
        case CMD_NAME_CSS:
          jj_consume_token(CMD_NAME_CSS);
          break;
        case CMD_NAME_LET:
          jj_consume_token(CMD_NAME_LET);
          break;
        case CMD_NAME_IF:
          jj_consume_token(CMD_NAME_IF);
          break;
        case CMD_NAME_SWITCH:
          jj_consume_token(CMD_NAME_SWITCH);
          break;
        case CMD_NAME_FOREACH:
          jj_consume_token(CMD_NAME_FOREACH);
          break;
        case CMD_NAME_FOR:
          jj_consume_token(CMD_NAME_FOR);
          break;
        case CMD_NAME_ANY_CALL:
          jj_consume_token(CMD_NAME_ANY_CALL);
          break;
        case CMD_NAME_LOG:
          jj_consume_token(CMD_NAME_LOG);
          break;
        case CMD_NAME_DEBUGGER:
          jj_consume_token(CMD_NAME_DEBUGGER);
          break;
        default:
          jj_la1[41] = jj_gen;
          jj_consume_token(-1);
          throw new ParseException();
        }
        switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
        case WS_AFTER_CMD_NAME:
          jj_consume_token(WS_AFTER_CMD_NAME);
          break;
        case REG_SOY_TAG_CLOSE_AFTER_CMD_NAME_1:
        case REG_SOY_TAG_CLOSE_AFTER_CMD_NAME_2:
        case REG_SOY_TAG_CLOSE_AFTER_CMD_TEXT_1:
        case REG_SOY_TAG_CLOSE_AFTER_CMD_TEXT_2:
          RegSoyTagClose();
          break;
        default:
          jj_la1[42] = jj_gen;
          jj_consume_token(-1);
          throw new ParseException();
        }
        break;
      default:
        jj_la1[43] = jj_gen;
        jj_consume_token(-1);
        throw new ParseException();
      }
    }
  }

  final private MsgFallbackGroupNode MsgStmt() throws ParseException {
  SourceItemInfo<String> cmdText;
  List<StandaloneNode> templateBlockForMsg;
    MsgNode msgNode;
    cmdText = MsgTag();
    MsgFallbackGroupNode msgFbGrpNode = setSrcLoc(
        new MsgFallbackGroupNode(nodeIdGen.genId()), cmdText);
    msgNode = MsgNode.msg(nodeIdGen.genId(), cmdText.parsedContent(), cmdText.srcLocation())
        .build(errorReporter);
    msgFbGrpNode.addChild(msgNode);
    templateBlockForMsg = TemplateBlockForMsg();
    msgNode.addChildren(templateBlockForMsg);
    label_10:
    while (true) {
      if (jj_2_24(2147483647)) {
        ;
      } else {
        break label_10;
      }
      cmdText = FallbackmsgTag();
      msgNode = MsgNode.fallbackmsg(
          nodeIdGen.genId(), cmdText.parsedContent(), cmdText.srcLocation())
          .build(errorReporter);
      msgFbGrpNode.addChild(msgNode);
      templateBlockForMsg = TemplateBlockForMsg();
      msgNode.addChildren(templateBlockForMsg);
    }
    EndMsgTag();
    // Currently, allow at most one 'fallbackmsg'.
    if (msgFbGrpNode.numChildren() > 2) {
      errorReporter.report(cmdText.srcLocation(), MULTIPLE_FALLBACK_MSGS);
    }
    {if (true) return msgFbGrpNode;}
    throw new Error("Missing return statement in function");
  }

  final private List<StandaloneNode> TemplateBlockForMsg() throws ParseException {
  RawTextNode contiguousRawTextAsNode;
  StatementNode stmt;
  MsgHtmlTagNode msgHtmlTag;
  MsgPluralNode msgPlural;
  MsgSelectNode msgSelect;
    List<StandaloneNode> templateBlock = Lists.newArrayList();
    if (jj_2_27(2147483647)) {
      MaybeWhitespace("No message content is allowed before a 'plural' block.");
      msgPlural = MsgPlural();
      templateBlock.add(msgPlural);
      MaybeWhitespace("No message content is allowed after a 'plural' block.");
    } else if (jj_2_28(2147483647)) {
      MaybeWhitespace("No message content is allowed before a 'select' block.");
      msgSelect = MsgSelect();
      templateBlock.add(msgSelect);
      MaybeWhitespace("No message content is allowed after a 'select' block.");
    } else {
      label_11:
      while (true) {
        if (jj_2_25(2147483647)) {
          ;
        } else {
          break label_11;
        }
        if (jj_2_26(2147483647)) {
          contiguousRawTextAsNode = ContiguousRawTextAsNode();
          if (contiguousRawTextAsNode != null) templateBlock.add(contiguousRawTextAsNode);
        } else {
          switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
          case SOY_TAG_OPEN_1:
          case SOY_TAG_OPEN_2:
            stmt = Stmt();
          if (! (stmt instanceof MsgPlaceholderInitialNode)) {
            String commandName =
                (stmt instanceof IfNode) ? "if" : ((CommandNode) stmt).getCommandName();
            errorReporter.report(
                stmt.getSourceLocation(), COMMAND_NOT_ALLOWED_WITHIN_MSG_BLOCK, commandName);
          } else {
            templateBlock.add(
                  new MsgPlaceholderNode(nodeIdGen.genId(), (MsgPlaceholderInitialNode) stmt));
          }
            break;
          case MSG_HTML_TAG_OPEN:
            msgHtmlTag = MsgHtmlTag();
          templateBlock.add(new MsgPlaceholderNode(nodeIdGen.genId(), msgHtmlTag));
            break;
          default:
            jj_la1[44] = jj_gen;
            jj_consume_token(-1);
            throw new ParseException();
          }
        }
      }
    }
    {if (true) return templateBlock;}
    throw new Error("Missing return statement in function");
  }

  final private MsgPluralNode MsgPlural() throws ParseException {
  SourceItemInfo<Void> defaultTagInfo;
  SourceItemInfo<String> cmdText;
  List<StandaloneNode> templateBlockForMsg;
    cmdText = PluralTag();
    MsgPluralNode msgPluralNode = new MsgPluralNode.Builder(
        nodeIdGen.genId(), cmdText.parsedContent(), cmdText.srcLocation())
        .build(errorReporter);
    MaybeWhitespace("No content allowed between 'plural' and 'case'" +
          " (whitespace and comments are okay).");
    label_12:
    while (true) {
      if (jj_2_29(2147483647)) {
        ;
      } else {
        break label_12;
      }
      cmdText = CaseTag();
      MsgPluralCaseNode msgPluralCaseNode = new MsgPluralCaseNode.Builder(
          nodeIdGen.genId(), cmdText.parsedContent(), cmdText.srcLocation())
          .build(errorReporter);
      msgPluralNode.addChild(msgPluralCaseNode);
      templateBlockForMsg = TemplateBlockForMsg();
      if (templateBlockForMsg.size() == 1 &&
          (templateBlockForMsg.get(0) instanceof MsgPluralNode ||
           templateBlockForMsg.get(0) instanceof MsgSelectNode )) {
        errorReporter.report(
            templateBlockForMsg.get(0).getSourceLocation(),
            PLURAL_AND_SELECT_NOT_ALLOWED_INSIDE_PLURAL_BLOCK);
      }
      msgPluralCaseNode.addChildren(templateBlockForMsg);
    }
    defaultTagInfo = DefaultTag();
    MsgPluralDefaultNode msgPluralDefaultNode = setSrcLoc(
        new MsgPluralDefaultNode(nodeIdGen.genId()), defaultTagInfo);
    msgPluralNode.addChild(msgPluralDefaultNode);
    templateBlockForMsg = TemplateBlockForMsg();
    if (templateBlockForMsg.size() == 1 &&
        (templateBlockForMsg.get(0) instanceof MsgPluralNode ||
         templateBlockForMsg.get(0) instanceof MsgSelectNode )) {
      errorReporter.report(
          templateBlockForMsg.get(0).getSourceLocation(),
          PLURAL_AND_SELECT_NOT_ALLOWED_INSIDE_PLURAL_BLOCK);
    }
    msgPluralDefaultNode.addChildren(templateBlockForMsg);
    EndPluralTag();
    {if (true) return msgPluralNode;}
    throw new Error("Missing return statement in function");
  }

  final private MsgSelectNode MsgSelect() throws ParseException {
  SourceItemInfo<Void> defaultTagInfo;
  SourceItemInfo<String> cmdText;
  List<StandaloneNode> templateBlockForMsg;
    cmdText = SelectTag();
    MsgSelectNode msgSelectNode = new MsgSelectNode.Builder(
        nodeIdGen.genId(), cmdText.parsedContent(), cmdText.srcLocation()).build(errorReporter);
    MaybeWhitespace("No content allowed between 'select' and 'case'" +
          " (whitespace and comments are okay).");
    label_13:
    while (true) {
      if (jj_2_30(2147483647)) {
        ;
      } else {
        break label_13;
      }
      cmdText = CaseTag();
      MsgSelectCaseNode msgSelectCaseNode = new MsgSelectCaseNode.Builder(
          nodeIdGen.genId(), cmdText.parsedContent(), cmdText.srcLocation())
          .build(errorReporter);
      msgSelectNode.addChild(msgSelectCaseNode);
      templateBlockForMsg = TemplateBlockForMsg();
      msgSelectCaseNode.addChildren(templateBlockForMsg);
    }
    defaultTagInfo = DefaultTag();
    MsgSelectDefaultNode msgSelectDefaultNode = setSrcLoc(
        new MsgSelectDefaultNode(nodeIdGen.genId()), defaultTagInfo);
    msgSelectNode.addChild(msgSelectDefaultNode);
    templateBlockForMsg = TemplateBlockForMsg();
    msgSelectDefaultNode.addChildren(templateBlockForMsg);
    EndSelectTag();
    {if (true) return msgSelectNode;}
    throw new Error("Missing return statement in function");
  }

  final private MsgHtmlTagNode MsgHtmlTag() throws ParseException {
  Token htmlTagOpen;
  List<StandaloneNode> templateBlock;
    htmlTagOpen = jj_consume_token(MSG_HTML_TAG_OPEN);
    templateBlock = TemplateBlock();
    jj_consume_token(MSG_HTML_TAG_CLOSE);
    // First, we add back the HTML tag's opening and closing angle brackets.
    // Minor note: If there's only one RawTextNode, we'll replace it twice. No big deal.
    if (templateBlock.get(0) instanceof RawTextNode) {
      RawTextNode firstNode = (RawTextNode) templateBlock.get(0);
      RawTextNode newNode = new RawTextNode(nodeIdGen.genId(), "<" + firstNode.getRawText());
      templateBlock.set(0, setSrcLoc(newNode, htmlTagOpen));
    } else {
      templateBlock.add(0, setSrcLoc(new RawTextNode(nodeIdGen.genId(), "<"), htmlTagOpen));
    }
    int lastNodeIndex = templateBlock.size() - 1;
    if (templateBlock.get(lastNodeIndex) instanceof RawTextNode) {
      RawTextNode lastNode = (RawTextNode) templateBlock.get(lastNodeIndex);
      RawTextNode newNode = new RawTextNode(nodeIdGen.genId(), lastNode.getRawText() + ">");
      templateBlock.set(lastNodeIndex, setSrcLoc(newNode, htmlTagOpen));
    } else {
      templateBlock.add(setSrcLoc(new RawTextNode(nodeIdGen.genId(), ">"), htmlTagOpen));
    }
    {if (true) return new MsgHtmlTagNode.Builder(
        nodeIdGen.genId(),
        ImmutableList.copyOf(templateBlock),
        createSrcLoc(htmlTagOpen))
        .build(errorReporter);}
    throw new Error("Missing return statement in function");
  }

  final private PrintNode PrintStmt() throws ParseException {
  SourceItemInfo<List<String>> printTagInfo;
    printTagInfo = PrintTag();
    List<String> printTagParts = printTagInfo.parsedContent();

    // ------ Process command name (implicit or explicit). ------
    boolean isImplicit;
    List<String> cmdTextParts;
    if (!printTagParts.isEmpty() && printTagParts.get(0).equals("print")) {
      isImplicit = false;
      cmdTextParts = printTagParts.subList(1, printTagParts.size());
    } else {
      isImplicit = true;
      cmdTextParts = printTagParts;
    }
    String cmdText = Joiner.on("").join(cmdTextParts);

    // ------ Process 'phname' attribute (if any). ------
    String phnameAttr = null;
    for (String cmdTextPart : cmdTextParts) {
      if (cmdTextPart.startsWith(" phname=\u005c"") && cmdTextPart.endsWith("\u005c"")) {
        if (phnameAttr != null) {
          errorReporter.report(
              printTagInfo.srcLocation(), MULTIPLE_PHNAME_ATTRIBUTES_IN_COMMAND, "print", cmdText);
        }
        phnameAttr = cmdTextPart;
      }
    }
    String userSuppliedPhName;
    if (phnameAttr != null) {
      cmdTextParts.remove(phnameAttr);
      userSuppliedPhName = phnameAttr.substring(9, phnameAttr.length() - 1);
    } else {
      userSuppliedPhName = null;
    }

    // ------ Process expression. ------
    // Note: First part is expression, rest of parts are directives or directive args.
    if (cmdTextParts.isEmpty()) {
      errorReporter.report(printTagInfo.srcLocation(), PRINT_COMMAND_WITH_EMPTY_TEXT);
      {if (true) return null;}
    }
    String exprText = cmdTextParts.get(0).trim();
    PrintNode printNode = setSrcLoc(
        new PrintNode(nodeIdGen.genId(), isImplicit, exprText, userSuppliedPhName), printTagInfo);

    // ------ Process directives (if any). ------
    String directiveName = null;
    for (int i = 1, n = cmdTextParts.size(); i < n; i++) {
      String cmdTextPart = cmdTextParts.get(i);

      if (cmdTextPart.startsWith("|")) {
        // Create previous directive and save current directive name.
        if (directiveName != null) {
          printNode.addChild(new PrintDirectiveNode.Builder(
              nodeIdGen.genId(), directiveName, "", printTagInfo.srcLocation())
              .build(errorReporter));
        }
        directiveName = cmdTextPart;

      } else if (cmdTextPart.startsWith(":")) {
        // Create previous directive with current args text.
        if (directiveName == null) {
          {if (true) throw new AssertionError();}
        }
        String argsText = cmdTextPart.substring(1);
        printNode.addChild(new PrintDirectiveNode.Builder(
            nodeIdGen.genId(), directiveName, argsText, printTagInfo.srcLocation())
            .build(errorReporter));
        directiveName = null;

      } else if (cmdTextPart.trim().length() == 0) {
        continue;

      } else {
        errorReporter.report(printNode.getSourceLocation(), INVALID_PRINT_COMMAND_TEXT, cmdText);
      }
    }
    // Add last directive.
    if (directiveName != null) {
      printNode.addChild(new PrintDirectiveNode.Builder(
          nodeIdGen.genId(), directiveName, "", printTagInfo.srcLocation())
          .build(errorReporter));
    }

    {if (true) return printNode;}
    throw new Error("Missing return statement in function");
  }

  final private void PrintStmtLookaheadHelper() throws ParseException {
    SoyTagOpen();
    if (jj_2_31(2147483647)) {
      jj_consume_token(CMD_NAME_PRINT);
      jj_consume_token(WS_AFTER_CMD_NAME);
    } else {
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case CMD_NAME_SP:
      case CMD_NAME_NIL:
      case CMD_NAME_LF:
      case CMD_NAME_CR:
      case CMD_NAME_TAB:
      case CMD_NAME_LB:
      case CMD_NAME_RB:
      case CMD_NAME_LITERAL:
      case CMD_NAME_END_LITERAL:
      case CMD_NAME_MSG:
      case CMD_NAME_END_MSG:
      case CMD_NAME_PRINT:
      case CMD_NAME_XID:
      case CMD_NAME_CSS:
      case CMD_NAME_LET:
      case CMD_NAME_END_LET:
      case CMD_NAME_IF:
      case CMD_NAME_ELSEIF:
      case CMD_NAME_ELSE:
      case CMD_NAME_END_IF:
      case CMD_NAME_SWITCH:
      case CMD_NAME_END_SWITCH:
      case CMD_NAME_FOREACH:
      case CMD_NAME_IFEMPTY:
      case CMD_NAME_END_FOREACH:
      case CMD_NAME_FOR:
      case CMD_NAME_END_FOR:
      case CMD_NAME_ANY_CALL:
      case CMD_NAME_END_ANY_CALL:
      case CMD_NAME_PARAM:
      case CMD_NAME_END_PARAM:
      case CMD_NAME_LOG:
      case CMD_NAME_END_LOG:
      case CMD_NAME_DEBUGGER:
      case CMD_NAME_CASE:
      case CMD_NAME_DEFAULT:
      case CMD_NAME_NAMESPACE:
      case CMD_NAME_TEMPLATE:
      case CMD_NAME_END_TEMPLATE:
        AnyCmdName();
        jj_consume_token(NOT_CMD_NAME_BOUNDARY_AFTER_CMD_NAME);
        break;
      case CMD_TEXT_CHAR_1:
        jj_consume_token(CMD_TEXT_CHAR_1);
        break;
      case CMD_TEXT_CHAR_2:
        jj_consume_token(CMD_TEXT_CHAR_2);
        break;
      default:
        jj_la1[45] = jj_gen;
        jj_consume_token(-1);
        throw new ParseException();
      }
    }
  }

  final private XidNode XidStmt() throws ParseException {
  SourceItemInfo<String> cmdText;
    cmdText = XidTag();
    {if (true) return new XidNode.Builder(nodeIdGen.genId(), cmdText.parsedContent(), cmdText.srcLocation())
        .build(errorReporter);}
    throw new Error("Missing return statement in function");
  }

  final private CssNode CssStmt() throws ParseException {
  SourceItemInfo<String> cmdText;
    cmdText = CssTag();
    {if (true) return new CssNode.Builder(nodeIdGen.genId(), cmdText.parsedContent(), cmdText.srcLocation())
        .build(errorReporter);}
    throw new Error("Missing return statement in function");
  }

  final private LetNode LetStmt() throws ParseException {
  SourceItemInfo<String> cmdText;
  List<StandaloneNode> templateBlock;
    LetNode letNode = null;
    if (jj_2_32(2147483647)) {
      cmdText = LetTagSelfEnding();
      letNode = new LetValueNode.Builder(
          nodeIdGen.genId(), cmdText.parsedContent(), cmdText.srcLocation())
          .build(errorReporter);
    } else if (jj_2_33(2147483647)) {
      cmdText = LetTagNotSelfEnding();
      LetContentNode letContentNode = new LetContentNode.Builder(
            nodeIdGen.genId(), cmdText.parsedContent(), cmdText.srcLocation())
            .build(errorReporter);
      templateBlock = TemplateBlock();
      letContentNode.addChildren(templateBlock);
      letNode = letContentNode;
      EndLetTag();
    } else {
      jj_consume_token(-1);
      throw new ParseException();
    }
    {if (true) return letNode;}
    throw new Error("Missing return statement in function");
  }

  final private IfNode IfStmt() throws ParseException {
  SourceItemInfo<String> cmdText;
  List<StandaloneNode> templateBlock;
  SourceItemInfo<Void> elseTagInfo;
    IfCondNode ifCondNode;
    cmdText = IfTag();
    IfNode ifNode = setSrcLoc(new IfNode(nodeIdGen.genId()), cmdText);
    ifCondNode = setSrcLoc(
        new IfCondNode(nodeIdGen.genId(), "if", cmdText.parsedContent()), cmdText);
    ifNode.addChild(ifCondNode);
    templateBlock = TemplateBlock();
    ifCondNode.addChildren(templateBlock);
    label_14:
    while (true) {
      if (jj_2_34(2147483647)) {
        ;
      } else {
        break label_14;
      }
      cmdText = ElseifTag();
      ifCondNode = setSrcLoc(
          new IfCondNode(nodeIdGen.genId(), "elseif", cmdText.parsedContent()), cmdText);
      ifNode.addChild(ifCondNode);
      templateBlock = TemplateBlock();
      ifCondNode.addChildren(templateBlock);
    }
    if (jj_2_35(2147483647)) {
      elseTagInfo = ElseTag();
      IfElseNode ifElseNode = setSrcLoc(new IfElseNode(nodeIdGen.genId()), elseTagInfo);
      ifNode.addChild(ifElseNode);
      templateBlock = TemplateBlock();
      ifElseNode.addChildren(templateBlock);
    } else {
      ;
    }
    EndIfTag();
    {if (true) return ifNode;}
    throw new Error("Missing return statement in function");
  }

  final private SwitchNode SwitchStmt() throws ParseException {
  SourceItemInfo<String> cmdText;
  SourceItemInfo<Void> defaultTagInfo;
  List<StandaloneNode> templateBlock;
    cmdText = SwitchTag();
    SwitchNode switchNode = new SwitchNode.Builder(
        nodeIdGen.genId(), cmdText.parsedContent(), cmdText.srcLocation())
        .build(errorReporter);
    MaybeWhitespace("No content allowed between 'switch' and 'case'" +
          " (whitespace and comments are okay).");
    label_15:
    while (true) {
      if (jj_2_36(2147483647)) {
        ;
      } else {
        break label_15;
      }
      cmdText = CaseTag();
      SwitchCaseNode switchCaseNode = new SwitchCaseNode.Builder(
          nodeIdGen.genId(), cmdText.parsedContent(), cmdText.srcLocation())
          .build(errorReporter);
      switchNode.addChild(switchCaseNode);
      templateBlock = TemplateBlock();
      switchCaseNode.addChildren(templateBlock);
    }
    if (jj_2_37(2147483647)) {
      defaultTagInfo = DefaultTag();
      SwitchDefaultNode switchDefaultNode = setSrcLoc(
          new SwitchDefaultNode(nodeIdGen.genId()), defaultTagInfo);
      switchNode.addChild(switchDefaultNode);
      templateBlock = TemplateBlock();
      switchDefaultNode.addChildren(templateBlock);
    } else {
      ;
    }
    EndSwitchTag();
    {if (true) return switchNode;}
    throw new Error("Missing return statement in function");
  }

  final private ForeachNode ForeachStmt() throws ParseException {
  SourceItemInfo<String> cmdText;
  List<StandaloneNode> templateBlock;
  SourceItemInfo<Void> ifemptyTagInfo;
    cmdText = ForeachTag();
    ForeachBuilder builder = ForeachBuilder.create(nodeIdGen, errorReporter)
        .setCommandLocation(cmdText.srcLocation())
        .setCommandText(cmdText.parsedContent());
    templateBlock = TemplateBlock();
    builder.setLoopBody(templateBlock);
    if (jj_2_38(2147483647)) {
      ifemptyTagInfo = IfemptyTag();
      templateBlock = TemplateBlock();
      builder.setIfEmptyBody(ifemptyTagInfo.srcLocation(), templateBlock);
    } else {
      ;
    }
    EndForeachTag();
    {if (true) return builder.build();}
    throw new Error("Missing return statement in function");
  }

  final private ForNode ForStmt() throws ParseException {
  SourceItemInfo<String> cmdText;
  List<StandaloneNode> templateBlock;
    cmdText = ForTag();
    ForNode forNode = new ForNode(
        nodeIdGen.genId(),
        cmdText.parsedContent(),
        cmdText.srcLocation(),
        errorReporter);
    templateBlock = TemplateBlock();
    forNode.addChildren(templateBlock);
    EndForTag();
    {if (true) return forNode;}
    throw new Error("Missing return statement in function");
  }

  final private CallNode CallStmt() throws ParseException {
  SourceItemInfo<List<String>> callTagInfo;
  CallParamNode callParam;
  Boolean isBasicEndCallTag;
    List<CallParamNode> callParams = Lists.newArrayList();
    if (jj_2_40(2147483647)) {
      callTagInfo = AnyCallTagSelfEnding();
      isBasicEndCallTag = null;
    } else if (jj_2_41(2147483647)) {
      callTagInfo = AnyCallTagNotSelfEnding();
      MaybeWhitespace("No content allowed between 'call' and 'param'" +
              " (whitespace and comments are okay).");
      label_16:
      while (true) {
        if (jj_2_39(2147483647)) {
          ;
        } else {
          break label_16;
        }
        callParam = CallParam();
        callParams.add(callParam);
        MaybeWhitespace("No content allowed between 'param' and 'param'" +
                  " (whitespace and comments are okay).");
      }
      isBasicEndCallTag = EndAnyCallTag();
    } else {
      jj_consume_token(-1);
      throw new ParseException();
    }
    List<String> callTagParts = callTagInfo.parsedContent();

    // ------ Divide callTagParts into cmdName, cmdText, and phnameAttr (if any). ------
    String cmdName = callTagParts.get(0);

    StringBuilder cmdTextSb = new StringBuilder();
    String phnameAttr = null;

    for (int i = 1; i < callTagParts.size(); i++) {
      String cmdTextPart = callTagParts.get(i);
      if (cmdTextPart.startsWith(" phname=\u005c"") && cmdTextPart.endsWith("\u005c"")) {
        if (phnameAttr != null) {
          errorReporter.report(
              callTagInfo.srcLocation(),
              MULTIPLE_PHNAME_ATTRIBUTES_IN_COMMAND,
              cmdName,
              Joiner.on("").join(callTagParts.subList(1, callTagParts.size())));
        }
        phnameAttr = cmdTextPart;
      } else {
        cmdTextSb.append(cmdTextPart);
      }
    }

    String cmdText = cmdTextSb.toString();

    // ------ Compute isBasicCallTag and userSuppliedPhName. ------
    boolean isBasicCallTag = callTagParts.get(0).equals("call");
    if (isBasicEndCallTag != null && isBasicCallTag != isBasicEndCallTag) {
      if (isBasicCallTag) {
        {if (true) throw new ParseException("Mismatched 'call' and '/delcall'.");}
      } else {
        {if (true) throw new ParseException("Mismatched 'delcall' and '/call'.");}
      }
    }

    String userSuppliedPhName =
        (phnameAttr != null) ? phnameAttr.substring(9, phnameAttr.length() - 1) : null;

    // ------ Create the CallNode. ------
    CallNode callNode = null;
    if (isBasicCallTag) {
      callNode = new CallBasicNode.Builder(nodeIdGen.genId(), callTagInfo.srcLocation())
          .commandText(cmdText)
          .userSuppliedPlaceholderName(userSuppliedPhName)
          .build(errorReporter);
    } else {
      callNode = new CallDelegateNode.Builder(nodeIdGen.genId(), callTagInfo.srcLocation())
          .commandText(cmdText)
          .userSuppliedPlaceholderName(userSuppliedPhName)
          .build(errorReporter);
    }
    callNode = setSrcLoc(callNode, callTagInfo);
    callNode.addChildren(callParams);

    {if (true) return callNode;}
    throw new Error("Missing return statement in function");
  }

  final private CallParamNode CallParam() throws ParseException {
  SourceItemInfo<String> cmdText;
  List<StandaloneNode> templateBlock;
    CallParamNode callParamNode = null;
    if (jj_2_42(2147483647)) {
      cmdText = ParamTagSelfEnding();
      callParamNode = new CallParamValueNode.Builder(
          nodeIdGen.genId(), cmdText.parsedContent(), cmdText.srcLocation())
          .build(errorReporter);
    } else if (jj_2_43(2147483647)) {
      cmdText = ParamTagNotSelfEnding();
      CallParamContentNode cpcn = new CallParamContentNode.Builder(
          nodeIdGen.genId(), cmdText.parsedContent(), cmdText.srcLocation())
          .build(errorReporter);
      templateBlock = TemplateBlock();
      cpcn.addChildren(templateBlock);
      callParamNode = cpcn;
      EndParamTag();
    } else {
      jj_consume_token(-1);
      throw new ParseException();
    }
    {if (true) return callParamNode;}
    throw new Error("Missing return statement in function");
  }

  final private LogNode LogStmt() throws ParseException {
  SourceItemInfo<Void> logTagInfo;
  List<StandaloneNode> templateBlock;
    logTagInfo = LogTag();
    LogNode logNode = setSrcLoc(new LogNode(nodeIdGen.genId()), logTagInfo);
    templateBlock = TemplateBlock();
    logNode.addChildren(templateBlock);
    EndLogTag();
    {if (true) return logNode;}
    throw new Error("Missing return statement in function");
  }

  final private DebuggerNode DebuggerStmt() throws ParseException {
  SourceItemInfo<Void> debuggerTagInfo;
    debuggerTagInfo = DebuggerTag();
    {if (true) return setSrcLoc(new DebuggerNode(nodeIdGen.genId()), debuggerTagInfo);}
    throw new Error("Missing return statement in function");
  }

  private boolean jj_2_1(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return !jj_3_1(); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(0, xla); }
  }

  private boolean jj_2_2(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return !jj_3_2(); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(1, xla); }
  }

  private boolean jj_2_3(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return !jj_3_3(); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(2, xla); }
  }

  private boolean jj_2_4(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return !jj_3_4(); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(3, xla); }
  }

  private boolean jj_2_5(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return !jj_3_5(); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(4, xla); }
  }

  private boolean jj_2_6(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return !jj_3_6(); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(5, xla); }
  }

  private boolean jj_2_7(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return !jj_3_7(); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(6, xla); }
  }

  private boolean jj_2_8(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return !jj_3_8(); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(7, xla); }
  }

  private boolean jj_2_9(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return !jj_3_9(); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(8, xla); }
  }

  private boolean jj_2_10(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return !jj_3_10(); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(9, xla); }
  }

  private boolean jj_2_11(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return !jj_3_11(); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(10, xla); }
  }

  private boolean jj_2_12(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return !jj_3_12(); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(11, xla); }
  }

  private boolean jj_2_13(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return !jj_3_13(); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(12, xla); }
  }

  private boolean jj_2_14(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return !jj_3_14(); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(13, xla); }
  }

  private boolean jj_2_15(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return !jj_3_15(); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(14, xla); }
  }

  private boolean jj_2_16(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return !jj_3_16(); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(15, xla); }
  }

  private boolean jj_2_17(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return !jj_3_17(); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(16, xla); }
  }

  private boolean jj_2_18(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return !jj_3_18(); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(17, xla); }
  }

  private boolean jj_2_19(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return !jj_3_19(); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(18, xla); }
  }

  private boolean jj_2_20(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return !jj_3_20(); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(19, xla); }
  }

  private boolean jj_2_21(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return !jj_3_21(); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(20, xla); }
  }

  private boolean jj_2_22(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return !jj_3_22(); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(21, xla); }
  }

  private boolean jj_2_23(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return !jj_3_23(); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(22, xla); }
  }

  private boolean jj_2_24(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return !jj_3_24(); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(23, xla); }
  }

  private boolean jj_2_25(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return !jj_3_25(); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(24, xla); }
  }

  private boolean jj_2_26(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return !jj_3_26(); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(25, xla); }
  }

  private boolean jj_2_27(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return !jj_3_27(); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(26, xla); }
  }

  private boolean jj_2_28(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return !jj_3_28(); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(27, xla); }
  }

  private boolean jj_2_29(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return !jj_3_29(); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(28, xla); }
  }

  private boolean jj_2_30(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return !jj_3_30(); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(29, xla); }
  }

  private boolean jj_2_31(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return !jj_3_31(); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(30, xla); }
  }

  private boolean jj_2_32(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return !jj_3_32(); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(31, xla); }
  }

  private boolean jj_2_33(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return !jj_3_33(); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(32, xla); }
  }

  private boolean jj_2_34(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return !jj_3_34(); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(33, xla); }
  }

  private boolean jj_2_35(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return !jj_3_35(); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(34, xla); }
  }

  private boolean jj_2_36(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return !jj_3_36(); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(35, xla); }
  }

  private boolean jj_2_37(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return !jj_3_37(); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(36, xla); }
  }

  private boolean jj_2_38(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return !jj_3_38(); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(37, xla); }
  }

  private boolean jj_2_39(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return !jj_3_39(); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(38, xla); }
  }

  private boolean jj_2_40(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return !jj_3_40(); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(39, xla); }
  }

  private boolean jj_2_41(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return !jj_3_41(); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(40, xla); }
  }

  private boolean jj_2_42(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return !jj_3_42(); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(41, xla); }
  }

  private boolean jj_2_43(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return !jj_3_43(); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(42, xla); }
  }

  private boolean jj_3_27() {
    if (jj_3R_27()) return true;
    if (jj_3R_18()) return true;
    if (jj_scan_token(CMD_NAME_PLURAL)) return true;
    if (jj_scan_token(WS_AFTER_CMD_NAME)) return true;
    return false;
  }

  private boolean jj_3R_52() {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_61()) {
    jj_scanpos = xsp;
    if (jj_3R_62()) return true;
    }
    return false;
  }

  private boolean jj_3R_44() {
    if (jj_3R_57()) return true;
    return false;
  }

  private boolean jj_3_10() {
    if (jj_3R_20()) return true;
    return false;
  }

  private boolean jj_3_33() {
    if (jj_3R_29()) return true;
    return false;
  }

  private boolean jj_3R_27() {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_44()) jj_scanpos = xsp;
    return false;
  }

  private boolean jj_3_9() {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_22()) {
    jj_scanpos = xsp;
    if (jj_3R_23()) return true;
    }
    return false;
  }

  private boolean jj_3R_22() {
    if (jj_3R_20()) return true;
    return false;
  }

  private boolean jj_3R_34() {
    if (jj_3R_48()) return true;
    return false;
  }

  private boolean jj_3_6() {
    if (jj_3R_21()) return true;
    return false;
  }

  private boolean jj_3_32() {
    if (jj_3R_28()) return true;
    return false;
  }

  private boolean jj_3R_17() {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_34()) jj_scanpos = xsp;
    if (jj_scan_token(TOKEN_NL)) return true;
    return false;
  }

  private boolean jj_3R_31() {
    if (jj_3R_18()) return true;
    if (jj_scan_token(CMD_NAME_ANY_CALL)) return true;
    if (jj_scan_token(WS_AFTER_CMD_NAME)) return true;
    if (jj_3R_47()) return true;
    if (jj_3R_19()) return true;
    return false;
  }

  private boolean jj_3R_67() {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_scan_token(67)) {
    jj_scanpos = xsp;
    if (jj_scan_token(68)) return true;
    }
    return false;
  }

  private boolean jj_3R_66() {
    if (jj_scan_token(CMD_TEXT_CHAR_2)) return true;
    return false;
  }

  private boolean jj_3R_65() {
    if (jj_scan_token(CMD_TEXT_CHAR_1)) return true;
    return false;
  }

  private boolean jj_3R_75() {
    if (jj_3R_48()) return true;
    return false;
  }

  private boolean jj_3R_59() {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_65()) {
    jj_scanpos = xsp;
    if (jj_3R_66()) {
    jj_scanpos = xsp;
    if (jj_3R_67()) return true;
    }
    }
    return false;
  }

  private boolean jj_3R_74() {
    if (jj_scan_token(TOKEN_NL)) return true;
    return false;
  }

  private boolean jj_3R_73() {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_74()) {
    jj_scanpos = xsp;
    if (jj_3R_75()) return true;
    }
    return false;
  }

  private boolean jj_3R_30() {
    if (jj_3R_18()) return true;
    if (jj_scan_token(CMD_NAME_ANY_CALL)) return true;
    if (jj_scan_token(WS_AFTER_CMD_NAME)) return true;
    if (jj_3R_47()) return true;
    if (jj_3R_46()) return true;
    return false;
  }

  private boolean jj_3_24() {
    if (jj_3R_18()) return true;
    if (jj_scan_token(CMD_NAME_FALLBACKMSG)) return true;
    if (jj_scan_token(WS_AFTER_CMD_NAME)) return true;
    return false;
  }

  private boolean jj_3R_58() {
    if (jj_3R_56()) return true;
    if (jj_scan_token(NOT_CMD_NAME_BOUNDARY_AFTER_CMD_NAME)) return true;
    return false;
  }

  private boolean jj_3R_36() {
    if (jj_3R_50()) return true;
    return false;
  }

  private boolean jj_3_38() {
    if (jj_3R_18()) return true;
    if (jj_scan_token(CMD_NAME_IFEMPTY)) return true;
    if (jj_3R_19()) return true;
    return false;
  }

  private boolean jj_3R_47() {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_58()) jj_scanpos = xsp;
    while (true) {
      xsp = jj_scanpos;
      if (jj_3R_59()) { jj_scanpos = xsp; break; }
    }
    return false;
  }

  private boolean jj_3R_29() {
    if (jj_3R_18()) return true;
    if (jj_scan_token(CMD_NAME_LET)) return true;
    if (jj_scan_token(WS_AFTER_CMD_NAME)) return true;
    if (jj_3R_45()) return true;
    if (jj_3R_19()) return true;
    return false;
  }

  private boolean jj_3_4() {
    if (jj_3R_18()) return true;
    if (jj_scan_token(CMD_NAME_LITERAL)) return true;
    if (jj_3R_19()) return true;
    return false;
  }

  private boolean jj_3R_72() {
    if (jj_3R_48()) return true;
    return false;
  }

  private boolean jj_3_30() {
    if (jj_3R_18()) return true;
    if (jj_scan_token(CMD_NAME_CASE)) return true;
    if (jj_scan_token(WS_AFTER_CMD_NAME)) return true;
    return false;
  }

  private boolean jj_3R_38() {
    if (jj_3R_51()) return true;
    return false;
  }

  private boolean jj_3R_69() {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_72()) jj_scanpos = xsp;
    if (jj_scan_token(TOKEN_NL)) return true;
    while (true) {
      xsp = jj_scanpos;
      if (jj_3R_73()) { jj_scanpos = xsp; break; }
    }
    return false;
  }

  private boolean jj_3R_37() {
    if (jj_3R_18()) return true;
    if (jj_scan_token(CMD_NAME_LITERAL)) return true;
    if (jj_3R_19()) return true;
    return false;
  }

  private boolean jj_3R_20() {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_35()) {
    jj_scanpos = xsp;
    if (jj_3R_36()) {
    jj_scanpos = xsp;
    if (jj_3R_37()) {
    jj_scanpos = xsp;
    if (jj_3R_38()) return true;
    }
    }
    }
    return false;
  }

  private boolean jj_3R_35() {
    if (jj_3R_49()) return true;
    return false;
  }

  private boolean jj_3R_45() {
    if (jj_3R_47()) return true;
    return false;
  }

  private boolean jj_3R_28() {
    if (jj_3R_18()) return true;
    if (jj_scan_token(CMD_NAME_LET)) return true;
    if (jj_scan_token(WS_AFTER_CMD_NAME)) return true;
    if (jj_3R_45()) return true;
    if (jj_3R_46()) return true;
    return false;
  }

  private boolean jj_3_31() {
    if (jj_scan_token(CMD_NAME_PRINT)) return true;
    if (jj_scan_token(WS_AFTER_CMD_NAME)) return true;
    return false;
  }

  private boolean jj_3_43() {
    if (jj_3R_33()) return true;
    return false;
  }

  private boolean jj_3R_71() {
    if (jj_3R_50()) return true;
    return false;
  }

  private boolean jj_3R_70() {
    if (jj_3R_49()) return true;
    return false;
  }

  private boolean jj_3R_63() {
    if (jj_3R_19()) return true;
    return false;
  }

  private boolean jj_3_8() {
    Token xsp;
    while (true) {
      xsp = jj_scanpos;
      if (jj_scan_token(87)) { jj_scanpos = xsp; break; }
    }
    if (jj_scan_token(BLOCK_DOC_COMMENT)) return true;
    return false;
  }

  private boolean jj_3R_43() {
    if (jj_3R_56()) return true;
    if (jj_scan_token(NOT_CMD_NAME_BOUNDARY_AFTER_CMD_NAME)) return true;
    return false;
  }

  private boolean jj_3R_64() {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_70()) {
    jj_scanpos = xsp;
    if (jj_3R_71()) return true;
    }
    return false;
  }

  private boolean jj_3R_42() {
    if (jj_scan_token(CMD_NAME_PRINT)) return true;
    if (jj_scan_token(WS_AFTER_CMD_NAME)) return true;
    return false;
  }

  private boolean jj_3_42() {
    if (jj_3R_32()) return true;
    return false;
  }

  private boolean jj_3R_24() {
    if (jj_3R_18()) return true;
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_42()) {
    jj_scanpos = xsp;
    if (jj_3R_43()) {
    jj_scanpos = xsp;
    if (jj_scan_token(70)) {
    jj_scanpos = xsp;
    if (jj_scan_token(71)) return true;
    }
    }
    }
    return false;
  }

  private boolean jj_3R_46() {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_scan_token(62)) {
    jj_scanpos = xsp;
    if (jj_scan_token(64)) {
    jj_scanpos = xsp;
    if (jj_scan_token(73)) {
    jj_scanpos = xsp;
    if (jj_scan_token(75)) return true;
    }
    }
    }
    return false;
  }

  private boolean jj_3_37() {
    if (jj_3R_18()) return true;
    if (jj_scan_token(CMD_NAME_DEFAULT)) return true;
    if (jj_3R_19()) return true;
    return false;
  }

  private boolean jj_3R_57() {
    Token xsp;
    if (jj_3R_64()) return true;
    while (true) {
      xsp = jj_scanpos;
      if (jj_3R_64()) { jj_scanpos = xsp; break; }
    }
    return false;
  }

  private boolean jj_3R_68() {
    if (jj_scan_token(TOKEN_WS_NOT_NL)) return true;
    return false;
  }

  private boolean jj_3_23() {
    if (jj_3R_24()) return true;
    return false;
  }

  private boolean jj_3_2() {
    if (jj_3R_18()) return true;
    if (jj_scan_token(CMD_NAME_LITERAL)) return true;
    if (jj_3R_19()) return true;
    return false;
  }

  private boolean jj_3R_60() {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_68()) {
    jj_scanpos = xsp;
    if (jj_scan_token(7)) return true;
    }
    return false;
  }

  private boolean jj_3R_55() {
    if (jj_3R_18()) return true;
    Token xsp;
    xsp = jj_scanpos;
    if (jj_scan_token(24)) {
    jj_scanpos = xsp;
    if (jj_scan_token(32)) {
    jj_scanpos = xsp;
    if (jj_scan_token(33)) {
    jj_scanpos = xsp;
    if (jj_scan_token(34)) {
    jj_scanpos = xsp;
    if (jj_scan_token(36)) {
    jj_scanpos = xsp;
    if (jj_scan_token(40)) {
    jj_scanpos = xsp;
    if (jj_scan_token(42)) {
    jj_scanpos = xsp;
    if (jj_scan_token(45)) {
    jj_scanpos = xsp;
    if (jj_scan_token(47)) {
    jj_scanpos = xsp;
    if (jj_scan_token(51)) {
    jj_scanpos = xsp;
    if (jj_scan_token(53)) return true;
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    xsp = jj_scanpos;
    if (jj_scan_token(65)) {
    jj_scanpos = xsp;
    if (jj_3R_63()) return true;
    }
    return false;
  }

  private boolean jj_3R_48() {
    Token xsp;
    if (jj_3R_60()) return true;
    while (true) {
      xsp = jj_scanpos;
      if (jj_3R_60()) { jj_scanpos = xsp; break; }
    }
    return false;
  }

  private boolean jj_3R_54() {
    if (jj_3R_24()) return true;
    return false;
  }

  private boolean jj_3R_41() {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_54()) {
    jj_scanpos = xsp;
    if (jj_3R_55()) return true;
    }
    return false;
  }

  private boolean jj_3_36() {
    if (jj_3R_18()) return true;
    if (jj_scan_token(CMD_NAME_CASE)) return true;
    if (jj_scan_token(WS_AFTER_CMD_NAME)) return true;
    return false;
  }

  private boolean jj_3_3() {
    if (jj_3R_20()) return true;
    return false;
  }

  private boolean jj_3R_19() {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_scan_token(61)) {
    jj_scanpos = xsp;
    if (jj_scan_token(63)) {
    jj_scanpos = xsp;
    if (jj_scan_token(72)) {
    jj_scanpos = xsp;
    if (jj_scan_token(74)) return true;
    }
    }
    }
    return false;
  }

  private boolean jj_3R_49() {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_scan_token(86)) {
    jj_scanpos = xsp;
    if (jj_scan_token(87)) {
    jj_scanpos = xsp;
    if (jj_scan_token(88)) return true;
    }
    }
    return false;
  }

  private boolean jj_3_5() {
    if (jj_scan_token(CMD_NAME_PRINT)) return true;
    if (jj_scan_token(WS_AFTER_CMD_NAME)) return true;
    return false;
  }

  private boolean jj_3_22() {
    if (jj_3R_18()) return true;
    if (jj_scan_token(CMD_NAME_DEBUGGER)) return true;
    if (jj_3R_19()) return true;
    return false;
  }

  private boolean jj_3_21() {
    if (jj_3R_18()) return true;
    if (jj_scan_token(CMD_NAME_LOG)) return true;
    if (jj_3R_19()) return true;
    return false;
  }

  private boolean jj_3_20() {
    if (jj_3R_18()) return true;
    if (jj_scan_token(CMD_NAME_ANY_CALL)) return true;
    if (jj_scan_token(WS_AFTER_CMD_NAME)) return true;
    return false;
  }

  private boolean jj_3R_53() {
    if (jj_3R_52()) return true;
    return false;
  }

  private boolean jj_3_19() {
    if (jj_3R_18()) return true;
    if (jj_scan_token(CMD_NAME_FOR)) return true;
    if (jj_scan_token(WS_AFTER_CMD_NAME)) return true;
    return false;
  }

  private boolean jj_3_29() {
    if (jj_3R_18()) return true;
    if (jj_scan_token(CMD_NAME_CASE)) return true;
    if (jj_scan_token(WS_AFTER_CMD_NAME)) return true;
    return false;
  }

  private boolean jj_3_18() {
    if (jj_3R_18()) return true;
    if (jj_scan_token(CMD_NAME_FOREACH)) return true;
    if (jj_scan_token(WS_AFTER_CMD_NAME)) return true;
    return false;
  }

  private boolean jj_3R_18() {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_scan_token(8)) {
    jj_scanpos = xsp;
    if (jj_scan_token(9)) return true;
    }
    return false;
  }

  private boolean jj_3_17() {
    if (jj_3R_18()) return true;
    if (jj_scan_token(CMD_NAME_SWITCH)) return true;
    if (jj_scan_token(WS_AFTER_CMD_NAME)) return true;
    return false;
  }

  private boolean jj_3_16() {
    if (jj_3R_18()) return true;
    if (jj_scan_token(CMD_NAME_IF)) return true;
    if (jj_scan_token(WS_AFTER_CMD_NAME)) return true;
    return false;
  }

  private boolean jj_3_15() {
    if (jj_3R_18()) return true;
    if (jj_scan_token(CMD_NAME_LET)) return true;
    if (jj_scan_token(WS_AFTER_CMD_NAME)) return true;
    return false;
  }

  private boolean jj_3R_26() {
    if (jj_3R_41()) return true;
    return false;
  }

  private boolean jj_3_14() {
    if (jj_3R_18()) return true;
    if (jj_scan_token(CMD_NAME_CSS)) return true;
    if (jj_scan_token(WS_AFTER_CMD_NAME)) return true;
    return false;
  }

  private boolean jj_3_13() {
    if (jj_3R_18()) return true;
    if (jj_scan_token(CMD_NAME_XID)) return true;
    if (jj_scan_token(WS_AFTER_CMD_NAME)) return true;
    return false;
  }

  private boolean jj_3_35() {
    if (jj_3R_18()) return true;
    if (jj_scan_token(CMD_NAME_ELSE)) return true;
    if (jj_3R_19()) return true;
    return false;
  }

  private boolean jj_3_12() {
    if (jj_3R_24()) return true;
    return false;
  }

  private boolean jj_3R_40() {
    if (jj_scan_token(BLOCK_DOC_COMMENT)) return true;
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_53()) jj_scanpos = xsp;
    return false;
  }

  private boolean jj_3R_39() {
    if (jj_3R_52()) return true;
    return false;
  }

  private boolean jj_3_11() {
    if (jj_3R_18()) return true;
    if (jj_scan_token(CMD_NAME_MSG)) return true;
    if (jj_scan_token(WS_AFTER_CMD_NAME)) return true;
    return false;
  }

  private boolean jj_3R_21() {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_39()) jj_scanpos = xsp;
    xsp = jj_scanpos;
    if (jj_3R_40()) jj_scanpos = xsp;
    if (jj_3R_18()) return true;
    xsp = jj_scanpos;
    if (jj_scan_token(12)) {
    jj_scanpos = xsp;
    if (jj_scan_token(13)) return true;
    }
    return false;
  }

  private boolean jj_3R_33() {
    if (jj_3R_18()) return true;
    if (jj_scan_token(CMD_NAME_PARAM)) return true;
    if (jj_scan_token(WS_AFTER_CMD_NAME)) return true;
    if (jj_3R_45()) return true;
    if (jj_3R_19()) return true;
    return false;
  }

  private boolean jj_3_34() {
    if (jj_3R_18()) return true;
    if (jj_scan_token(CMD_NAME_ELSEIF)) return true;
    if (jj_scan_token(WS_AFTER_CMD_NAME)) return true;
    return false;
  }

  private boolean jj_3R_51() {
    if (jj_3R_18()) return true;
    Token xsp;
    xsp = jj_scanpos;
    if (jj_scan_token(15)) {
    jj_scanpos = xsp;
    if (jj_scan_token(16)) {
    jj_scanpos = xsp;
    if (jj_scan_token(17)) {
    jj_scanpos = xsp;
    if (jj_scan_token(18)) {
    jj_scanpos = xsp;
    if (jj_scan_token(19)) {
    jj_scanpos = xsp;
    if (jj_scan_token(20)) {
    jj_scanpos = xsp;
    if (jj_scan_token(21)) return true;
    }
    }
    }
    }
    }
    }
    if (jj_3R_19()) return true;
    return false;
  }

  private boolean jj_3_7() {
    if (jj_3R_21()) return true;
    return false;
  }

  private boolean jj_3R_56() {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_scan_token(15)) {
    jj_scanpos = xsp;
    if (jj_scan_token(16)) {
    jj_scanpos = xsp;
    if (jj_scan_token(17)) {
    jj_scanpos = xsp;
    if (jj_scan_token(18)) {
    jj_scanpos = xsp;
    if (jj_scan_token(19)) {
    jj_scanpos = xsp;
    if (jj_scan_token(20)) {
    jj_scanpos = xsp;
    if (jj_scan_token(21)) {
    jj_scanpos = xsp;
    if (jj_scan_token(22)) {
    jj_scanpos = xsp;
    if (jj_scan_token(23)) {
    jj_scanpos = xsp;
    if (jj_scan_token(24)) {
    jj_scanpos = xsp;
    if (jj_scan_token(26)) {
    jj_scanpos = xsp;
    if (jj_scan_token(31)) {
    jj_scanpos = xsp;
    if (jj_scan_token(32)) {
    jj_scanpos = xsp;
    if (jj_scan_token(33)) {
    jj_scanpos = xsp;
    if (jj_scan_token(34)) {
    jj_scanpos = xsp;
    if (jj_scan_token(35)) {
    jj_scanpos = xsp;
    if (jj_scan_token(36)) {
    jj_scanpos = xsp;
    if (jj_scan_token(37)) {
    jj_scanpos = xsp;
    if (jj_scan_token(38)) {
    jj_scanpos = xsp;
    if (jj_scan_token(39)) {
    jj_scanpos = xsp;
    if (jj_scan_token(40)) {
    jj_scanpos = xsp;
    if (jj_scan_token(41)) {
    jj_scanpos = xsp;
    if (jj_scan_token(42)) {
    jj_scanpos = xsp;
    if (jj_scan_token(43)) {
    jj_scanpos = xsp;
    if (jj_scan_token(44)) {
    jj_scanpos = xsp;
    if (jj_scan_token(45)) {
    jj_scanpos = xsp;
    if (jj_scan_token(46)) {
    jj_scanpos = xsp;
    if (jj_scan_token(47)) {
    jj_scanpos = xsp;
    if (jj_scan_token(48)) {
    jj_scanpos = xsp;
    if (jj_scan_token(49)) {
    jj_scanpos = xsp;
    if (jj_scan_token(50)) {
    jj_scanpos = xsp;
    if (jj_scan_token(51)) {
    jj_scanpos = xsp;
    if (jj_scan_token(52)) {
    jj_scanpos = xsp;
    if (jj_scan_token(53)) {
    jj_scanpos = xsp;
    if (jj_scan_token(54)) {
    jj_scanpos = xsp;
    if (jj_scan_token(55)) {
    jj_scanpos = xsp;
    if (jj_scan_token(56)) {
    jj_scanpos = xsp;
    if (jj_scan_token(57)) {
    jj_scanpos = xsp;
    if (jj_scan_token(58)) return true;
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    return false;
  }

  private boolean jj_3R_23() {
    if (jj_3R_41()) return true;
    return false;
  }

  private boolean jj_3_39() {
    if (jj_3R_18()) return true;
    if (jj_scan_token(CMD_NAME_PARAM)) return true;
    if (jj_scan_token(WS_AFTER_CMD_NAME)) return true;
    return false;
  }

  private boolean jj_3R_32() {
    if (jj_3R_18()) return true;
    if (jj_scan_token(CMD_NAME_PARAM)) return true;
    if (jj_scan_token(WS_AFTER_CMD_NAME)) return true;
    if (jj_3R_45()) return true;
    if (jj_3R_46()) return true;
    return false;
  }

  private boolean jj_3_26() {
    if (jj_3R_20()) return true;
    return false;
  }

  private boolean jj_3R_50() {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_scan_token(6)) {
    jj_scanpos = xsp;
    if (jj_scan_token(7)) return true;
    }
    return false;
  }

  private boolean jj_3_25() {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_25()) {
    jj_scanpos = xsp;
    if (jj_3R_26()) {
    jj_scanpos = xsp;
    if (jj_scan_token(80)) return true;
    }
    }
    return false;
  }

  private boolean jj_3R_25() {
    if (jj_3R_20()) return true;
    return false;
  }

  private boolean jj_3_41() {
    if (jj_3R_31()) return true;
    return false;
  }

  private boolean jj_3_1() {
    if (jj_3R_17()) return true;
    return false;
  }

  private boolean jj_3_40() {
    if (jj_3R_30()) return true;
    return false;
  }

  private boolean jj_3_28() {
    if (jj_3R_27()) return true;
    if (jj_3R_18()) return true;
    if (jj_scan_token(CMD_NAME_SELECT)) return true;
    if (jj_scan_token(WS_AFTER_CMD_NAME)) return true;
    return false;
  }

  private boolean jj_3R_62() {
    if (jj_3R_48()) return true;
    return false;
  }

  private boolean jj_3R_61() {
    if (jj_3R_69()) return true;
    return false;
  }

  /** Generated Token Manager. */
  public TemplateParserTokenManager token_source;
  SimpleCharStream jj_input_stream;
  /** Current token. */
  public Token token;
  /** Next token. */
  public Token jj_nt;
  private int jj_ntk;
  private Token jj_scanpos, jj_lastpos;
  private int jj_la;
  private int jj_gen;
  final private int[] jj_la1 = new int[46];
  static private int[] jj_la1_0;
  static private int[] jj_la1_1;
  static private int[] jj_la1_2;
  static private int[] jj_la1_3;
  static {
      jj_la1_init_0();
      jj_la1_init_1();
      jj_la1_init_2();
      jj_la1_init_3();
   }
   private static void jj_la1_init_0() {
      jj_la1_0 = new int[] {0x300,0x0,0x0,0x85ff8000,0x0,0x0,0x0,0x85ff8000,0x80,0x80,0x80,0x80,0x80,0x80,0x80,0xc0,0xc0,0xc0,0x0,0xc0,0xc0,0xc0,0x3f8000,0xc0,0x300,0xc0,0x300,0xc0,0x80,0x80,0x80,0x40,0x3000,0x340,0x3000,0x0,0x0,0x80,0x3000,0x0,0x300,0x1000000,0x0,0x300,0x300,0x85ff8000,};
   }
   private static void jj_la1_init_1() {
      jj_la1_1 = new int[] {0x0,0xa0000000,0x40000000,0x7ffffff,0x0,0x0,0x0,0x7ffffff,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x28a517,0xa0000000,0x0,0x0,0x7ffffff,};
   }
   private static void jj_la1_init_2() {
      jj_la1_2 = new int[] {0x0,0x500,0xa01,0x0,0xd8,0x18,0xd8,0x0,0x800000,0x800000,0x800000,0xc00000,0xc00000,0x800000,0x800000,0x0,0x800000,0x800000,0x1c00000,0x1c00000,0x1c00000,0x1c00000,0x0,0x1c00000,0x0,0x1c00000,0x0,0x800000,0xc00000,0xc00000,0xc00000,0x0,0x0,0x0,0x0,0x0,0x800000,0xc00000,0x0,0x0,0x0,0x0,0x502,0x0,0x10000,0xc0,};
   }
   private static void jj_la1_init_3() {
      jj_la1_3 = new int[] {0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x4,0x0,0x0,0x0,0x4,0x0,0x0,0x0,0x0,0x0,0x0,};
   }
  final private JJCalls[] jj_2_rtns = new JJCalls[43];
  private boolean jj_rescan = false;
  private int jj_gc = 0;

  /** Constructor with InputStream. */
  public TemplateParser(java.io.InputStream stream) {
     this(stream, null);
  }
  /** Constructor with InputStream and supplied encoding */
  public TemplateParser(java.io.InputStream stream, String encoding) {
    try { jj_input_stream = new SimpleCharStream(stream, encoding, 1, 1); } catch(java.io.UnsupportedEncodingException e) { throw new RuntimeException(e); }
    token_source = new TemplateParserTokenManager(jj_input_stream);
    token = new Token();
    jj_ntk = -1;
    jj_gen = 0;
    for (int i = 0; i < 46; i++) jj_la1[i] = -1;
    for (int i = 0; i < jj_2_rtns.length; i++) jj_2_rtns[i] = new JJCalls();
  }

  /** Reinitialise. */
  public void ReInit(java.io.InputStream stream) {
     ReInit(stream, null);
  }
  /** Reinitialise. */
  public void ReInit(java.io.InputStream stream, String encoding) {
    try { jj_input_stream.ReInit(stream, encoding, 1, 1); } catch(java.io.UnsupportedEncodingException e) { throw new RuntimeException(e); }
    token_source.ReInit(jj_input_stream);
    token = new Token();
    jj_ntk = -1;
    jj_gen = 0;
    for (int i = 0; i < 46; i++) jj_la1[i] = -1;
    for (int i = 0; i < jj_2_rtns.length; i++) jj_2_rtns[i] = new JJCalls();
  }

  /** Constructor. */
  public TemplateParser(java.io.Reader stream) {
    jj_input_stream = new SimpleCharStream(stream, 1, 1);
    token_source = new TemplateParserTokenManager(jj_input_stream);
    token = new Token();
    jj_ntk = -1;
    jj_gen = 0;
    for (int i = 0; i < 46; i++) jj_la1[i] = -1;
    for (int i = 0; i < jj_2_rtns.length; i++) jj_2_rtns[i] = new JJCalls();
  }

  /** Reinitialise. */
  public void ReInit(java.io.Reader stream) {
    jj_input_stream.ReInit(stream, 1, 1);
    token_source.ReInit(jj_input_stream);
    token = new Token();
    jj_ntk = -1;
    jj_gen = 0;
    for (int i = 0; i < 46; i++) jj_la1[i] = -1;
    for (int i = 0; i < jj_2_rtns.length; i++) jj_2_rtns[i] = new JJCalls();
  }

  /** Constructor with generated Token Manager. */
  public TemplateParser(TemplateParserTokenManager tm) {
    token_source = tm;
    token = new Token();
    jj_ntk = -1;
    jj_gen = 0;
    for (int i = 0; i < 46; i++) jj_la1[i] = -1;
    for (int i = 0; i < jj_2_rtns.length; i++) jj_2_rtns[i] = new JJCalls();
  }

  /** Reinitialise. */
  public void ReInit(TemplateParserTokenManager tm) {
    token_source = tm;
    token = new Token();
    jj_ntk = -1;
    jj_gen = 0;
    for (int i = 0; i < 46; i++) jj_la1[i] = -1;
    for (int i = 0; i < jj_2_rtns.length; i++) jj_2_rtns[i] = new JJCalls();
  }

  private Token jj_consume_token(int kind) throws ParseException {
    Token oldToken;
    if ((oldToken = token).next != null) token = token.next;
    else token = token.next = token_source.getNextToken();
    jj_ntk = -1;
    if (token.kind == kind) {
      jj_gen++;
      if (++jj_gc > 100) {
        jj_gc = 0;
        for (int i = 0; i < jj_2_rtns.length; i++) {
          JJCalls c = jj_2_rtns[i];
          while (c != null) {
            if (c.gen < jj_gen) c.first = null;
            c = c.next;
          }
        }
      }
      return token;
    }
    token = oldToken;
    jj_kind = kind;
    throw generateParseException();
  }

  static private final class LookaheadSuccess extends java.lang.Error { }
  final private LookaheadSuccess jj_ls = new LookaheadSuccess();
  private boolean jj_scan_token(int kind) {
    if (jj_scanpos == jj_lastpos) {
      jj_la--;
      if (jj_scanpos.next == null) {
        jj_lastpos = jj_scanpos = jj_scanpos.next = token_source.getNextToken();
      } else {
        jj_lastpos = jj_scanpos = jj_scanpos.next;
      }
    } else {
      jj_scanpos = jj_scanpos.next;
    }
    if (jj_rescan) {
      int i = 0; Token tok = token;
      while (tok != null && tok != jj_scanpos) { i++; tok = tok.next; }
      if (tok != null) jj_add_error_token(kind, i);
    }
    if (jj_scanpos.kind != kind) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) throw jj_ls;
    return false;
  }


/** Get the next Token. */
  final public Token getNextToken() {
    if (token.next != null) token = token.next;
    else token = token.next = token_source.getNextToken();
    jj_ntk = -1;
    jj_gen++;
    return token;
  }

/** Get the specific Token. */
  final public Token getToken(int index) {
    Token t = token;
    for (int i = 0; i < index; i++) {
      if (t.next != null) t = t.next;
      else t = t.next = token_source.getNextToken();
    }
    return t;
  }

  private int jj_ntk() {
    if ((jj_nt=token.next) == null)
      return (jj_ntk = (token.next=token_source.getNextToken()).kind);
    else
      return (jj_ntk = jj_nt.kind);
  }

  private java.util.List<int[]> jj_expentries = new java.util.ArrayList<int[]>();
  private int[] jj_expentry;
  private int jj_kind = -1;
  private int[] jj_lasttokens = new int[100];
  private int jj_endpos;

  private void jj_add_error_token(int kind, int pos) {
    if (pos >= 100) return;
    if (pos == jj_endpos + 1) {
      jj_lasttokens[jj_endpos++] = kind;
    } else if (jj_endpos != 0) {
      jj_expentry = new int[jj_endpos];
      for (int i = 0; i < jj_endpos; i++) {
        jj_expentry[i] = jj_lasttokens[i];
      }
      jj_entries_loop: for (java.util.Iterator<?> it = jj_expentries.iterator(); it.hasNext();) {
        int[] oldentry = (int[])(it.next());
        if (oldentry.length == jj_expentry.length) {
          for (int i = 0; i < jj_expentry.length; i++) {
            if (oldentry[i] != jj_expentry[i]) {
              continue jj_entries_loop;
            }
          }
          jj_expentries.add(jj_expentry);
          break jj_entries_loop;
        }
      }
      if (pos != 0) jj_lasttokens[(jj_endpos = pos) - 1] = kind;
    }
  }

  /** Generate ParseException. */
  public ParseException generateParseException() {
    jj_expentries.clear();
    boolean[] la1tokens = new boolean[100];
    if (jj_kind >= 0) {
      la1tokens[jj_kind] = true;
      jj_kind = -1;
    }
    for (int i = 0; i < 46; i++) {
      if (jj_la1[i] == jj_gen) {
        for (int j = 0; j < 32; j++) {
          if ((jj_la1_0[i] & (1<<j)) != 0) {
            la1tokens[j] = true;
          }
          if ((jj_la1_1[i] & (1<<j)) != 0) {
            la1tokens[32+j] = true;
          }
          if ((jj_la1_2[i] & (1<<j)) != 0) {
            la1tokens[64+j] = true;
          }
          if ((jj_la1_3[i] & (1<<j)) != 0) {
            la1tokens[96+j] = true;
          }
        }
      }
    }
    for (int i = 0; i < 100; i++) {
      if (la1tokens[i]) {
        jj_expentry = new int[1];
        jj_expentry[0] = i;
        jj_expentries.add(jj_expentry);
      }
    }
    jj_endpos = 0;
    jj_rescan_token();
    jj_add_error_token(0, 0);
    int[][] exptokseq = new int[jj_expentries.size()][];
    for (int i = 0; i < jj_expentries.size(); i++) {
      exptokseq[i] = jj_expentries.get(i);
    }
    return new ParseException(token, exptokseq, tokenImage);
  }

  /** Enable tracing. */
  final public void enable_tracing() {
  }

  /** Disable tracing. */
  final public void disable_tracing() {
  }

  private void jj_rescan_token() {
    jj_rescan = true;
    for (int i = 0; i < 43; i++) {
    try {
      JJCalls p = jj_2_rtns[i];
      do {
        if (p.gen > jj_gen) {
          jj_la = p.arg; jj_lastpos = jj_scanpos = p.first;
          switch (i) {
            case 0: jj_3_1(); break;
            case 1: jj_3_2(); break;
            case 2: jj_3_3(); break;
            case 3: jj_3_4(); break;
            case 4: jj_3_5(); break;
            case 5: jj_3_6(); break;
            case 6: jj_3_7(); break;
            case 7: jj_3_8(); break;
            case 8: jj_3_9(); break;
            case 9: jj_3_10(); break;
            case 10: jj_3_11(); break;
            case 11: jj_3_12(); break;
            case 12: jj_3_13(); break;
            case 13: jj_3_14(); break;
            case 14: jj_3_15(); break;
            case 15: jj_3_16(); break;
            case 16: jj_3_17(); break;
            case 17: jj_3_18(); break;
            case 18: jj_3_19(); break;
            case 19: jj_3_20(); break;
            case 20: jj_3_21(); break;
            case 21: jj_3_22(); break;
            case 22: jj_3_23(); break;
            case 23: jj_3_24(); break;
            case 24: jj_3_25(); break;
            case 25: jj_3_26(); break;
            case 26: jj_3_27(); break;
            case 27: jj_3_28(); break;
            case 28: jj_3_29(); break;
            case 29: jj_3_30(); break;
            case 30: jj_3_31(); break;
            case 31: jj_3_32(); break;
            case 32: jj_3_33(); break;
            case 33: jj_3_34(); break;
            case 34: jj_3_35(); break;
            case 35: jj_3_36(); break;
            case 36: jj_3_37(); break;
            case 37: jj_3_38(); break;
            case 38: jj_3_39(); break;
            case 39: jj_3_40(); break;
            case 40: jj_3_41(); break;
            case 41: jj_3_42(); break;
            case 42: jj_3_43(); break;
          }
        }
        p = p.next;
      } while (p != null);
      } catch(LookaheadSuccess ls) { }
    }
    jj_rescan = false;
  }

  private void jj_save(int index, int xla) {
    JJCalls p = jj_2_rtns[index];
    while (p.gen > jj_gen) {
      if (p.next == null) { p = p.next = new JJCalls(); break; }
      p = p.next;
    }
    p.gen = jj_gen + xla - jj_la; p.first = token; p.arg = xla;
  }

  static final class JJCalls {
    int gen;
    Token first;
    int arg;
    JJCalls next;
  }

}
