/* Generated By:JavaCC: Do not edit this line. SoyFileParser.java */
package com.google.template.soy.soyparse;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Joiner;
import com.google.common.base.Preconditions;
import com.google.common.collect.Lists;
import com.google.template.soy.base.SourceLocation;
import com.google.template.soy.base.SoySyntaxException;
import com.google.template.soy.base.internal.IdGenerator;
import com.google.template.soy.base.internal.SoyFileKind;
import com.google.template.soy.soyparse.ErrorReporter;
import com.google.template.soy.soyparse.ErrorReporterImpl;
import com.google.template.soy.soytree.SoyFileNode;
import com.google.template.soy.soytree.SoyNode.StandaloneNode;
import com.google.template.soy.soytree.TemplateBasicNodeBuilder;
import com.google.template.soy.soytree.TemplateDelegateNodeBuilder;
import com.google.template.soy.soytree.TemplateNode;
import com.google.template.soy.soytree.TemplateNodeBuilder;
import com.google.template.soy.soytree.TemplateNodeBuilder.DeclInfo;
import com.google.template.soy.soytree.TemplateNode.SoyFileHeaderInfo;
import com.google.template.soy.types.SoyTypeRegistry;

import java.io.*;
import java.util.*;
import java.util.regex.*;


/**
 * This parser's specification is in SoyFileParser.jj, which is read by JavaCC and transformed
 * into SoyFileParser.java. To modify this parser, please edit SoyFileParser.jj. Do not edit
 * SoyFileParser.java directly.
 *
 * <p> Important: Do not use outside of Soy code (treat as superpackage-private).
 *
 * <pre>
 * This parser parses the following Soy file structure:
 *
 * 1. Delegate package (delpackage):
 *    + Optional.
 *    + The file must contain 0 or 1 delpackage declaration.
 *    + It must appear before the namespace declaration.
 *    + It must appear on its own line and start at the start of a line.
 *    Example:  {delpackage MySecretFeature}
 *
 * 2. Namespace:
 *    + The file must contain exactly one namespace declaration.
 *    + It must appear before any templates.
 *    + It must appear on its own line and start at the start of a line.
 *    Examples:
 *    {namespace boo.foo}
 *    {namespace boo.foo autoescape="..."}
 *
 * 3. Alias:
 *    + Alias declarations must appear after the namespace declaration.
 *    + They must appear before any templates.
 *    + Each must appear on its own line and start at the start of a line.
 *    Examples:
 *    {alias boo.foo.goo.moo}
 *    {alias boo.foo.goo.moo as zoo}
 *
 * 4. SoyDoc:
 *    + Starts with slash-star-star (/**) and ends with star-slash (*&#47;) like JavaDoc.
 *    + SoyDoc must appear on its own line(s) and start at the start of a line.
 *    + Currently recognizes two tags: "&#64;param keyName" and "&#64;param? optionalKeyName".
 *    Example:
 *    /**
 *     * &#64;param boo Something scary.
 *     * &#64;param? goo Something slimy (optional).
 *     *&#47;
 *
 * 5. Template:
 *    + Each template must be immediately preceded by a SoyDoc block.
 *    + The 'template' tag and the '/template' tag much each appear on its own line(s) and start
 *      at the start of a line.
 *    + The template content is parsed by TemplateParser.jj.
 *    Examples:
 *    /**
 *     * New style.
 *     * &#64;param boo Something scary.
 *     * &#64;param? goo Something slimy (optional).
 *     *&#47;
 *    {template .foo autoescape="..."}
 *      {msg desc=""}
 *        {$boo} has a friend named {$goo.firstName}.
 *      {/msg}
 *    {/template}
 *    /**
 *     * Old style.
 *     *&#47;
 *    {template name="foo"}
 *      ...
 *    {/template}
 *
 * 6. Misc:
 *    + Other than the items specified above, everything else is ignored.
 *    + SoyDoc blocks not immediately followed by a template are ignored.
 *    + The file must end with a newline.
 * </pre>
 *
 */
public class SoyFileParser implements SoyFileParserConstants {


  /** Pattern for the line number in an error message generated by the parser or token manager. */
  private static final Pattern ERROR_MSG_LINE_NUM_PAT =
      Pattern.compile("(?<=line )\u005c\u005cd+(?=, column )");

  private static final SoyError UNCATEGORIZED = SoyError.of("In file {0}, template {1}: {2}");


  /** Type registry for resolving type names. */
  private SoyTypeRegistry typeRegistry;

  /** Node id generator for the tree being built. */
  private IdGenerator nodeIdGen;

  /** The kind of this Soy file. */
  private SoyFileKind soyFileKind;

  /** Path of source being parsed. This is descriptive, not a means to refetch source. */
  private String filePath = SourceLocation.UNKNOWN.getFilePath();

  private ErrorReporter errorReporter;

  /**
   * Constructor that takes a reader object providing the input.
   * @param typeRegistry The type registry for resolving type names.
   * @param nodeIdGen The node id generator for the tree being built.
   * @param input The input to parse.
   * @param soyFileKind The kind of this Soy file.
   * @param filePath The path of the source being parsed. Used for reporting.
   * @param errorReporter For reporting parse errors.
   */
  public SoyFileParser(
      SoyTypeRegistry typeRegistry,
      IdGenerator nodeIdGen,
      Reader input,
      SoyFileKind soyFileKind,
      String filePath,
      ErrorReporter errorReporter) {
    this(input);
    Preconditions.checkNotNull(typeRegistry);
    Preconditions.checkNotNull(nodeIdGen);
    this.typeRegistry = typeRegistry;
    this.nodeIdGen = nodeIdGen;
    this.soyFileKind = soyFileKind;
    this.filePath = filePath;
    this.errorReporter = errorReporter;
  }

  /**
   * Constructor that takes a reader object providing the input.
   * @param typeRegistry The type registry for resolving type names.
   * @param nodeIdGen The node id generator for the tree being built.
   * @param input The input to parse.
   * @param soyFileKind The kind of this Soy file.
   * @param filePath The path of the source being parsed. Used for reporting.
   */
  public SoyFileParser(
      SoyTypeRegistry typeRegistry,
      IdGenerator nodeIdGen,
      Reader input,
      SoyFileKind soyFileKind,
      String filePath) {
      this(typeRegistry, nodeIdGen, input, soyFileKind, filePath, new ErrorReporterImpl());
    }

  /**
   * Constructor that takes a string input.
   * @param typeRegistry The type registry for resolving type names.
   * @param nodeIdGen The node id generator for the tree being built.
   * @param input The input to parse.
   * @param soyFileKind The kind of this Soy file.
   * @param filePath The path of the source being parsed. Used for reporting.
   * @param errorReporter For reporting parse errors.
   */
  public SoyFileParser(
      SoyTypeRegistry typeRegistry,
      IdGenerator nodeIdGen,
      String input,
      SoyFileKind soyFileKind,
      String filePath,
      ErrorReporter errorReporter) {
    this(typeRegistry, nodeIdGen, new StringReader(input), soyFileKind, filePath, errorReporter);
  }

  /**
   * Constructor that takes a string input.
   * @param typeRegistry The type registry for resolving type names.
   * @param nodeIdGen The node id generator for the tree being built.
   * @param input The input to parse.
   * @param soyFileKind The kind of this Soy file.
   * @param filePath The path of the source being parsed. Used for reporting.
   */
  public SoyFileParser(
      SoyTypeRegistry typeRegistry,
      IdGenerator nodeIdGen,
      String input,
      SoyFileKind soyFileKind,
      String filePath) {
    this(typeRegistry, nodeIdGen, input, soyFileKind, filePath, new ErrorReporterImpl());
  }

  /**
   * Attempts to parse the given input as a Soy file.
   */
  public SoyFileNode parseSoyFile() {
    Preconditions.checkNotNull(typeRegistry);
    Preconditions.checkNotNull(nodeIdGen);

    SoyFileNode soyFileNode = null;
    try {
        soyFileNode = SoyFile();
    } catch (ParseException e) {
        errorReporter.report(SourceLocation.UNKNOWN, UNCATEGORIZED, filePath, "", e.getMessage());
    } catch (SoySyntaxException e) {
        errorReporter.report(SourceLocation.UNKNOWN, UNCATEGORIZED, filePath, "", e.getMessage());
    } catch (TokenMgrError e) {
        errorReporter.report(SourceLocation.UNKNOWN, UNCATEGORIZED, filePath, "", e.getMessage());
    } catch (NullPointerException e) {
        errorReporter.report(SourceLocation.UNKNOWN, UNCATEGORIZED, filePath, "", e.getMessage());
    }

    return soyFileNode;
  }


  /**
   * Adjusts an error message generated by the template parser or template token manager so that the
   * line number is with respect to the Soy file instead of with respect to the template.
   * @param errorMsg Error message from a parser or token manager error.
   * @param templateTagLineNum The line number of the 'template' tag with respect to the Soy file.
   * @return The adjusted error message with the new line number, or the original error message if
   *     no line number is found in it.
   */
  @VisibleForTesting
  static String adjustLineNumInErrorMsg(String errorMsg, int templateTagLineNum) {

    Matcher matcher = ERROR_MSG_LINE_NUM_PAT.matcher(errorMsg);
    if (! matcher.find()) {
      // Can't find line number, so no adjustment.
      return errorMsg;
    }

    int newLineNum = templateTagLineNum + Integer.parseInt(matcher.group());
    return errorMsg.substring(0, matcher.start()) + newLineNum + errorMsg.substring(matcher.end());
  }

  final private SoyFileNode SoyFile() throws ParseException {
  Token delpackageTag, namespaceTag, aliasTag;
  TemplateNode template;
    String delpackageCmdText = null;
    String namespaceCmdText = null;
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case DELPACKAGE_TAG:
      delpackageTag = jj_consume_token(DELPACKAGE_TAG);
      int start = "{delpackage".length();
      int end = delpackageTag.image.length() - 1;
      delpackageCmdText = delpackageTag.image.substring(start, end).trim();
      break;
    default:
      jj_la1[0] = jj_gen;
      ;
    }
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case NAMESPACE_TAG:
      namespaceTag = jj_consume_token(NAMESPACE_TAG);
      int start = "{namespace".length();
      int end = namespaceTag.image.length() - 1;
      namespaceCmdText = namespaceTag.image.substring(start, end).trim();
      break;
    default:
      jj_la1[1] = jj_gen;
      ;
    }
    List<String> aliasCmdTexts = null;
    label_1:
    while (true) {
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case ALIAS_TAG:
        ;
        break;
      default:
        jj_la1[2] = jj_gen;
        break label_1;
      }
      aliasTag = jj_consume_token(ALIAS_TAG);
      int start = "{alias".length();
      int end = aliasTag.image.length() - 1;
      if (aliasCmdTexts == null) {
        aliasCmdTexts = Lists.newArrayList();
      }
      aliasCmdTexts.add(aliasTag.image.substring(start, end).trim());
    }
    SoyFileNode soyFileNode = new SoyFileNode(
        nodeIdGen.genId(), soyFileKind, delpackageCmdText, namespaceCmdText, aliasCmdTexts);
    soyFileNode.setFilePath(filePath);
    SoyFileHeaderInfo soyFileHeaderInfo = new SoyFileHeaderInfo(soyFileNode);
    label_2:
    while (true) {
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case ANY_TEMPLATE_TAG:
        ;
        break;
      default:
        jj_la1[3] = jj_gen;
        break label_2;
      }
      template = Template(soyFileHeaderInfo);
      soyFileNode.addChild(template);
    }
    jj_consume_token(0);
    {if (true) return soyFileNode;}
    throw new Error("Missing return statement in function");
  }

  final private TemplateNode Template(SoyFileHeaderInfo soyFileHeaderInfo) throws ParseException {
  Token templateTag, templateContent;
    templateTag = jj_consume_token(ANY_TEMPLATE_TAG);
    boolean isBasicTemplate = templateTag.image.startsWith("{template");

    TemplateNodeBuilder templateNodeBuilder = isBasicTemplate ?
        new TemplateBasicNodeBuilder(soyFileHeaderInfo, typeRegistry) :
        new TemplateDelegateNodeBuilder(soyFileHeaderInfo, typeRegistry);

    templateNodeBuilder.setId(nodeIdGen.genId());

    // --- Set the command text. ---
    String cmdText =
        templateTag.image.substring(isBasicTemplate ? 10 : 13, templateTag.image.length() - 1)
            .trim();
    templateNodeBuilder.setCmdText(cmdText);

    // --- Set the SoyDoc. ---
    String soyDoc;
    Token soyDocEnd = templateTag.specialToken;
    if (soyDocEnd != null && soyDocEnd.kind == SOY_DOC_END) {
      // Collect all the preceding special tokens to reconstruct the SoyDoc. The special tokens
      // should be a list of the form
      //     SOY_DOC_START ( SOY_DOC_NEWLINE | SOY_DOC_CHAR )* SOY_DOC_END
      // Note that since we're iterating in reverse, we need to prepend to the list we're building.
      List<String> soyDocParts = Lists.newArrayList();
      soyDocParts.add(0, "*/");
      for (Token st = soyDocEnd.specialToken; st.kind != SOY_DOC_START; st = st.specialToken) {
        soyDocParts.add(0, st.image);
      }
      soyDocParts.add(0, "/**");
      soyDoc = Joiner.on("").join(soyDocParts);
    } else {
      // Null means there is no preceding SoyDoc.
      soyDoc = null;
    }
    templateNodeBuilder.setSoyDoc(soyDoc);
    templateContent = jj_consume_token(TEMPLATE_CONTENT);
    List<DeclInfo> templateHeaderDecls = null;
    List<StandaloneNode> templateBodyNodes = null;
    try {
      TemplateParseResult result = new TemplateParser(
            nodeIdGen,
            templateContent.image,
            filePath,
            templateContent.beginLine,
            errorReporter)
            .parseTemplateContent();
      templateHeaderDecls = result.getHeaderDecls();
      templateBodyNodes = result.getBodyNodes();
    } catch (TokenMgrError tme) {
      String adjustedErrorMsg = adjustLineNumInErrorMsg(tme.getMessage(), templateTag.beginLine);
      errorReporter.report(
          SourceLocation.UNKNOWN,
          UNCATEGORIZED,
          filePath,
          templateNodeBuilder.getTemplateNameForUserMsgs(),
          adjustedErrorMsg);
    } catch (ParseException pe) {
      String adjustedErrorMsg = adjustLineNumInErrorMsg(pe.getMessage(), templateTag.beginLine);
      errorReporter.report(
          SourceLocation.UNKNOWN,
          UNCATEGORIZED,
          filePath,
          templateNodeBuilder.getTemplateNameForUserMsgs(),
          adjustedErrorMsg);
    } catch (SoySyntaxException sse) {
      errorReporter.report(
          SourceLocation.UNKNOWN,
          UNCATEGORIZED,
          filePath,
          templateNodeBuilder.getTemplateNameForUserMsgs(),
          sse.getMessage());
    }
    if (templateHeaderDecls != null) {
      templateNodeBuilder.setHeaderDecls(templateHeaderDecls);
    }
    TemplateNode templateNode = templateNodeBuilder.build();
    templateNode.setSourceLocation(new SourceLocation(
        filePath,
        templateTag.beginLine,
        templateTag.beginColumn,
        templateContent.endLine,
        templateContent.endColumn));
    if (templateBodyNodes != null) {
        templateNode.addChildren(templateBodyNodes);
    }
    {if (true) return templateNode;}
    throw new Error("Missing return statement in function");
  }

  /** Generated Token Manager. */
  public SoyFileParserTokenManager token_source;
  SimpleCharStream jj_input_stream;
  /** Current token. */
  public Token token;
  /** Next token. */
  public Token jj_nt;
  private int jj_ntk;
  private int jj_gen;
  final private int[] jj_la1 = new int[4];
  static private int[] jj_la1_0;
  static private int[] jj_la1_1;
  static {
      jj_la1_init_0();
      jj_la1_init_1();
   }
   private static void jj_la1_init_0() {
      jj_la1_0 = new int[] {0x2,0x20,0x200,0x80000,};
   }
   private static void jj_la1_init_1() {
      jj_la1_1 = new int[] {0x0,0x0,0x0,0x0,};
   }

  /** Constructor with InputStream. */
  public SoyFileParser(java.io.InputStream stream) {
     this(stream, null);
  }
  /** Constructor with InputStream and supplied encoding */
  public SoyFileParser(java.io.InputStream stream, String encoding) {
    try { jj_input_stream = new SimpleCharStream(stream, encoding, 1, 1); } catch(java.io.UnsupportedEncodingException e) { throw new RuntimeException(e); }
    token_source = new SoyFileParserTokenManager(jj_input_stream);
    token = new Token();
    jj_ntk = -1;
    jj_gen = 0;
    for (int i = 0; i < 4; i++) jj_la1[i] = -1;
  }

  /** Reinitialise. */
  public void ReInit(java.io.InputStream stream) {
     ReInit(stream, null);
  }
  /** Reinitialise. */
  public void ReInit(java.io.InputStream stream, String encoding) {
    try { jj_input_stream.ReInit(stream, encoding, 1, 1); } catch(java.io.UnsupportedEncodingException e) { throw new RuntimeException(e); }
    token_source.ReInit(jj_input_stream);
    token = new Token();
    jj_ntk = -1;
    jj_gen = 0;
    for (int i = 0; i < 4; i++) jj_la1[i] = -1;
  }

  /** Constructor. */
  public SoyFileParser(java.io.Reader stream) {
    jj_input_stream = new SimpleCharStream(stream, 1, 1);
    token_source = new SoyFileParserTokenManager(jj_input_stream);
    token = new Token();
    jj_ntk = -1;
    jj_gen = 0;
    for (int i = 0; i < 4; i++) jj_la1[i] = -1;
  }

  /** Reinitialise. */
  public void ReInit(java.io.Reader stream) {
    jj_input_stream.ReInit(stream, 1, 1);
    token_source.ReInit(jj_input_stream);
    token = new Token();
    jj_ntk = -1;
    jj_gen = 0;
    for (int i = 0; i < 4; i++) jj_la1[i] = -1;
  }

  /** Constructor with generated Token Manager. */
  public SoyFileParser(SoyFileParserTokenManager tm) {
    token_source = tm;
    token = new Token();
    jj_ntk = -1;
    jj_gen = 0;
    for (int i = 0; i < 4; i++) jj_la1[i] = -1;
  }

  /** Reinitialise. */
  public void ReInit(SoyFileParserTokenManager tm) {
    token_source = tm;
    token = new Token();
    jj_ntk = -1;
    jj_gen = 0;
    for (int i = 0; i < 4; i++) jj_la1[i] = -1;
  }

  private Token jj_consume_token(int kind) throws ParseException {
    Token oldToken;
    if ((oldToken = token).next != null) token = token.next;
    else token = token.next = token_source.getNextToken();
    jj_ntk = -1;
    if (token.kind == kind) {
      jj_gen++;
      return token;
    }
    token = oldToken;
    jj_kind = kind;
    throw generateParseException();
  }


/** Get the next Token. */
  final public Token getNextToken() {
    if (token.next != null) token = token.next;
    else token = token.next = token_source.getNextToken();
    jj_ntk = -1;
    jj_gen++;
    return token;
  }

/** Get the specific Token. */
  final public Token getToken(int index) {
    Token t = token;
    for (int i = 0; i < index; i++) {
      if (t.next != null) t = t.next;
      else t = t.next = token_source.getNextToken();
    }
    return t;
  }

  private int jj_ntk() {
    if ((jj_nt=token.next) == null)
      return (jj_ntk = (token.next=token_source.getNextToken()).kind);
    else
      return (jj_ntk = jj_nt.kind);
  }

  private java.util.List<int[]> jj_expentries = new java.util.ArrayList<int[]>();
  private int[] jj_expentry;
  private int jj_kind = -1;

  /** Generate ParseException. */
  public ParseException generateParseException() {
    jj_expentries.clear();
    boolean[] la1tokens = new boolean[40];
    if (jj_kind >= 0) {
      la1tokens[jj_kind] = true;
      jj_kind = -1;
    }
    for (int i = 0; i < 4; i++) {
      if (jj_la1[i] == jj_gen) {
        for (int j = 0; j < 32; j++) {
          if ((jj_la1_0[i] & (1<<j)) != 0) {
            la1tokens[j] = true;
          }
          if ((jj_la1_1[i] & (1<<j)) != 0) {
            la1tokens[32+j] = true;
          }
        }
      }
    }
    for (int i = 0; i < 40; i++) {
      if (la1tokens[i]) {
        jj_expentry = new int[1];
        jj_expentry[0] = i;
        jj_expentries.add(jj_expentry);
      }
    }
    int[][] exptokseq = new int[jj_expentries.size()][];
    for (int i = 0; i < jj_expentries.size(); i++) {
      exptokseq[i] = jj_expentries.get(i);
    }
    return new ParseException(token, exptokseq, tokenImage);
  }

  /** Enable tracing. */
  final public void enable_tracing() {
  }

  /** Disable tracing. */
  final public void disable_tracing() {
  }

}
