/* Generated By:JavaCC: Do not edit this line. ExpressionParser.java */
package com.google.template.soy.exprparse;

import com.google.common.base.CharMatcher;
import com.google.common.base.Throwables;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import com.google.template.soy.base.SourceLocation;
import com.google.template.soy.exprtree.BooleanNode;
import com.google.template.soy.exprtree.ExprNode;
import com.google.template.soy.exprtree.ExprNode.OperatorNode;
import com.google.template.soy.exprtree.ExprNode.PrimitiveNode;
import com.google.template.soy.exprtree.ExprRootNode;
import com.google.template.soy.exprtree.FieldAccessNode;
import com.google.template.soy.exprtree.FloatNode;
import com.google.template.soy.exprtree.FunctionNode;
import com.google.template.soy.exprtree.GlobalNode;
import com.google.template.soy.exprtree.IntegerNode;
import com.google.template.soy.exprtree.ItemAccessNode;
import com.google.template.soy.exprtree.ListLiteralNode;
import com.google.template.soy.exprtree.MapLiteralNode;
import com.google.template.soy.exprtree.NullNode;
import com.google.template.soy.exprtree.Operator;
import com.google.template.soy.exprtree.OperatorNodes;
import com.google.template.soy.exprtree.OperatorNodes.ConditionalOpNode;
import com.google.template.soy.exprtree.OperatorNodes.NullCoalescingOpNode;
import com.google.template.soy.exprtree.StringNode;
import com.google.template.soy.exprtree.VarNode;
import com.google.template.soy.exprtree.VarRefNode;
import com.google.template.soy.internal.base.UnescapeUtils;
import com.google.template.soy.soyparse.ErrorReporter;
import com.google.template.soy.soyparse.SoyError;

import java.io.StringReader;
import java.util.List;


/**
 * This parser's specification is in ExpressionParser.jj, which is read by JavaCC and transformed
 * into ExpressionParser.java. To modify this parser, please edit ExpressionParser.jj. Do not edit
 * ExpressionParser.java directly.
 *
 * <p> Important: Do not use outside of Soy code (treat as superpackage-private).
 *
 * <pre>
 * This parser parses several related things: variables, data references, globals, expression lists,
 * and expressions.
 *
 * A. Variable:
 *    + A dollar sign "$" followed by an identifier (no space between).
 *
 * B. Data reference:
 *    + The first part must be "$" followed by the first key name (no space between).
 *    + The first key name cannot be a number.
 *    + A variable will only have the first part. A data reference may have subsequent parts.
 *    + Subsequent parts may be:
 *       - A dot "." or question-dot "?." followed by a key name or array index (spaces between are
 *         allowed).
 *       - Brackets "[ ]" or question-brackets "?[ ]" with any expression inside the brackets (see
 *         below for definition of expression).
 *    + A special case is when the first key name is "ij". In this case, it's a reference to
 *      injected data, and the reference is considered to start from the second key (i.e. the second
 *      key actually becomes the first key in the parsed node).
 *    Examples:   $aaa   $ij.aaa   $aaa.bbb.0.ccc.12   $aaa[0]['bbb'].ccc   $aaa[$bbb + $ccc]
 *                $aaa?.bbb   $aaa.bbb?[0]?.ccc?['ddd']   $ij?.aaa
 *
 * C. Global:
 *    + One or more identifiers. If more than one, a dot "." is used to separate them.
 *    + Must not be preceded by a dollar sign "$".
 *    Examples:   AAA   aaa.bbb.CCC   a22.b88_
 *
 * D. Expression list:
 *    + A comma-separated list of one or more expressions (see below for definition of expression).
 *    Example:   $aaa, $bbb.ccc + 1, round(3.14)
 *
 * E. Expression:
 *
 *    1. Data reference:
 *       + See above for definition.
 *
 *    2. Global:
 *       + See above for definition.
 *
 *    3. Null:   null
 *
 *    4. Boolean:   false   true
 *
 *    5. Integer:
 *       + No octal numbers.
 *       + Hex numbers have strict lower case "x" in "0x" and upper case "A-F".
 *       Examples:   0   26   -729   0x1A2B
 *
 *    6. Float:
 *       + Decimal numbers only.
 *       + Must have digits on both sides of decimal point.
 *       + Exponents have strict lower case "e".
 *       Examples:   0.0   3.14159   -20.0   6.03e23   -3e-3
 *
 *    7. String:
 *       + Single quotes only.
 *       + Escape sequences:   \\   \'   \"   \n   \r   \t   \b   \f
 *       + Unicode escape:   \ u ####   (backslash, "u", four hex digits -- no spaces in between)
 *       Examples:   ''   'abc'   'blah bleh bluh'   'aa\\bb\'cc\ndd'
 *
 *    8. List literal:
 *       + Delimited by brackets.
 *       Examples:   []   ['blah', 123, $foo]
 *
 *    9. Map literal:
 *       + Delimited by brackets.
 *       + Empty map has a single colon within the brackets (to distinguish from empty list).
 *       + Keys must be strings (or expressions that will evaluate to strings).
 *       Examples:   [:]   ['aaa': 'blah', 'bbb': 123, $boo: $foo]
 *
 *    10. Operators:
 *       + Parentheses can be used to override precedence rules:   ( )
 *       + Precedence 8:   - (unary)   not
 *       + Precedence 7:   *   /   %
 *       + Precedence 6:   +   - (binary)
 *       + Precedence 5:   <   >   <=   >=
 *       + Precedence 4:   ==   !=
 *       + Precedence 3:   and
 *       + Precedence 2:   or
 *       + Precedence 1:   ?: (binary)   ? : (ternary)
 *
 *    11. Functions:
 *       + Function name, open parenthesis, optional expression list, close parenthesis.
 *       + The function name is one identifier.
 *       + See above for the definition of an expression list.
 *       Examples:   isFirst($item)   foo()   myFunction(2, 'aa')
 * </pre>
 *
 */
public final class ExpressionParser implements ExpressionParserConstants {

  public static final SoyError INVALID_EXPRESSION_LIST
      = SoyError.of("Invalid expression list");
  private static final SoyError INVALID_PARAM_NAME_IJ
      = SoyError.of("Invalid param name ''ij'' ('ij'' is for injected data ref).");
  public static final SoyError INVALID_VAR_NAME
      = SoyError.of("Invalid var name ''{0}''");
  private static final SoyError INVALID_VAR_NAME_IJ
      = SoyError.of("Invalid var name ''ij'' ('ij'' is for injected data ref).");

  private static final SoyError SINGLE_IDENTIFIER_KEY_IN_MAP_LITERAL
      = SoyError.of("Disallowed single-identifier key \u005c"{0}\u005c" in map literal "
          + "(please surround with single quotes for string or parentheses for global).");

  private static final SoyError PARSE_ERROR = SoyError.of("{0}");

  private String input;
  private SourceLocation parentSourceLocation;
  private ErrorReporter errorReporter;

  /**
   * Constructor that takes a string input.
   * @param input The input to parse.
   * @param parentSourceLocation the source location associated with the input.
   * @param errorReporter For reporting syntax errors.
   */
  public ExpressionParser(
      String input, SourceLocation parentSourceLocation, ErrorReporter errorReporter) {
    this(new StringReader(input));
    this.input = input;
    this.parentSourceLocation = parentSourceLocation;
    this.errorReporter = errorReporter;
  }


  /**
   * Parses the input as a comma-separated list of expressions.
   *
   * <p>Maintains the following invariant: an empty list is returned if and only if
   * an error is reported to the parser's {@link ErrorReporter}.
   */
  public List<ExprRootNode<? extends ExprNode>> parseExpressionList() {
    try {
      return ExprListInput();
    } catch (TokenMgrError e) {
      errorReporter.report(parentSourceLocation, INVALID_EXPRESSION_LIST);
      return ImmutableList.of();
    } catch (ParseException e) {
      errorReporter.report(parentSourceLocation, INVALID_EXPRESSION_LIST);
      return ImmutableList.of();
    }
  }


  /**
   * Parses the input as an expression.
   *
   * <p>Maintains the following invariant: an error node is returned if and only if an error
   * is reported to the parser's {@link ErrorReporter}.
   */
  public ExprRootNode<? extends ExprNode> parseExpression() {
    try {
      return ExprInput();
    } catch (ParseException e) {
      errorReporter.report(parentSourceLocation, PARSE_ERROR, e.getMessage());
      return new ExprRootNode<VarRefNode>(VarRefNode.ERROR);
    } catch (TokenMgrError e) {
      errorReporter.report(parentSourceLocation, PARSE_ERROR, e.getMessage());
      return new ExprRootNode<VarRefNode>(VarRefNode.ERROR);
    }
  }


  /**
   * Parses the input as a variable name.
   *
   * <p>Maintains the following invariant: an error node is returned if and only if an error
   * is reported to the parser's {@link ErrorReporter}.
   */
  public ExprRootNode<VarNode> parseVariable() {
    try {
      return VarInput();
    } catch (ParseException e) {
      errorReporter.report(parentSourceLocation, INVALID_VAR_NAME, input);
      return new ExprRootNode<VarNode>(VarNode.ERROR);
    } catch (TokenMgrError e) {
      errorReporter.report(parentSourceLocation, PARSE_ERROR, e.getMessage());
      return new ExprRootNode<VarNode>(VarNode.ERROR);
    }
  }


  /**
   * Parses the input as a data reference.
   *
   * <p>Maintains the following invariant: an error node is returned if and only if an error
   * is reported to the parser's {@link ErrorReporter}.
   */
  public ExprRootNode<? extends ExprNode> parseDataReference() {
    try {
      return DataRefInput();
    } catch (ParseException e) {
      errorReporter.report(parentSourceLocation, PARSE_ERROR, e.getMessage());
      return new ExprRootNode<VarRefNode>(VarRefNode.ERROR);
    } catch (TokenMgrError e) {
      errorReporter.report(parentSourceLocation, PARSE_ERROR, e.getMessage());
      return new ExprRootNode<VarRefNode>(VarRefNode.ERROR);
    }
  }


  /**
   * Parses the input as a global.
   * <p>Maintains the following invariant: an error node is returned if and only if am error
   * is reported to the parser's {@link ErrorReporter}.
   */
  public ExprRootNode<GlobalNode> parseGlobal() {
    try {
      return GlobalInput();
    } catch (ParseException e) {
      errorReporter.report(parentSourceLocation, PARSE_ERROR, e.getMessage());
      return new ExprRootNode<GlobalNode>(GlobalNode.ERROR);
    } catch (TokenMgrError e) {
      errorReporter.report(parentSourceLocation, PARSE_ERROR, e.getMessage());
      return new ExprRootNode<GlobalNode>(GlobalNode.ERROR);
    }
  }


  /**
   * Private helper to create an operator node.
   */
  private static final OperatorNode createOperatorNode(String op, int numOperands) {

    try {
      return Operator.of(op, numOperands).getNodeClass().getConstructor().newInstance();
    } catch (Exception e) {
      throw Throwables.propagate(e);
    }
  }

  private SourceLocation createSrcLoc(Token token) {
    // TODO(brndn): The Math.max fiddling is required because some callers instantiate
    // the expression parser with SourceLocation.UNKNOWN (for example, ExprParseUtils).
    return new SourceLocation(
        token.image,
        Math.max(1, parentSourceLocation.getLineNumber()),
        Math.max(1, parentSourceLocation.getBeginColumn() + token.beginColumn),
        parentSourceLocation.getLineNumber(),
        parentSourceLocation.getBeginColumn() + token.endColumn);
  }

  final private PrimitiveNode Primitive() throws ParseException {
  Token b, i, f, str;
    PrimitiveNode primitive;
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case NULL:
      jj_consume_token(NULL);
      primitive = new NullNode();
      break;
    case BOOLEAN:
      b = jj_consume_token(BOOLEAN);
      primitive = new BooleanNode(b.image.equals("true"));
      break;
    case INTEGER:
      i = jj_consume_token(INTEGER);
      if (i.image.startsWith("0x")) {
        primitive = new IntegerNode(Integer.parseInt(i.image.substring(2), 16));
      } else {
        primitive = new IntegerNode(Integer.parseInt(i.image, 10));
      }
      break;
    case FLOAT:
      f = jj_consume_token(FLOAT);
      primitive = new FloatNode(Double.parseDouble(f.image));
      break;
    case STRING:
      str = jj_consume_token(STRING);
      String strNoQuotes = str.image.substring(1, str.image.length() - 1);
      primitive = new StringNode(UnescapeUtils.unescapeJs(strNoQuotes));
      break;
    default:
      jj_la1[0] = jj_gen;
      jj_consume_token(-1);
      throw new ParseException();
    }
    {if (true) return primitive;}
    throw new Error("Missing return statement in function");
  }

  final private String UnaryOp() throws ParseException {
  Token unaryOp;
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case ONLY_UNARY_OP:
      unaryOp = jj_consume_token(ONLY_UNARY_OP);
      break;
    case UNARY_OR_BINARY_OP:
      unaryOp = jj_consume_token(UNARY_OR_BINARY_OP);
      break;
    default:
      jj_la1[1] = jj_gen;
      jj_consume_token(-1);
      throw new ParseException();
    }
    {if (true) return unaryOp.image;}
    throw new Error("Missing return statement in function");
  }

  final private String BinaryOp() throws ParseException {
  Token binaryOp;
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case ONLY_BINARY_OP:
      binaryOp = jj_consume_token(ONLY_BINARY_OP);
      break;
    case UNARY_OR_BINARY_OP:
      binaryOp = jj_consume_token(UNARY_OR_BINARY_OP);
      break;
    default:
      jj_la1[2] = jj_gen;
      jj_consume_token(-1);
      throw new ParseException();
    }
    {if (true) return binaryOp.image;}
    throw new Error("Missing return statement in function");
  }

  final private List<ExprRootNode<?>> ExprListInput() throws ParseException {
  List<ExprNode> exprList;
    exprList = ExprList();
    List<ExprRootNode<?>> rootedExprList = Lists.newArrayList();
    for (ExprNode expr : exprList) {
      rootedExprList.add(new ExprRootNode<ExprNode>(expr));
    }
    jj_consume_token(0);
    {if (true) return rootedExprList;}
    throw new Error("Missing return statement in function");
  }

  final private ExprRootNode<?> ExprInput() throws ParseException {
  ExprNode expr;
    expr = Expr();
    jj_consume_token(0);
    {if (true) return new ExprRootNode<ExprNode>(expr);}
    throw new Error("Missing return statement in function");
  }

  final private ExprRootNode<VarNode> VarInput() throws ParseException {
  VarNode var;
    var = Var();
    jj_consume_token(0);
    {if (true) return new ExprRootNode<VarNode>(var);}
    throw new Error("Missing return statement in function");
  }

  final private ExprRootNode<ExprNode> DataRefInput() throws ParseException {
  ExprNode dataRef;
    dataRef = DataRef();
    jj_consume_token(0);
    {if (true) return new ExprRootNode<ExprNode>(dataRef);}
    throw new Error("Missing return statement in function");
  }

  final private ExprRootNode<GlobalNode> GlobalInput() throws ParseException {
  GlobalNode global;
    global = Global();
    jj_consume_token(0);
    {if (true) return new ExprRootNode<GlobalNode>(global);}
    throw new Error("Missing return statement in function");
  }

  final private List<ExprNode> ExprList() throws ParseException {
  ExprNode expr;
    List<ExprNode> exprList = Lists.newArrayList();
    expr = Expr();
    exprList.add(expr);
    label_1:
    while (true) {
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case 18:
        ;
        break;
      default:
        jj_la1[3] = jj_gen;
        break label_1;
      }
      jj_consume_token(18);
      expr = Expr();
      exprList.add(expr);
    }
    {if (true) return exprList;}
    throw new Error("Missing return statement in function");
  }

  final private ExprNode Expr() throws ParseException {
  ExprNode expr;
    expr = PrecExpr1();
    {if (true) return expr;}
    throw new Error("Missing return statement in function");
  }

  final private ExprNode PrecExpr1() throws ParseException {
  ExprNode expr1, expr2;
    ExprNode expr;
    expr = PrecExpr(2);
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case 19:
    case 20:
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case 19:
        jj_consume_token(19);
        expr1 = PrecExpr1();
        NullCoalescingOpNode nullCoal = new OperatorNodes.NullCoalescingOpNode();
        nullCoal.addChild(expr);
        nullCoal.addChild(expr1);
        expr = nullCoal;
        break;
      case 20:
        jj_consume_token(20);
        expr1 = PrecExpr1();
        jj_consume_token(21);
        expr2 = PrecExpr1();
        ConditionalOpNode cond = new OperatorNodes.ConditionalOpNode();
        cond.addChild(expr);
        cond.addChild(expr1);
        cond.addChild(expr2);
        expr = cond;
        break;
      default:
        jj_la1[4] = jj_gen;
        jj_consume_token(-1);
        throw new ParseException();
      }
      break;
    default:
      jj_la1[5] = jj_gen;
      ;
    }
    {if (true) return expr;}
    throw new Error("Missing return statement in function");
  }

  final private ExprNode PrecExpr(int minPrec) throws ParseException {
  String binaryOp;
  ExprNode rightOperand;
    ExprNode expr;
    expr = Primary();
    label_2:
    while (true) {
      if (jj_2_1(2147483647) && (Operator.of(getToken(1).image, 2).getPrecedence() >= minPrec)) {
        ;
      } else {
        break label_2;
      }
      binaryOp = BinaryOp();
      rightOperand = PrecExpr(Operator.of(binaryOp, 2).getPrecedence() + 1);
      OperatorNode opNode = createOperatorNode(binaryOp, 2);
      opNode.addChild(expr);  // expr is the current left operand
      opNode.addChild(rightOperand);
      expr = opNode;
    }
    {if (true) return expr;}
    throw new Error("Missing return statement in function");
  }

  final private ExprNode Primary() throws ParseException {
  String unaryOp;
  ExprNode operand;
    ExprNode primary;
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case 22:
      jj_consume_token(22);
      primary = Expr();
      jj_consume_token(23);
      break;
    case UNARY_OR_BINARY_OP:
    case ONLY_UNARY_OP:
      unaryOp = UnaryOp();
      operand = PrecExpr(Operator.of(unaryOp, 1).getPrecedence());
      OperatorNode opNode = createOperatorNode(unaryOp, 1);
      opNode.addChild(operand);
      primary = opNode;
      break;
    default:
      jj_la1[6] = jj_gen;
      if (jj_2_2(2147483647)) {
        primary = FunctionCall();
      } else {
        switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
        case DOLLAR_IDENT:
        case 26:
        case 27:
          primary = DataRef();
          break;
        case IDENT:
          primary = Global();
          break;
        default:
          jj_la1[7] = jj_gen;
          if (jj_2_3(2147483647)) {
            primary = ListLiteral();
          } else {
            switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
            case 24:
              primary = MapLiteral();
              break;
            case NULL:
            case BOOLEAN:
            case INTEGER:
            case FLOAT:
            case STRING:
              primary = Primitive();
              break;
            default:
              jj_la1[8] = jj_gen;
              jj_consume_token(-1);
              throw new ParseException();
            }
          }
        }
      }
    }
    {if (true) return primary;}
    throw new Error("Missing return statement in function");
  }

  final private VarNode Var() throws ParseException {
  Token dollarIdent;
    dollarIdent = jj_consume_token(DOLLAR_IDENT);
    String identStr = dollarIdent.image.substring(1);
    if (identStr.equals("ij")) {
      errorReporter.report(createSrcLoc(dollarIdent), INVALID_VAR_NAME_IJ);
    }
    {if (true) return new VarNode(identStr);}
    throw new Error("Missing return statement in function");
  }

  final private ExprNode DataRef() throws ParseException {
  Token ident, dollarIdent, integer;
  Token dotIdent, questionDotIdent, dotIndex, questionDotIndex;
  ExprNode expr;
    ExprNode dataRef;
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case 26:
      jj_consume_token(26);
      ident = jj_consume_token(IDENT);
      dataRef = new VarRefNode(ident.image, true, false, null);
      break;
    case 27:
      jj_consume_token(27);
      ident = jj_consume_token(IDENT);
      dataRef = new VarRefNode(ident.image, true, true, null);
      break;
    case DOLLAR_IDENT:
      dollarIdent = jj_consume_token(DOLLAR_IDENT);
      String identStr = dollarIdent.image.substring(1);
      if (identStr.equals("ij")) {
        errorReporter.report(createSrcLoc(dollarIdent), INVALID_PARAM_NAME_IJ);
      }
      dataRef = new VarRefNode(identStr, false, false, null);
      break;
    default:
      jj_la1[9] = jj_gen;
      jj_consume_token(-1);
      throw new ParseException();
    }
    label_3:
    while (true) {
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case DOT_IDENT:
      case QUESTION_DOT_IDENT:
      case DOT_INDEX:
      case QUESTION_DOT_INDEX:
      case 24:
      case 28:
        ;
        break;
      default:
        jj_la1[10] = jj_gen;
        break label_3;
      }
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case DOT_IDENT:
        dotIdent = jj_consume_token(DOT_IDENT);
      dataRef = new FieldAccessNode(dataRef, dotIdent.image.substring(1), false);
        break;
      case QUESTION_DOT_IDENT:
        questionDotIdent = jj_consume_token(QUESTION_DOT_IDENT);
      dataRef = new FieldAccessNode(dataRef, questionDotIdent.image.substring(2), true);
        break;
      case DOT_INDEX:
        dotIndex = jj_consume_token(DOT_INDEX);
      dataRef = new ItemAccessNode(dataRef,
          new IntegerNode(Integer.parseInt(dotIndex.image.substring(1))), false, true);
        break;
      case QUESTION_DOT_INDEX:
        questionDotIndex = jj_consume_token(QUESTION_DOT_INDEX);
      dataRef = new ItemAccessNode(dataRef,
          new IntegerNode(Integer.parseInt(questionDotIndex.image.substring(2))), true, true);
        break;
      case 24:
        jj_consume_token(24);
        expr = Expr();
        jj_consume_token(25);
      dataRef = new ItemAccessNode(dataRef, expr, false, false);
        break;
      case 28:
        jj_consume_token(28);
        expr = Expr();
        jj_consume_token(25);
      dataRef = new ItemAccessNode(dataRef, expr, true, false);
        break;
      default:
        jj_la1[11] = jj_gen;
        jj_consume_token(-1);
        throw new ParseException();
      }
    }
    {if (true) return dataRef;}
    throw new Error("Missing return statement in function");
  }

  final private GlobalNode Global() throws ParseException {
  Token ident, dotIdent;
     StringBuilder globalNameSb = new StringBuilder();
    ident = jj_consume_token(IDENT);
    globalNameSb.append(ident.image);
    label_4:
    while (true) {
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case DOT_IDENT:
        ;
        break;
      default:
        jj_la1[12] = jj_gen;
        break label_4;
      }
      dotIdent = jj_consume_token(DOT_IDENT);
      globalNameSb.append(dotIdent.image);
    }
    {if (true) return new GlobalNode(globalNameSb.toString());}
    throw new Error("Missing return statement in function");
  }

  final private FunctionNode FunctionCall() throws ParseException {
  Token ident;
  List<ExprNode> exprList;
    ident = jj_consume_token(IDENT);
    jj_consume_token(22);
    exprList = null;
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case NULL:
    case BOOLEAN:
    case INTEGER:
    case FLOAT:
    case STRING:
    case UNARY_OR_BINARY_OP:
    case ONLY_UNARY_OP:
    case IDENT:
    case DOLLAR_IDENT:
    case 22:
    case 24:
    case 26:
    case 27:
      exprList = ExprList();
      break;
    default:
      jj_la1[13] = jj_gen;
      ;
    }
    jj_consume_token(23);
    FunctionNode fnNode = new FunctionNode(ident.image);
    if (exprList != null) {
      fnNode.addChildren(exprList);
    }
    {if (true) return fnNode;}
    throw new Error("Missing return statement in function");
  }

  final private ListLiteralNode ListLiteral() throws ParseException {
  ExprNode itemExpr;
    List<ExprNode> items = Lists.newArrayList();
    jj_consume_token(24);
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case NULL:
    case BOOLEAN:
    case INTEGER:
    case FLOAT:
    case STRING:
    case UNARY_OR_BINARY_OP:
    case ONLY_UNARY_OP:
    case IDENT:
    case DOLLAR_IDENT:
    case 22:
    case 24:
    case 26:
    case 27:
      itemExpr = Expr();
      items.add(itemExpr);
      label_5:
      while (true) {
        if (jj_2_4(2147483647)) {
          ;
        } else {
          break label_5;
        }
        jj_consume_token(18);
        itemExpr = Expr();
        items.add(itemExpr);
      }
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case 18:
        jj_consume_token(18);
        break;
      default:
        jj_la1[14] = jj_gen;
        ;
      }
      break;
    default:
      jj_la1[15] = jj_gen;
      ;
    }
    jj_consume_token(25);
    {if (true) return new ListLiteralNode(items);}
    throw new Error("Missing return statement in function");
  }

  final private MapLiteralNode MapLiteral() throws ParseException {
  Token ident;
  ExprNode keyExpr, valueExpr;
    List<ExprNode> alternatingKeysAndValues = Lists.newArrayList();
    jj_consume_token(24);
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case 21:
      jj_consume_token(21);
      break;
    case NULL:
    case BOOLEAN:
    case INTEGER:
    case FLOAT:
    case STRING:
    case UNARY_OR_BINARY_OP:
    case ONLY_UNARY_OP:
    case IDENT:
    case DOLLAR_IDENT:
    case 22:
    case 24:
    case 26:
    case 27:
      if (jj_2_5(2147483647)) {
        ident = jj_consume_token(IDENT);
        errorReporter.report(
            createSrcLoc(ident), SINGLE_IDENTIFIER_KEY_IN_MAP_LITERAL, ident.image);
      } else {
        ;
      }
      keyExpr = Expr();
      alternatingKeysAndValues.add(keyExpr);
      jj_consume_token(21);
      valueExpr = Expr();
      alternatingKeysAndValues.add(valueExpr);
      label_6:
      while (true) {
        if (jj_2_6(2147483647)) {
          ;
        } else {
          break label_6;
        }
        jj_consume_token(18);
        if (jj_2_7(2147483647)) {
          ident = jj_consume_token(IDENT);
          errorReporter.report(
              createSrcLoc(ident), SINGLE_IDENTIFIER_KEY_IN_MAP_LITERAL, ident.image);
        } else {
          ;
        }
        keyExpr = Expr();
        alternatingKeysAndValues.add(keyExpr);
        jj_consume_token(21);
        valueExpr = Expr();
        alternatingKeysAndValues.add(valueExpr);
      }
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case 18:
        jj_consume_token(18);
        break;
      default:
        jj_la1[16] = jj_gen;
        ;
      }
      break;
    default:
      jj_la1[17] = jj_gen;
      jj_consume_token(-1);
      throw new ParseException();
    }
    jj_consume_token(25);
    {if (true) return new MapLiteralNode(alternatingKeysAndValues);}
    throw new Error("Missing return statement in function");
  }

  private boolean jj_2_1(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return !jj_3_1(); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(0, xla); }
  }

  private boolean jj_2_2(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return !jj_3_2(); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(1, xla); }
  }

  private boolean jj_2_3(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return !jj_3_3(); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(2, xla); }
  }

  private boolean jj_2_4(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return !jj_3_4(); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(3, xla); }
  }

  private boolean jj_2_5(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return !jj_3_5(); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(4, xla); }
  }

  private boolean jj_2_6(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return !jj_3_6(); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(5, xla); }
  }

  private boolean jj_2_7(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return !jj_3_7(); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(6, xla); }
  }

  private boolean jj_3R_53() {
    if (jj_scan_token(IDENT)) return true;
    return false;
  }

  private boolean jj_3_3() {
    if (jj_scan_token(24)) return true;
    Token xsp;
    xsp = jj_scanpos;
    if (jj_scan_token(25)) {
    jj_scanpos = xsp;
    if (jj_3R_8()) return true;
    }
    return false;
  }

  private boolean jj_3R_28() {
    if (jj_scan_token(IDENT)) return true;
    Token xsp;
    while (true) {
      xsp = jj_scanpos;
      if (jj_3R_37()) { jj_scanpos = xsp; break; }
    }
    return false;
  }

  private boolean jj_3R_39() {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_53()) jj_scanpos = xsp;
    if (jj_3R_9()) return true;
    if (jj_scan_token(21)) return true;
    if (jj_3R_9()) return true;
    while (true) {
      xsp = jj_scanpos;
      if (jj_3R_54()) { jj_scanpos = xsp; break; }
    }
    xsp = jj_scanpos;
    if (jj_scan_token(18)) jj_scanpos = xsp;
    return false;
  }

  private boolean jj_3R_25() {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_scan_token(9)) {
    jj_scanpos = xsp;
    if (jj_scan_token(8)) return true;
    }
    return false;
  }

  private boolean jj_3R_24() {
    if (jj_3R_31()) return true;
    return false;
  }

  private boolean jj_3_2() {
    if (jj_scan_token(IDENT)) return true;
    if (jj_scan_token(22)) return true;
    return false;
  }

  private boolean jj_3R_23() {
    if (jj_3R_30()) return true;
    return false;
  }

  private boolean jj_3R_30() {
    if (jj_scan_token(24)) return true;
    Token xsp;
    xsp = jj_scanpos;
    if (jj_scan_token(21)) {
    jj_scanpos = xsp;
    if (jj_3R_39()) return true;
    }
    if (jj_scan_token(25)) return true;
    return false;
  }

  private boolean jj_3R_16() {
    if (jj_scan_token(20)) return true;
    if (jj_3R_10()) return true;
    if (jj_scan_token(21)) return true;
    if (jj_3R_10()) return true;
    return false;
  }

  private boolean jj_3R_22() {
    if (jj_3R_29()) return true;
    return false;
  }

  private boolean jj_3R_21() {
    if (jj_3R_28()) return true;
    return false;
  }

  private boolean jj_3R_20() {
    if (jj_3R_27()) return true;
    return false;
  }

  private boolean jj_3R_51() {
    if (jj_scan_token(28)) return true;
    if (jj_3R_9()) return true;
    if (jj_scan_token(25)) return true;
    return false;
  }

  private boolean jj_3R_19() {
    if (jj_3R_26()) return true;
    return false;
  }

  private boolean jj_3R_15() {
    if (jj_scan_token(19)) return true;
    if (jj_3R_10()) return true;
    return false;
  }

  private boolean jj_3R_44() {
    if (jj_scan_token(STRING)) return true;
    return false;
  }

  private boolean jj_3R_50() {
    if (jj_scan_token(24)) return true;
    if (jj_3R_9()) return true;
    if (jj_scan_token(25)) return true;
    return false;
  }

  private boolean jj_3R_12() {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_15()) {
    jj_scanpos = xsp;
    if (jj_3R_16()) return true;
    }
    return false;
  }

  private boolean jj_3R_43() {
    if (jj_scan_token(FLOAT)) return true;
    return false;
  }

  private boolean jj_3R_18() {
    if (jj_3R_25()) return true;
    if (jj_3R_11()) return true;
    return false;
  }

  private boolean jj_3_4() {
    if (jj_scan_token(18)) return true;
    if (jj_3R_9()) return true;
    return false;
  }

  private boolean jj_3R_49() {
    if (jj_scan_token(QUESTION_DOT_INDEX)) return true;
    return false;
  }

  private boolean jj_3R_17() {
    if (jj_scan_token(22)) return true;
    if (jj_3R_9()) return true;
    if (jj_scan_token(23)) return true;
    return false;
  }

  private boolean jj_3R_10() {
    if (jj_3R_11()) return true;
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_12()) jj_scanpos = xsp;
    return false;
  }

  private boolean jj_3R_48() {
    if (jj_scan_token(DOT_INDEX)) return true;
    return false;
  }

  private boolean jj_3R_42() {
    if (jj_scan_token(INTEGER)) return true;
    return false;
  }

  private boolean jj_3R_13() {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_17()) {
    jj_scanpos = xsp;
    if (jj_3R_18()) {
    jj_scanpos = xsp;
    if (jj_3R_19()) {
    jj_scanpos = xsp;
    if (jj_3R_20()) {
    jj_scanpos = xsp;
    if (jj_3R_21()) {
    jj_scanpos = xsp;
    if (jj_3R_22()) {
    jj_scanpos = xsp;
    if (jj_3R_23()) {
    jj_scanpos = xsp;
    if (jj_3R_24()) return true;
    }
    }
    }
    }
    }
    }
    }
    return false;
  }

  private boolean jj_3R_47() {
    if (jj_scan_token(QUESTION_DOT_IDENT)) return true;
    return false;
  }

  private boolean jj_3R_41() {
    if (jj_scan_token(BOOLEAN)) return true;
    return false;
  }

  private boolean jj_3R_52() {
    if (jj_scan_token(18)) return true;
    if (jj_3R_9()) return true;
    return false;
  }

  private boolean jj_3R_46() {
    if (jj_scan_token(DOT_IDENT)) return true;
    return false;
  }

  private boolean jj_3R_40() {
    if (jj_scan_token(NULL)) return true;
    return false;
  }

  private boolean jj_3R_36() {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_46()) {
    jj_scanpos = xsp;
    if (jj_3R_47()) {
    jj_scanpos = xsp;
    if (jj_3R_48()) {
    jj_scanpos = xsp;
    if (jj_3R_49()) {
    jj_scanpos = xsp;
    if (jj_3R_50()) {
    jj_scanpos = xsp;
    if (jj_3R_51()) return true;
    }
    }
    }
    }
    }
    return false;
  }

  private boolean jj_3R_38() {
    if (jj_3R_9()) return true;
    Token xsp;
    while (true) {
      xsp = jj_scanpos;
      if (jj_3R_52()) { jj_scanpos = xsp; break; }
    }
    xsp = jj_scanpos;
    if (jj_scan_token(18)) jj_scanpos = xsp;
    return false;
  }

  private boolean jj_3R_31() {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_40()) {
    jj_scanpos = xsp;
    if (jj_3R_41()) {
    jj_scanpos = xsp;
    if (jj_3R_42()) {
    jj_scanpos = xsp;
    if (jj_3R_43()) {
    jj_scanpos = xsp;
    if (jj_3R_44()) return true;
    }
    }
    }
    }
    return false;
  }

  private boolean jj_3R_35() {
    if (jj_scan_token(DOLLAR_IDENT)) return true;
    return false;
  }

  private boolean jj_3R_9() {
    if (jj_3R_10()) return true;
    return false;
  }

  private boolean jj_3R_29() {
    if (jj_scan_token(24)) return true;
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_38()) jj_scanpos = xsp;
    if (jj_scan_token(25)) return true;
    return false;
  }

  private boolean jj_3_1() {
    if (jj_3R_7()) return true;
    return false;
  }

  private boolean jj_3R_34() {
    if (jj_scan_token(27)) return true;
    if (jj_scan_token(IDENT)) return true;
    return false;
  }

  private boolean jj_3R_33() {
    if (jj_scan_token(26)) return true;
    if (jj_scan_token(IDENT)) return true;
    return false;
  }

  private boolean jj_3R_14() {
    if (jj_3R_7()) return true;
    if (jj_3R_11()) return true;
    return false;
  }

  private boolean jj_3R_27() {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_33()) {
    jj_scanpos = xsp;
    if (jj_3R_34()) {
    jj_scanpos = xsp;
    if (jj_3R_35()) return true;
    }
    }
    while (true) {
      xsp = jj_scanpos;
      if (jj_3R_36()) { jj_scanpos = xsp; break; }
    }
    return false;
  }

  private boolean jj_3_7() {
    if (jj_scan_token(IDENT)) return true;
    if (jj_scan_token(21)) return true;
    return false;
  }

  private boolean jj_3R_55() {
    if (jj_scan_token(18)) return true;
    if (jj_3R_9()) return true;
    return false;
  }

  private boolean jj_3R_32() {
    if (jj_3R_45()) return true;
    return false;
  }

  private boolean jj_3R_11() {
    if (jj_3R_13()) return true;
    Token xsp;
    while (true) {
      xsp = jj_scanpos;
      if (jj_3R_14()) { jj_scanpos = xsp; break; }
    }
    return false;
  }

  private boolean jj_3_6() {
    if (jj_scan_token(18)) return true;
    if (jj_3R_9()) return true;
    return false;
  }

  private boolean jj_3R_45() {
    if (jj_3R_9()) return true;
    Token xsp;
    while (true) {
      xsp = jj_scanpos;
      if (jj_3R_55()) { jj_scanpos = xsp; break; }
    }
    return false;
  }

  private boolean jj_3R_56() {
    if (jj_scan_token(IDENT)) return true;
    return false;
  }

  private boolean jj_3R_26() {
    if (jj_scan_token(IDENT)) return true;
    if (jj_scan_token(22)) return true;
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_32()) jj_scanpos = xsp;
    if (jj_scan_token(23)) return true;
    return false;
  }

  private boolean jj_3R_54() {
    if (jj_scan_token(18)) return true;
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_56()) jj_scanpos = xsp;
    if (jj_3R_9()) return true;
    if (jj_scan_token(21)) return true;
    if (jj_3R_9()) return true;
    return false;
  }

  private boolean jj_3R_8() {
    if (jj_3R_9()) return true;
    Token xsp;
    xsp = jj_scanpos;
    if (jj_scan_token(18)) {
    jj_scanpos = xsp;
    if (jj_scan_token(25)) return true;
    }
    return false;
  }

  private boolean jj_3_5() {
    if (jj_scan_token(IDENT)) return true;
    if (jj_scan_token(21)) return true;
    return false;
  }

  private boolean jj_3R_7() {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_scan_token(10)) {
    jj_scanpos = xsp;
    if (jj_scan_token(8)) return true;
    }
    return false;
  }

  private boolean jj_3R_37() {
    if (jj_scan_token(DOT_IDENT)) return true;
    return false;
  }

  /** Generated Token Manager. */
  public ExpressionParserTokenManager token_source;
  SimpleCharStream jj_input_stream;
  /** Current token. */
  public Token token;
  /** Next token. */
  public Token jj_nt;
  private int jj_ntk;
  private Token jj_scanpos, jj_lastpos;
  private int jj_la;
  private int jj_gen;
  final private int[] jj_la1 = new int[18];
  static private int[] jj_la1_0;
  static {
      jj_la1_init_0();
   }
   private static void jj_la1_init_0() {
      jj_la1_0 = new int[] {0x3e,0x300,0x500,0x40000,0x180000,0x180000,0x400300,0xc001800,0x100003e,0xc001000,0x1101e000,0x1101e000,0x2000,0xd401b3e,0x40000,0xd401b3e,0x40000,0xd601b3e,};
   }
  final private JJCalls[] jj_2_rtns = new JJCalls[7];
  private boolean jj_rescan = false;
  private int jj_gc = 0;

  /** Constructor with InputStream. */
  public ExpressionParser(java.io.InputStream stream) {
     this(stream, null);
  }
  /** Constructor with InputStream and supplied encoding */
  public ExpressionParser(java.io.InputStream stream, String encoding) {
    try { jj_input_stream = new SimpleCharStream(stream, encoding, 1, 1); } catch(java.io.UnsupportedEncodingException e) { throw new RuntimeException(e); }
    token_source = new ExpressionParserTokenManager(jj_input_stream);
    token = new Token();
    jj_ntk = -1;
    jj_gen = 0;
    for (int i = 0; i < 18; i++) jj_la1[i] = -1;
    for (int i = 0; i < jj_2_rtns.length; i++) jj_2_rtns[i] = new JJCalls();
  }

  /** Reinitialise. */
  public void ReInit(java.io.InputStream stream) {
     ReInit(stream, null);
  }
  /** Reinitialise. */
  public void ReInit(java.io.InputStream stream, String encoding) {
    try { jj_input_stream.ReInit(stream, encoding, 1, 1); } catch(java.io.UnsupportedEncodingException e) { throw new RuntimeException(e); }
    token_source.ReInit(jj_input_stream);
    token = new Token();
    jj_ntk = -1;
    jj_gen = 0;
    for (int i = 0; i < 18; i++) jj_la1[i] = -1;
    for (int i = 0; i < jj_2_rtns.length; i++) jj_2_rtns[i] = new JJCalls();
  }

  /** Constructor. */
  public ExpressionParser(java.io.Reader stream) {
    jj_input_stream = new SimpleCharStream(stream, 1, 1);
    token_source = new ExpressionParserTokenManager(jj_input_stream);
    token = new Token();
    jj_ntk = -1;
    jj_gen = 0;
    for (int i = 0; i < 18; i++) jj_la1[i] = -1;
    for (int i = 0; i < jj_2_rtns.length; i++) jj_2_rtns[i] = new JJCalls();
  }

  /** Reinitialise. */
  public void ReInit(java.io.Reader stream) {
    jj_input_stream.ReInit(stream, 1, 1);
    token_source.ReInit(jj_input_stream);
    token = new Token();
    jj_ntk = -1;
    jj_gen = 0;
    for (int i = 0; i < 18; i++) jj_la1[i] = -1;
    for (int i = 0; i < jj_2_rtns.length; i++) jj_2_rtns[i] = new JJCalls();
  }

  /** Constructor with generated Token Manager. */
  public ExpressionParser(ExpressionParserTokenManager tm) {
    token_source = tm;
    token = new Token();
    jj_ntk = -1;
    jj_gen = 0;
    for (int i = 0; i < 18; i++) jj_la1[i] = -1;
    for (int i = 0; i < jj_2_rtns.length; i++) jj_2_rtns[i] = new JJCalls();
  }

  /** Reinitialise. */
  public void ReInit(ExpressionParserTokenManager tm) {
    token_source = tm;
    token = new Token();
    jj_ntk = -1;
    jj_gen = 0;
    for (int i = 0; i < 18; i++) jj_la1[i] = -1;
    for (int i = 0; i < jj_2_rtns.length; i++) jj_2_rtns[i] = new JJCalls();
  }

  private Token jj_consume_token(int kind) throws ParseException {
    Token oldToken;
    if ((oldToken = token).next != null) token = token.next;
    else token = token.next = token_source.getNextToken();
    jj_ntk = -1;
    if (token.kind == kind) {
      jj_gen++;
      if (++jj_gc > 100) {
        jj_gc = 0;
        for (int i = 0; i < jj_2_rtns.length; i++) {
          JJCalls c = jj_2_rtns[i];
          while (c != null) {
            if (c.gen < jj_gen) c.first = null;
            c = c.next;
          }
        }
      }
      return token;
    }
    token = oldToken;
    jj_kind = kind;
    throw generateParseException();
  }

  static private final class LookaheadSuccess extends java.lang.Error { }
  final private LookaheadSuccess jj_ls = new LookaheadSuccess();
  private boolean jj_scan_token(int kind) {
    if (jj_scanpos == jj_lastpos) {
      jj_la--;
      if (jj_scanpos.next == null) {
        jj_lastpos = jj_scanpos = jj_scanpos.next = token_source.getNextToken();
      } else {
        jj_lastpos = jj_scanpos = jj_scanpos.next;
      }
    } else {
      jj_scanpos = jj_scanpos.next;
    }
    if (jj_rescan) {
      int i = 0; Token tok = token;
      while (tok != null && tok != jj_scanpos) { i++; tok = tok.next; }
      if (tok != null) jj_add_error_token(kind, i);
    }
    if (jj_scanpos.kind != kind) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) throw jj_ls;
    return false;
  }


/** Get the next Token. */
  final public Token getNextToken() {
    if (token.next != null) token = token.next;
    else token = token.next = token_source.getNextToken();
    jj_ntk = -1;
    jj_gen++;
    return token;
  }

/** Get the specific Token. */
  final public Token getToken(int index) {
    Token t = token;
    for (int i = 0; i < index; i++) {
      if (t.next != null) t = t.next;
      else t = t.next = token_source.getNextToken();
    }
    return t;
  }

  private int jj_ntk() {
    if ((jj_nt=token.next) == null)
      return (jj_ntk = (token.next=token_source.getNextToken()).kind);
    else
      return (jj_ntk = jj_nt.kind);
  }

  private java.util.List<int[]> jj_expentries = new java.util.ArrayList<int[]>();
  private int[] jj_expentry;
  private int jj_kind = -1;
  private int[] jj_lasttokens = new int[100];
  private int jj_endpos;

  private void jj_add_error_token(int kind, int pos) {
    if (pos >= 100) return;
    if (pos == jj_endpos + 1) {
      jj_lasttokens[jj_endpos++] = kind;
    } else if (jj_endpos != 0) {
      jj_expentry = new int[jj_endpos];
      for (int i = 0; i < jj_endpos; i++) {
        jj_expentry[i] = jj_lasttokens[i];
      }
      jj_entries_loop: for (java.util.Iterator<?> it = jj_expentries.iterator(); it.hasNext();) {
        int[] oldentry = (int[])(it.next());
        if (oldentry.length == jj_expentry.length) {
          for (int i = 0; i < jj_expentry.length; i++) {
            if (oldentry[i] != jj_expentry[i]) {
              continue jj_entries_loop;
            }
          }
          jj_expentries.add(jj_expentry);
          break jj_entries_loop;
        }
      }
      if (pos != 0) jj_lasttokens[(jj_endpos = pos) - 1] = kind;
    }
  }

  /** Generate ParseException. */
  public ParseException generateParseException() {
    jj_expentries.clear();
    boolean[] la1tokens = new boolean[29];
    if (jj_kind >= 0) {
      la1tokens[jj_kind] = true;
      jj_kind = -1;
    }
    for (int i = 0; i < 18; i++) {
      if (jj_la1[i] == jj_gen) {
        for (int j = 0; j < 32; j++) {
          if ((jj_la1_0[i] & (1<<j)) != 0) {
            la1tokens[j] = true;
          }
        }
      }
    }
    for (int i = 0; i < 29; i++) {
      if (la1tokens[i]) {
        jj_expentry = new int[1];
        jj_expentry[0] = i;
        jj_expentries.add(jj_expentry);
      }
    }
    jj_endpos = 0;
    jj_rescan_token();
    jj_add_error_token(0, 0);
    int[][] exptokseq = new int[jj_expentries.size()][];
    for (int i = 0; i < jj_expentries.size(); i++) {
      exptokseq[i] = jj_expentries.get(i);
    }
    return new ParseException(token, exptokseq, tokenImage);
  }

  /** Enable tracing. */
  final public void enable_tracing() {
  }

  /** Disable tracing. */
  final public void disable_tracing() {
  }

  private void jj_rescan_token() {
    jj_rescan = true;
    for (int i = 0; i < 7; i++) {
    try {
      JJCalls p = jj_2_rtns[i];
      do {
        if (p.gen > jj_gen) {
          jj_la = p.arg; jj_lastpos = jj_scanpos = p.first;
          switch (i) {
            case 0: jj_3_1(); break;
            case 1: jj_3_2(); break;
            case 2: jj_3_3(); break;
            case 3: jj_3_4(); break;
            case 4: jj_3_5(); break;
            case 5: jj_3_6(); break;
            case 6: jj_3_7(); break;
          }
        }
        p = p.next;
      } while (p != null);
      } catch(LookaheadSuccess ls) { }
    }
    jj_rescan = false;
  }

  private void jj_save(int index, int xla) {
    JJCalls p = jj_2_rtns[index];
    while (p.gen > jj_gen) {
      if (p.next == null) { p = p.next = new JJCalls(); break; }
      p = p.next;
    }
    p.gen = jj_gen + xla - jj_la; p.first = token; p.arg = xla;
  }

  static final class JJCalls {
    int gen;
    Token first;
    int arg;
    JJCalls next;
  }

}
