/*
 * Decompiled with CFR 0.152.
 */
package com.google.template.soy.soytree;

import com.google.template.soy.base.SourceLocation;
import com.google.template.soy.base.SoySyntaxException;
import com.google.template.soy.exprparse.ExprParseUtils;
import com.google.template.soy.exprtree.ExprRootNode;
import com.google.template.soy.exprtree.StringNode;
import com.google.template.soy.soyparse.ErrorReporter;
import com.google.template.soy.soyparse.TransitionalThrowingErrorReporter;
import com.google.template.soy.soytree.CaseOrDefaultNode;
import com.google.template.soy.soytree.SoyNode;

public final class MsgSelectCaseNode
extends CaseOrDefaultNode
implements SoyNode.MsgBlockNode {
    private final String caseValue;

    private MsgSelectCaseNode(int id, String commandText, String caseValue) {
        super(id, "case", commandText);
        this.caseValue = caseValue;
    }

    protected MsgSelectCaseNode(MsgSelectCaseNode orig) {
        super(orig);
        this.caseValue = orig.caseValue;
    }

    @Override
    public SoyNode.Kind getKind() {
        return SoyNode.Kind.MSG_SELECT_CASE_NODE;
    }

    public String getCaseValue() {
        return this.caseValue;
    }

    @Override
    public MsgSelectCaseNode clone() {
        return new MsgSelectCaseNode(this);
    }

    public static final class Builder {
        public static final MsgSelectCaseNode ERROR = new MsgSelectCaseNode(-1, "error", "error");
        private final int id;
        private final String commandText;
        private final SourceLocation sourceLocation;

        public Builder(int id, String commandText, SourceLocation sourceLocation) {
            this.id = id;
            this.commandText = commandText;
            this.sourceLocation = sourceLocation;
        }

        public MsgSelectCaseNode build(ErrorReporter errorReporter) {
            ExprRootNode<?> strLit;
            ErrorReporter.Checkpoint checkpoint = errorReporter.checkpoint();
            try {
                strLit = ExprParseUtils.parseExprElseThrowSoySyntaxException(this.commandText, "Invalid expression in 'case' command text \"" + this.commandText + "\".");
            }
            catch (SoySyntaxException e) {
                errorReporter.report(e);
                return ERROR;
            }
            if (strLit.numChildren() != 1 || !(strLit.getChild(0) instanceof StringNode)) {
                errorReporter.report(SoySyntaxException.createWithMetaInfo("Invalid string for select 'case'.", this.sourceLocation));
            }
            String caseValue = ((StringNode)strLit.getChild(0)).getValue();
            if (errorReporter.errorsSince(checkpoint)) {
                return ERROR;
            }
            MsgSelectCaseNode node = new MsgSelectCaseNode(this.id, this.commandText, caseValue);
            node.setSourceLocation(this.sourceLocation);
            return node;
        }

        public MsgSelectCaseNode buildAndThrowIfInvalid() {
            TransitionalThrowingErrorReporter errorReporter = new TransitionalThrowingErrorReporter();
            MsgSelectCaseNode node = this.build(errorReporter);
            errorReporter.throwIfErrorsPresent();
            return node;
        }
    }
}

