/*
 * Decompiled with CFR 0.152.
 */
package com.google.template.soy.soytree;

import com.google.template.soy.base.SourceLocation;
import com.google.template.soy.base.SoySyntaxException;
import com.google.template.soy.soyparse.ErrorReporter;
import com.google.template.soy.soytree.CaseOrDefaultNode;
import com.google.template.soy.soytree.SoyNode;

public final class MsgPluralCaseNode
extends CaseOrDefaultNode
implements SoyNode.MsgBlockNode {
    private final int caseNumber;

    private MsgPluralCaseNode(int id, String commandText, int caseNumber) {
        super(id, "case", commandText);
        this.caseNumber = caseNumber;
    }

    protected MsgPluralCaseNode(MsgPluralCaseNode orig) {
        super(orig);
        this.caseNumber = orig.caseNumber;
    }

    @Override
    public SoyNode.Kind getKind() {
        return SoyNode.Kind.MSG_PLURAL_CASE_NODE;
    }

    public int getCaseNumber() {
        return this.caseNumber;
    }

    @Override
    public MsgPluralCaseNode clone() {
        return new MsgPluralCaseNode(this);
    }

    public static final class Builder {
        public static final MsgPluralCaseNode ERROR = new MsgPluralCaseNode(-1, "error", 1);
        private final int id;
        private final String commandText;
        private final SourceLocation sourceLocation;

        public Builder(int id, String commandText, SourceLocation sourceLocation) {
            this.id = id;
            this.commandText = commandText;
            this.sourceLocation = sourceLocation;
        }

        public MsgPluralCaseNode build(ErrorReporter errorReporter) {
            ErrorReporter.Checkpoint checkpoint = errorReporter.checkpoint();
            int caseNumber = 0;
            try {
                caseNumber = Integer.parseInt(this.commandText);
                if (caseNumber < 0) {
                    errorReporter.report(SoySyntaxException.createWithMetaInfo("Plural cases must be nonnegative integers.", this.sourceLocation));
                }
            }
            catch (NumberFormatException nfe) {
                errorReporter.report(SoySyntaxException.createCausedWithMetaInfo("Invalid number in 'plural case' command text", nfe, this.sourceLocation, null, null));
            }
            if (errorReporter.errorsSince(checkpoint)) {
                return ERROR;
            }
            MsgPluralCaseNode node = new MsgPluralCaseNode(this.id, this.commandText, caseNumber);
            node.setSourceLocation(this.sourceLocation);
            return node;
        }
    }
}

