/*
 * Decompiled with CFR 0.152.
 */
package com.google.template.soy.soyparse;

import com.google.common.base.Preconditions;
import com.google.template.soy.base.SourceLocation;
import com.google.template.soy.base.SoySyntaxException;
import com.google.template.soy.base.internal.IdGenerator;
import com.google.template.soy.exprparse.ExprParseUtils;
import com.google.template.soy.exprtree.ExprRootNode;
import com.google.template.soy.soyparse.ErrorReporter;
import com.google.template.soy.soytree.ForeachIfemptyNode;
import com.google.template.soy.soytree.ForeachNode;
import com.google.template.soy.soytree.ForeachNonemptyNode;
import com.google.template.soy.soytree.SoyNode;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

final class ForeachBuilder {
    private static final Pattern FOR_EACH_COMMAND_TEXT_PATTERN = Pattern.compile("( [$] \\w+ ) \\s+ in \\s+ (\\S .*)", 36);
    private final IdGenerator nodeIdGen;
    private final ErrorReporter errorReporter;
    private String cmdText;
    private List<SoyNode.StandaloneNode> templateBlock;
    private SourceLocation ifEmptyLocation;
    private List<SoyNode.StandaloneNode> ifEmptyBlock;
    private SourceLocation commandLocation;

    static ForeachBuilder create(IdGenerator nodeIdGen, ErrorReporter errorReporter) {
        return new ForeachBuilder(nodeIdGen, errorReporter);
    }

    private ForeachBuilder(IdGenerator nodeIdGen, ErrorReporter errorReporter) {
        this.nodeIdGen = nodeIdGen;
        this.errorReporter = errorReporter;
    }

    ForeachBuilder setCommandLocation(SourceLocation location) {
        this.commandLocation = location;
        return this;
    }

    ForeachBuilder setCommandText(String cmdText) {
        this.cmdText = cmdText;
        return this;
    }

    ForeachBuilder setLoopBody(List<SoyNode.StandaloneNode> templateBlock) {
        this.templateBlock = templateBlock;
        return this;
    }

    ForeachBuilder setIfEmptyBody(SourceLocation ifEmptyLocation, List<SoyNode.StandaloneNode> ifEmptyBlock) {
        this.ifEmptyLocation = ifEmptyLocation;
        this.ifEmptyBlock = ifEmptyBlock;
        return this;
    }

    ForeachNode build() {
        Preconditions.checkState((this.cmdText != null ? 1 : 0) != 0, (Object)"You must call .setCommandText()");
        Preconditions.checkState((this.commandLocation != null ? 1 : 0) != 0, (Object)"You must call .setCommandLocation()");
        Preconditions.checkState((this.templateBlock != null ? 1 : 0) != 0, (Object)"You must call .setLoopBody()");
        String varName = "__error__";
        ExprRootNode<?> expr = null;
        Matcher matcher = FOR_EACH_COMMAND_TEXT_PATTERN.matcher(this.cmdText);
        if (!matcher.matches()) {
            this.errorReporter.report(SoySyntaxException.createWithMetaInfo("Invalid 'foreach' command text \"" + this.cmdText + "\".", this.commandLocation, null, null));
        } else {
            try {
                varName = ExprParseUtils.parseVarNameElseThrowSoySyntaxException(matcher.group(1), "Invalid variable name in 'foreach' command text \"" + this.cmdText + "\".");
            }
            catch (SoySyntaxException e) {
                this.errorReporter.report(SoySyntaxException.createCausedWithMetaInfo(null, e, this.commandLocation, null, null));
            }
            try {
                expr = ExprParseUtils.parseExprElseThrowSoySyntaxException(matcher.group(2), "Invalid expression in 'foreach' command text \"" + this.cmdText + "\".");
            }
            catch (SoySyntaxException e) {
                this.errorReporter.report(SoySyntaxException.createCausedWithMetaInfo(null, e, this.commandLocation, null, null));
            }
        }
        ForeachNode foreach = new ForeachNode(this.nodeIdGen.genId(), expr, this.cmdText);
        foreach.setSourceLocation(this.commandLocation);
        ForeachNonemptyNode nonEmpty = new ForeachNonemptyNode(this.nodeIdGen.genId(), varName);
        nonEmpty.setSourceLocation(this.commandLocation);
        nonEmpty.addChildren(this.templateBlock);
        foreach.addChild(nonEmpty);
        if (this.ifEmptyBlock != null) {
            ForeachIfemptyNode ifEmpty = new ForeachIfemptyNode(this.nodeIdGen.genId());
            ifEmpty.setSourceLocation(this.ifEmptyLocation);
            ifEmpty.addChildren(this.ifEmptyBlock);
            foreach.addChild(ifEmpty);
        }
        return foreach;
    }
}

