/*
 * Decompiled with CFR 0.152.
 */
package com.google.template.soy.pysrc.restricted;

import com.google.common.base.Function;
import com.google.common.base.Joiner;
import com.google.common.base.Strings;
import com.google.common.collect.Iterables;
import com.google.template.soy.pysrc.restricted.PyExpr;
import com.google.template.soy.pysrc.restricted.PyStringExpr;
import java.util.ArrayDeque;
import java.util.Deque;
import java.util.LinkedHashMap;
import java.util.Map;

public final class PyFunctionExprBuilder {
    private static final Function<Map.Entry<String, PyExpr>, String> KEYWORD_ARG_MAPPER = new Function<Map.Entry<String, PyExpr>, String>(){

        public String apply(Map.Entry<String, PyExpr> entry) {
            String key = entry.getKey();
            PyExpr value = entry.getValue();
            return key + "=" + value.getText();
        }
    };
    private static final Function<PyExpr, String> LIST_ARG_MAPPER = new Function<PyExpr, String>(){

        public String apply(PyExpr arg) {
            return arg.getText();
        }
    };
    private final String funcName;
    private final Deque<PyExpr> argList;
    private final Map<String, PyExpr> kwargMap;
    private String unpackedKwargs = null;

    public PyFunctionExprBuilder(String funcName) {
        this.funcName = funcName;
        this.argList = new ArrayDeque<PyExpr>();
        this.kwargMap = new LinkedHashMap<String, PyExpr>();
    }

    public PyFunctionExprBuilder addArg(PyExpr arg) {
        this.argList.add(arg);
        return this;
    }

    public PyFunctionExprBuilder addArg(String str) {
        this.argList.add(new PyStringExpr("'" + str + "'"));
        return this;
    }

    public PyFunctionExprBuilder addArg(int i) {
        this.argList.add(new PyExpr(String.valueOf(i), Integer.MAX_VALUE));
        return this;
    }

    public PyFunctionExprBuilder addArg(double i) {
        this.argList.add(new PyExpr(String.valueOf(i), Integer.MAX_VALUE));
        return this;
    }

    public PyFunctionExprBuilder addArg(long i) {
        this.argList.add(new PyExpr(String.valueOf(i), Integer.MAX_VALUE));
        return this;
    }

    public String getFuncName() {
        return this.funcName;
    }

    public PyFunctionExprBuilder addKwarg(String key, PyExpr argValue) {
        this.kwargMap.put(key, argValue);
        return this;
    }

    public PyFunctionExprBuilder addKwarg(String key, String str) {
        this.kwargMap.put(key, new PyStringExpr("'" + str + "'"));
        return this;
    }

    public PyFunctionExprBuilder addKwarg(String key, int i) {
        this.kwargMap.put(key, new PyExpr(String.valueOf(i), Integer.MAX_VALUE));
        return this;
    }

    public PyFunctionExprBuilder addKwarg(String key, double i) {
        this.kwargMap.put(key, new PyExpr(String.valueOf(i), Integer.MAX_VALUE));
        return this;
    }

    public PyFunctionExprBuilder addKwarg(String key, long i) {
        this.kwargMap.put(key, new PyExpr(String.valueOf(i), Integer.MAX_VALUE));
        return this;
    }

    public PyFunctionExprBuilder setUnpackedKwargs(PyExpr mapping) {
        if (this.unpackedKwargs != null) {
            throw new UnsupportedOperationException("Only one kwarg unpacking allowed per expression.");
        }
        StringBuilder expr = new StringBuilder("**");
        if (mapping.getPrecedence() < Integer.MAX_VALUE) {
            expr.append("(").append(mapping.getText()).append(")");
        } else {
            expr.append(mapping.getText());
        }
        this.unpackedKwargs = expr.toString();
        return this;
    }

    public String build() {
        StringBuilder sb = new StringBuilder(this.funcName + "(");
        Joiner joiner = Joiner.on((String)", ").skipNulls();
        String args = joiner.join(Iterables.transform(this.argList, LIST_ARG_MAPPER));
        String kwargs = joiner.join(Iterables.transform(this.kwargMap.entrySet(), KEYWORD_ARG_MAPPER));
        args = Strings.emptyToNull((String)args);
        kwargs = Strings.emptyToNull((String)kwargs);
        joiner.appendTo(sb, (Object)args, (Object)kwargs, new Object[]{this.unpackedKwargs});
        sb.append(")");
        return sb.toString();
    }

    public PyExpr asPyExpr() {
        return new PyExpr(this.build(), Integer.MAX_VALUE);
    }

    public PyStringExpr asPyStringExpr() {
        return new PyStringExpr(this.build());
    }
}

