/*
 * Decompiled with CFR 0.152.
 */
package com.google.template.soy.base;

import com.google.common.base.CharMatcher;
import com.google.common.base.Preconditions;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;

@ParametersAreNonnullByDefault
public class SourceLocation {
    @Nonnull
    private final String filePath;
    private final String fileName;
    private final int beginLine;
    private final int beginColumn;
    private final int endLine;
    private final int endColumn;
    public static final SourceLocation UNKNOWN = new SourceLocation("unknown");

    public SourceLocation(String filePath, int beginLine, int beginColumn, int endLine, int endColumn) {
        int lastSlashIndex;
        Preconditions.checkArgument((beginLine > 0 || beginLine == -1 ? 1 : 0) != 0);
        Preconditions.checkArgument((beginColumn > 0 || beginColumn == -1 ? 1 : 0) != 0);
        Preconditions.checkArgument((endLine > 0 || endLine == -1 ? 1 : 0) != 0);
        Preconditions.checkArgument((endColumn > 0 || endColumn == -1 ? 1 : 0) != 0);
        int lastBangIndex = filePath.lastIndexOf(33);
        if (lastBangIndex != -1) {
            filePath = filePath.substring(lastBangIndex + 1);
        }
        this.fileName = (lastSlashIndex = CharMatcher.anyOf((CharSequence)"/\\").lastIndexIn((CharSequence)filePath)) != -1 && lastSlashIndex != filePath.length() - 1 ? filePath.substring(lastSlashIndex + 1) : filePath;
        this.filePath = filePath;
        this.beginLine = beginLine;
        this.beginColumn = beginColumn;
        this.endLine = endLine;
        this.endColumn = endColumn;
    }

    public SourceLocation(String filePath) {
        this(filePath, -1, -1, -1, -1);
    }

    @Nonnull
    public String getFilePath() {
        return this.filePath;
    }

    @Nullable
    public String getFileName() {
        if (UNKNOWN.equals(this)) {
            return null;
        }
        return this.fileName;
    }

    public int getLineNumber() {
        return this.beginLine;
    }

    public int getBeginColumn() {
        return this.beginColumn;
    }

    public int getEndLine() {
        return this.endLine;
    }

    public int getEndColumn() {
        return this.endColumn;
    }

    boolean isKnown() {
        return !this.equals(UNKNOWN);
    }

    public boolean equals(@Nullable Object o) {
        if (!(o instanceof SourceLocation)) {
            return false;
        }
        SourceLocation that = (SourceLocation)o;
        return this.filePath.equals(that.filePath) && this.beginLine == that.beginLine && this.beginColumn == that.beginColumn && this.endLine == that.endLine && this.endColumn == that.endColumn;
    }

    public int hashCode() {
        return this.filePath.hashCode() + 31 * this.beginLine;
    }

    public String toString() {
        return this.beginLine != -1 ? this.filePath + ":" + this.beginLine + ":" + this.beginColumn : this.filePath;
    }
}

