/*
 * Decompiled with CFR 0.152.
 */
package com.google.template.soy.soytree;

import com.google.common.collect.ImmutableMap;
import java.util.Set;

public enum Visibility {
    PRIVATE("private"),
    LEGACY_PRIVATE("legacy-private"),
    PUBLIC("public");

    private final String attributeValue;
    private static final ImmutableMap<String, Visibility> attrValuesToVisibilityLevels;

    private Visibility(String attributeValue) {
        this.attributeValue = attributeValue;
    }

    public String getAttributeValue() {
        return this.attributeValue;
    }

    public static Set<String> getAttributeValues() {
        return attrValuesToVisibilityLevels.keySet();
    }

    public static Visibility forAttributeValue(String attributeValue) {
        return (Visibility)((Object)attrValuesToVisibilityLevels.get((Object)attributeValue));
    }

    static {
        ImmutableMap.Builder builder = ImmutableMap.builder();
        for (Visibility v : Visibility.values()) {
            builder.put((Object)v.attributeValue, (Object)v);
        }
        attrValuesToVisibilityLevels = builder.build();
    }
}

