/*
 * Decompiled with CFR 0.152.
 */
package com.google.template.soy.sharedpasses;

import com.google.common.base.CaseFormat;
import com.google.template.soy.soytree.AbstractSoyNodeVisitor;
import com.google.template.soy.soytree.CssNode;
import com.google.template.soy.soytree.SoyNode;
import com.google.template.soy.soytree.SoySyntaxExceptionUtils;
import com.google.template.soy.soytree.TemplateNode;

public class ResolvePackageRelativeCssNamesVisitor
extends AbstractSoyNodeVisitor<Void> {
    private String packagePrefix = null;

    @Override
    protected void visitTemplateNode(TemplateNode node) {
        this.packagePrefix = null;
        if (node.getCssBaseNamespace() != null) {
            this.packagePrefix = ResolvePackageRelativeCssNamesVisitor.toCamelCase(node.getCssBaseNamespace());
        } else if (node.getParent().getCssBaseNamespace() != null) {
            this.packagePrefix = ResolvePackageRelativeCssNamesVisitor.toCamelCase(node.getParent().getCssBaseNamespace());
        } else if (!node.getParent().getRequiredCssNamespaces().isEmpty()) {
            this.packagePrefix = ResolvePackageRelativeCssNamesVisitor.toCamelCase((String)node.getParent().getRequiredCssNamespaces().get(0));
        }
        super.visitTemplateNode(node);
    }

    @Override
    protected void visitCssNode(CssNode node) {
        String selectorText = node.getSelectorText();
        if (!selectorText.startsWith("%")) {
            return;
        }
        if (node.getComponentNameExpr() != null) {
            throw SoySyntaxExceptionUtils.createWithNode("Package-relative class name '" + selectorText + "' cannot be used with a component expression", node);
        }
        if (this.packagePrefix == null) {
            throw SoySyntaxExceptionUtils.createWithNode("No CSS package defined for package-relative class name '" + selectorText + "'", node);
        }
        SoyNode.BlockNode parent = node.getParent();
        int indexInParent = parent.getChildIndex(node);
        parent.removeChild(indexInParent);
        CssNode newNode = new CssNode(node, this.packagePrefix + selectorText.substring(1));
        parent.addChild(indexInParent, newNode);
    }

    @Override
    protected void visitSoyNode(SoyNode node) {
        if (node instanceof SoyNode.ParentSoyNode) {
            this.visitChildrenAllowingConcurrentModification((SoyNode.ParentSoyNode)node);
        }
    }

    private static String toCamelCase(String packageName) {
        String packageNameWithDashes = packageName.replace('.', '-');
        return CaseFormat.LOWER_HYPHEN.to(CaseFormat.LOWER_CAMEL, packageNameWithDashes);
    }
}

