/*
 * Decompiled with CFR 0.152.
 */
package com.google.template.soy.pysrc.restricted;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.template.soy.data.SanitizedContent;
import com.google.template.soy.data.internalutils.NodeContentKinds;
import com.google.template.soy.exprtree.Operator;
import com.google.template.soy.internal.targetexpr.ExprUtils;
import com.google.template.soy.internal.targetexpr.TargetExpr;
import com.google.template.soy.pysrc.restricted.PyExpr;
import com.google.template.soy.pysrc.restricted.PyListExpr;
import com.google.template.soy.pysrc.restricted.PyStringExpr;
import java.util.List;
import javax.annotation.Nullable;

public final class PyExprUtils {
    private static final PyExpr EMPTY_STRING = new PyStringExpr("''");
    private static final ImmutableMap<Operator, Integer> PYTHON_PRECEDENCES = new ImmutableMap.Builder().put((Object)Operator.NEGATIVE, (Object)8).put((Object)Operator.TIMES, (Object)7).put((Object)Operator.DIVIDE_BY, (Object)7).put((Object)Operator.MOD, (Object)7).put((Object)Operator.PLUS, (Object)6).put((Object)Operator.MINUS, (Object)6).put((Object)Operator.LESS_THAN, (Object)5).put((Object)Operator.GREATER_THAN, (Object)5).put((Object)Operator.LESS_THAN_OR_EQUAL, (Object)5).put((Object)Operator.GREATER_THAN_OR_EQUAL, (Object)5).put((Object)Operator.EQUAL, (Object)5).put((Object)Operator.NOT_EQUAL, (Object)5).put((Object)Operator.NOT, (Object)4).put((Object)Operator.AND, (Object)3).put((Object)Operator.OR, (Object)2).put((Object)Operator.NULL_COALESCING, (Object)1).put((Object)Operator.CONDITIONAL, (Object)1).build();

    private PyExprUtils() {
    }

    public static PyExpr concatPyExprs(List<? extends PyExpr> pyExprs) {
        if (pyExprs.isEmpty()) {
            return EMPTY_STRING;
        }
        if (pyExprs.size() == 1) {
            return pyExprs.get(0).toPyString();
        }
        StringBuilder resultSb = new StringBuilder();
        resultSb.append("[");
        boolean isFirst = true;
        for (PyExpr pyExpr : pyExprs) {
            if (isFirst) {
                isFirst = false;
            } else {
                resultSb.append(',');
            }
            resultSb.append(pyExpr.toPyString().getText());
        }
        resultSb.append("]");
        return new PyListExpr(resultSb.toString(), Integer.MAX_VALUE);
    }

    public static PyExpr genPyNotNullCheck(PyExpr pyExpr) {
        ImmutableList exprs = ImmutableList.of((Object)pyExpr, (Object)new PyExpr("None", Integer.MAX_VALUE));
        String conditionalExpr = ExprUtils.genExprWithNewToken(Operator.NOT_EQUAL, (List<? extends TargetExpr>)exprs, "is not");
        return new PyExpr(conditionalExpr, PyExprUtils.pyPrecedenceForOperator(Operator.NOT_EQUAL));
    }

    public static PyExpr maybeWrapAsSanitizedContent(@Nullable SanitizedContent.ContentKind contentKind, PyExpr pyExpr) {
        if (contentKind == null) {
            return pyExpr;
        }
        String sanitizer = NodeContentKinds.toPySanitizedContentOrdainer(contentKind);
        return new PyExpr(sanitizer + "(" + pyExpr.getText() + ")", Integer.MAX_VALUE);
    }

    public static int pyPrecedenceForOperator(Operator op) {
        return (Integer)PYTHON_PRECEDENCES.get((Object)op);
    }
}

