/*
 * Decompiled with CFR 0.152.
 */
package com.google.template.soy.pysrc.internal;

import com.google.common.base.Preconditions;
import com.google.template.soy.base.SoyBackendKind;
import com.google.template.soy.base.SoySyntaxException;
import com.google.template.soy.exprtree.AbstractReturningExprNodeVisitor;
import com.google.template.soy.exprtree.BooleanNode;
import com.google.template.soy.exprtree.DataAccessNode;
import com.google.template.soy.exprtree.ExprNode;
import com.google.template.soy.exprtree.ExprRootNode;
import com.google.template.soy.exprtree.FieldAccessNode;
import com.google.template.soy.exprtree.FunctionNode;
import com.google.template.soy.exprtree.IntegerNode;
import com.google.template.soy.exprtree.ItemAccessNode;
import com.google.template.soy.exprtree.ListLiteralNode;
import com.google.template.soy.exprtree.MapLiteralNode;
import com.google.template.soy.exprtree.NullNode;
import com.google.template.soy.exprtree.Operator;
import com.google.template.soy.exprtree.OperatorNodes;
import com.google.template.soy.exprtree.StringNode;
import com.google.template.soy.exprtree.VarRefNode;
import com.google.template.soy.internal.targetexpr.ExprUtils;
import com.google.template.soy.pysrc.restricted.PyExpr;
import com.google.template.soy.pysrc.restricted.PyExprUtils;
import com.google.template.soy.pysrc.restricted.PyListExpr;
import com.google.template.soy.pysrc.restricted.PyStringExpr;
import com.google.template.soy.shared.internal.NonpluginFunction;
import com.google.template.soy.types.SoyObjectType;
import com.google.template.soy.types.SoyType;
import java.util.List;

final class TranslateToPyExprVisitor
extends AbstractReturningExprNodeVisitor<PyExpr> {
    TranslateToPyExprVisitor() {
    }

    @Override
    protected PyExpr visitExprRootNode(ExprRootNode<?> node) {
        return (PyExpr)this.visit((ExprNode)node.getChild(0));
    }

    @Override
    protected PyExpr visitPrimitiveNode(ExprNode.PrimitiveNode node) {
        return new PyExpr(node.toSourceString(), Integer.MAX_VALUE);
    }

    @Override
    protected PyExpr visitStringNode(StringNode node) {
        return new PyStringExpr(node.toSourceString());
    }

    @Override
    protected PyExpr visitNullNode(NullNode node) {
        return new PyExpr("None", Integer.MAX_VALUE);
    }

    @Override
    protected PyExpr visitBooleanNode(BooleanNode node) {
        return new PyExpr(node.getValue() ? "True" : "False", Integer.MAX_VALUE);
    }

    @Override
    protected PyExpr visitListLiteralNode(ListLiteralNode node) {
        StringBuilder listContents = new StringBuilder();
        for (ExprNode child : node.getChildren()) {
            if (listContents.length() > 0) {
                listContents.append(", ");
            }
            listContents.append(((PyExpr)this.visit(child)).getText());
        }
        return new PyListExpr("[" + listContents + "]", Integer.MAX_VALUE);
    }

    @Override
    protected PyExpr visitMapLiteralNode(MapLiteralNode node) {
        StringBuilder mapContents = new StringBuilder();
        Preconditions.checkArgument((node.numChildren() % 2 == 0 ? 1 : 0) != 0);
        int n = node.numChildren();
        for (int i = 0; i < n; i += 2) {
            ExprNode keyNode = node.getChild(i);
            ExprNode valueNode = node.getChild(i + 1);
            if (i > 0) {
                mapContents.append(", ");
            }
            mapContents.append(((PyExpr)this.visit(keyNode)).getText()).append(": ").append(((PyExpr)this.visit(valueNode)).getText());
        }
        return new PyExpr("{" + mapContents + "}", Integer.MAX_VALUE);
    }

    @Override
    protected PyExpr visitVarRefNode(VarRefNode node) {
        return this.visitNullSafeNode(node);
    }

    @Override
    protected PyExpr visitDataAccessNode(DataAccessNode node) {
        return this.visitNullSafeNode(node);
    }

    private PyExpr visitNullSafeNode(ExprNode node) {
        StringBuilder nullSafetyPrefix = new StringBuilder();
        String refText = this.visitNullSafeNodeRecurse(node, nullSafetyPrefix);
        if (nullSafetyPrefix.length() == 0) {
            return new PyExpr(refText, Integer.MAX_VALUE);
        }
        return new PyExpr(nullSafetyPrefix + refText, PyExprUtils.pyPrecedenceForOperator(Operator.CONDITIONAL));
    }

    private String visitNullSafeNodeRecurse(ExprNode node, StringBuilder nullSafetyPrefix) {
        switch (node.getKind()) {
            case VAR_REF_NODE: {
                VarRefNode varRef = (VarRefNode)node;
                if (varRef.isInjected()) {
                    if (varRef.isNullSafeInjected()) {
                        nullSafetyPrefix.append("None if opt_ijData is None else ");
                    }
                    return "opt_ijData" + TranslateToPyExprVisitor.genCodeForLiteralKeyAccess(varRef.getName());
                }
                return "opt_data" + TranslateToPyExprVisitor.genCodeForLiteralKeyAccess(varRef.getName());
            }
            case FIELD_ACCESS_NODE: 
            case ITEM_ACCESS_NODE: {
                DataAccessNode dataAccess = (DataAccessNode)node;
                String refText = this.visitNullSafeNodeRecurse(dataAccess.getBaseExprChild(), nullSafetyPrefix);
                if (dataAccess.isNullSafe()) {
                    nullSafetyPrefix.append("None if " + refText + " is None else ");
                }
                if (node.getKind() == ExprNode.Kind.FIELD_ACCESS_NODE) {
                    FieldAccessNode fieldAccess = (FieldAccessNode)node;
                    return refText + TranslateToPyExprVisitor.genCodeForFieldAccess(fieldAccess.getBaseExprChild().getType(), fieldAccess.getFieldName());
                }
                ItemAccessNode itemAccess = (ItemAccessNode)node;
                if (itemAccess.getKeyExprChild() instanceof IntegerNode) {
                    return refText + "[" + ((IntegerNode)itemAccess.getKeyExprChild()).getValue() + "]";
                }
                PyExpr keyPyExpr = (PyExpr)this.visit(itemAccess.getKeyExprChild());
                return refText + TranslateToPyExprVisitor.genCodeForKeyAccess(keyPyExpr.getText());
            }
        }
        PyExpr value = (PyExpr)this.visit(node);
        return TranslateToPyExprVisitor.genMaybeProtect(value, Integer.MAX_VALUE);
    }

    @Override
    protected PyExpr visitOperatorNode(ExprNode.OperatorNode node) {
        return this.genPyExprUsingSoySyntax(node);
    }

    @Override
    protected PyExpr visitEqualOpNode(OperatorNodes.EqualOpNode node) {
        List operandPyExprs = this.visitChildren(node);
        return new PyExpr("runtime.type_safe_eq(" + ((PyExpr)operandPyExprs.get(0)).getText() + ", " + ((PyExpr)operandPyExprs.get(1)).getText() + ")", Integer.MAX_VALUE);
    }

    @Override
    protected PyExpr visitNotEqualOpNode(OperatorNodes.NotEqualOpNode node) {
        List operandPyExprs = this.visitChildren(node);
        return new PyExpr("not runtime.type_safe_eq(" + ((PyExpr)operandPyExprs.get(0)).getText() + ", " + ((PyExpr)operandPyExprs.get(1)).getText() + ")", PyExprUtils.pyPrecedenceForOperator(Operator.NOT));
    }

    @Override
    protected PyExpr visitPlusOpNode(OperatorNodes.PlusOpNode node) {
        List operandPyExprs = this.visitChildren(node);
        return new PyExpr("runtime.type_safe_add(" + ((PyExpr)operandPyExprs.get(0)).getText() + ", " + ((PyExpr)operandPyExprs.get(1)).getText() + ")", Integer.MAX_VALUE);
    }

    @Override
    protected PyExpr visitConditionalOpNode(OperatorNodes.ConditionalOpNode node) {
        Operator op = Operator.CONDITIONAL;
        List<Operator.SyntaxElement> syntax = op.getSyntax();
        List operandExprs = this.visitChildren(node);
        Operator.Operand conditionalOperand = (Operator.Operand)syntax.get(0);
        PyExpr conditionalExpr = (PyExpr)operandExprs.get(conditionalOperand.getIndex());
        Operator.Operand trueOperand = (Operator.Operand)syntax.get(4);
        PyExpr trueExpr = (PyExpr)operandExprs.get(trueOperand.getIndex());
        Operator.Operand falseOperand = (Operator.Operand)syntax.get(8);
        PyExpr falseExpr = (PyExpr)operandExprs.get(falseOperand.getIndex());
        StringBuilder exprSb = new StringBuilder();
        exprSb.append(TranslateToPyExprVisitor.genMaybeProtect(trueExpr, PyExprUtils.pyPrecedenceForOperator(op)));
        exprSb.append(" if ");
        exprSb.append(TranslateToPyExprVisitor.genMaybeProtect(conditionalExpr, PyExprUtils.pyPrecedenceForOperator(op)));
        exprSb.append(" else ");
        exprSb.append(TranslateToPyExprVisitor.genMaybeProtect(falseExpr, PyExprUtils.pyPrecedenceForOperator(op)));
        return new PyExpr(exprSb.toString(), PyExprUtils.pyPrecedenceForOperator(op));
    }

    @Override
    protected PyExpr visitFunctionNode(FunctionNode node) {
        String fnName = node.getFunctionName();
        int numArgs = node.numChildren();
        NonpluginFunction nonpluginFn = NonpluginFunction.forFunctionName(fnName);
        if (nonpluginFn != null) {
            if (numArgs != nonpluginFn.getNumArgs()) {
                throw SoySyntaxException.createWithoutMetaInfo("Function '" + fnName + "' called with the wrong number of arguments" + " (function call \"" + node.toSourceString() + "\").");
            }
            switch (nonpluginFn) {
                case QUOTE_KEYS_IF_JS: {
                    return this.visitMapLiteralNode((MapLiteralNode)node.getChild(0));
                }
            }
            throw new AssertionError();
        }
        throw new UnsupportedOperationException("Plugin functions are not yet supported.");
    }

    private static String genCodeForLiteralKeyAccess(String key) {
        return TranslateToPyExprVisitor.genCodeForKeyAccess("'" + key + "'");
    }

    private static String genCodeForKeyAccess(String key) {
        return ".get(" + key + ")";
    }

    private static String genCodeForFieldAccess(SoyType baseType, String fieldName) {
        SoyObjectType objType;
        String accessExpr;
        if (baseType != null && baseType.getKind() == SoyType.Kind.OBJECT && (accessExpr = (objType = (SoyObjectType)baseType).getFieldAccessor(fieldName, SoyBackendKind.PYTHON_SRC)) != null) {
            return accessExpr;
        }
        return TranslateToPyExprVisitor.genCodeForLiteralKeyAccess(fieldName);
    }

    private PyExpr genPyExprUsingSoySyntax(ExprNode.OperatorNode opNode) {
        List operandPyExprs = this.visitChildren(opNode);
        String newExpr = ExprUtils.genExprWithNewToken(opNode.getOperator(), operandPyExprs, null);
        return new PyExpr(newExpr, PyExprUtils.pyPrecedenceForOperator(opNode.getOperator()));
    }

    private static String genMaybeProtect(PyExpr expr, int minSafePrecedence) {
        return expr.getPrecedence() > minSafePrecedence ? expr.getText() : "(" + expr.getText() + ")";
    }

    static interface TranslateToPyExprVisitorFactory {
        public TranslateToPyExprVisitor create();
    }
}

