/*
 * Decompiled with CFR 0.152.
 */
package com.google.template.soy.pysrc.internal;

import com.google.common.base.Charsets;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Iterables;
import com.google.common.collect.Multimap;
import com.google.common.io.Files;
import com.google.inject.Inject;
import com.google.inject.Key;
import com.google.inject.Provider;
import com.google.template.soy.base.SoySyntaxException;
import com.google.template.soy.internal.i18n.BidiGlobalDir;
import com.google.template.soy.internal.i18n.SoyBidiUtils;
import com.google.template.soy.pysrc.SoyPySrcOptions;
import com.google.template.soy.pysrc.internal.GenPyCodeVisitor;
import com.google.template.soy.shared.internal.ApiCallScopeUtils;
import com.google.template.soy.shared.internal.GuiceSimpleScope;
import com.google.template.soy.shared.internal.MainEntryPointUtils;
import com.google.template.soy.shared.restricted.ApiCallScopeBindingAnnotations;
import com.google.template.soy.sharedpasses.opti.SimplifyVisitor;
import com.google.template.soy.soytree.SoyFileNode;
import com.google.template.soy.soytree.SoyFileSetNode;
import java.io.BufferedWriter;
import java.io.File;
import java.io.IOException;
import java.nio.charset.Charset;
import java.util.Iterator;
import java.util.List;

public final class PySrcMain {
    private final GuiceSimpleScope apiCallScope;
    private final SimplifyVisitor simplifyVisitor;
    private final Provider<GenPyCodeVisitor> genPyCodeVisitorProvider;

    @Inject
    public PySrcMain(@ApiCallScopeBindingAnnotations.ApiCall GuiceSimpleScope apiCallScope, SimplifyVisitor simplifyVisitor, Provider<GenPyCodeVisitor> genPyCodeVisitorProvider) {
        this.apiCallScope = apiCallScope;
        this.simplifyVisitor = simplifyVisitor;
        this.genPyCodeVisitorProvider = genPyCodeVisitorProvider;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<String> genPySrc(SoyFileSetNode soyTree, SoyPySrcOptions pySrcOptions) throws SoySyntaxException {
        this.apiCallScope.enter();
        try {
            this.apiCallScope.seed(SoyPySrcOptions.class, pySrcOptions);
            this.apiCallScope.seed(Key.get(String.class, ApiCallScopeBindingAnnotations.RuntimePath.class), pySrcOptions.getRuntimePath());
            this.apiCallScope.seed(Key.get(String.class, ApiCallScopeBindingAnnotations.TranslationPyModuleName.class), pySrcOptions.getTranslationPyModuleName());
            BidiGlobalDir bidiGlobalDir = SoyBidiUtils.decodeBidiGlobalDirFromPyOptions(pySrcOptions.getBidiIsRtlFn());
            ApiCallScopeUtils.seedSharedParams(this.apiCallScope, null, bidiGlobalDir);
            this.simplifyVisitor.exec(soyTree);
            List<String> list = ((GenPyCodeVisitor)this.genPyCodeVisitorProvider.get()).exec(soyTree);
            return list;
        }
        finally {
            this.apiCallScope.exit();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void genPyFiles(SoyFileSetNode soyTree, SoyPySrcOptions pySrcOptions, String outputPathFormat, String inputPathsPrefix) throws SoySyntaxException, IOException {
        List<String> pyFileContents = this.genPySrc(soyTree, pySrcOptions);
        ImmutableList srcsToCompile = ImmutableList.copyOf((Iterable)Iterables.filter(soyTree.getChildren(), SoyFileNode.MATCH_SRC_FILENODE));
        if (srcsToCompile.size() != pyFileContents.size()) {
            throw new AssertionError((Object)String.format("Expected to generate %d code chunk(s), got %d", srcsToCompile.size(), pyFileContents.size()));
        }
        Multimap<String, Integer> outputs = MainEntryPointUtils.mapOutputsToSrcs(null, outputPathFormat, inputPathsPrefix, (ImmutableList<SoyFileNode>)srcsToCompile);
        for (String outputFilePath : outputs.keySet()) {
            try (BufferedWriter out = Files.newWriter((File)new File(outputFilePath), (Charset)Charsets.UTF_8);){
                Iterator iterator = outputs.get((Object)outputFilePath).iterator();
                while (iterator.hasNext()) {
                    int inputFileIndex = (Integer)iterator.next();
                    out.write(pyFileContents.get(inputFileIndex));
                }
            }
        }
    }
}

