/*
 * Decompiled with CFR 0.152.
 */
package com.google.template.soy.data;

import com.google.template.soy.data.SoyAbstractCachingValueProvider;
import com.google.template.soy.data.SoyFutureException;
import com.google.template.soy.data.SoyValue;
import com.google.template.soy.data.SoyValueHelper;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import javax.annotation.Nonnull;

public final class SoyFutureValueProvider
extends SoyAbstractCachingValueProvider {
    private static final FutureBlockCallback NOOP = new FutureBlockCallback(){

        @Override
        public void beforeBlock() {
        }
    };
    public static final ThreadLocal<FutureBlockCallback> futureBlockCallback = new ThreadLocal<FutureBlockCallback>(){

        @Override
        protected FutureBlockCallback initialValue() {
            return NOOP;
        }
    };
    private final SoyValueHelper valueHelper;
    private final Future<?> future;

    public SoyFutureValueProvider(SoyValueHelper valueHelper, Future<?> future) {
        this.valueHelper = valueHelper;
        this.future = future;
    }

    @Override
    @Nonnull
    protected final SoyValue compute() {
        try {
            if (!this.future.isDone()) {
                futureBlockCallback.get().beforeBlock();
            }
            return this.valueHelper.convert(this.future.get()).resolve();
        }
        catch (ExecutionException e) {
            throw new SoyFutureException(e.getCause());
        }
        catch (Throwable e) {
            throw new SoyFutureException(e);
        }
    }

    public static interface FutureBlockCallback {
        public void beforeBlock();
    }
}

