/*
 * Decompiled with CFR 0.152.
 */
package com.google.template.soy.basicdirectives;

import com.google.common.base.Function;
import com.google.common.base.Joiner;
import com.google.common.collect.ContiguousSet;
import com.google.common.collect.DiscreteDomain;
import com.google.common.collect.FluentIterable;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Iterables;
import com.google.common.collect.Range;
import com.google.template.soy.data.SoyValue;
import com.google.template.soy.jssrc.restricted.JsExpr;
import com.google.template.soy.jssrc.restricted.SoyJsSrcPrintDirective;
import com.google.template.soy.shared.restricted.Sanitizers;
import com.google.template.soy.shared.restricted.SoyJavaPrintDirective;
import com.google.template.soy.shared.restricted.SoyPurePrintDirective;
import com.google.template.soy.shared.restricted.TagWhitelist;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import javax.inject.Inject;
import javax.inject.Singleton;

@Singleton
@SoyPurePrintDirective
public class CleanHtmlDirective
implements SoyJavaPrintDirective,
SoyJsSrcPrintDirective {
    private static final Set<Integer> VALID_ARGS_SIZES = ContiguousSet.create((Range)Range.closed((Comparable)Integer.valueOf(0), (Comparable)Integer.valueOf(TagWhitelist.OptionalSafeTag.values().length)), (DiscreteDomain)DiscreteDomain.integers());
    private static final Function<SoyValue, String> SOY_VALUE_TO_STRING = new Function<SoyValue, String>(){

        public String apply(SoyValue soyValue) {
            return soyValue.stringValue();
        }
    };
    private static final Function<JsExpr, String> JS_EXPR_TO_STRING = new Function<JsExpr, String>(){

        public String apply(JsExpr expr) {
            return expr.getText();
        }
    };
    private static final Function<String, String> SINGLE_QUOTED_TO_UNQUOTED = new Function<String, String>(){

        public String apply(String singleQuoted) {
            if (singleQuoted.length() < 2 || singleQuoted.charAt(0) != '\'' || singleQuoted.charAt(singleQuoted.length() - 1) != '\'') {
                throw new IllegalArgumentException(String.format("The cleanHtml directive expects arguments to be tag name string literals, such as 'span'. Encountered: %s", singleQuoted));
            }
            return singleQuoted.substring(1, singleQuoted.length() - 1);
        }
    };
    private static final Joiner JS_ARG_JOINER = Joiner.on((String)", ");

    @Inject
    public CleanHtmlDirective() {
    }

    @Override
    public String getName() {
        return "|cleanHtml";
    }

    @Override
    public final Set<Integer> getValidArgsSizes() {
        return VALID_ARGS_SIZES;
    }

    @Override
    public boolean shouldCancelAutoescape() {
        return false;
    }

    @Override
    public SoyValue applyForJava(SoyValue value, List<SoyValue> args) {
        ImmutableSet optionalSafeTags = FluentIterable.from(args).transform(SOY_VALUE_TO_STRING).transform(TagWhitelist.OptionalSafeTag.FROM_TAG_NAME).toSet();
        return Sanitizers.cleanHtml(value, (Collection<? extends TagWhitelist.OptionalSafeTag>)optionalSafeTags);
    }

    @Override
    public JsExpr applyForJsSrc(JsExpr value, List<JsExpr> args) {
        String optionalSafeTagsArg = "";
        if (!args.isEmpty()) {
            Iterable optionalSafeTagExprs = Iterables.transform(args, JS_EXPR_TO_STRING);
            FluentIterable.from((Iterable)optionalSafeTagExprs).transform(SINGLE_QUOTED_TO_UNQUOTED).transform(TagWhitelist.OptionalSafeTag.FROM_TAG_NAME).toSet();
            optionalSafeTagsArg = ", [" + JS_ARG_JOINER.join(optionalSafeTagExprs) + "]";
        }
        return new JsExpr("soy.$$cleanHtml(" + value.getText() + optionalSafeTagsArg + ")", Integer.MAX_VALUE);
    }
}

