/*
 * Decompiled with CFR 0.152.
 */
package com.google.template.soy;

import com.google.common.base.Function;
import com.google.inject.Injector;
import com.google.template.soy.MainClassUtils;
import com.google.template.soy.SoyFileSet;
import com.google.template.soy.base.SoySyntaxException;
import com.google.template.soy.basetree.SyntaxVersion;
import com.google.template.soy.pysrc.SoyPySrcOptions;
import com.google.template.soy.shared.SoyGeneralOptions;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.kohsuke.args4j.Argument;
import org.kohsuke.args4j.CmdLineParser;
import org.kohsuke.args4j.Option;

public final class SoyToPySrcCompiler {
    private static final String USAGE_PREFIX = "Usage:\njava com.google.template.soy.SoyToPySrcCompiler  \\\n     [<flag1> <flag2> ...] --outputPathFormat <formatString>  \\\n     --runtimePath <runtimeModulePath>  \\\n     --srcs <soyFilePath>,... [--deps <soyFilePath>,...]\n";
    @Option(name="--srcs", usage="The list of source Soy files. Extra arguments are treated as srcs. Sources are required from either this flag or as extra arguments.", handler=MainClassUtils.StringListOptionHandler.class)
    private List<String> srcs = new ArrayList<String>();
    @Option(name="--translationPyModuleName", usage="Python class name used in python runtime to instantiate translation. It should be given in absolute module path in dot notation format,  for example: my.package.module.TranslatorClass. It is required for {msg} command.")
    private String translationPyModuleName = "";
    @Option(name="--runtimePath", required=true, usage="[Required] The module path used to find the python runtime libraries. This should be in dot notation format.")
    private String runtimePath = "";
    @Option(name="--inputPrefix", usage="If provided, this path prefix will be prepended to each input file path listed on the command line. This is a literal string prefix, so you'll need to include a trailing slash if necessary.")
    private String inputPrefix = "";
    @Option(name="--deps", usage="The list of dependency Soy files (if applicable). The compiler needs deps for analysis/checking, but will not generate code for dep files.", handler=MainClassUtils.StringListOptionHandler.class)
    private List<String> deps = new ArrayList<String>();
    @Option(name="--indirectDeps", usage="Soy files required by deps, but which may not be used by srcs.", handler=MainClassUtils.StringListOptionHandler.class)
    private List<String> indirectDeps = new ArrayList<String>();
    @Option(name="--outputPathFormat", required=true, usage="[Required] A format string that specifies how to build the path to each output file. There will be one output Python file (UTF-8) for each input Soy file. The format string can include literal characters as well as the placeholders {INPUT_PREFIX}, {INPUT_DIRECTORY}, {INPUT_FILE_NAME}, and {INPUT_FILE_NAME_NO_EXT}. Additionally periods are not allowed in the outputted filename outside of the final py extension.")
    private String outputPathFormat = "";
    @Option(name="--syntaxVersion", usage="User-declared syntax version for the Soy file bundle (e.g. 2.2, 2.3).")
    private String syntaxVersion = "";
    @Option(name="--cssHandlingScheme", usage="The scheme to use for handling 'css' commands. Specifying 'literal' will cause command text to be inserted as literal text. Specifying 'reference' will cause command text to be evaluated as a data or global reference. The 'goog' scheme is not supported in Python. This option has no effect if the Soy code does not contain 'css' commands.")
    private String cssHandlingScheme = "literal";
    @Option(name="--compileTimeGlobalsFile", usage="The path to a file containing the mappings for global names to be substituted at compile time. Each line of the file should have the format \"<global_name> = <primitive_data>\" where primitive_data is a valid Soy expression literal for a primitive type (null, boolean, integer, float, or string). Empty lines and lines beginning with \"//\" are ignored. The file should be encoded in UTF-8. If you need to generate a file in this format from Java, consider using the utility SoyUtils.generateCompileTimeGlobalsFile().")
    private String compileTimeGlobalsFile = "";
    @Option(name="--bidiIsRtlFn", usage="The full name of a function used to determine if bidi is rtl for setting global directionality. The name should include the full module path and functionname (e.g. \"my.app.bidi.is_rtl\"). Only applicable if your Soy code uses bidi functions/directives.")
    private String bidiIsRtlFn = "";
    @Option(name="--pluginModules", usage="Specifies the full class names of Guice modules for function plugins and print directive plugins (comma-delimited list).")
    private String pluginModules = "";
    @Argument
    private List<String> arguments = new ArrayList<String>();

    public static void main(String[] args) throws IOException, SoySyntaxException {
        new SoyToPySrcCompiler().execMain(args);
    }

    private SoyToPySrcCompiler() {
    }

    private void execMain(String[] args) throws IOException, SoySyntaxException {
        final CmdLineParser cmdLineParser = MainClassUtils.parseFlags(this, args, USAGE_PREFIX);
        Function<String, Void> exitWithErrorFn = new Function<String, Void>(){

            public Void apply(String errorMsg) {
                MainClassUtils.exitWithError(errorMsg, cmdLineParser, SoyToPySrcCompiler.USAGE_PREFIX);
                return null;
            }
        };
        if (this.runtimePath.length() == 0) {
            MainClassUtils.exitWithError("Must provide the Python runtime library path.", cmdLineParser, USAGE_PREFIX);
        }
        if (this.outputPathFormat.length() == 0) {
            MainClassUtils.exitWithError("Must provide the output path format.", cmdLineParser, USAGE_PREFIX);
        }
        Injector injector = MainClassUtils.createInjector(this.pluginModules);
        SoyFileSet.Builder sfsBuilder = (SoyFileSet.Builder)injector.getInstance(SoyFileSet.Builder.class);
        MainClassUtils.addSoyFilesToBuilder(sfsBuilder, this.inputPrefix, this.srcs, this.arguments, this.deps, this.indirectDeps, exitWithErrorFn);
        if (this.syntaxVersion.length() > 0) {
            SyntaxVersion parsedVersion = SyntaxVersion.forName(this.syntaxVersion);
            if (parsedVersion.num < SyntaxVersion.V2_2.num) {
                exitWithErrorFn.apply((Object)"Declared syntax version must be 2.2 or greater.");
            }
            sfsBuilder.setDeclaredSyntaxVersionName(this.syntaxVersion);
        }
        sfsBuilder.setAllowExternalCalls(false);
        String cssHandlingSchemeUc = this.cssHandlingScheme.toUpperCase();
        if (cssHandlingSchemeUc.equals("GOOG")) {
            exitWithErrorFn.apply((Object)"CSS handling scheme 'GOOG' is not support in Python.");
        }
        sfsBuilder.setCssHandlingScheme(SoyGeneralOptions.CssHandlingScheme.valueOf(cssHandlingSchemeUc));
        if (this.compileTimeGlobalsFile.length() > 0) {
            sfsBuilder.setCompileTimeGlobals(new File(this.compileTimeGlobalsFile));
        }
        SoyFileSet sfs = sfsBuilder.build();
        SoyPySrcOptions pySrcOptions = new SoyPySrcOptions(this.runtimePath, this.bidiIsRtlFn, this.translationPyModuleName);
        sfs.compileToPySrcFiles(this.outputPathFormat, this.inputPrefix, pySrcOptions);
    }
}

