/*
 * Decompiled with CFR 0.152.
 */
package com.google.sitebricks.conversion.generics;

import com.google.sitebricks.conversion.generics.CaptureType;
import com.google.sitebricks.conversion.generics.VarMap;
import java.lang.reflect.Type;
import java.lang.reflect.TypeVariable;
import java.lang.reflect.WildcardType;
import java.util.ArrayList;
import java.util.Arrays;

class CaptureTypeImpl
implements CaptureType {
    private final WildcardType wildcard;
    private final TypeVariable<?> variable;
    private final Type[] lowerBounds;
    private Type[] upperBounds;

    public CaptureTypeImpl(WildcardType wildcard, TypeVariable<?> variable) {
        this.wildcard = wildcard;
        this.variable = variable;
        this.lowerBounds = wildcard.getLowerBounds();
    }

    void init(VarMap varMap) {
        ArrayList<Type> upperBoundsList = new ArrayList<Type>();
        upperBoundsList.addAll(Arrays.asList(varMap.map(this.variable.getBounds())));
        upperBoundsList.addAll(Arrays.asList(this.wildcard.getUpperBounds()));
        this.upperBounds = new Type[upperBoundsList.size()];
        upperBoundsList.toArray(this.upperBounds);
    }

    @Override
    public Type[] getLowerBounds() {
        return (Type[])this.lowerBounds.clone();
    }

    @Override
    public Type[] getUpperBounds() {
        assert (this.upperBounds != null);
        return (Type[])this.upperBounds.clone();
    }

    public String toString() {
        return "capture of " + this.wildcard;
    }
}

