/*
 * Decompiled with CFR 0.152.
 */
package com.google.sitebricks.conversion;

import com.google.common.collect.ArrayListMultimap;
import com.google.common.collect.Multimap;
import com.google.common.primitives.Primitives;
import com.google.inject.Inject;
import com.google.inject.Singleton;
import com.google.sitebricks.conversion.Converter;
import com.google.sitebricks.conversion.ConverterRegistry;
import com.google.sitebricks.conversion.TypeConverter;
import com.google.sitebricks.conversion.generics.Generics;
import java.lang.reflect.Type;
import java.lang.reflect.TypeVariable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Set;

@Singleton
public class StandardTypeConverter
implements TypeConverter,
ConverterRegistry {
    Multimap<Type, Converter<?, ?>> convertersBySource = ArrayListMultimap.create();
    Multimap<Type, Converter<?, ?>> convertersByTarget = ArrayListMultimap.create();
    Multimap<SourceAndTarget, Converter<?, ?>> convertersBySourceAndTarget = ArrayListMultimap.create();
    private static final TypeVariable<? extends Class<?>> sourceTypeParameter = Converter.class.getTypeParameters()[0];
    private static final TypeVariable<? extends Class<?>> targetTypeParameter = Converter.class.getTypeParameters()[1];

    @Inject
    public StandardTypeConverter(Set<Converter> converters) {
        for (Converter converter : converters) {
            this.register(converter);
        }
    }

    @Override
    public void register(Converter<?, ?> converter) {
        Type sourceType = StandardTypeConverter.sourceType(converter);
        Type targetType = StandardTypeConverter.targetType(converter);
        this.convertersBySource.put((Object)sourceType, converter);
        this.convertersByTarget.put((Object)targetType, converter);
        this.convertersBySourceAndTarget.put((Object)new SourceAndTarget(sourceType, targetType), converter);
    }

    public static Type targetType(Converter<?, ?> converter) {
        return Generics.getTypeParameter(converter.getClass(), targetTypeParameter);
    }

    public static Type sourceType(Converter<?, ?> converter) {
        return Generics.getTypeParameter(converter.getClass(), sourceTypeParameter);
    }

    @Override
    public <T> T convert(Object source, Type type) {
        if (source == null) {
            return (T)this.nullValue(type);
        }
        if (source.getClass() == type) {
            return (T)source;
        }
        if (Generics.isSuperType(type, source.getClass())) {
            return (T)source;
        }
        if ("".equals(source) && type != String.class && this.isEmptyStringNull()) {
            return null;
        }
        Type sourceType = source.getClass();
        Class<?> sourceClass = Generics.erase(sourceType);
        if (sourceClass.isArray() && Generics.isSuperType(Collection.class, type)) {
            return (T)Arrays.asList(source);
        }
        Class<?> targetClass = Generics.erase(type);
        if (Collection.class.isAssignableFrom(sourceClass) && targetClass.isArray()) {
            throw new UnsupportedOperationException("Not implemented yet");
        }
        if (type instanceof Class && ((Class)type).isPrimitive()) {
            type = Primitives.wrap((Class)((Class)type));
        }
        T result = null;
        do {
            SourceAndTarget key = new SourceAndTarget(sourceType, type);
            Collection forwards = this.convertersBySourceAndTarget.get((Object)key);
            for (Converter forward : forwards) {
                T t = StandardTypeConverter.typeSafeTo(forward, source);
                result = t;
                if (t == null) continue;
                break;
            }
            if (result == null) {
                Collection reverses = this.convertersBySourceAndTarget.get((Object)key.reverse());
                for (Converter reverse : reverses) {
                    Object s = StandardTypeConverter.typeSafeFrom(reverse, source);
                    result = (T)s;
                    if (s == null) continue;
                    break;
                }
            }
            if (sourceType == Object.class) break;
            Class<?> superClass = Generics.erase(sourceType).getSuperclass();
            sourceType = Generics.getExactSuperType(sourceType, superClass);
        } while (result == null);
        if (result == null) {
            throw new IllegalStateException("Cannot convert " + source.getClass() + " to " + type);
        }
        return result;
    }

    @Override
    public Collection<Converter<?, ?>> converter(Type source, Type target) {
        SourceAndTarget key = new SourceAndTarget(source, target);
        return this.convertersBySourceAndTarget.get((Object)key);
    }

    protected boolean isEmptyStringNull() {
        return true;
    }

    protected Object nullValue(Type type) {
        if (type == String.class) {
            return "";
        }
        return null;
    }

    public static <T, S> T typeSafeTo(Converter<?, ?> converter, S source) {
        return (T)converter.to(source);
    }

    public static <T, S> S typeSafeFrom(Converter<?, ?> converter, T source) {
        return (S)converter.from(source);
    }

    @Override
    public Multimap<Type, Converter<?, ?>> getConvertersBySource() {
        return this.convertersBySource;
    }

    @Override
    public Multimap<Type, Converter<?, ?>> getConvertersByTarget() {
        return this.convertersByTarget;
    }

    private static final class SourceAndTarget {
        private Type source;
        private Type target;

        public SourceAndTarget(Type source, Type target) {
            this.source = source;
            this.target = target;
        }

        public SourceAndTarget reverse() {
            return new SourceAndTarget(this.target, this.source);
        }

        public int hashCode() {
            int prime = 31;
            int result = 1;
            result = 31 * result + (this.source == null ? 0 : this.source.hashCode());
            result = 31 * result + (this.target == null ? 0 : this.target.hashCode());
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            SourceAndTarget other = (SourceAndTarget)obj;
            if (this.source == null ? other.source != null : !this.source.equals(other.source)) {
                return false;
            }
            return !(this.target == null ? other.target != null : !this.target.equals(other.target));
        }
    }
}

