/*
 * Decompiled with CFR 0.152.
 */
package com.google.shopping.css.v1;

import com.google.api.core.ApiFuture;
import com.google.api.core.ApiFutures;
import com.google.api.gax.core.BackgroundResource;
import com.google.api.gax.paging.AbstractFixedSizeCollection;
import com.google.api.gax.paging.AbstractPage;
import com.google.api.gax.paging.AbstractPagedListResponse;
import com.google.api.gax.rpc.PageContext;
import com.google.api.gax.rpc.UnaryCallable;
import com.google.common.util.concurrent.MoreExecutors;
import com.google.shopping.css.v1.AccountName;
import com.google.shopping.css.v1.ListQuotaGroupsRequest;
import com.google.shopping.css.v1.ListQuotaGroupsResponse;
import com.google.shopping.css.v1.QuotaGroup;
import com.google.shopping.css.v1.QuotaServiceSettings;
import com.google.shopping.css.v1.stub.QuotaServiceStub;
import com.google.shopping.css.v1.stub.QuotaServiceStubSettings;
import java.io.IOException;
import java.util.List;
import java.util.concurrent.Executor;
import java.util.concurrent.TimeUnit;

public class QuotaServiceClient
implements BackgroundResource {
    private final QuotaServiceSettings settings;
    private final QuotaServiceStub stub;

    public static final QuotaServiceClient create() throws IOException {
        return QuotaServiceClient.create(QuotaServiceSettings.newBuilder().build());
    }

    public static final QuotaServiceClient create(QuotaServiceSettings settings) throws IOException {
        return new QuotaServiceClient(settings);
    }

    public static final QuotaServiceClient create(QuotaServiceStub stub) {
        return new QuotaServiceClient(stub);
    }

    protected QuotaServiceClient(QuotaServiceSettings settings) throws IOException {
        this.settings = settings;
        this.stub = ((QuotaServiceStubSettings)settings.getStubSettings()).createStub();
    }

    protected QuotaServiceClient(QuotaServiceStub stub) {
        this.settings = null;
        this.stub = stub;
    }

    public final QuotaServiceSettings getSettings() {
        return this.settings;
    }

    public QuotaServiceStub getStub() {
        return this.stub;
    }

    public final ListQuotaGroupsPagedResponse listQuotaGroups(AccountName parent) {
        ListQuotaGroupsRequest request = ListQuotaGroupsRequest.newBuilder().setParent(parent == null ? null : parent.toString()).build();
        return this.listQuotaGroups(request);
    }

    public final ListQuotaGroupsPagedResponse listQuotaGroups(String parent) {
        ListQuotaGroupsRequest request = ListQuotaGroupsRequest.newBuilder().setParent(parent).build();
        return this.listQuotaGroups(request);
    }

    public final ListQuotaGroupsPagedResponse listQuotaGroups(ListQuotaGroupsRequest request) {
        return (ListQuotaGroupsPagedResponse)((Object)this.listQuotaGroupsPagedCallable().call((Object)request));
    }

    public final UnaryCallable<ListQuotaGroupsRequest, ListQuotaGroupsPagedResponse> listQuotaGroupsPagedCallable() {
        return this.stub.listQuotaGroupsPagedCallable();
    }

    public final UnaryCallable<ListQuotaGroupsRequest, ListQuotaGroupsResponse> listQuotaGroupsCallable() {
        return this.stub.listQuotaGroupsCallable();
    }

    public final void close() {
        this.stub.close();
    }

    public void shutdown() {
        this.stub.shutdown();
    }

    public boolean isShutdown() {
        return this.stub.isShutdown();
    }

    public boolean isTerminated() {
        return this.stub.isTerminated();
    }

    public void shutdownNow() {
        this.stub.shutdownNow();
    }

    public boolean awaitTermination(long duration, TimeUnit unit) throws InterruptedException {
        return this.stub.awaitTermination(duration, unit);
    }

    public static class ListQuotaGroupsFixedSizeCollection
    extends AbstractFixedSizeCollection<ListQuotaGroupsRequest, ListQuotaGroupsResponse, QuotaGroup, ListQuotaGroupsPage, ListQuotaGroupsFixedSizeCollection> {
        private ListQuotaGroupsFixedSizeCollection(List<ListQuotaGroupsPage> pages, int collectionSize) {
            super(pages, collectionSize);
        }

        private static ListQuotaGroupsFixedSizeCollection createEmptyCollection() {
            return new ListQuotaGroupsFixedSizeCollection(null, 0);
        }

        protected ListQuotaGroupsFixedSizeCollection createCollection(List<ListQuotaGroupsPage> pages, int collectionSize) {
            return new ListQuotaGroupsFixedSizeCollection(pages, collectionSize);
        }
    }

    public static class ListQuotaGroupsPage
    extends AbstractPage<ListQuotaGroupsRequest, ListQuotaGroupsResponse, QuotaGroup, ListQuotaGroupsPage> {
        private ListQuotaGroupsPage(PageContext<ListQuotaGroupsRequest, ListQuotaGroupsResponse, QuotaGroup> context, ListQuotaGroupsResponse response) {
            super(context, (Object)response);
        }

        private static ListQuotaGroupsPage createEmptyPage() {
            return new ListQuotaGroupsPage(null, null);
        }

        protected ListQuotaGroupsPage createPage(PageContext<ListQuotaGroupsRequest, ListQuotaGroupsResponse, QuotaGroup> context, ListQuotaGroupsResponse response) {
            return new ListQuotaGroupsPage(context, response);
        }

        public ApiFuture<ListQuotaGroupsPage> createPageAsync(PageContext<ListQuotaGroupsRequest, ListQuotaGroupsResponse, QuotaGroup> context, ApiFuture<ListQuotaGroupsResponse> futureResponse) {
            return super.createPageAsync(context, futureResponse);
        }
    }

    public static class ListQuotaGroupsPagedResponse
    extends AbstractPagedListResponse<ListQuotaGroupsRequest, ListQuotaGroupsResponse, QuotaGroup, ListQuotaGroupsPage, ListQuotaGroupsFixedSizeCollection> {
        public static ApiFuture<ListQuotaGroupsPagedResponse> createAsync(PageContext<ListQuotaGroupsRequest, ListQuotaGroupsResponse, QuotaGroup> context, ApiFuture<ListQuotaGroupsResponse> futureResponse) {
            ApiFuture<ListQuotaGroupsPage> futurePage = ListQuotaGroupsPage.createEmptyPage().createPageAsync(context, futureResponse);
            return ApiFutures.transform(futurePage, input -> new ListQuotaGroupsPagedResponse((ListQuotaGroupsPage)((Object)input)), (Executor)MoreExecutors.directExecutor());
        }

        private ListQuotaGroupsPagedResponse(ListQuotaGroupsPage page) {
            super((AbstractPage)page, (AbstractFixedSizeCollection)ListQuotaGroupsFixedSizeCollection.createEmptyCollection());
        }
    }
}

