/*
 * Decompiled with CFR 0.152.
 */
package com.google.shopping.css.v1;

import com.google.api.core.ApiFuture;
import com.google.api.core.ApiFutures;
import com.google.api.gax.core.BackgroundResource;
import com.google.api.gax.paging.AbstractFixedSizeCollection;
import com.google.api.gax.paging.AbstractPage;
import com.google.api.gax.paging.AbstractPagedListResponse;
import com.google.api.gax.rpc.PageContext;
import com.google.api.gax.rpc.UnaryCallable;
import com.google.common.util.concurrent.MoreExecutors;
import com.google.shopping.css.v1.AccountName;
import com.google.shopping.css.v1.CssProduct;
import com.google.shopping.css.v1.CssProductName;
import com.google.shopping.css.v1.CssProductsServiceSettings;
import com.google.shopping.css.v1.GetCssProductRequest;
import com.google.shopping.css.v1.ListCssProductsRequest;
import com.google.shopping.css.v1.ListCssProductsResponse;
import com.google.shopping.css.v1.stub.CssProductsServiceStub;
import com.google.shopping.css.v1.stub.CssProductsServiceStubSettings;
import java.io.IOException;
import java.util.List;
import java.util.concurrent.Executor;
import java.util.concurrent.TimeUnit;

public class CssProductsServiceClient
implements BackgroundResource {
    private final CssProductsServiceSettings settings;
    private final CssProductsServiceStub stub;

    public static final CssProductsServiceClient create() throws IOException {
        return CssProductsServiceClient.create(CssProductsServiceSettings.newBuilder().build());
    }

    public static final CssProductsServiceClient create(CssProductsServiceSettings settings) throws IOException {
        return new CssProductsServiceClient(settings);
    }

    public static final CssProductsServiceClient create(CssProductsServiceStub stub) {
        return new CssProductsServiceClient(stub);
    }

    protected CssProductsServiceClient(CssProductsServiceSettings settings) throws IOException {
        this.settings = settings;
        this.stub = ((CssProductsServiceStubSettings)settings.getStubSettings()).createStub();
    }

    protected CssProductsServiceClient(CssProductsServiceStub stub) {
        this.settings = null;
        this.stub = stub;
    }

    public final CssProductsServiceSettings getSettings() {
        return this.settings;
    }

    public CssProductsServiceStub getStub() {
        return this.stub;
    }

    public final CssProduct getCssProduct(CssProductName name) {
        GetCssProductRequest request = GetCssProductRequest.newBuilder().setName(name == null ? null : name.toString()).build();
        return this.getCssProduct(request);
    }

    public final CssProduct getCssProduct(String name) {
        GetCssProductRequest request = GetCssProductRequest.newBuilder().setName(name).build();
        return this.getCssProduct(request);
    }

    public final CssProduct getCssProduct(GetCssProductRequest request) {
        return (CssProduct)this.getCssProductCallable().call((Object)request);
    }

    public final UnaryCallable<GetCssProductRequest, CssProduct> getCssProductCallable() {
        return this.stub.getCssProductCallable();
    }

    public final ListCssProductsPagedResponse listCssProducts(AccountName parent) {
        ListCssProductsRequest request = ListCssProductsRequest.newBuilder().setParent(parent == null ? null : parent.toString()).build();
        return this.listCssProducts(request);
    }

    public final ListCssProductsPagedResponse listCssProducts(String parent) {
        ListCssProductsRequest request = ListCssProductsRequest.newBuilder().setParent(parent).build();
        return this.listCssProducts(request);
    }

    public final ListCssProductsPagedResponse listCssProducts(ListCssProductsRequest request) {
        return (ListCssProductsPagedResponse)((Object)this.listCssProductsPagedCallable().call((Object)request));
    }

    public final UnaryCallable<ListCssProductsRequest, ListCssProductsPagedResponse> listCssProductsPagedCallable() {
        return this.stub.listCssProductsPagedCallable();
    }

    public final UnaryCallable<ListCssProductsRequest, ListCssProductsResponse> listCssProductsCallable() {
        return this.stub.listCssProductsCallable();
    }

    public final void close() {
        this.stub.close();
    }

    public void shutdown() {
        this.stub.shutdown();
    }

    public boolean isShutdown() {
        return this.stub.isShutdown();
    }

    public boolean isTerminated() {
        return this.stub.isTerminated();
    }

    public void shutdownNow() {
        this.stub.shutdownNow();
    }

    public boolean awaitTermination(long duration, TimeUnit unit) throws InterruptedException {
        return this.stub.awaitTermination(duration, unit);
    }

    public static class ListCssProductsFixedSizeCollection
    extends AbstractFixedSizeCollection<ListCssProductsRequest, ListCssProductsResponse, CssProduct, ListCssProductsPage, ListCssProductsFixedSizeCollection> {
        private ListCssProductsFixedSizeCollection(List<ListCssProductsPage> pages, int collectionSize) {
            super(pages, collectionSize);
        }

        private static ListCssProductsFixedSizeCollection createEmptyCollection() {
            return new ListCssProductsFixedSizeCollection(null, 0);
        }

        protected ListCssProductsFixedSizeCollection createCollection(List<ListCssProductsPage> pages, int collectionSize) {
            return new ListCssProductsFixedSizeCollection(pages, collectionSize);
        }
    }

    public static class ListCssProductsPage
    extends AbstractPage<ListCssProductsRequest, ListCssProductsResponse, CssProduct, ListCssProductsPage> {
        private ListCssProductsPage(PageContext<ListCssProductsRequest, ListCssProductsResponse, CssProduct> context, ListCssProductsResponse response) {
            super(context, (Object)response);
        }

        private static ListCssProductsPage createEmptyPage() {
            return new ListCssProductsPage(null, null);
        }

        protected ListCssProductsPage createPage(PageContext<ListCssProductsRequest, ListCssProductsResponse, CssProduct> context, ListCssProductsResponse response) {
            return new ListCssProductsPage(context, response);
        }

        public ApiFuture<ListCssProductsPage> createPageAsync(PageContext<ListCssProductsRequest, ListCssProductsResponse, CssProduct> context, ApiFuture<ListCssProductsResponse> futureResponse) {
            return super.createPageAsync(context, futureResponse);
        }
    }

    public static class ListCssProductsPagedResponse
    extends AbstractPagedListResponse<ListCssProductsRequest, ListCssProductsResponse, CssProduct, ListCssProductsPage, ListCssProductsFixedSizeCollection> {
        public static ApiFuture<ListCssProductsPagedResponse> createAsync(PageContext<ListCssProductsRequest, ListCssProductsResponse, CssProduct> context, ApiFuture<ListCssProductsResponse> futureResponse) {
            ApiFuture<ListCssProductsPage> futurePage = ListCssProductsPage.createEmptyPage().createPageAsync(context, futureResponse);
            return ApiFutures.transform(futurePage, input -> new ListCssProductsPagedResponse((ListCssProductsPage)((Object)input)), (Executor)MoreExecutors.directExecutor());
        }

        private ListCssProductsPagedResponse(ListCssProductsPage page) {
            super((AbstractPage)page, (AbstractFixedSizeCollection)ListCssProductsFixedSizeCollection.createEmptyCollection());
        }
    }
}

