/*
 * Decompiled with CFR 0.152.
 */
package com.google.shopping.css.v1.stub;

import com.google.api.core.ApiFunction;
import com.google.api.core.ApiFuture;
import com.google.api.core.BetaApi;
import com.google.api.gax.core.CredentialsProvider;
import com.google.api.gax.core.GaxProperties;
import com.google.api.gax.core.GoogleCredentialsProvider;
import com.google.api.gax.core.InstantiatingExecutorProvider;
import com.google.api.gax.grpc.GaxGrpcProperties;
import com.google.api.gax.grpc.GrpcTransportChannel;
import com.google.api.gax.grpc.InstantiatingGrpcChannelProvider;
import com.google.api.gax.httpjson.GaxHttpJsonProperties;
import com.google.api.gax.httpjson.HttpJsonTransportChannel;
import com.google.api.gax.httpjson.InstantiatingHttpJsonChannelProvider;
import com.google.api.gax.retrying.RetrySettings;
import com.google.api.gax.rpc.ApiCallContext;
import com.google.api.gax.rpc.ApiClientHeaderProvider;
import com.google.api.gax.rpc.ClientContext;
import com.google.api.gax.rpc.HeaderProvider;
import com.google.api.gax.rpc.PageContext;
import com.google.api.gax.rpc.PagedCallSettings;
import com.google.api.gax.rpc.PagedListDescriptor;
import com.google.api.gax.rpc.PagedListResponseFactory;
import com.google.api.gax.rpc.StatusCode;
import com.google.api.gax.rpc.StubSettings;
import com.google.api.gax.rpc.TransportChannelProvider;
import com.google.api.gax.rpc.UnaryCallSettings;
import com.google.api.gax.rpc.UnaryCallable;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Lists;
import com.google.shopping.css.v1.CssProduct;
import com.google.shopping.css.v1.CssProductsServiceClient;
import com.google.shopping.css.v1.GetCssProductRequest;
import com.google.shopping.css.v1.ListCssProductsRequest;
import com.google.shopping.css.v1.ListCssProductsResponse;
import com.google.shopping.css.v1.stub.CssProductsServiceStub;
import com.google.shopping.css.v1.stub.GrpcCssProductsServiceStub;
import com.google.shopping.css.v1.stub.HttpJsonCssProductsServiceStub;
import java.io.IOException;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import org.threeten.bp.Duration;

public class CssProductsServiceStubSettings
extends StubSettings<CssProductsServiceStubSettings> {
    private static final ImmutableList<String> DEFAULT_SERVICE_SCOPES = ImmutableList.builder().add((Object)"https://www.googleapis.com/auth/content").build();
    private final UnaryCallSettings<GetCssProductRequest, CssProduct> getCssProductSettings;
    private final PagedCallSettings<ListCssProductsRequest, ListCssProductsResponse, CssProductsServiceClient.ListCssProductsPagedResponse> listCssProductsSettings;
    private static final PagedListDescriptor<ListCssProductsRequest, ListCssProductsResponse, CssProduct> LIST_CSS_PRODUCTS_PAGE_STR_DESC = new PagedListDescriptor<ListCssProductsRequest, ListCssProductsResponse, CssProduct>(){

        public String emptyToken() {
            return "";
        }

        public ListCssProductsRequest injectToken(ListCssProductsRequest payload, String token) {
            return ListCssProductsRequest.newBuilder((ListCssProductsRequest)payload).setPageToken(token).build();
        }

        public ListCssProductsRequest injectPageSize(ListCssProductsRequest payload, int pageSize) {
            return ListCssProductsRequest.newBuilder((ListCssProductsRequest)payload).setPageSize(pageSize).build();
        }

        public Integer extractPageSize(ListCssProductsRequest payload) {
            return payload.getPageSize();
        }

        public String extractNextToken(ListCssProductsResponse payload) {
            return payload.getNextPageToken();
        }

        public Iterable<CssProduct> extractResources(ListCssProductsResponse payload) {
            return payload.getCssProductsList() == null ? ImmutableList.of() : payload.getCssProductsList();
        }
    };
    private static final PagedListResponseFactory<ListCssProductsRequest, ListCssProductsResponse, CssProductsServiceClient.ListCssProductsPagedResponse> LIST_CSS_PRODUCTS_PAGE_STR_FACT = new PagedListResponseFactory<ListCssProductsRequest, ListCssProductsResponse, CssProductsServiceClient.ListCssProductsPagedResponse>(){

        public ApiFuture<CssProductsServiceClient.ListCssProductsPagedResponse> getFuturePagedResponse(UnaryCallable<ListCssProductsRequest, ListCssProductsResponse> callable, ListCssProductsRequest request, ApiCallContext context, ApiFuture<ListCssProductsResponse> futureResponse) {
            PageContext pageContext = PageContext.create(callable, (PagedListDescriptor)LIST_CSS_PRODUCTS_PAGE_STR_DESC, (Object)request, (ApiCallContext)context);
            return CssProductsServiceClient.ListCssProductsPagedResponse.createAsync((PageContext<ListCssProductsRequest, ListCssProductsResponse, CssProduct>)pageContext, futureResponse);
        }
    };

    public UnaryCallSettings<GetCssProductRequest, CssProduct> getCssProductSettings() {
        return this.getCssProductSettings;
    }

    public PagedCallSettings<ListCssProductsRequest, ListCssProductsResponse, CssProductsServiceClient.ListCssProductsPagedResponse> listCssProductsSettings() {
        return this.listCssProductsSettings;
    }

    public CssProductsServiceStub createStub() throws IOException {
        if (this.getTransportChannelProvider().getTransportName().equals(GrpcTransportChannel.getGrpcTransportName())) {
            return GrpcCssProductsServiceStub.create(this);
        }
        if (this.getTransportChannelProvider().getTransportName().equals(HttpJsonTransportChannel.getHttpJsonTransportName())) {
            return HttpJsonCssProductsServiceStub.create(this);
        }
        throw new UnsupportedOperationException(String.format("Transport not supported: %s", this.getTransportChannelProvider().getTransportName()));
    }

    public String getServiceName() {
        return "css";
    }

    public static InstantiatingExecutorProvider.Builder defaultExecutorProviderBuilder() {
        return InstantiatingExecutorProvider.newBuilder();
    }

    public static String getDefaultEndpoint() {
        return "css.googleapis.com:443";
    }

    public static String getDefaultMtlsEndpoint() {
        return "css.mtls.googleapis.com:443";
    }

    public static List<String> getDefaultServiceScopes() {
        return DEFAULT_SERVICE_SCOPES;
    }

    public static GoogleCredentialsProvider.Builder defaultCredentialsProviderBuilder() {
        return GoogleCredentialsProvider.newBuilder().setScopesToApply(DEFAULT_SERVICE_SCOPES).setUseJwtAccessWithScope(true);
    }

    public static InstantiatingGrpcChannelProvider.Builder defaultGrpcTransportProviderBuilder() {
        return InstantiatingGrpcChannelProvider.newBuilder().setMaxInboundMessageSize(Integer.valueOf(Integer.MAX_VALUE));
    }

    @BetaApi
    public static InstantiatingHttpJsonChannelProvider.Builder defaultHttpJsonTransportProviderBuilder() {
        return InstantiatingHttpJsonChannelProvider.newBuilder();
    }

    public static TransportChannelProvider defaultTransportChannelProvider() {
        return CssProductsServiceStubSettings.defaultGrpcTransportProviderBuilder().build();
    }

    @BetaApi(value="The surface for customizing headers is not stable yet and may change in the future.")
    public static ApiClientHeaderProvider.Builder defaultGrpcApiClientHeaderProviderBuilder() {
        return ApiClientHeaderProvider.newBuilder().setGeneratedLibToken("gapic", GaxProperties.getLibraryVersion(CssProductsServiceStubSettings.class)).setTransportToken(GaxGrpcProperties.getGrpcTokenName(), GaxGrpcProperties.getGrpcVersion());
    }

    @BetaApi(value="The surface for customizing headers is not stable yet and may change in the future.")
    public static ApiClientHeaderProvider.Builder defaultHttpJsonApiClientHeaderProviderBuilder() {
        return ApiClientHeaderProvider.newBuilder().setGeneratedLibToken("gapic", GaxProperties.getLibraryVersion(CssProductsServiceStubSettings.class)).setTransportToken(GaxHttpJsonProperties.getHttpJsonTokenName(), GaxHttpJsonProperties.getHttpJsonVersion());
    }

    public static ApiClientHeaderProvider.Builder defaultApiClientHeaderProviderBuilder() {
        return CssProductsServiceStubSettings.defaultGrpcApiClientHeaderProviderBuilder();
    }

    public static Builder newBuilder() {
        return Builder.createDefault();
    }

    public static Builder newHttpJsonBuilder() {
        return Builder.createHttpJsonDefault();
    }

    public static Builder newBuilder(ClientContext clientContext) {
        return new Builder(clientContext);
    }

    public Builder toBuilder() {
        return new Builder(this);
    }

    protected CssProductsServiceStubSettings(Builder settingsBuilder) throws IOException {
        super((StubSettings.Builder)settingsBuilder);
        this.getCssProductSettings = settingsBuilder.getCssProductSettings().build();
        this.listCssProductsSettings = settingsBuilder.listCssProductsSettings().build();
    }

    public static class Builder
    extends StubSettings.Builder<CssProductsServiceStubSettings, Builder> {
        private final ImmutableList<UnaryCallSettings.Builder<?, ?>> unaryMethodSettingsBuilders;
        private final UnaryCallSettings.Builder<GetCssProductRequest, CssProduct> getCssProductSettings;
        private final PagedCallSettings.Builder<ListCssProductsRequest, ListCssProductsResponse, CssProductsServiceClient.ListCssProductsPagedResponse> listCssProductsSettings;
        private static final ImmutableMap<String, ImmutableSet<StatusCode.Code>> RETRYABLE_CODE_DEFINITIONS;
        private static final ImmutableMap<String, RetrySettings> RETRY_PARAM_DEFINITIONS;

        protected Builder() {
            this((ClientContext)null);
        }

        protected Builder(ClientContext clientContext) {
            super(clientContext);
            this.getCssProductSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.listCssProductsSettings = PagedCallSettings.newBuilder((PagedListResponseFactory)LIST_CSS_PRODUCTS_PAGE_STR_FACT);
            this.unaryMethodSettingsBuilders = ImmutableList.of(this.getCssProductSettings, this.listCssProductsSettings);
            Builder.initDefaults(this);
        }

        protected Builder(CssProductsServiceStubSettings settings) {
            super((StubSettings)settings);
            this.getCssProductSettings = settings.getCssProductSettings.toBuilder();
            this.listCssProductsSettings = settings.listCssProductsSettings.toBuilder();
            this.unaryMethodSettingsBuilders = ImmutableList.of(this.getCssProductSettings, this.listCssProductsSettings);
        }

        private static Builder createDefault() {
            Builder builder = new Builder((ClientContext)null);
            builder.setTransportChannelProvider(CssProductsServiceStubSettings.defaultTransportChannelProvider());
            builder.setCredentialsProvider((CredentialsProvider)CssProductsServiceStubSettings.defaultCredentialsProviderBuilder().build());
            builder.setInternalHeaderProvider((HeaderProvider)CssProductsServiceStubSettings.defaultApiClientHeaderProviderBuilder().build());
            builder.setEndpoint(CssProductsServiceStubSettings.getDefaultEndpoint());
            builder.setMtlsEndpoint(CssProductsServiceStubSettings.getDefaultMtlsEndpoint());
            builder.setSwitchToMtlsEndpointAllowed(true);
            return Builder.initDefaults(builder);
        }

        private static Builder createHttpJsonDefault() {
            Builder builder = new Builder((ClientContext)null);
            builder.setTransportChannelProvider((TransportChannelProvider)CssProductsServiceStubSettings.defaultHttpJsonTransportProviderBuilder().build());
            builder.setCredentialsProvider((CredentialsProvider)CssProductsServiceStubSettings.defaultCredentialsProviderBuilder().build());
            builder.setInternalHeaderProvider((HeaderProvider)CssProductsServiceStubSettings.defaultHttpJsonApiClientHeaderProviderBuilder().build());
            builder.setEndpoint(CssProductsServiceStubSettings.getDefaultEndpoint());
            builder.setMtlsEndpoint(CssProductsServiceStubSettings.getDefaultMtlsEndpoint());
            builder.setSwitchToMtlsEndpointAllowed(true);
            return Builder.initDefaults(builder);
        }

        private static Builder initDefaults(Builder builder) {
            builder.getCssProductSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"retry_policy_0_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"retry_policy_0_params"));
            builder.listCssProductsSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"retry_policy_0_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"retry_policy_0_params"));
            return builder;
        }

        public Builder applyToAllUnaryMethods(ApiFunction<UnaryCallSettings.Builder<?, ?>, Void> settingsUpdater) {
            StubSettings.Builder.applyToAllUnaryMethods(this.unaryMethodSettingsBuilders, settingsUpdater);
            return this;
        }

        public ImmutableList<UnaryCallSettings.Builder<?, ?>> unaryMethodSettingsBuilders() {
            return this.unaryMethodSettingsBuilders;
        }

        public UnaryCallSettings.Builder<GetCssProductRequest, CssProduct> getCssProductSettings() {
            return this.getCssProductSettings;
        }

        public PagedCallSettings.Builder<ListCssProductsRequest, ListCssProductsResponse, CssProductsServiceClient.ListCssProductsPagedResponse> listCssProductsSettings() {
            return this.listCssProductsSettings;
        }

        public CssProductsServiceStubSettings build() throws IOException {
            return new CssProductsServiceStubSettings(this);
        }

        static {
            ImmutableMap.Builder definitions = ImmutableMap.builder();
            definitions.put((Object)"retry_policy_0_codes", (Object)ImmutableSet.copyOf((Collection)Lists.newArrayList((Object[])new StatusCode.Code[]{StatusCode.Code.UNAVAILABLE})));
            RETRYABLE_CODE_DEFINITIONS = definitions.build();
            definitions = ImmutableMap.builder();
            RetrySettings settings = null;
            settings = RetrySettings.newBuilder().setInitialRetryDelay(Duration.ofMillis((long)1000L)).setRetryDelayMultiplier(1.3).setMaxRetryDelay(Duration.ofMillis((long)10000L)).setInitialRpcTimeout(Duration.ofMillis((long)60000L)).setRpcTimeoutMultiplier(1.0).setMaxRpcTimeout(Duration.ofMillis((long)60000L)).setTotalTimeout(Duration.ofMillis((long)60000L)).build();
            definitions.put((Object)"retry_policy_0_params", (Object)settings);
            RETRY_PARAM_DEFINITIONS = definitions.build();
        }
    }
}

