/*
 * Decompiled with CFR 0.152.
 */
package com.google.security.fences.util;

import com.google.common.base.Preconditions;
import java.util.Iterator;

public final class CountingIterator
implements Iterator<Integer> {
    private int i;
    private final int rightExclusive;

    CountingIterator(int leftInclusive, int rightExclusive) {
        Preconditions.checkArgument((leftInclusive <= rightExclusive ? 1 : 0) != 0);
        this.i = leftInclusive;
        this.rightExclusive = rightExclusive;
    }

    public synchronized String toString() {
        return "[" + this.i + ".." + this.rightExclusive + ")";
    }

    @Override
    public synchronized boolean hasNext() {
        return this.i < this.rightExclusive;
    }

    @Override
    public synchronized Integer next() {
        if (this.i >= this.rightExclusive) {
            throw new IndexOutOfBoundsException(this.i + " >= " + this.rightExclusive);
        }
        return this.i++;
    }

    @Override
    public void remove() {
        throw new UnsupportedOperationException();
    }
}

