/*
 * Decompiled with CFR 0.152.
 */
package com.google.security.fences.util;

import com.google.common.base.Preconditions;
import com.google.security.fences.util.CountingIterator;
import java.util.Iterator;

public final class CountingIterable
implements Iterable<Integer> {
    private final int leftInclusive;
    private final int rightExclusive;

    CountingIterable(int leftInclusive, int rightExclusive) {
        Preconditions.checkArgument((leftInclusive <= rightExclusive ? 1 : 0) != 0);
        this.leftInclusive = leftInclusive;
        this.rightExclusive = rightExclusive;
    }

    @Override
    public Iterator<Integer> iterator() {
        return new CountingIterator(this.leftInclusive, this.rightExclusive);
    }

    public String toString() {
        return "[" + this.leftInclusive + ".." + this.rightExclusive + ")";
    }
}

