/*
 * Decompiled with CFR 0.152.
 */
package com.google.security.fences.policy;

import com.google.common.base.Optional;
import com.google.common.base.Preconditions;
import com.google.common.collect.Sets;
import com.google.security.fences.inheritance.ClassNode;
import com.google.security.fences.inheritance.FieldDetails;
import com.google.security.fences.inheritance.InheritanceGraph;
import com.google.security.fences.inheritance.MethodDetails;
import com.google.security.fences.policy.ApiElement;
import com.google.security.fences.policy.ApiElementType;
import com.google.security.fences.util.LazyString;
import java.util.ArrayDeque;
import java.util.Deque;
import java.util.Iterator;
import java.util.NoSuchElementException;
import java.util.PriorityQueue;
import java.util.Set;
import org.apache.maven.plugin.logging.Log;

public final class PolicyApplicationOrder
implements Iterable<ApiElement> {
    private final ApiElement used;
    private final String descriptor;
    private final InheritanceGraph inheritanceGraph;
    private final Log log;

    public PolicyApplicationOrder(ApiElement used, String descriptor, InheritanceGraph inheritanceGraph, Log log) {
        Preconditions.checkArgument((used.type == ApiElementType.CONSTRUCTOR || used.type == ApiElementType.FIELD || used.type == ApiElementType.METHOD ? 1 : 0) != 0);
        this.used = used;
        this.descriptor = descriptor;
        this.inheritanceGraph = inheritanceGraph;
        this.log = log;
    }

    @Override
    public Iterator<ApiElement> iterator() {
        return new ApiElementIterator();
    }

    private Optional<ClassNode> classContaining(ApiElement el) {
        Optional<ApiElement> elClass = el.containingClass();
        Preconditions.checkState((boolean)elClass.isPresent());
        final String elInternalName = ((ApiElement)elClass.get()).toInternalName();
        Optional<ClassNode> cn = this.inheritanceGraph.named(elInternalName);
        if (!cn.isPresent()) {
            this.log.debug((CharSequence)new LazyString(){

                @Override
                protected String makeString() {
                    return "Did not find node for class " + elInternalName;
                }
            });
        }
        return cn;
    }

    static Optional<ApiElement> apiElementFromSuper(ApiElement el, String superTypeName) {
        switch (el.type) {
            case CLASS: {
                return Optional.of((Object)ApiElement.fromInternalClassName(superTypeName));
            }
            case METHOD: 
            case FIELD: 
            case CONSTRUCTOR: {
                return Optional.of((Object)((ApiElement)PolicyApplicationOrder.apiElementFromSuper((ApiElement)el.parent.get(), superTypeName).get()).child(el.name, el.type));
            }
            case PACKAGE: {
                return Optional.absent();
            }
        }
        throw new AssertionError((Object)el.type);
    }

    final class ApiElementIterator
    implements Iterator<ApiElement> {
        private final PriorityQueue<SubList> sublists = new PriorityQueue();
        private final Set<QueueItem> enqueued = Sets.newHashSet();
        private final Set<ApiElement> produced = Sets.newHashSet();
        private QueueItem pending;
        private SubList source;
        private boolean consumed;
        private final SubList useOnly = new SubList(0){

            @Override
            void addLowerPrecedenceItems(QueueItem item) {
                ApiElementIterator.this.addCorrespondingMembers(item, true);
            }
        };
        private final SubList superTypeMembers = new SubList(1){

            @Override
            void addLowerPrecedenceItems(QueueItem item) {
                ApiElementIterator.this.addCorrespondingMembers(item, false);
            }
        };
        private final SubList interfaceMethods = new SubList(2){

            @Override
            void addLowerPrecedenceItems(QueueItem item) {
                ApiElementIterator.this.addCorrespondingMembers(item, false);
            }
        };
        private final SubList classes = new SubList(3){

            @Override
            void addLowerPrecedenceItems(QueueItem item) {
                ApiElementIterator.this.addOuterClassesAndPackages(item);
            }
        };
        private final SubList interfaces = new SubList(4){

            @Override
            void addLowerPrecedenceItems(QueueItem item) {
                ApiElementIterator.this.addOuterClassesAndPackages(item);
            }
        };
        private final SubList outerClasses = new SubList(5){

            @Override
            void addLowerPrecedenceItems(QueueItem item) {
                ApiElementIterator.this.addOuterClassesAndPackages(item);
            }
        };
        private final SubList packages = new SubList(6){

            @Override
            void addLowerPrecedenceItems(QueueItem item) {
                ApiElementIterator.this.addSuperPackages(item);
            }
        };

        ApiElementIterator() {
            ApiElement el = PolicyApplicationOrder.this.used;
            this.useOnly.add(new QueueItem(el));
        }

        @Override
        public boolean hasNext() {
            this.update();
            return this.pending != null;
        }

        @Override
        public ApiElement next() {
            this.update();
            this.consumed = true;
            if (this.pending == null) {
                throw new NoSuchElementException();
            }
            return this.pending.el;
        }

        private void update() {
            do {
                if (this.pending != null) {
                    if (this.consumed) {
                        this.source.addLowerPrecedenceItems(this.pending);
                        this.consumed = false;
                        this.source = null;
                        this.pending = null;
                    } else {
                        return;
                    }
                }
                this.source = this.sublists.peek();
                if (this.source == null) break;
                this.pending = this.source.removeFirst();
                if (this.source.isEmpty()) {
                    this.sublists.poll();
                }
                boolean bl = this.consumed = !this.produced.add(this.pending.el) || this.pending.skip;
            } while (this.consumed);
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }

        private void addCorrespondingMembers(QueueItem item, boolean isExactUse) {
            ApiElement el = item.el;
            this.addContainingClass(el);
            String name = el.name;
            Optional cnOpt = PolicyApplicationOrder.this.classContaining(el);
            if (cnOpt.isPresent()) {
                ClassNode cn = (ClassNode)cnOpt.get();
                switch (el.type) {
                    case METHOD: {
                        Optional<MethodDetails> md = cn.getMethod(name, PolicyApplicationOrder.this.descriptor);
                        boolean onlyAbstract = item.onlyAbstract;
                        boolean lookOnSuperClass = true;
                        if (md.isPresent()) {
                            boolean isAbstract;
                            int access = ((MethodDetails)md.get()).access;
                            boolean isPrivate = (access & 2) != 0;
                            boolean bl = isAbstract = (access & 0x400) != 0;
                            if (isPrivate && isExactUse) {
                                lookOnSuperClass = false;
                            } else if (isAbstract) {
                                Preconditions.checkState((!isPrivate ? 1 : 0) != 0);
                            } else {
                                boolean bl2 = onlyAbstract = !isPrivate;
                            }
                        }
                        if (lookOnSuperClass) {
                            if (cn.superType.isPresent()) {
                                ApiElement correspondingApiElement = ApiElement.fromInternalClassName((String)cn.superType.get()).child(name, ApiElementType.METHOD);
                                boolean skip = false;
                                Optional superClassNode = PolicyApplicationOrder.this.classContaining(correspondingApiElement);
                                Optional<MethodDetails> superMethod = Optional.absent();
                                if (superClassNode.isPresent()) {
                                    superMethod = ((ClassNode)superClassNode.get()).getMethod(name, PolicyApplicationOrder.this.descriptor);
                                }
                                int superMethodAccess = 0;
                                if (superMethod.isPresent()) {
                                    superMethodAccess = ((MethodDetails)superMethod.get()).access;
                                }
                                if ((superMethodAccess & 2) != 0) {
                                    skip = true;
                                } else if (onlyAbstract) {
                                    skip = (superMethodAccess & 0x400) == 0;
                                }
                                QueueItem correspondingMethod = new QueueItem(correspondingApiElement, onlyAbstract, skip);
                                this.superTypeMembers.add(correspondingMethod);
                            }
                            for (String interfaceName : cn.interfaces) {
                                QueueItem correspondingMethod = new QueueItem(ApiElement.fromInternalClassName(interfaceName).child(name, ApiElementType.METHOD));
                                this.interfaceMethods.add(correspondingMethod);
                            }
                        }
                        return;
                    }
                    case FIELD: {
                        if (cn.superType.isPresent()) {
                            boolean lookOnSuperClass;
                            Optional<FieldDetails> fd = cn.getField(name);
                            if (fd.isPresent()) {
                                boolean isPrivate;
                                int access = ((FieldDetails)fd.get()).access;
                                boolean bl = isPrivate = (access & 2) != 0;
                                lookOnSuperClass = isPrivate ? !isExactUse : false;
                            } else {
                                lookOnSuperClass = true;
                            }
                            if (lookOnSuperClass) {
                                boolean skip;
                                ApiElement correspondingApiElement = ApiElement.fromInternalClassName((String)cn.superType.get()).child(name, ApiElementType.FIELD);
                                Optional superClassNode = PolicyApplicationOrder.this.classContaining(correspondingApiElement);
                                Optional<FieldDetails> superField = Optional.absent();
                                if (superClassNode.isPresent()) {
                                    superField = ((ClassNode)superClassNode.get()).getField(name);
                                }
                                int superFieldAccess = 0;
                                if (superField.isPresent()) {
                                    superFieldAccess = ((FieldDetails)superField.get()).access;
                                }
                                boolean bl = skip = (superFieldAccess & 2) != 0;
                                if (cn.superType.isPresent()) {
                                    this.superTypeMembers.add(new QueueItem(correspondingApiElement, false, skip));
                                }
                            }
                        }
                        return;
                    }
                    case CONSTRUCTOR: {
                        return;
                    }
                }
                throw new AssertionError((Object)el.type);
            }
        }

        private void addContainingClass(ApiElement el) {
            ApiElement classEl = (ApiElement)el.containingClass().get();
            Optional cnOpt = PolicyApplicationOrder.this.classContaining(classEl);
            if (cnOpt.isPresent()) {
                ClassNode cn = (ClassNode)cnOpt.get();
                ((cn.access & 0x200) != 0 ? this.interfaces : this.classes).add(new QueueItem(classEl));
            }
        }

        private void addOuterClassesAndPackages(QueueItem item) {
            ApiElement el = item.el;
            if (el.parent.isPresent()) {
                ApiElement parent = (ApiElement)el.parent.get();
                switch (parent.type) {
                    case CLASS: {
                        this.outerClasses.add(new QueueItem(parent));
                        return;
                    }
                    case PACKAGE: {
                        this.packages.add(new QueueItem(parent));
                        return;
                    }
                }
                throw new AssertionError((Object)parent.type);
            }
        }

        private void addSuperPackages(QueueItem item) {
            Preconditions.checkArgument((item.el.type == ApiElementType.PACKAGE ? 1 : 0) != 0);
            ApiElement el = item.el;
            if (el.parent.isPresent()) {
                this.packages.add(new QueueItem((ApiElement)el.parent.get()));
            }
        }

        private abstract class SubList
        implements Comparable<SubList> {
            private final Deque<QueueItem> items = new ArrayDeque<QueueItem>();
            private final int priority;

            SubList(int priority) {
                this.priority = priority;
            }

            QueueItem removeFirst() {
                return this.items.removeFirst();
            }

            boolean isEmpty() {
                return this.items.isEmpty();
            }

            abstract void addLowerPrecedenceItems(QueueItem var1);

            void add(QueueItem item) {
                if (ApiElementIterator.this.enqueued.add(item)) {
                    boolean wasEmpty = this.items.isEmpty();
                    this.items.add(item);
                    if (wasEmpty) {
                        ApiElementIterator.this.sublists.add(this);
                    }
                }
            }

            @Override
            public int compareTo(SubList ls) {
                return Integer.compare(this.priority, ls.priority);
            }
        }
    }

    private static final class QueueItem {
        final ApiElement el;
        final boolean onlyAbstract;
        final boolean skip;

        QueueItem(ApiElement el) {
            this(el, false, false);
        }

        QueueItem(ApiElement el, boolean onlyAbstract, boolean skip) {
            this.el = el;
            this.onlyAbstract = onlyAbstract;
            this.skip = skip;
        }

        public boolean equals(Object o) {
            if (!(o instanceof QueueItem)) {
                return false;
            }
            QueueItem that = (QueueItem)o;
            return this.el.equals(that.el) && this.onlyAbstract == that.onlyAbstract && this.skip == that.skip;
        }

        public int hashCode() {
            return this.el.hashCode() ^ (this.onlyAbstract ? 1 : 0) ^ (this.skip ? 2 : 0);
        }

        public String toString() {
            return "[QueueItem " + this.el + (this.onlyAbstract ? " onlyAbstract" : "") + "]";
        }
    }
}

