/*
 * Decompiled with CFR 0.152.
 */
package com.google.security.fences.policy;

import com.google.common.base.Objects;
import com.google.common.base.Optional;
import com.google.common.base.Preconditions;
import com.google.common.collect.Lists;
import com.google.security.fences.policy.ApiElementType;
import java.util.ArrayList;
import javax.annotation.Nullable;

public class ApiElement
implements Comparable<ApiElement> {
    public final Optional<ApiElement> parent;
    public final String name;
    public final ApiElementType type;
    private final int hashCode;
    public static final String CONSTRUCTOR_SPECIAL_METHOD_NAME = "<init>";
    public static final ApiElement DEFAULT_PACKAGE = new ApiElement((Optional<ApiElement>)Optional.absent(), "", ApiElementType.PACKAGE);

    private ApiElement(Optional<ApiElement> parent, String name, ApiElementType type) {
        this.parent = parent;
        this.name = name;
        this.type = type;
        this.hashCode = Objects.hashCode((Object[])new Object[]{parent, name, type});
        Preconditions.checkArgument((name.length() == 0 == (type == ApiElementType.PACKAGE && !parent.isPresent()) ? 1 : 0) != 0);
        Preconditions.checkArgument((!name.contains(".") ? 1 : 0) != 0, (Object)name);
        Preconditions.checkArgument((parent.isPresent() || name.length() == 0 ? 1 : 0) != 0);
        switch (type) {
            case CLASS: {
                Preconditions.checkArgument((((ApiElement)parent.get()).type == ApiElementType.PACKAGE || ((ApiElement)parent.get()).type == ApiElementType.CLASS ? 1 : 0) != 0);
                return;
            }
            case CONSTRUCTOR: {
                Preconditions.checkArgument((boolean)name.equals(CONSTRUCTOR_SPECIAL_METHOD_NAME));
                Preconditions.checkArgument((parent.isPresent() && ((ApiElement)parent.get()).type == ApiElementType.CLASS ? 1 : 0) != 0);
                return;
            }
            case FIELD: 
            case METHOD: {
                Preconditions.checkArgument((parent.isPresent() && ((ApiElement)parent.get()).type == ApiElementType.CLASS ? 1 : 0) != 0);
                return;
            }
            case PACKAGE: {
                Preconditions.checkArgument((!parent.isPresent() || ((ApiElement)parent.get()).type == ApiElementType.PACKAGE ? 1 : 0) != 0);
                return;
            }
        }
        throw new AssertionError((Object)type);
    }

    public ApiElement child(String childName, ApiElementType childType) {
        return new ApiElement((Optional<ApiElement>)Optional.of((Object)this), childName, childType);
    }

    public static ApiElement fromInternalClassName(String name) {
        try {
            ApiElement apiElement = DEFAULT_PACKAGE;
            String[] nameParts = name.split("/");
            int n = nameParts.length;
            for (int i = 0; i < n - 1; ++i) {
                apiElement = apiElement.child(nameParts[i], ApiElementType.PACKAGE);
            }
            String className = nameParts[nameParts.length - 1];
            for (String classNamePart : ApiElement.splitClassName(className)) {
                apiElement = apiElement.child(classNamePart, ApiElementType.CLASS);
            }
            return apiElement;
        }
        catch (RuntimeException ex) {
            throw new IllegalArgumentException("Bad internal class name `" + name + "`", ex);
        }
    }

    static Iterable<String> splitClassName(String className) {
        int n = className.length();
        if (n == 0) {
            throw new IllegalArgumentException();
        }
        ArrayList parts = Lists.newArrayList();
        int start = 0;
        for (int i = start + 1; i < n - 1; ++i) {
            if (className.charAt(i) != '$') continue;
            assert (i != start);
            parts.add(className.substring(start, i));
            start = ++i;
        }
        parts.add(className.substring(start));
        return parts;
    }

    public Optional<ApiElement> containingClass() {
        switch (this.type) {
            case CLASS: {
                return Optional.of((Object)this);
            }
            case CONSTRUCTOR: 
            case FIELD: 
            case METHOD: {
                return ((ApiElement)this.parent.get()).containingClass();
            }
            case PACKAGE: {
                return Optional.absent();
            }
        }
        throw new AssertionError((Object)this.type);
    }

    public boolean equals(Object o) {
        if (!(o instanceof ApiElement)) {
            return false;
        }
        ApiElement that = (ApiElement)o;
        return this.type == that.type && this.name.equals(that.name) && this.parent.equals(that.parent);
    }

    public int hashCode() {
        return this.hashCode;
    }

    @Override
    public int compareTo(ApiElement that) {
        int delta = (this.parent.isPresent() ? 1 : 0) - (that.parent.isPresent() ? 1 : 0);
        if (delta == 0) {
            if (this.parent.isPresent()) {
                delta = ((ApiElement)this.parent.get()).compareTo((ApiElement)that.parent.get());
            }
            if (delta == 0 && (delta = this.name.compareTo(that.name)) == 0) {
                delta = this.type.compareTo(that.type);
            }
        }
        return delta;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append('[').append((Object)this.type).append(" : ");
        this.toName(false, sb);
        sb.append(']');
        return sb.toString();
    }

    public String toDottedName() {
        return this.toName(false, null).toString();
    }

    public String toInternalName() {
        return this.toName(true, null).toString();
    }

    private CharSequence toName(boolean internal, @Nullable StringBuilder out) {
        if (DEFAULT_PACKAGE.equals(this)) {
            return "";
        }
        StringBuilder sb = out;
        if (sb == null) {
            sb = new StringBuilder();
        }
        int startPosition = sb.length();
        switch (this.type) {
            case PACKAGE: {
                if (!internal) break;
                sb.append('/');
                break;
            }
            case CONSTRUCTOR: 
            case METHOD: {
                sb.append(")(");
                break;
            }
        }
        ApiElement el = this;
        while (true) {
            ApiElement parentEl = (ApiElement)el.parent.get();
            ApiElement.appendInReverse(el.name, sb);
            if (DEFAULT_PACKAGE.equals(parentEl)) break;
            switch (el.type) {
                case CLASS: {
                    sb.append((char)(internal ? (parentEl.type == ApiElementType.CLASS ? 36 : 47) : 46));
                    break;
                }
                case PACKAGE: {
                    sb.append(internal ? (char)'/' : '.');
                    break;
                }
                case CONSTRUCTOR: 
                case FIELD: 
                case METHOD: {
                    sb.append(internal ? (char)'#' : '.');
                }
            }
            el = parentEl;
        }
        ApiElement.reverse(sb, startPosition, sb.length());
        return sb;
    }

    private static void appendInReverse(String s, StringBuilder sb) {
        int i = s.length();
        while (--i >= 0) {
            sb.append(s.charAt(i));
        }
    }

    private static void reverse(StringBuilder sb, int start, int end) {
        int j = end;
        for (int i = start; --j > i; ++i) {
            char c = sb.charAt(i);
            char d = sb.charAt(j);
            sb.setCharAt(i, d);
            sb.setCharAt(j, c);
        }
    }

    public static final class Factory {
        static ApiElement pkg(String name, ApiElement parent) {
            return parent.child(name, ApiElementType.PACKAGE);
        }

        static ApiElement pkg(String name) {
            return Factory.pkg(name, DEFAULT_PACKAGE);
        }

        static ApiElement clazz(String name, ApiElement parent) {
            return parent.child(name, ApiElementType.CLASS);
        }

        static ApiElement field(String name, ApiElement parent) {
            return parent.child(name, ApiElementType.FIELD);
        }

        static ApiElement method(String name, ApiElement parent) {
            return parent.child(name, ApiElementType.METHOD);
        }
    }
}

