/*
 * Decompiled with CFR 0.152.
 */
package com.google.security.fences.config;

import com.google.common.base.Objects;
import com.google.security.fences.config.HumanReadableText;
import com.google.security.fences.config.IdentityValueSource;
import org.apache.maven.enforcer.rule.api.EnforcerRuleException;
import org.codehaus.plexus.interpolation.InterpolationException;
import org.codehaus.plexus.interpolation.RegexBasedInterpolator;
import org.codehaus.plexus.interpolation.ValueSource;

public final class Rationale {
    public static final Rationale EMPTY = new Rationale(HumanReadableText.EMPTY, HumanReadableText.EMPTY);
    public final HumanReadableText body;
    public final HumanReadableText addendum;

    public Rationale(HumanReadableText body, HumanReadableText addendum) {
        this.body = body;
        this.addendum = addendum;
    }

    public boolean isEmpty() {
        return this.body.isEmpty() && this.addendum.isEmpty();
    }

    public HumanReadableText getWholeText() {
        return this.body.concat(this.addendum);
    }

    public int hashCode() {
        return Objects.hashCode((Object[])new Object[]{this.body, this.addendum});
    }

    public boolean equals(Object o) {
        if (!(o instanceof Rationale)) {
            return false;
        }
        Rationale that = (Rationale)o;
        return this.body.equals(that.body) && this.addendum.equals(that.addendum);
    }

    public static Rationale merge(Rationale a, Rationale b) {
        if (b.isEmpty() || a.equals(b)) {
            return a;
        }
        if (a.isEmpty()) {
            return b;
        }
        return new Rationale(a.body.concatDedupe(b.body), a.addendum.concatDedupe(b.addendum));
    }

    public static final class Builder {
        private HumanReadableText body = HumanReadableText.EMPTY;
        private HumanReadableText addendum = HumanReadableText.EMPTY;

        public Builder addBody(String xmlTextNodeContent) throws EnforcerRuleException {
            return this.addBody(HumanReadableText.fromXmlTextNode(xmlTextNodeContent));
        }

        public Builder addBody(HumanReadableText newBody) throws EnforcerRuleException {
            this.body = this.body.concat(Builder.checkInterpolatable(newBody));
            return this;
        }

        public Builder addBodyFrom(Rationale r) {
            try {
                return this.addBody(r.body);
            }
            catch (EnforcerRuleException ex) {
                throw new AssertionError(null, ex);
            }
        }

        public Builder setBodyFrom(Rationale r) {
            this.body = r.body;
            return this;
        }

        public Builder addAddendum(String xmlTextNodeContent) throws EnforcerRuleException {
            return this.addAddendum(HumanReadableText.fromXmlTextNode(xmlTextNodeContent));
        }

        public Builder addAddendum(HumanReadableText newAddendum) throws EnforcerRuleException {
            this.addendum = this.addendum.concat(Builder.checkInterpolatable(newAddendum));
            return this;
        }

        public Builder addAddendumFrom(Rationale r) {
            try {
                return this.addAddendum(r.addendum);
            }
            catch (EnforcerRuleException ex) {
                throw new AssertionError(null, ex);
            }
        }

        public HumanReadableText getBody() {
            return this.body;
        }

        public HumanReadableText getAddendum() {
            return this.addendum;
        }

        private static HumanReadableText checkInterpolatable(HumanReadableText t) throws EnforcerRuleException {
            RegexBasedInterpolator interpolator = new RegexBasedInterpolator();
            interpolator.addValueSource((ValueSource)IdentityValueSource.INSTANCE);
            try {
                interpolator.interpolate(t.text);
            }
            catch (InterpolationException ex) {
                throw new EnforcerRuleException("Malformed property expression in: " + t.text, (Exception)((Object)ex));
            }
            return t;
        }

        public Rationale build() {
            if (this.body.isEmpty() && this.addendum.isEmpty()) {
                return EMPTY;
            }
            return new Rationale(this.body, this.addendum);
        }
    }
}

