/*
 * Decompiled with CFR 0.152.
 */
package com.google.security.fences.config;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.security.fences.config.ClassFence;
import com.google.security.fences.config.Fence;
import com.google.security.fences.config.NamedFence;
import com.google.security.fences.config.PackageFence;
import com.google.security.fences.inheritance.InheritanceGraph;
import com.google.security.fences.policy.ApiElement;

abstract class NamedLeafFence
extends NamedFence {
    NamedLeafFence() {
    }

    @Override
    public Iterable<Fence> getChildFences() {
        return ImmutableList.of();
    }

    @Override
    void replaceChildFences(Iterable<? extends Fence> newChildren) {
        Preconditions.checkArgument((!newChildren.iterator().hasNext() ? 1 : 0) != 0);
    }

    protected abstract void addToClass(ClassFence var1);

    @Override
    public Fence splitDottedNames(ApiElement parentEl, InheritanceGraph g) {
        String name = this.getName();
        String[] parts = name.split("[.]");
        if (parts.length == 1) {
            return this;
        }
        int i = parts.length - 1;
        this.setName(parts[i]);
        String className = parts[--i];
        ClassFence c = new ClassFence();
        c.setName(className);
        this.addToClass(c);
        NamedFence f = c;
        while (--i >= 0) {
            String part = parts[i];
            PackageFence pkg = new PackageFence();
            pkg.setName(part);
            if (f instanceof ClassFence) {
                pkg.setClass((ClassFence)f);
            } else {
                pkg.setPackage((PackageFence)f);
            }
            f = pkg;
        }
        return f;
    }
}

