/*
 * Decompiled with CFR 0.152.
 */
package com.google.security.fences.config;

import com.google.common.base.Preconditions;
import com.google.security.fences.config.Fence;
import java.util.Locale;
import org.apache.maven.enforcer.rule.api.EnforcerRuleException;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

abstract class NamedFence
extends Fence {
    private String name;

    NamedFence() {
    }

    public String getName() {
        return this.name;
    }

    public void setName(String newName) {
        this.name = (String)Preconditions.checkNotNull((Object)newName);
    }

    @Override
    String getKey() {
        return this.name;
    }

    @Override
    public void check() throws EnforcerRuleException {
        super.check();
        if (this.name == null) {
            throw new EnforcerRuleException(this.getClass().getSimpleName().replaceFirst("Fence$", "").toLowerCase(Locale.ENGLISH) + " is missing a name");
        }
    }

    public String toString() {
        String type = this.getClass().getSimpleName().replaceFirst("Fence$", "").toLowerCase(Locale.ENGLISH);
        return "{" + type + " " + this.name + "}";
    }

    @Override
    void fleshOutEffectiveConfiguration(Element el) {
        Document doc = el.getOwnerDocument();
        Element nameElement = doc.createElement("name");
        nameElement.appendChild(doc.createTextNode(this.name));
        el.appendChild(nameElement);
        super.fleshOutEffectiveConfiguration(el);
    }
}

