/*
 * Decompiled with CFR 0.152.
 */
package com.google.security.fences.config;

import com.google.common.base.Joiner;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Sets;
import java.util.Arrays;
import java.util.LinkedHashSet;
import java.util.List;

public final class HumanReadableText {
    public final String text;
    public static final HumanReadableText EMPTY = new HumanReadableText("");
    private static final String PARAGRAPH_SEPARATOR = "\n\n";

    HumanReadableText(String text) {
        this.text = (String)Preconditions.checkNotNull((Object)text);
    }

    public boolean isEmpty() {
        return this.text.isEmpty();
    }

    public boolean equals(Object o) {
        if (!(o instanceof HumanReadableText)) {
            return false;
        }
        return this.text.equals(((HumanReadableText)o).text);
    }

    public int hashCode() {
        return this.text.hashCode();
    }

    public String toString() {
        return this.text;
    }

    public static HumanReadableText fromXmlTextNode(String s) {
        List<String> lines = HumanReadableText.linesFromXmlTextNode(s);
        if (lines.isEmpty()) {
            return EMPTY;
        }
        return new HumanReadableText(Joiner.on((char)'\n').join(lines));
    }

    static List<String> linesFromXmlTextNode(String s) {
        int spaceWidth;
        String line;
        int j;
        String[] lines = s.replaceAll("\u2029", PARAGRAPH_SEPARATOR).split("[\n\u2028]|\r\n?");
        int minWhitespace = Integer.MAX_VALUE;
        int nLines = lines.length;
        for (j = 1; j < nLines; ++j) {
            int leadingWhitespace = 0;
            line = lines[j];
            if (line.trim().isEmpty()) continue;
            int n = line.length();
            for (int i = 0; i < n && (spaceWidth = HumanReadableText.spaceWidthOf(line.charAt(i))) != 0; ++i) {
                leadingWhitespace += spaceWidth;
            }
            minWhitespace = Math.min(minWhitespace, leadingWhitespace);
        }
        if (minWhitespace == 0) {
            return ImmutableList.copyOf(Arrays.asList(lines));
        }
        j = nLines;
        while (--j >= 0) {
            int trimPt;
            int nToTrim = minWhitespace;
            line = lines[j];
            int n = line.length();
            for (trimPt = 0; trimPt < n && nToTrim > 0 && (spaceWidth = HumanReadableText.spaceWidthOf(line.charAt(trimPt))) != 0 && spaceWidth <= nToTrim; nToTrim -= spaceWidth, ++trimPt) {
            }
            lines[j] = line.substring(trimPt);
        }
        ImmutableList.Builder trimmedLines = ImmutableList.builder();
        boolean hasOne = false;
        for (String line2 : lines) {
            if (!hasOne && "".equals(line2)) continue;
            trimmedLines.add((Object)line2);
            hasOne = true;
        }
        return trimmedLines.build();
    }

    private static int spaceWidthOf(char ch) {
        if (ch == ' ') {
            return 1;
        }
        if (ch == '\t') {
            return 8;
        }
        return 0;
    }

    public HumanReadableText concat(HumanReadableText that) {
        if (that.isEmpty()) {
            return this;
        }
        if (this.isEmpty()) {
            return that;
        }
        return new HumanReadableText(this.text + PARAGRAPH_SEPARATOR + that.text);
    }

    public HumanReadableText concatDedupe(HumanReadableText that) {
        if (that.isEmpty() || this.equals(that)) {
            return this;
        }
        if (this.isEmpty()) {
            return that;
        }
        LinkedHashSet paragraphs = Sets.newLinkedHashSet();
        paragraphs.addAll(Arrays.asList(this.text.split(PARAGRAPH_SEPARATOR)));
        paragraphs.addAll(Arrays.asList(that.text.split(PARAGRAPH_SEPARATOR)));
        return new HumanReadableText(Joiner.on((String)PARAGRAPH_SEPARATOR).join((Iterable)paragraphs));
    }
}

