/*
 * Decompiled with CFR 0.152.
 */
package com.google.security.fences.config;

import com.google.common.collect.ImmutableSet;
import com.google.security.fences.config.Rationale;
import com.google.security.fences.namespace.Namespace;
import java.util.LinkedHashSet;
import java.util.Set;

public final class Frenemies {
    public final ImmutableSet<Namespace> friends;
    public final ImmutableSet<Namespace> enemies;
    public final Rationale rationale;

    private Frenemies(ImmutableSet<Namespace> friends, ImmutableSet<Namespace> enemies, Rationale rationale) {
        this.friends = friends;
        this.enemies = enemies;
        this.rationale = rationale;
    }

    static Builder builder() {
        return new Builder();
    }

    static final class Builder {
        private final Set<Namespace> friends = new LinkedHashSet<Namespace>();
        private final Set<Namespace> enemies = new LinkedHashSet<Namespace>();
        private Rationale rationale = Rationale.EMPTY;

        private Builder() {
        }

        Builder addFriend(Namespace ns) {
            this.friends.add(ns);
            return this;
        }

        Builder addEnemy(Namespace ns) {
            this.enemies.add(ns);
            return this;
        }

        Builder setRationale(Rationale r) {
            this.rationale = r;
            return this;
        }

        Frenemies build() {
            return new Frenemies(ImmutableSet.copyOf(this.friends), ImmutableSet.copyOf(this.enemies), this.rationale);
        }
    }
}

