/*
 * Decompiled with CFR 0.152.
 */
package com.google.security.fences.config;

import com.google.common.base.Optional;
import com.google.security.fences.inheritance.ClassNode;
import com.google.security.fences.inheritance.InheritanceGraph;
import com.google.security.fences.policy.ApiElement;
import com.google.security.fences.policy.ApiElementType;

final class ClassNameDisambiguator {
    private final InheritanceGraph g;
    private final String partiallyQualifiedName;

    ClassNameDisambiguator(InheritanceGraph g, String partiallyQualifiedName) {
        this.g = g;
        this.partiallyQualifiedName = partiallyQualifiedName;
    }

    Optional<ApiElement> resolve(ApiElement parent) {
        return this.resolve(parent, 0, 0);
    }

    private Optional<ApiElement> resolve(ApiElement parent, int nameStartIndex, int nameIndex) {
        Optional<ApiElement> classOption;
        Optional<ClassNode> classNode;
        ApiElement newParent;
        Optional<ApiElement> packageOption;
        int nextStartIndex;
        Optional<ApiElement> longerOption;
        ApiElementType parentType = parent.type;
        int n = this.partiallyQualifiedName.length();
        if (nameIndex == n) {
            if (nameStartIndex == nameIndex) {
                if (parentType == ApiElementType.CLASS) {
                    return Optional.of((Object)parent);
                }
            } else {
                int boundaryType;
                int n2 = boundaryType = nameStartIndex >= 0 ? (int)this.partiallyQualifiedName.charAt(nameStartIndex - 1) : 46;
                if (boundaryType == 36 || boundaryType == 46) {
                    String name = this.partiallyQualifiedName.substring(nameStartIndex + 1, nameIndex);
                    return Optional.of((Object)parent.child(name, ApiElementType.CLASS));
                }
            }
            return Optional.absent();
        }
        boolean canBeClassBoundary = true;
        boolean canBePackageBoundary = false;
        boolean optional = false;
        int nameEndIndex = nameIndex;
        while (++nameEndIndex < n) {
            if (nameEndIndex + 1 == n) continue;
            char ch = this.partiallyQualifiedName.charAt(nameEndIndex);
            if (ch == '.') {
                canBePackageBoundary = true;
                canBeClassBoundary = true;
                optional = false;
                break;
            }
            if (ch == '$') {
                canBeClassBoundary = true;
                canBePackageBoundary = false;
                optional = true;
                break;
            }
            if (ch != '/') continue;
            canBeClassBoundary = false;
            canBePackageBoundary = true;
            optional = false;
            break;
        }
        if (optional && nameEndIndex < n && nameEndIndex != nameIndex && (longerOption = this.resolve(parent, nameStartIndex, nameEndIndex)).isPresent()) {
            return longerOption;
        }
        String partName = this.partiallyQualifiedName.substring(nameStartIndex, nameEndIndex);
        if (partName.indexOf(47) >= 0 || partName.indexOf(46) >= 0) {
            return Optional.absent();
        }
        int n3 = nextStartIndex = nameEndIndex < n ? nameEndIndex + 1 : nameEndIndex;
        if (canBePackageBoundary && nameEndIndex < n && (packageOption = this.resolve(newParent = parent.child(partName, ApiElementType.PACKAGE), nextStartIndex, nextStartIndex)).isPresent()) {
            return packageOption;
        }
        if (canBeClassBoundary && (classNode = this.g.named((newParent = parent.child(partName, ApiElementType.CLASS)).toInternalName())).isPresent() && ClassNameDisambiguator.isContainedIn((ClassNode)classNode.get(), parent) && (classOption = this.resolve(newParent, nextStartIndex, nextStartIndex)).isPresent()) {
            return classOption;
        }
        if (nameStartIndex == 0 && nameEndIndex == n && this.partiallyQualifiedName.indexOf(47) < 0 && this.partiallyQualifiedName.indexOf(46) < 0 && this.partiallyQualifiedName.indexOf(36) < 0) {
            return Optional.of((Object)parent.child(this.partiallyQualifiedName, ApiElementType.CLASS));
        }
        return Optional.absent();
    }

    private static boolean isContainedIn(ClassNode inner, ApiElement outer) {
        Optional<String> outerClass = inner.outerClass;
        if (outer.type == ApiElementType.PACKAGE) {
            return !outerClass.isPresent();
        }
        if (outerClass.isPresent()) {
            return outer.toInternalName().equals(outerClass.get());
        }
        return false;
    }
}

