/*
 * Decompiled with CFR 0.152.
 */
package com.google.security.fences.config;

import com.google.common.base.Optional;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import com.google.security.fences.config.ApiFence;
import com.google.security.fences.config.ClassNameDisambiguator;
import com.google.security.fences.config.ConstructorFence;
import com.google.security.fences.config.Fence;
import com.google.security.fences.config.FenceVisitor;
import com.google.security.fences.config.FieldFence;
import com.google.security.fences.config.MethodFence;
import com.google.security.fences.config.NamedFence;
import com.google.security.fences.config.PackageFence;
import com.google.security.fences.inheritance.InheritanceGraph;
import com.google.security.fences.policy.ApiElement;
import com.google.security.fences.policy.ApiElementType;
import java.util.List;
import org.apache.maven.enforcer.rule.api.EnforcerRuleException;

public final class ClassFence
extends NamedFence {
    private final List<ClassFence> classes = Lists.newArrayList();
    private final List<ConstructorFence> constructors = Lists.newArrayList();
    private final List<MethodFence> methods = Lists.newArrayList();
    private final List<FieldFence> fields = Lists.newArrayList();

    public void setClass(ClassFence x) {
        this.classes.add((ClassFence)Preconditions.checkNotNull((Object)x));
    }

    public void setConstructor(ConstructorFence x) {
        this.constructors.add((ConstructorFence)Preconditions.checkNotNull((Object)x));
    }

    public void setMethod(MethodFence x) {
        this.methods.add((MethodFence)Preconditions.checkNotNull((Object)x));
    }

    public void setField(FieldFence x) {
        this.fields.add((FieldFence)Preconditions.checkNotNull((Object)x));
    }

    @Override
    public Iterable<Fence> getChildFences() {
        return ImmutableList.builder().addAll(this.classes).addAll(this.constructors).addAll(this.methods).addAll(this.fields).build();
    }

    @Override
    void visit(FenceVisitor v, ApiElement el) {
        String name = this.getName();
        ApiElement classEl = el.child(name, ApiElementType.CLASS);
        v.visit(this, classEl);
        for (Fence child : this.getChildFences()) {
            child.visit(v, classEl);
        }
    }

    @Override
    void replaceChildFences(Iterable<? extends Fence> newChildren) {
        this.classes.clear();
        this.constructors.clear();
        this.methods.clear();
        this.fields.clear();
        for (Fence fence : newChildren) {
            if (fence instanceof ClassFence) {
                this.classes.add((ClassFence)fence);
                continue;
            }
            if (fence instanceof ConstructorFence) {
                this.constructors.add((ConstructorFence)fence);
                continue;
            }
            if (fence instanceof MethodFence) {
                this.methods.add((MethodFence)fence);
                continue;
            }
            if (fence instanceof FieldFence) {
                this.fields.add((FieldFence)fence);
                continue;
            }
            throw new IllegalArgumentException(fence.getClass().getName());
        }
    }

    @Override
    public Fence splitDottedNames(ApiElement parentEl, InheritanceGraph g) throws EnforcerRuleException {
        String partiallyQualifiedName = (String)Preconditions.checkNotNull((Object)this.getName());
        ClassNameDisambiguator dis = new ClassNameDisambiguator(g, partiallyQualifiedName);
        Optional<ApiElement> unambiguous = dis.resolve(parentEl);
        if (!unambiguous.isPresent()) {
            throw new EnforcerRuleException("Cannot find a class on the class path corresponding to `" + partiallyQualifiedName + "` in `" + parentEl.toInternalName());
        }
        ApiElement el = (ApiElement)unambiguous.get();
        Preconditions.checkState((el.type == ApiElementType.CLASS ? 1 : 0) != 0, (Object)el);
        ImmutableList.Builder splitChildren = ImmutableList.builder();
        for (Fence unsplitChild : this.getChildFences()) {
            splitChildren.add((Object)unsplitChild.splitDottedNames(el, g));
        }
        this.replaceChildFences((Iterable<? extends Fence>)splitChildren.build());
        this.setName(el.name);
        NamedFence f = this;
        ApiElement anc = (ApiElement)el.parent.get();
        while (!anc.equals(parentEl)) {
            String partName = anc.name;
            switch (anc.type) {
                case CLASS: {
                    ClassFence classFence = new ClassFence();
                    classFence.setName(partName);
                    classFence.setClass((ClassFence)f);
                    f = classFence;
                    break;
                }
                case PACKAGE: {
                    PackageFence pkgFence = new PackageFence();
                    pkgFence.setName(partName);
                    if (f instanceof ClassFence) {
                        pkgFence.setClass((ClassFence)f);
                    } else {
                        pkgFence.setPackage((PackageFence)f);
                    }
                    f = pkgFence;
                    break;
                }
                default: {
                    throw new AssertionError((Object)anc.type);
                }
            }
            anc = (ApiElement)anc.parent.get();
        }
        return f;
    }

    @Override
    String getConfigurationElementName() {
        return "class";
    }

    @Override
    public ApiFence promoteToApi() {
        ApiFence api = new ApiFence();
        api.setClass(this);
        return api;
    }
}

