/*
 * Decompiled with CFR 0.152.
 */
package com.google.security.fences;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import com.google.security.fences.ArtifactFinder;
import com.google.security.fences.Checker;
import com.google.security.fences.ClassRoot;
import com.google.security.fences.ConfigurationImport;
import com.google.security.fences.InheritanceGraphExtractor;
import com.google.security.fences.PolicyViolationReporter;
import com.google.security.fences.RelevantSystemProperties;
import com.google.security.fences.Violation;
import com.google.security.fences.config.ApiFence;
import com.google.security.fences.config.ClassFence;
import com.google.security.fences.config.Fence;
import com.google.security.fences.config.PackageFence;
import com.google.security.fences.inheritance.InheritanceGraph;
import com.google.security.fences.policy.ApiElement;
import com.google.security.fences.policy.Policy;
import com.google.security.fences.util.LazyString;
import com.google.security.fences.util.Utils;
import java.io.IOException;
import java.io.StringWriter;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.artifact.repository.ArtifactRepository;
import org.apache.maven.artifact.resolver.ArtifactNotFoundException;
import org.apache.maven.artifact.resolver.ArtifactResolutionException;
import org.apache.maven.artifact.resolver.ArtifactResolver;
import org.apache.maven.enforcer.rule.api.EnforcerRule;
import org.apache.maven.enforcer.rule.api.EnforcerRuleException;
import org.apache.maven.enforcer.rule.api.EnforcerRuleHelper;
import org.apache.maven.plugin.logging.Log;
import org.apache.maven.project.MavenProject;
import org.apache.maven.shared.dependency.tree.DependencyTreeBuilder;
import org.apache.maven.shared.dependency.tree.DependencyTreeBuilderException;
import org.codehaus.plexus.component.configurator.BasicComponentConfigurator;
import org.codehaus.plexus.component.configurator.ComponentConfigurator;
import org.codehaus.plexus.component.configurator.expression.ExpressionEvaluationException;
import org.codehaus.plexus.component.repository.exception.ComponentLookupException;
import org.codehaus.plexus.interpolation.PropertiesBasedValueSource;
import org.codehaus.plexus.interpolation.ValueSource;
import org.w3c.dom.Element;

public final class FencesMavenEnforcerRule
implements EnforcerRule {
    private final List<Fence> fences = Lists.newArrayList();
    private final LinkedList<ConfigurationImport> imports = Lists.newLinkedList();
    private final Set<ConfigurationImport.PartialArtifactKey> alreadyImported = Sets.newLinkedHashSet();

    private void addFence(Fence f) throws EnforcerRuleException {
        f.check();
        this.fences.add(f);
    }

    public void setApi(ApiFence x) throws EnforcerRuleException {
        this.addFence(x);
    }

    public void setPackage(PackageFence x) throws EnforcerRuleException {
        this.addFence(x);
    }

    public void setClass(ClassFence x) throws EnforcerRuleException {
        this.addFence(x);
    }

    public void setImport(String x) throws EnforcerRuleException {
        this.imports.add(new ConfigurationImport(x));
    }

    public void setAddendum(String x) throws EnforcerRuleException {
        ApiFence api = new ApiFence();
        api.setAddendum(x);
        this.fences.add(api);
    }

    public void execute(EnforcerRuleHelper helper) throws EnforcerRuleException {
        InheritanceGraph inheritanceGraph;
        List remoteRepositories;
        ArtifactRepository localRepository;
        MavenProject project;
        BasicComponentConfigurator configurator;
        DependencyTreeBuilder treeBuilder;
        ArtifactResolver resolver;
        Log log = helper.getLog();
        try {
            resolver = (ArtifactResolver)helper.getComponent(ArtifactResolver.class);
            treeBuilder = (DependencyTreeBuilder)helper.getComponent(DependencyTreeBuilder.class);
            configurator = new BasicComponentConfigurator();
        }
        catch (ComponentLookupException ex) {
            throw new EnforcerRuleException("Failed to locate component: " + ex.getLocalizedMessage(), (Exception)((Object)ex));
        }
        try {
            List rr;
            project = (MavenProject)helper.evaluate("${project}");
            localRepository = (ArtifactRepository)helper.evaluate("${localRepository}");
            remoteRepositories = rr = (List)helper.evaluate("${project.remoteArtifactRepositories}");
        }
        catch (ExpressionEvaluationException ex) {
            throw new EnforcerRuleException("Failed to locate component: " + ex.getLocalizedMessage(), (Exception)((Object)ex));
        }
        ArtifactFinder finder = new ArtifactFinder(resolver, treeBuilder, localRepository, remoteRepositories, log);
        try {
            finder.findClassRoots(project);
        }
        catch (DependencyTreeBuilderException ex) {
            throw new EnforcerRuleException("Failed to find artifacts", (Exception)((Object)ex));
        }
        catch (ArtifactResolutionException ex) {
            throw new EnforcerRuleException("Failed to find artifacts", (Exception)((Object)ex));
        }
        catch (ArtifactNotFoundException ex) {
            throw new EnforcerRuleException("Failed to find artifacts", (Exception)((Object)ex));
        }
        ImmutableList<ClassRoot> classRoots = finder.getClassRoots();
        try {
            inheritanceGraph = InheritanceGraphExtractor.fromClassRoots(classRoots);
        }
        catch (IOException ex) {
            throw new EnforcerRuleException("Failed to read classes to find inheritance relationships", (Exception)ex);
        }
        int nAssignedImportOrder = 0;
        int importOrder = 0;
        while (!this.imports.isEmpty()) {
            nAssignedImportOrder = this.rerootAndAssignImportOrder(inheritanceGraph, nAssignedImportOrder, importOrder);
            ConfigurationImport imp = this.imports.removeFirst();
            if (this.alreadyImported.add(imp.key)) {
                log.debug((CharSequence)("Importing " + imp.key));
                imp.configure(this, (ComponentConfigurator)configurator, new ConfigurationImport.ClassRoots((Iterator<ClassRoot>)classRoots.iterator()), log);
            } else {
                log.info((CharSequence)("Not importing " + imp.key + " a second time"));
            }
            ++importOrder;
        }
        this.rerootAndAssignImportOrder(inheritanceGraph, nAssignedImportOrder, importOrder);
        ImmutableList allFences = ImmutableList.copyOf(this.fences);
        if (allFences.isEmpty()) {
            throw new EnforcerRuleException("No fences.  Please configure this rule with a policy.  See https://github.com/mikesamuel/fences-maven-enforcer-rule/blob/master/src/site/markdown/usage.md for details");
        }
        ApiFence mergedFence = new ApiFence();
        for (Fence f : allFences) {
            mergedFence.mergeDeep(f);
        }
        boolean showConfig = RelevantSystemProperties.shouldShowEffectiveConfig();
        if (showConfig || log.isDebugEnabled()) {
            try {
                Element config = mergedFence.buildEffectiveConfiguration();
                TransformerFactory tf = TransformerFactory.newInstance();
                Transformer transformer = tf.newTransformer();
                transformer.setOutputProperty("omit-xml-declaration", "yes");
                transformer.setOutputProperty("method", "xml");
                transformer.setOutputProperty("indent", "yes");
                transformer.setOutputProperty("encoding", "UTF-8");
                transformer.setOutputProperty("{http://xml.apache.org/xslt}indent-amount", "2");
                StringWriter xmlOut = new StringWriter();
                xmlOut.write("Effective Fences Rule Configuration:\n");
                transformer.transform(new DOMSource(config), new StreamResult(xmlOut));
                String xml = xmlOut.toString();
                if (showConfig) {
                    log.info((CharSequence)xml);
                } else {
                    log.debug((CharSequence)xml);
                }
            }
            catch (ParserConfigurationException ex) {
                log.error((Throwable)ex);
            }
            catch (TransformerException ex) {
                log.error((Throwable)ex);
            }
        }
        FencesMavenEnforcerRule.checkAllClasses(project, log, inheritanceGraph, mergedFence, classRoots);
    }

    private int rerootAndAssignImportOrder(InheritanceGraph inheritanceGraph, int start, int importOrder) throws EnforcerRuleException {
        int end = this.fences.size();
        for (int i = start; i < end; ++i) {
            Fence f = this.fences.get(i);
            f = f.splitDottedNames(ApiElement.DEFAULT_PACKAGE, inheritanceGraph).promoteToApi();
            f.assignImportOrder(importOrder);
            this.fences.set(i, f);
        }
        return end;
    }

    protected static void checkAllClasses(MavenProject project, Log log, InheritanceGraph inheritanceGraph, ApiFence mergedFence, Iterable<? extends ClassRoot> classRoots) throws EnforcerRuleException {
        final Policy p = Policy.fromFence(mergedFence);
        log.debug((CharSequence)new LazyString(){

            @Override
            protected String makeString() {
                return "Using policy\n" + p.toString();
            }
        });
        Checker checker = new Checker(log, inheritanceGraph, p);
        for (ClassRoot classRoot : classRoots) {
            Artifact art = classRoot.art;
            log.info((CharSequence)("Checking " + art.getId() + " from scope " + art.getScope()));
            try {
                checker.visitAll((Iterable<? extends ClassRoot>)ImmutableList.of((Object)classRoot));
            }
            catch (IOException ex) {
                throw new EnforcerRuleException("Failed to check " + Utils.artToString(art), (Exception)ex);
            }
        }
        ImmutableList<Violation> violations = checker.getViolations();
        PolicyViolationReporter policyViolationReporter = new PolicyViolationReporter(log);
        policyViolationReporter.interpolator.addValueSource((ValueSource)new PropertiesBasedValueSource(project.getProperties()));
        int errorCount = policyViolationReporter.report(violations);
        if (errorCount != 0) {
            String message = errorCount + " access policy violation" + (errorCount == 1 ? "" : "s");
            if (RelevantSystemProperties.inExperimentalMode()) {
                log.info((CharSequence)(message + " ignored in experimental mode"));
            } else {
                throw new EnforcerRuleException(message);
            }
        }
    }

    public String getCacheId() {
        return null;
    }

    public boolean isCacheable() {
        return false;
    }

    public boolean isResultValid(EnforcerRule arg0) {
        return false;
    }
}

