/*
 * Decompiled with CFR 0.152.
 */
package com.google.security.fences;

import com.google.common.base.Objects;
import com.google.common.base.Optional;
import com.google.common.base.Preconditions;
import com.google.common.collect.Maps;
import com.google.security.fences.ClassRoot;
import com.google.security.fences.util.Utils;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.Iterator;
import java.util.Map;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.enforcer.rule.api.EnforcerRuleException;
import org.apache.maven.plugin.logging.Log;
import org.codehaus.plexus.classworlds.realm.ClassRealm;
import org.codehaus.plexus.component.configurator.ComponentConfigurationException;
import org.codehaus.plexus.component.configurator.ComponentConfigurator;
import org.codehaus.plexus.configuration.PlexusConfiguration;
import org.codehaus.plexus.configuration.xml.XmlPlexusConfiguration;
import org.codehaus.plexus.util.xml.Xpp3Dom;
import org.codehaus.plexus.util.xml.Xpp3DomBuilder;
import org.codehaus.plexus.util.xml.pull.XmlPullParserException;

final class ConfigurationImport {
    final PartialArtifactKey key;
    static final String FENCES_CONFIGURATION_XML_RELATIVE_PATH = "META-INF/fences.xml";

    ConfigurationImport(String s) throws EnforcerRuleException {
        this.key = new PartialArtifactKey(s.trim());
    }

    void configure(Object configurable, ComponentConfigurator configurator, ClassRoots classRoots, Log log) throws EnforcerRuleException {
        Optional<ClassRoot> cr = classRoots.lookup(this.key);
        if (cr.isPresent()) {
            XmlPlexusConfiguration configuration;
            try {
                configuration = ConfigurationImport.loadConfiguration(log, (ClassRoot)cr.get(), FENCES_CONFIGURATION_XML_RELATIVE_PATH);
            }
            catch (IOException ex) {
                throw new EnforcerRuleException("Failed to load META-INF/fences.xml from " + this.key, (Exception)ex);
            }
            ClassRealm realm = null;
            ClassLoader cl = configurable.getClass().getClassLoader();
            if (cl instanceof ClassRealm) {
                realm = (ClassRealm)cl;
            }
            try {
                configurator.configureComponent(configurable, (PlexusConfiguration)configuration, realm);
            }
            catch (ComponentConfigurationException ex) {
                throw new EnforcerRuleException("Failed to process configuration META-INF/fences.xml from " + this.key, (Exception)((Object)ex));
            }
        }
        log.error((CharSequence)("Cannot import " + this.key + ", no such artifact depended upon"));
    }

    static XmlPlexusConfiguration loadConfiguration(Log log, ClassRoot cr, String path) throws EnforcerRuleException, IOException {
        log.debug((CharSequence)("Loading " + path + " from " + Utils.artToString(cr.art)));
        File classRootFile = cr.classRoot;
        if (classRootFile == null) {
            throw new EnforcerRuleException("Cannot import configuration from unresolved artifact " + Utils.artToString(cr.art));
        }
        Xpp3Dom dom = cr.readRelativePath(path, new ClassRoot.IOConsumer<InputStream, Xpp3Dom>(){

            @Override
            public Xpp3Dom consume(ClassRoot root, String relPath, InputStream is) throws IOException {
                try {
                    Xpp3Dom xpp3Dom = Xpp3DomBuilder.build((InputStream)is, (String)"UTF-8", (boolean)true);
                    return xpp3Dom;
                }
                catch (XmlPullParserException ex) {
                    throw new IOException("Malformed XML " + relPath + " in " + root.art.getId(), ex);
                }
                finally {
                    is.close();
                }
            }
        });
        return new XmlPlexusConfiguration(dom);
    }

    static <K, V> void putIfAbsent(Map<K, V> m, K k, V v) {
        if (!m.containsKey(k)) {
            m.put(k, v);
        }
    }

    static final class ClassRoots {
        private final Map<PartialArtifactKey, ClassRoot> map = Maps.newLinkedHashMap();
        private final Iterator<ClassRoot> classRoots;

        ClassRoots(Iterator<ClassRoot> classRoots) {
            this.classRoots = classRoots;
        }

        Optional<ClassRoot> lookup(PartialArtifactKey k) {
            ClassRoot result = this.map.get(k);
            if (result == null) {
                while (this.classRoots.hasNext()) {
                    ClassRoot cr = this.classRoots.next();
                    Artifact art = cr.art;
                    PartialArtifactKey full = new PartialArtifactKey(art.getGroupId(), art.getArtifactId(), (Optional<String>)Optional.of((Object)art.getVersion()));
                    PartialArtifactKey partial = new PartialArtifactKey(full.groupId, full.artifactId);
                    ConfigurationImport.putIfAbsent(this.map, full, cr);
                    ConfigurationImport.putIfAbsent(this.map, partial, cr);
                    if (!k.equals(full) && !k.equals(partial)) continue;
                    result = cr;
                    break;
                }
            }
            return Optional.fromNullable((Object)result);
        }
    }

    static final class PartialArtifactKey {
        final String groupId;
        final String artifactId;
        final Optional<String> version;

        PartialArtifactKey(String artifact) throws EnforcerRuleException {
            String[] parts = artifact.split(":");
            switch (parts.length) {
                case 3: {
                    this.groupId = parts[0];
                    this.artifactId = parts[1];
                    this.version = Optional.of((Object)parts[2]);
                    break;
                }
                case 2: {
                    this.groupId = parts[0];
                    this.artifactId = parts[1];
                    this.version = Optional.absent();
                    break;
                }
                default: {
                    throw new EnforcerRuleException("Bad artifact key: " + artifact);
                }
            }
        }

        PartialArtifactKey(String gid, String aid, Optional<String> ver) {
            this.groupId = (String)Preconditions.checkNotNull((Object)gid);
            this.artifactId = (String)Preconditions.checkNotNull((Object)aid);
            this.version = (Optional)Preconditions.checkNotNull(ver);
        }

        PartialArtifactKey(String gid, String aid) {
            this(gid, aid, (Optional<String>)Optional.absent());
        }

        public boolean equals(Object o) {
            if (!(o instanceof PartialArtifactKey)) {
                return false;
            }
            PartialArtifactKey that = (PartialArtifactKey)o;
            return this.groupId.equals(that.groupId) && this.artifactId.equals(that.artifactId) && this.version.equals(that.version);
        }

        public int hashCode() {
            return Objects.hashCode((Object[])new Object[]{this.groupId, this.artifactId, this.version});
        }

        public String toString() {
            return this.groupId + ":" + this.artifactId + (this.version.isPresent() ? ":" + (String)this.version.get() : "");
        }
    }
}

