/*
 * Decompiled with CFR 0.152.
 */
package com.google.security.fences;

import com.google.common.base.Optional;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.security.fences.AbstractClassesVisitor;
import com.google.security.fences.ClassRoot;
import com.google.security.fences.Violation;
import com.google.security.fences.config.Rationale;
import com.google.security.fences.inheritance.InheritanceGraph;
import com.google.security.fences.namespace.Namespace;
import com.google.security.fences.policy.AccessLevel;
import com.google.security.fences.policy.ApiElement;
import com.google.security.fences.policy.ApiElementType;
import com.google.security.fences.policy.Policy;
import com.google.security.fences.policy.PolicyApplicationOrder;
import com.google.security.fences.util.LazyString;
import com.google.security.fences.util.Utils;
import java.io.IOException;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.enforcer.rule.api.EnforcerRuleException;
import org.apache.maven.plugin.logging.Log;
import org.objectweb.asm.ClassReader;
import org.objectweb.asm.ClassVisitor;
import org.objectweb.asm.Handle;
import org.objectweb.asm.Label;
import org.objectweb.asm.MethodVisitor;

final class Checker
extends AbstractClassesVisitor {
    final Log log;
    final Policy policy;
    final InheritanceGraph inheritanceGraph;
    private final List<Violation> violations = Lists.newArrayList();

    Checker(Log log, InheritanceGraph inheritanceGraph, Policy policy) {
        this.log = log;
        this.inheritanceGraph = inheritanceGraph;
        this.policy = policy;
    }

    ImmutableList<Violation> getViolations() {
        return ImmutableList.copyOf(this.violations);
    }

    @Override
    protected void startClassRoot(ClassRoot root) {
        this.log.debug((CharSequence)("Visiting " + root));
    }

    @Override
    protected ClassVisitor makeVisitorForClass(ClassRoot root, String relPath, ClassReader reader) throws IOException {
        try {
            return new ClassChecker(root.art, reader);
        }
        catch (EnforcerRuleException ex) {
            throw new IOException("Failed to check " + root, ex);
        }
    }

    PolicyResult applyAccessPolicy(Namespace from, ApiElement to, String descriptor) {
        ImmutableList<Policy.NamespacePolicy> applicable = this.policy.forNamespace(from);
        for (ApiElement el : new PolicyApplicationOrder(to, descriptor, this.inheritanceGraph, this.log)) {
            AccessLevel levelFromPolicy = null;
            Rationale.Builder rationaleBuilder = new Rationale.Builder();
            for (Policy.NamespacePolicy nsp : applicable) {
                Optional<Policy.AccessControlDecision> d = nsp.accessPolicyForApiElement(el);
                if (!d.isPresent()) continue;
                Policy.AccessControlDecision acd = (Policy.AccessControlDecision)d.get();
                AccessLevel dLvl = acd.accessLevel;
                if (levelFromPolicy == null) {
                    levelFromPolicy = dLvl;
                }
                if (dLvl != levelFromPolicy || acd.rationale.isEmpty()) continue;
                try {
                    rationaleBuilder.addBody(acd.rationale);
                    break;
                }
                catch (EnforcerRuleException ex) {
                    throw new AssertionError(null, ex);
                }
            }
            try {
                rationaleBuilder.addAddendum(this.policy.getAddenda(to));
            }
            catch (EnforcerRuleException ex) {
                throw new AssertionError(null, ex);
            }
            if (levelFromPolicy == null) continue;
            return new PolicyResult(levelFromPolicy, rationaleBuilder.build(), el);
        }
        return PolicyResult.defaultResult(to);
    }

    static final class PolicyResult {
        final AccessLevel accessLevel;
        final Rationale rationale;
        final ApiElement target;

        static PolicyResult defaultResult(ApiElement target) {
            return new PolicyResult(AccessLevel.ALLOWED, Rationale.EMPTY, target);
        }

        PolicyResult(AccessLevel accessLevel, Rationale rationale, ApiElement target) {
            this.accessLevel = accessLevel;
            this.rationale = rationale;
            this.target = target;
        }
    }

    private final class MethodChecker
    extends MethodVisitor {
        final Artifact art;
        final Optional<String> sourceFilePath;
        final String className;
        final Namespace ns;
        final String methodName;
        private final Map<ApiElement, Map<String, PolicyResult>> memoTable;
        private int latestLineNumber;

        MethodChecker(Artifact art, ClassReader reader, Optional<String> sourceFilePath, Namespace ns, String methodName) {
            super(327680);
            this.memoTable = Maps.newLinkedHashMap();
            this.latestLineNumber = -1;
            this.art = art;
            this.sourceFilePath = sourceFilePath;
            this.className = reader.getClassName();
            this.ns = ns;
            this.methodName = methodName;
        }

        public void visitCode() {
            Checker.this.log.debug((CharSequence)(". . Visiting method " + this.methodName));
        }

        public void visitFieldInsn(int opcode, String owner, String name, String desc) {
            ApiElement classEl = ApiElement.fromInternalClassName(owner);
            ApiElement fieldApiElement = classEl.child(name, ApiElementType.FIELD);
            this.requireAccessAllowed(fieldApiElement, desc);
        }

        public void visitInvokeDynamicInsn(String name, String desc, Handle bsm, Object ... bsmArgs) {
        }

        public void visitMethodInsn(int opcode, String owner, String name, String desc, boolean itf) {
            ApiElement classEl = ApiElement.fromInternalClassName(owner);
            ApiElement methodApiElement = classEl.child(name, "<init>".equals(name) ? ApiElementType.CONSTRUCTOR : ApiElementType.METHOD);
            this.requireAccessAllowed(methodApiElement, desc);
        }

        public void visitLineNumber(int lineNumber, Label start) {
            this.latestLineNumber = lineNumber;
        }

        void requireAccessAllowed(final ApiElement el, String descriptor) {
            PolicyResult r;
            LinkedHashMap descriptorMemoTable = this.memoTable.get(el);
            if (descriptorMemoTable == null) {
                descriptorMemoTable = Maps.newLinkedHashMap();
                this.memoTable.put(el, descriptorMemoTable);
            }
            if ((r = (PolicyResult)descriptorMemoTable.get(descriptor)) == null) {
                Checker.this.log.debug((CharSequence)new LazyString(){

                    @Override
                    protected String makeString() {
                        return ". . . Checking whether " + el + " allowed from " + MethodChecker.this.ns + " in " + Utils.artToString(MethodChecker.this.art);
                    }
                });
                r = Checker.this.applyAccessPolicy(this.ns, el, descriptor);
                descriptorMemoTable.put(descriptor, r);
            }
            switch (r.accessLevel) {
                case ALLOWED: {
                    return;
                }
                case DISALLOWED: {
                    Violation v = new Violation(this.art, this.ns, (String)this.sourceFilePath.or((Object)this.className), this.latestLineNumber, el, r.target, r.rationale);
                    Checker.this.violations.add(v);
                    return;
                }
            }
            throw new AssertionError((Object)r.accessLevel);
        }
    }

    final class ClassChecker
    extends ClassVisitor {
        final Artifact art;
        final ClassReader reader;
        final String className;
        final Namespace ns;
        private Optional<String> sourceFilePath;

        ClassChecker(Artifact art, ClassReader reader) throws EnforcerRuleException {
            super(327680);
            this.sourceFilePath = Optional.absent();
            this.art = art;
            this.reader = reader;
            this.className = reader.getClassName();
            this.ns = Namespace.fromInternalClassName(this.className);
        }

        public void visit(int version, int access, String name, String signature, String superName, String[] interfaces) {
            Checker.this.log.debug((CharSequence)(". Visiting class " + this.className));
        }

        public void visitSource(String source, String debug) {
            this.sourceFilePath = Optional.fromNullable((Object)source);
        }

        public MethodVisitor visitMethod(int access, String name, String desc, String signature, String[] exceptions) {
            return new MethodChecker(this.art, this.reader, this.sourceFilePath, this.ns, name);
        }
    }
}

