/*
 * Decompiled with CFR 0.152.
 */
package com.google.security.fences;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Sets;
import com.google.security.fences.ClassRoot;
import com.google.security.fences.util.LazyString;
import com.google.security.fences.util.Utils;
import java.io.File;
import java.util.List;
import java.util.Set;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.artifact.repository.ArtifactRepository;
import org.apache.maven.artifact.resolver.ArtifactNotFoundException;
import org.apache.maven.artifact.resolver.ArtifactResolutionException;
import org.apache.maven.artifact.resolver.ArtifactResolver;
import org.apache.maven.enforcer.rule.api.EnforcerRuleException;
import org.apache.maven.model.Build;
import org.apache.maven.plugin.logging.Log;
import org.apache.maven.project.MavenProject;
import org.apache.maven.shared.dependency.tree.DependencyNode;
import org.apache.maven.shared.dependency.tree.DependencyTreeBuilder;
import org.apache.maven.shared.dependency.tree.DependencyTreeBuilderException;

final class ArtifactFinder {
    private final ArtifactResolver resolver;
    private final DependencyTreeBuilder treeBuilder;
    private final ArtifactRepository localRepository;
    private final List<ArtifactRepository> remoteRepositories;
    private final Log log;
    private final Set<String> seen = Sets.newLinkedHashSet();
    private final Set<String> availableAsProject = Sets.newLinkedHashSet();
    private final ImmutableList.Builder<ClassRoot> classRoots = ImmutableList.builder();

    ArtifactFinder(ArtifactResolver resolver, DependencyTreeBuilder treeBuilder, ArtifactRepository localRepository, List<ArtifactRepository> remoteRepositories, Log log) {
        this.resolver = (ArtifactResolver)Preconditions.checkNotNull((Object)resolver);
        this.treeBuilder = (DependencyTreeBuilder)Preconditions.checkNotNull((Object)treeBuilder);
        this.localRepository = (ArtifactRepository)Preconditions.checkNotNull((Object)localRepository);
        this.remoteRepositories = ImmutableList.copyOf(remoteRepositories);
        this.log = log;
    }

    ImmutableList<ClassRoot> getClassRoots() {
        return this.classRoots.build();
    }

    private void markAvailableAsProject(MavenProject project) {
        List collectedProjects;
        if (this.availableAsProject.add(project.getId()) && (collectedProjects = project.getCollectedProjects()) != null) {
            for (MavenProject collectedProject : collectedProjects) {
                this.markAvailableAsProject(collectedProject);
            }
        }
    }

    void findClassRoots(MavenProject project) throws ArtifactNotFoundException, ArtifactResolutionException, DependencyTreeBuilderException, EnforcerRuleException {
        List collectedProjects;
        this.markAvailableAsProject(project);
        String id = project.getId();
        if (!this.seen.add(id)) {
            return;
        }
        DependencyNode node = this.treeBuilder.buildDependencyTree(project, this.localRepository, null);
        Artifact art = node.getArtifact();
        boolean hasClassRoot = !"pom".equals(project.getPackaging());
        File buildOutputDirectory = null;
        if (hasClassRoot) {
            String buildOutputDirectoryPath;
            Build build = project.getBuild();
            if (build != null && (buildOutputDirectoryPath = build.getOutputDirectory()) != null && !(buildOutputDirectory = new File(buildOutputDirectoryPath)).exists()) {
                this.log.debug((CharSequence)("Build output directory " + buildOutputDirectory + " does not exist for " + id + ".  Falling back to local repository."));
                buildOutputDirectory = null;
            }
            if (buildOutputDirectory != null) {
                this.log.info((CharSequence)("Found directory class root " + buildOutputDirectory + " for " + project.getId()));
                this.classRoots.add((Object)new ClassRoot(art, buildOutputDirectory, ClassRoot.ClassRootKind.BUILD_OUTPUT_DIRECTORY));
            } else {
                this.resolver.resolve(art, this.remoteRepositories, this.localRepository);
                this.addZipClassRoot(art);
            }
        }
        if ((collectedProjects = project.getCollectedProjects()) != null) {
            for (MavenProject collectedProject : collectedProjects) {
                this.findClassRoots(collectedProject);
            }
        }
        this.addAllDescendants(node);
    }

    private void addAllDescendants(DependencyNode node) throws ArtifactNotFoundException, ArtifactResolutionException, EnforcerRuleException {
        List childNodes = node.getChildren();
        if (childNodes != null) {
            for (DependencyNode depNode : childNodes) {
                Artifact artifact = depNode.getArtifact();
                if (this.availableAsProject.contains(artifact.getId())) continue;
                this.resolver.resolve(artifact, this.remoteRepositories, this.localRepository);
                boolean isProductionCode = true;
                if (depNode.getState() != 0 || "test".equals(depNode.getOriginalScope())) {
                    isProductionCode = false;
                }
                if (isProductionCode) {
                    this.addZipClassRoot(artifact);
                }
                this.addAllDescendants(depNode);
            }
        }
    }

    private void addZipClassRoot(final Artifact art) throws EnforcerRuleException {
        final File artFile = art.getFile();
        if (artFile == null) {
            throw new EnforcerRuleException("Cannot check artifact " + Utils.artToString(art) + " since it has not been packaged.");
        }
        this.log.info((CharSequence)new LazyString(){

            @Override
            protected String makeString() {
                return "Found zip file " + artFile + " for " + Utils.artToString(art);
            }
        });
        this.classRoots.add((Object)new ClassRoot(art, artFile, ClassRoot.ClassRootKind.ZIPFILE));
    }
}

