/*
 * Decompiled with CFR 0.152.
 */
package com.google.prefab.ndkbuild;

import com.google.prefab.api.Android;
import com.google.prefab.api.BuildSystemInterface;
import com.google.prefab.api.LibraryReference;
import com.google.prefab.api.Module;
import com.google.prefab.api.NoMatchingLibraryException;
import com.google.prefab.api.Package;
import com.google.prefab.api.PlatformDataInterface;
import com.google.prefab.api.PrebuiltLibrary;
import com.google.prefab.ndkbuild.DuplicateModuleNameException;
import com.google.prefab.ndkbuild.NdkBuildPluginKt;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.collections.CollectionsKt;
import kotlin.comparisons.ComparisonsKt;
import kotlin.io.FilesKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000L\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u001e\n\u0002\u0018\u0002\n\u0002\b\u0004\u0018\u00002\u00020\u0001B\u001b\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\f\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005\u00a2\u0006\u0002\u0010\u0007J\u0018\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u0003H\u0002J \u0010\u0011\u001a\u00020\r2\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0010\u001a\u00020\u0003H\u0002J\u0018\u0010\u0016\u001a\u00020\u00132\u0006\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u0019\u001a\u00020\u0013H\u0002J\u0016\u0010\u001a\u001a\u00020\r2\f\u0010\u001b\u001a\b\u0012\u0004\u0012\u00020\u001d0\u001cH\u0016J&\u0010\u001e\u001a\u00020\r2\u0006\u0010\u001f\u001a\u00020\u00062\f\u0010\u001b\u001a\b\u0012\u0004\u0012\u00020\u00150\u001c2\u0006\u0010 \u001a\u00020\u0003H\u0002R\u0014\u0010\u0002\u001a\u00020\u0003X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u001a\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000b\u00a8\u0006!"}, d2={"Lcom/google/prefab/ndkbuild/NdkBuildPlugin;", "Lcom/google/prefab/api/BuildSystemInterface;", "outputDirectory", "Ljava/io/File;", "packages", "", "Lcom/google/prefab/api/Package;", "(Ljava/io/File;Ljava/util/List;)V", "getOutputDirectory", "()Ljava/io/File;", "getPackages", "()Ljava/util/List;", "emitDependency", "", "dependency", "", "androidMk", "emitModule", "module", "Lcom/google/prefab/api/Module;", "requirement", "Lcom/google/prefab/api/Android;", "findReferredModule", "reference", "Lcom/google/prefab/api/LibraryReference;", "currentModule", "generate", "requirements", "", "Lcom/google/prefab/api/PlatformDataInterface;", "generatePackage", "pkg", "packageDirectory", "ndk-build-plugin"})
public final class NdkBuildPlugin
implements BuildSystemInterface {
    @NotNull
    private final File outputDirectory;
    @NotNull
    private final List<Package> packages;

    public NdkBuildPlugin(@NotNull File outputDirectory, @NotNull List<Package> packages2) {
        Intrinsics.checkNotNullParameter(outputDirectory, "outputDirectory");
        Intrinsics.checkNotNullParameter(packages2, "packages");
        this.outputDirectory = outputDirectory;
        this.packages = packages2;
    }

    @Override
    @NotNull
    public File getOutputDirectory() {
        return this.outputDirectory;
    }

    @Override
    @NotNull
    public List<Package> getPackages() {
        return this.packages;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void generate(@NotNull Collection<? extends PlatformDataInterface> requirements) {
        void $this$filterIsInstanceTo$iv$iv;
        Intrinsics.checkNotNullParameter(requirements, "requirements");
        Iterable $this$filterIsInstance$iv = requirements;
        boolean $i$f$filterIsInstance = false;
        Iterable iterable = $this$filterIsInstance$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterIsInstanceTo = false;
        for (Object element$iv$iv : $this$filterIsInstanceTo$iv$iv) {
            if (!(element$iv$iv instanceof Android)) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        List androidRequirements = (List)destination$iv$iv;
        if (!Intrinsics.areEqual(androidRequirements, requirements)) {
            throw new UnsupportedOperationException("ndk-build only supports Android targets");
        }
        boolean bl = false;
        Map seenNames = new LinkedHashMap();
        for (Package pkg : this.getPackages()) {
            for (Module module : pkg.getModules()) {
                Module dupModule = (Module)seenNames.get(module.getName());
                if (dupModule != null) {
                    throw new DuplicateModuleNameException(module, dupModule);
                }
                Map map = seenNames;
                String string = module.getName();
                boolean bl2 = false;
                map.put(string, module);
            }
        }
        this.prepareOutputDirectory(this.getOutputDirectory());
        for (Package pkg : this.getPackages()) {
            File packageDir = FilesKt.resolve(this.getOutputDirectory(), pkg.getName());
            packageDir.mkdir();
            this.generatePackage(pkg, androidRequirements, packageDir);
        }
    }

    private final void generatePackage(Package pkg, Collection<Android> requirements, File packageDirectory) {
        File androidMk = FilesKt.resolve(packageDirectory, "Android.mk");
        FilesKt.writeText$default(androidMk, "LOCAL_PATH := $(call my-dir)\n\n", null, 2, null);
        for (Android requirement : requirements) {
            FilesKt.appendText$default(androidMk, StringsKt.trimIndent("\n                ifeq ($(TARGET_ARCH_ABI)," + requirement.getAbi().getTargetArchAbi() + ")\n\n\n                "), null, 2, null);
            Iterable $this$sortedBy$iv = pkg.getModules();
            boolean $i$f$sortedBy = false;
            boolean bl = false;
            for (Module module : CollectionsKt.sortedWith($this$sortedBy$iv, new Comparator<T>(){

                public final int compare(T a, T b) {
                    boolean bl = false;
                    Module it = (Module)a;
                    boolean bl2 = false;
                    Comparable comparable = (Comparable)((Object)it.getName());
                    it = (Module)b;
                    Comparable comparable2 = comparable;
                    bl2 = false;
                    String string = it.getName();
                    return ComparisonsKt.compareValues(comparable2, (Comparable)((Object)string));
                }
            })) {
                this.emitModule(module, requirement, androidMk);
            }
            FilesKt.appendText$default(androidMk, StringsKt.trimIndent("\n                endif  # " + requirement.getAbi().getTargetArchAbi() + "\n\n\n                "), null, 2, null);
        }
        for (String dep : CollectionsKt.sorted((Iterable)pkg.getDependencies())) {
            this.emitDependency(dep, androidMk);
        }
    }

    private final void emitModule(Module module, Android requirement, File androidMk) {
        boolean bl = false;
        List ldLibs = new ArrayList();
        boolean bl2 = false;
        List sharedLibraries = new ArrayList();
        boolean bl3 = false;
        List staticLibraries = new ArrayList();
        for (LibraryReference libraryReference : module.linkLibsForPlatform(requirement)) {
            if (libraryReference instanceof LibraryReference.Literal) {
                ldLibs.add(((LibraryReference.Literal)libraryReference).getArg());
                continue;
            }
            Module referredModule232 = this.findReferredModule(libraryReference, module);
            if (referredModule232.isHeaderOnly()) {
                staticLibraries.add(referredModule232.getName());
                continue;
            }
            try {
                PrebuiltLibrary prebuilt = referredModule232.getLibraryFor(requirement);
                File file2 = prebuilt.getPath().toFile();
                Intrinsics.checkNotNullExpressionValue(file2, "prebuilt.path.toFile()");
                String extension = FilesKt.getExtension(file2);
                if (Intrinsics.areEqual(extension, "so")) {
                    sharedLibraries.add(referredModule232.getName());
                    continue;
                }
                if (Intrinsics.areEqual(extension, "a")) {
                    staticLibraries.add(referredModule232.getName());
                    continue;
                }
                throw new RuntimeException(Intrinsics.stringPlus("Unrecognized library extension: ", extension));
            }
            catch (NoMatchingLibraryException ex232) {
                System.err.println("Skipping " + module.getCanonicalName() + " because it depends on an incompatible library:");
                System.err.print(ex232);
                return;
            }
        }
        String string = CollectionsKt.joinToString$default(ldLibs, " ", " ", null, 0, null, null, 60, null);
        boolean referredModule232 = false;
        String string2 = string;
        if (string2 == null) {
            throw new NullPointerException("null cannot be cast to non-null type kotlin.CharSequence");
        }
        String exportLdLibs = ((Object)StringsKt.trimEnd((CharSequence)string2)).toString();
        String referredModule232 = CollectionsKt.joinToString$default(sharedLibraries, " ", " ", null, 0, null, null, 60, null);
        boolean ex232 = false;
        String string3 = referredModule232;
        if (string3 == null) {
            throw new NullPointerException("null cannot be cast to non-null type kotlin.CharSequence");
        }
        String string4 = ((Object)StringsKt.trimEnd((CharSequence)string3)).toString();
        String ex232 = CollectionsKt.joinToString$default(staticLibraries, " ", " ", null, 0, null, null, 60, null);
        boolean extension = false;
        String string5 = ex232;
        if (string5 == null) {
            throw new NullPointerException("null cannot be cast to non-null type kotlin.CharSequence");
        }
        String exportStaticLibraries = ((Object)StringsKt.trimEnd((CharSequence)string5)).toString();
        if (module.isHeaderOnly()) {
            String escapedHeaders = NdkBuildPluginKt.sanitize(module.getIncludePath());
            FilesKt.appendText$default(androidMk, StringsKt.trimIndent("\n                include $(CLEAR_VARS)\n                LOCAL_MODULE := " + module.getName() + "\n                LOCAL_EXPORT_C_INCLUDES := " + escapedHeaders + "\n                LOCAL_EXPORT_SHARED_LIBRARIES :=" + string4 + "\n                LOCAL_EXPORT_STATIC_LIBRARIES :=" + exportStaticLibraries + "\n                LOCAL_EXPORT_LDLIBS :=" + exportLdLibs + "\n                include $(BUILD_STATIC_LIBRARY)\n    \n    \n                "), null, 2, null);
        } else {
            try {
                String string6;
                PrebuiltLibrary prebuilt = module.getLibraryFor(requirement);
                String escapedLibrary = NdkBuildPluginKt.sanitize(prebuilt.getPath());
                String escapedHeaders = NdkBuildPluginKt.sanitize(prebuilt.getIncludePath());
                File file3 = prebuilt.getPath().toFile();
                Intrinsics.checkNotNullExpressionValue(file3, "prebuilt.path.toFile()");
                String extension2 = FilesKt.getExtension(file3);
                if (Intrinsics.areEqual(extension2, "so")) {
                    string6 = "PREBUILT_SHARED_LIBRARY";
                } else if (Intrinsics.areEqual(extension2, "a")) {
                    string6 = "PREBUILT_STATIC_LIBRARY";
                } else {
                    throw new RuntimeException(Intrinsics.stringPlus("Unrecognized library extension: ", extension2));
                }
                String prebuiltType = string6;
                FilesKt.appendText$default(androidMk, StringsKt.trimIndent("\n                    include $(CLEAR_VARS)\n                    LOCAL_MODULE := " + module.getName() + "\n                    LOCAL_SRC_FILES := " + escapedLibrary + "\n                    LOCAL_EXPORT_C_INCLUDES := " + escapedHeaders + "\n                    LOCAL_EXPORT_SHARED_LIBRARIES :=" + string4 + "\n                    LOCAL_EXPORT_STATIC_LIBRARIES :=" + exportStaticLibraries + "\n                    LOCAL_EXPORT_LDLIBS :=" + exportLdLibs + "\n                    include $(" + prebuiltType + ")\n\n\n                    "), null, 2, null);
            }
            catch (NoMatchingLibraryException ex) {
                System.err.println(ex);
            }
        }
    }

    private final void emitDependency(String dependency, File androidMk) {
        FilesKt.appendText$default(androidMk, StringsKt.trimIndent("\n            $(call import-module,prefab/" + dependency + ")\n\n            "), null, 2, null);
    }

    private final Module findReferredModule(LibraryReference reference, Module currentModule) {
        Module module;
        Package package_;
        List<Module> list;
        LibraryReference libraryReference = reference;
        if (libraryReference instanceof LibraryReference.Local) {
            Object v0;
            block18: {
                list = (List<Module>)this.getPackages();
                boolean bl = false;
                List<Module> list2 = list;
                boolean bl2 = false;
                for (Object object : list2) {
                    Package it2 = (Package)object;
                    boolean bl3 = false;
                    if (!Intrinsics.areEqual(it2.getName(), currentModule.getPkg().getName())) continue;
                    v0 = object;
                    break block18;
                }
                v0 = null;
            }
            package_ = v0;
            if (package_ == null) {
                module = null;
            } else {
                list = package_.getModules();
                if (list == null) {
                    module = null;
                } else {
                    Package package_2;
                    block19: {
                        Iterable iterable = list;
                        boolean bl = false;
                        Iterable iterable2 = iterable;
                        boolean bl4 = false;
                        for (Package it2 : iterable2) {
                            Module it3 = (Module)((Object)it2);
                            boolean bl5 = false;
                            if (!Intrinsics.areEqual(it3.getName(), ((LibraryReference.Local)reference).getName())) continue;
                            package_2 = it2;
                            break block19;
                        }
                        package_2 = null;
                    }
                    module = (Module)((Object)package_2);
                }
            }
        } else if (libraryReference instanceof LibraryReference.External) {
            Object v3;
            block20: {
                list = this.getPackages();
                boolean bl = false;
                List<Module> list3 = list;
                boolean bl6 = false;
                for (Object t : list3) {
                    Package it = (Package)t;
                    boolean bl7 = false;
                    if (!Intrinsics.areEqual(it.getName(), ((LibraryReference.External)reference).getPkg())) continue;
                    v3 = t;
                    break block20;
                }
                v3 = null;
            }
            package_ = v3;
            if (package_ == null) {
                module = null;
            } else {
                list = package_.getModules();
                if (list == null) {
                    module = null;
                } else {
                    Object v4;
                    block21: {
                        Iterable iterable = list;
                        boolean bl = false;
                        Iterable iterable3 = iterable;
                        boolean bl8 = false;
                        for (Object t : iterable3) {
                            Module it4 = (Module)t;
                            boolean bl9 = false;
                            if (!Intrinsics.areEqual(it4.getName(), ((LibraryReference.External)reference).getModule())) continue;
                            v4 = t;
                            break block21;
                        }
                        v4 = null;
                    }
                    module = v4;
                }
            }
        } else {
            if (libraryReference instanceof LibraryReference.Literal) {
                throw new IllegalArgumentException("Literal library references do not have types");
            }
            throw new NoWhenBranchMatchedException();
        }
        Module module2 = module;
        if (module2 == null) {
            throw new RuntimeException(Intrinsics.stringPlus("Could not find a module matching ", reference));
        }
        return module2;
    }

    @Override
    public void prepareOutputDirectory(@NotNull File output) {
        BuildSystemInterface.DefaultImpls.prepareOutputDirectory(this, output);
    }
}

